/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class InfoPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(InfoPanel.class.getName());
    private static final int PANEL_WIDTH = 256;
    public static final int PANEL_HEIGHT = 128;
    private final EndTurnPanel endTurnPanel;
    private final UnitInfoPanel unitInfoPanel;
    private final TileInfoPanel tileInfoPanel = new TileInfoPanel();
    private final JPanel mapEditorPanel;
    private Image skin = ResourceManager.getImage("InfoPanel.skin");
    private boolean useSkin = true;

    public InfoPanel(FreeColClient freeColClient, GUI gui) {
        this(freeColClient, gui, true);
    }

    public InfoPanel(FreeColClient freeColClient, final GUI gui, boolean useSkin) {
        super(freeColClient, gui);
        this.useSkin = useSkin;
        this.endTurnPanel = new EndTurnPanel(gui);
        this.unitInfoPanel = new UnitInfoPanel();
        this.setLayout(null);
        int internalPanelTop = 0;
        int internalPanelHeight = 128;
        if (useSkin && this.skin != null) {
            this.setBorder(null);
            this.setSize(this.skin.getWidth(null), this.skin.getHeight(null));
            this.setOpaque(false);
            internalPanelTop = 75;
            internalPanelHeight = 128;
        } else {
            this.setSize(256, 128);
        }
        this.mapEditorPanel = new JPanel(null);
        this.mapEditorPanel.setSize(130, 100);
        this.mapEditorPanel.setOpaque(false);
        this.add(this.unitInfoPanel, internalPanelTop, internalPanelHeight);
        this.add(this.endTurnPanel, internalPanelTop, internalPanelHeight);
        this.add(this.tileInfoPanel, internalPanelTop, internalPanelHeight);
        this.add(this.mapEditorPanel, internalPanelTop, internalPanelHeight);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Unit activeUnit = gui.getActiveUnit();
                if (activeUnit != null && activeUnit.getTile() != null) {
                    gui.setFocus(activeUnit.getTile());
                }
            }
        });
    }

    private void add(JPanel panel, int internalPanelTop, int internalPanelHeight) {
        panel.setVisible(false);
        panel.setLocation((this.getWidth() - panel.getWidth()) / 2, internalPanelTop + (internalPanelHeight - panel.getHeight()) / 2);
        this.add(panel);
    }

    public void update(Unit unit) {
        this.unitInfoPanel.update(unit);
    }

    public void update(MapEditorTransformPanel.MapTransform mapTransform) {
        JPanel p;
        if (mapTransform != null && (p = mapTransform.getDescriptionPanel()) != null) {
            p.setOpaque(false);
            Dimension d = p.getPreferredSize();
            p.setBounds(0, (this.mapEditorPanel.getHeight() - d.height) / 2, this.mapEditorPanel.getWidth(), d.height);
            this.mapEditorPanel.removeAll();
            this.mapEditorPanel.add((Component)p, "Center");
            this.mapEditorPanel.validate();
            this.mapEditorPanel.revalidate();
            this.mapEditorPanel.repaint();
        }
    }

    public void update(Tile tile) {
        this.tileInfoPanel.update(tile);
    }

    public Unit getUnit() {
        return this.unitInfoPanel.getUnit();
    }

    public Tile getTile() {
        return this.tileInfoPanel.getTile();
    }

    public void paintComponent(Graphics graphics) {
        int viewMode = this.getGUI().getCurrentViewMode();
        this.mapEditorPanel.setVisible(false);
        this.unitInfoPanel.setVisible(false);
        this.endTurnPanel.setVisible(false);
        this.tileInfoPanel.setVisible(false);
        if (this.getFreeColClient().isMapEditor()) {
            this.mapEditorPanel.setVisible(true);
        } else if (viewMode == 1) {
            this.tileInfoPanel.setVisible(true);
        } else if (this.unitInfoPanel.getUnit() != null) {
            this.unitInfoPanel.setVisible(true);
        } else if (this.getMyPlayer() != null && !this.getMyPlayer().hasNextActiveUnit()) {
            this.endTurnPanel.setVisible(true);
        }
        if (this.useSkin && this.skin != null) {
            graphics.drawImage(this.skin, 0, 0, null);
        }
        super.paintComponent(graphics);
    }

    public class EndTurnPanel
    extends JPanel {
        public EndTurnPanel(GUI gui) {
            super((LayoutManager)new MigLayout("wrap 1, center", "[center]", ""));
            String labelString = Messages.message("infoPanel.endTurnPanel.text");
            int width = this.getFontMetrics(this.getFont()).stringWidth(labelString);
            if (width > 150) {
                int index = Messages.getBreakingPoint(labelString);
                if (index > 0) {
                    this.add(new JLabel(labelString.substring(0, index)));
                    this.add(new JLabel(labelString.substring(index + 1)));
                } else {
                    this.add(new JLabel(labelString));
                }
            } else {
                this.add(new JLabel(labelString));
            }
            this.add(new JButton(InfoPanel.this.getFreeColClient().getActionManager().getFreeColAction("endTurnAction")));
            this.setOpaque(false);
            this.setSize(this.getPreferredSize());
        }
    }

    public class UnitInfoPanel
    extends JPanel {
        private Unit unit;

        public UnitInfoPanel() {
            super((LayoutManager)new MigLayout("wrap 6, fill, gap 0 0", "", ""));
            this.setSize(226, 100);
            this.setOpaque(false);
        }

        public void update(Unit unit) {
            this.unit = unit;
            this.removeAll();
            ImageLibrary lib = InfoPanel.this.getLibrary();
            if (unit != null) {
                this.add((Component)new JLabel(lib.getUnitImageIcon(unit)), "spany, gapafter 5px");
                String name = Messages.message(Messages.getLabel(unit));
                int index = name.indexOf(" (");
                if (index < 0) {
                    this.add((Component)new JLabel(name), "span");
                } else {
                    this.add((Component)new JLabel(name.substring(0, index)), "span");
                    this.add((Component)new JLabel(name.substring(index + 1)), "span");
                }
                String text = unit.isInEurope() ? Messages.message(unit.getOwner().getEurope().getNameKey()) : Messages.message("moves") + " " + unit.getMovesAsString();
                this.add((Component)new JLabel(text), "span");
                if (unit.canCarryTreasure()) {
                    text = unit.getTreasureAmount() + " " + Messages.message("gold");
                    this.add((Component)new JLabel(text), "span");
                } else if (unit.isCarrier()) {
                    JLabel label;
                    ImageIcon icon;
                    for (Goods goods : unit.getGoodsList()) {
                        icon = lib.getScaledGoodsImageIcon(goods.getType(), 0.66f);
                        label = new JLabel(icon);
                        text = Messages.message(StringTemplate.template("model.goods.goodsAmount").addAmount("%amount%", goods.getAmount()).add("%goods%", goods.getNameKey()));
                        label.setToolTipText(text);
                        this.add(label);
                    }
                    for (Unit carriedUnit : unit.getUnitList()) {
                        icon = lib.getUnitImageIcon(carriedUnit, 0.5);
                        label = new JLabel(icon);
                        text = Messages.message(carriedUnit.getLabel());
                        label.setToolTipText(text);
                        this.add(label);
                    }
                } else {
                    for (EquipmentType et : unit.getEquipment().keySet()) {
                        for (AbstractGoods ag : et.getRequiredGoods()) {
                            int amount = ag.getAmount() * unit.getEquipment().getCount(et);
                            ImageIcon icon = lib.getScaledGoodsImageIcon(ag.getType(), 0.66f);
                            JLabel label = new JLabel(Integer.toString(amount), icon, 0);
                            text = Messages.message(StringTemplate.template("model.goods.goodsAmount").addAmount("%amount%", amount).add("%goods%", ag.getNameKey()));
                            label.setToolTipText(text);
                            this.add(label);
                        }
                    }
                }
            }
            this.revalidate();
            this.repaint();
        }

        public Unit getUnit() {
            return this.unit;
        }
    }

    public class TileInfoPanel
    extends JPanel {
        private Tile tile;
        private Font font;

        public TileInfoPanel() {
            super(null);
            this.font = new JLabel().getFont().deriveFont(9.0f);
            this.setSize(226, 128);
            this.setOpaque(false);
            this.setLayout((LayoutManager)new MigLayout("fill, wrap 5, gap 2 2"));
        }

        public void update(Tile tile) {
            this.tile = tile;
            this.removeAll();
            if (tile != null) {
                Image terrain = InfoPanel.this.getLibrary().getTerrainImage(tile.getType(), tile.getX(), tile.getY());
                int width = terrain.getWidth(null);
                int height = terrain.getHeight(null);
                int compoundHeight = InfoPanel.this.getLibrary().getCompoundTerrainImageHeight(tile.getType());
                BufferedImage image = new BufferedImage(width, compoundHeight, 2);
                Graphics2D g = image.createGraphics();
                g.translate(0, compoundHeight - height);
                InfoPanel.this.getGUI().getMapViewer().displayTerrain(g, tile);
                if (tile.isExplored()) {
                    StringTemplate items = StringTemplate.label(", ");
                    items.add(tile.getNameKey());
                    for (TileImprovement tileImprovement : tile.getCompletedTileImprovements()) {
                        items.add(tileImprovement.getType().getDescriptionKey());
                    }
                    this.add((Component)new JLabel(Messages.message(items)), "span, align center");
                    this.add((Component)new JLabel(new ImageIcon(image)), "spany");
                    if (tile.getOwner() != null) {
                        JLabel ownerLabel = InfoPanel.this.localizedLabel(tile.getOwner().getNationName());
                        ownerLabel.setFont(this.font);
                        this.add((Component)ownerLabel, "span 4");
                    }
                    int defenceBonus = (int)tile.getType().applyModifier(100.0f, "model.modifier.defence") - 100;
                    JLabel defenceLabel = new JLabel(Messages.message("colopedia.terrain.defenseBonus") + " " + defenceBonus + "%");
                    defenceLabel.setFont(this.font);
                    this.add((Component)defenceLabel, "span 4");
                    JLabel moveLabel = new JLabel(Messages.message("colopedia.terrain.movementCost") + " " + String.valueOf(tile.getType().getBasicMoveCost() / 3));
                    moveLabel.setFont(this.font);
                    this.add((Component)moveLabel, "span 4");
                    List<AbstractGoods> production = tile.getType().getProduction();
                    for (AbstractGoods goods : production) {
                        JLabel goodsLabel = new JLabel(String.valueOf(tile.potential(goods.getType(), null)), InfoPanel.this.getLibrary().getScaledGoodsImageIcon(goods.getType(), 0.5), 4);
                        goodsLabel.setToolTipText(Messages.message(goods.getType().getNameKey()));
                        goodsLabel.setFont(this.font);
                        this.add(goodsLabel);
                    }
                } else {
                    this.add((Component)new JLabel(Messages.message("unexplored")), "span, align center");
                    this.add((Component)new JLabel(new ImageIcon(image)), "spany");
                }
                this.revalidate();
                this.repaint();
            }
        }

        public Tile getTile() {
            return this.tile;
        }
    }
}

