/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeColDialog<T>
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(FreeColDialog.class.getName());
    protected static final String CANCEL = "CANCEL";
    private T response = null;
    private boolean responseGiven = false;
    protected JButton cancelButton = new JButton(Messages.message("cancel"));

    public static <T> FreeColDialog<ChoiceItem<T>> createChoiceDialog(FreeColClient freeColClient, GUI gui, String text, String cancelText, List<ChoiceItem<T>> choices) {
        if (choices.isEmpty()) {
            throw new IllegalArgumentException("Can not create choice dialog with 0 choices!");
        }
        final ArrayList<JButton> choiceBtnLst = new ArrayList<JButton>();
        final FreeColDialog choiceDialog = new FreeColDialog<ChoiceItem<T>>(freeColClient, gui){

            @Override
            public void requestFocus() {
                for (JButton b : choiceBtnLst) {
                    if (!b.isEnabled()) continue;
                    b.requestFocus();
                    return;
                }
            }
        };
        choiceDialog.setLayout((LayoutManager)new MigLayout("fillx, wrap 1", "[align center]", ""));
        JTextArea textArea = FreeColDialog.getDefaultTextArea(text);
        choiceDialog.add(textArea);
        int columns = 1;
        if (choices.size() % 4 == 0 && choices.size() > 12) {
            columns = 4;
        } else if (choices.size() % 3 == 0 && choices.size() > 6) {
            columns = 3;
        } else if (choices.size() % 2 == 0 && choices.size() > 4) {
            columns = 2;
        } else if (choices.size() > 21) {
            columns = 4;
        } else if (choices.size() > 10) {
            columns = 2;
        }
        JPanel choicesPanel = new JPanel(new GridLayout(0, columns, 10, 10));
        choicesPanel.setBorder(new CompoundBorder(choicesPanel.getBorder(), new EmptyBorder(10, 20, 10, 20)));
        for (final ChoiceItem<T> object : choices) {
            JButton objectButton = new JButton(object.toString());
            if (object.isEnabled()) {
                objectButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        choiceDialog.setResponse(object);
                    }
                });
                FreeColDialog.enterPressesWhenFocused(objectButton);
            }
            objectButton.setEnabled(object.isEnabled());
            choiceBtnLst.add(objectButton);
            choicesPanel.add(objectButton);
        }
        if (choices.size() > 20) {
            JScrollPane scrollPane = new JScrollPane(choicesPanel, 20, 31);
            choiceDialog.add((Component)scrollPane, "newline 20");
        } else {
            choicesPanel.setOpaque(false);
            choiceDialog.add((Component)choicesPanel, "newline 20");
        }
        if (cancelText != null) {
            choiceDialog.cancelButton.setText(cancelText);
            choiceDialog.add((Component)choiceDialog.cancelButton, "newline 20, tag cancel");
            choiceDialog.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    choiceDialog.setResponse(null);
                }
            });
        }
        choiceDialog.setSize(choiceDialog.getPreferredSize());
        return choiceDialog;
    }

    public static FreeColDialog<Boolean> createConfirmDialog(FreeColClient freeColClient, GUI gui, String text, String okText, String cancelText) {
        return FreeColDialog.createConfirmDialog(freeColClient, gui, new String[]{text}, null, okText, cancelText);
    }

    public static FreeColDialog<Boolean> createConfirmDialog(FreeColClient freeColClient, GUI gui, String[] texts, ImageIcon[] icons, String okText, String cancelText) {
        final FreeColDialog<Boolean> confirmDialog = new FreeColDialog<Boolean>(freeColClient, gui);
        confirmDialog.setLayout((LayoutManager)new MigLayout("wrap 2", "[][fill]", ""));
        confirmDialog.okButton.setText(okText);
        confirmDialog.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                confirmDialog.setResponse(Boolean.TRUE);
            }
        });
        confirmDialog.cancelButton.setText(cancelText);
        confirmDialog.cancelButton.removeActionListener(confirmDialog);
        confirmDialog.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                confirmDialog.setResponse(Boolean.FALSE);
            }
        });
        for (int i = 0; i < texts.length; ++i) {
            if (icons != null && icons[i] != null) {
                confirmDialog.add(new JLabel(icons[i]));
                confirmDialog.add(FreeColDialog.getDefaultTextArea(texts[i]));
                continue;
            }
            confirmDialog.add((Component)FreeColDialog.getDefaultTextArea(texts[i]), "skip");
        }
        confirmDialog.add((Component)confirmDialog.okButton, "newline 20, span, split 2, tag ok");
        confirmDialog.add((Component)confirmDialog.cancelButton, "tag cancel");
        return confirmDialog;
    }

    public static FreeColDialog<String> createInputDialog(FreeColClient freeColClient, GUI gui, String text, String defaultValue, String okText, String cancelText) {
        final JTextField input = new JTextField(defaultValue);
        final FreeColDialog<String> inputDialog = new FreeColDialog<String>(freeColClient, gui){

            @Override
            public void requestFocus() {
                input.requestFocus();
            }
        };
        inputDialog.setLayout((LayoutManager)new MigLayout("wrap 1, gapy 20", "", ""));
        inputDialog.okButton.setText(okText);
        inputDialog.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inputDialog.setResponse(input.getText());
            }
        });
        input.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inputDialog.setResponse(input.getText());
            }
        });
        input.selectAll();
        inputDialog.add(FreeColDialog.getDefaultTextArea(text));
        inputDialog.add((Component)input, "width 180:, growx");
        if (cancelText == null) {
            inputDialog.add((Component)inputDialog.okButton, "tag ok");
            inputDialog.setCancelComponent(inputDialog.okButton);
            inputDialog.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    inputDialog.setResponse(null);
                }
            });
        } else {
            inputDialog.cancelButton.setText(cancelText);
            inputDialog.add((Component)inputDialog.okButton, "split 2, tag ok");
            inputDialog.add((Component)inputDialog.cancelButton, "tag cancel");
            inputDialog.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    inputDialog.setResponse(null);
                }
            });
        }
        inputDialog.setSize(inputDialog.getPreferredSize());
        return inputDialog;
    }

    public static FreeColDialog<File> createLoadDialog(FreeColClient freeColClient, GUI gui, File directory, FileFilter[] fileFilters) {
        FreeColDialog<File> loadDialog = new FreeColDialog<File>(freeColClient, gui);
        JFileChooser fileChooser = new JFileChooser(directory);
        if (fileFilters.length > 0) {
            for (FileFilter fileFilter : fileFilters) {
                fileChooser.addChoosableFileFilter(fileFilter);
            }
            fileChooser.setFileFilter(fileFilters[0]);
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileHidingEnabled(false);
        fileChooser.addActionListener(loadDialog);
        loadDialog.setLayout(new BorderLayout());
        loadDialog.add(fileChooser);
        loadDialog.setSize(480, 320);
        return loadDialog;
    }

    public static FreeColDialog<Dimension> createMapSizeDialog(FreeColClient freeColClient, final GUI gui) {
        int defaultHeight = 100;
        int defaultWidth = 40;
        int COLUMNS = 5;
        String widthText = Messages.message("width");
        String heightText = Messages.message("height");
        final JTextField inputWidth = new JTextField(Integer.toString(40), 5);
        final JTextField inputHeight = new JTextField(Integer.toString(100), 5);
        final FreeColDialog<Dimension> mapSizeDialog = new FreeColDialog<Dimension>(freeColClient, gui);
        mapSizeDialog.setLayout((LayoutManager)new MigLayout("wrap 2"));
        mapSizeDialog.okButton.setText(Messages.message("ok"));
        mapSizeDialog.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int width = Integer.parseInt(inputWidth.getText());
                    int height = Integer.parseInt(inputHeight.getText());
                    if (width <= 0 || height <= 0) {
                        throw new NumberFormatException();
                    }
                    mapSizeDialog.setResponse(new Dimension(width, height));
                }
                catch (NumberFormatException nfe) {
                    gui.errorMessage("integerAboveZero");
                }
            }
        });
        JLabel widthLabel = new JLabel(widthText);
        widthLabel.setLabelFor(inputWidth);
        JLabel heightLabel = new JLabel(heightText);
        heightLabel.setLabelFor(inputHeight);
        mapSizeDialog.add((Component)new JLabel(Messages.message("editor.mapSize")), "span, align center");
        mapSizeDialog.add((Component)widthLabel, "newline 20");
        mapSizeDialog.add(inputWidth);
        mapSizeDialog.add(heightLabel);
        mapSizeDialog.add(inputHeight);
        mapSizeDialog.add((Component)mapSizeDialog.okButton, "newline 20, span, split2, tag ok");
        mapSizeDialog.add((Component)mapSizeDialog.cancelButton, "tag cancel");
        mapSizeDialog.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                mapSizeDialog.setResponse(null);
            }
        });
        mapSizeDialog.setSize(mapSizeDialog.getPreferredSize());
        return mapSizeDialog;
    }

    public static FreeColDialog<File> createSaveDialog(FreeColClient freeColClient, GUI gui, File directory, String standardName, FileFilter[] fileFilters, String defaultName) {
        FreeColDialog<File> saveDialog = new FreeColDialog<File>(freeColClient, gui);
        JFileChooser fileChooser = new JFileChooser(directory);
        File defaultFile = new File(defaultName);
        fileChooser.putClientProperty("standardName", standardName);
        fileChooser.setDialogType(1);
        if (fileFilters.length > 0) {
            for (int i = 0; i < fileFilters.length; ++i) {
                fileChooser.addChoosableFileFilter(fileFilters[i]);
            }
            fileChooser.setFileFilter(fileFilters[0]);
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileHidingEnabled(false);
        fileChooser.setSelectedFile(defaultFile);
        fileChooser.addActionListener(saveDialog);
        saveDialog.setLayout(new BorderLayout());
        saveDialog.add(fileChooser);
        saveDialog.setSize(480, 320);
        return saveDialog;
    }

    public static FileFilter getFGOFileFilter() {
        return new FreeColFileFilter(".fgo", "filter.gameOptions");
    }

    public static FileFilter getFSGFileFilter() {
        return new FreeColFileFilter(".fsg", "filter.savedGames");
    }

    public static FileFilter getGameOptionsFileFilter() {
        return new FreeColFileFilter(".fgo", ".fsg", "filter.gameOptionsAndSavedGames");
    }

    public FreeColDialog(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
        this.cancelButton.setActionCommand(CANCEL);
        this.cancelButton.addActionListener(this);
        FreeColDialog.enterPressesWhenFocused(this.cancelButton);
        this.setCancelComponent(this.cancelButton);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (CANCEL.equals(command)) {
            this.setResponse(null);
        } else if ("ApproveSelection".equals(command)) {
            File selectedFile;
            String standardName;
            JFileChooser fileChooser = (JFileChooser)event.getSource();
            File file = fileChooser.getSelectedFile();
            if (fileChooser.getDialogType() == 1 && (standardName = (String)fileChooser.getClientProperty("standardName")) != null && !file.getName().endsWith(standardName)) {
                file = new File(file.getAbsolutePath() + standardName);
            }
            if ((selectedFile = file) != null) {
                this.setResponse(selectedFile);
            }
        } else if ("CancelSelection".equals(command)) {
            this.setResponse(null);
        } else {
            super.actionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T getResponse() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.getToolkit().getSystemEventQueue();
                while (!this.responseGiven) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object src = event.getSource();
                    try {
                        if (event instanceof ActiveEvent) {
                            ((ActiveEvent)((Object)event)).dispatch();
                            continue;
                        }
                        if (src instanceof Component) {
                            ((Component)src).dispatchEvent(event);
                            continue;
                        }
                        if (src instanceof MenuComponent) {
                            ((MenuComponent)src).dispatchEvent(event);
                            continue;
                        }
                        logger.warning("unable to dispatch event: " + event);
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                while (!this.responseGiven) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        T tempResponse = this.response;
        this.response = null;
        this.responseGiven = false;
        return tempResponse;
    }

    public void initialize() {
    }

    public void resetResponse() {
        this.response = null;
        this.responseGiven = false;
    }

    public synchronized void setResponse(T response) {
        this.response = response;
        this.responseGiven = true;
        logger.info("Response has been set to " + response);
        this.notifyAll();
    }

    static final class FreeColFileFilter
    extends FileFilter {
        private final String extension1;
        private final String extension2;
        private final String description;

        FreeColFileFilter(String extension, String descriptionMessage) {
            this.extension1 = extension;
            this.extension2 = "....";
            this.description = Messages.message(descriptionMessage);
        }

        FreeColFileFilter(String extension1, String extension2, String descriptionMessage) {
            this.extension1 = extension1;
            this.extension2 = extension2;
            this.description = Messages.message(descriptionMessage);
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(this.extension1) || f.getName().endsWith(this.extension2);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

