/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FatherDetailPanel
extends ColopediaGameObjectTypePanel<FoundingFather> {
    public FatherDetailPanel(FreeColClient freeColClient, GUI gui, ColopediaPanel colopediaPanel) {
        super(freeColClient, gui, colopediaPanel, ColopediaAction.PanelType.FATHERS.toString(), 0.75);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        EnumMap fathersByType = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            fathersByType.put(fatherType, new ArrayList());
        }
        for (FoundingFather foundingFather : this.getSpecification().getFoundingFathers()) {
            ((List)fathersByType.get((Object)foundingFather.getType())).add(foundingFather);
        }
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            String id = FoundingFather.getTypeKey(fatherType);
            String typeName = Messages.message(id);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, id, typeName, null));
            parent.add(node);
            for (FoundingFather father : (List)fathersByType.get((Object)fatherType)) {
                ImageIcon icon = new ImageIcon(ResourceManager.getImage("model.goods.bells.image", this.getScale()));
                node.add(this.buildItem(father, icon));
            }
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        block3: {
            try {
                FoundingFather father = this.getSpecification().getFoundingFather(id);
                this.buildDetail(father, panel);
            }
            catch (IllegalArgumentException e) {
                panel.setLayout((LayoutManager)new MigLayout("wrap 1, align center", "align center"));
                JLabel header = this.localizedLabel(id + ".name");
                header.setFont(smallHeaderFont);
                panel.add((Component)header, "align center, wrap 20");
                if (this.getId().equals(id)) {
                    panel.add(FatherDetailPanel.getDefaultTextArea(Messages.message("colopedia.foundingFather.description"), 40));
                }
                Image image = ResourceManager.getImage(id + ".image");
                if (image == null) break block3;
                header.setText(Messages.message(id));
                panel.add(new JLabel(new ImageIcon(image)));
            }
        }
    }

    public void buildDetail(FoundingFather father, JPanel panel) {
        panel.setLayout((LayoutManager)new MigLayout("wrap 2, fillx, gapx 20", "", ""));
        String name = Messages.message(father.getNameKey());
        String type = Messages.message(father.getTypeKey());
        JLabel header = new JLabel(name + " (" + type + ")");
        header.setFont(smallHeaderFont);
        panel.add((Component)header, "span, align center, wrap 40");
        Image image = this.getLibrary().getFoundingFatherImage(father);
        panel.add((Component)new JLabel(new ImageIcon(image)), "top");
        StringBuilder text = new StringBuilder();
        text.append(Messages.message(father.getDescriptionKey()));
        text.append("\n\n[");
        text.append(Messages.message(father.getId() + ".birthAndDeath"));
        text.append("] ");
        text.append(Messages.message(father.getId() + ".text"));
        Turn turn = this.getElectionTurns().get(name);
        if (turn != null) {
            text.append("\n\n");
            text.append(Messages.message("report.continentalCongress.elected"));
            text.append(" ");
            text.append(Messages.message(turn.getLabel()));
        }
        JTextArea description = FatherDetailPanel.getDefaultTextArea(text.toString(), 20);
        panel.add((Component)description, "top, growx");
    }
}

