/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmigrationPanel
extends FreeColDialog<Integer> {
    private static final Logger logger = Logger.getLogger(EmigrationPanel.class.getName());
    private static final int NUMBER_OF_PERSONS = 3;
    private static final JButton[] person = new JButton[3];
    private JTextArea question = EmigrationPanel.getDefaultTextArea(Messages.message("chooseImmigrant"));

    public EmigrationPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
        for (int index = 0; index < 3; ++index) {
            EmigrationPanel.person[index] = new JButton();
            person[index].setActionCommand(String.valueOf(index));
            person[index].addActionListener(this);
            EmigrationPanel.enterPressesWhenFocused(person[index]);
        }
    }

    @Override
    public void requestFocus() {
        person[0].requestFocus();
    }

    public void initialize(Europe europe, boolean fountainOfYouth) {
        if (fountainOfYouth) {
            this.question.insert(Messages.message("lostCityRumour.FountainOfYouth") + "\n\n", 0);
        }
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "[fill]", ""));
        this.add((Component)this.question, "wrap 20");
        for (int index = 0; index < 3; ++index) {
            UnitType unitType = europe.getRecruitable(index);
            ImageIcon unitIcon = this.getLibrary().getUnitImageIcon(unitType, 0.66);
            person[index].setText(Messages.message(unitType.getNameKey()));
            person[index].setIcon(unitIcon);
            this.add(person[index]);
        }
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            int action = Integer.valueOf(command);
            if (action >= 0 && action < 3) {
                this.setResponse(new Integer(action));
            } else {
                logger.warning("Invalid Actioncommand: invalid number.");
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

