/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.QuickActionMenu;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Unit;

public final class DragListener
extends MouseAdapter {
    private static final Logger logger = Logger.getLogger(DragListener.class.getName());
    private final FreeColPanel parentPanel;
    private FreeColClient freeColClient;
    private GUI gui;

    public DragListener(FreeColClient freeColClient, GUI gui, FreeColPanel parentPanel) {
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.parentPanel = parentPanel;
    }

    public void mousePressed(MouseEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (e.getButton() == 3 || e.isPopupTrigger()) {
            if (this.parentPanel.isEditable()) {
                int elements;
                QuickActionMenu menu = null;
                if (comp instanceof UnitLabel) {
                    menu = new QuickActionMenu(this.freeColClient, this.gui, this.parentPanel);
                    menu.createUnitMenu((UnitLabel)comp);
                } else if (comp instanceof GoodsLabel) {
                    menu = new QuickActionMenu(this.freeColClient, this.gui, this.parentPanel);
                    menu.createGoodsMenu((GoodsLabel)comp);
                } else if (comp instanceof MarketLabel && this.parentPanel instanceof EuropePanel) {
                    GoodsType goodsType = ((MarketLabel)comp).getType();
                    if (this.freeColClient.getInGameController().payArrears(goodsType)) {
                        ((EuropePanel)this.parentPanel).revalidate();
                        ((EuropePanel)this.parentPanel).refresh();
                    }
                }
                if (menu != null && (elements = menu.getSubElements().length) > 0) {
                    int lastIndex = menu.getComponentCount() - 1;
                    if (menu.getComponent(lastIndex) instanceof JPopupMenu.Separator) {
                        menu.remove(lastIndex);
                    }
                    if (this.gui.isWindowed() && System.getProperty("os.name").startsWith("Windows")) {
                        menu.show(this.gui.getCanvas(), menu.getLocation().x, 0);
                    } else if (!this.gui.isWindowed() && Toolkit.getDefaultToolkit().getScreenSize().getHeight() < 768.0) {
                        menu.show(this.gui.getCanvas(), menu.getLocation().x, 0);
                    } else {
                        menu.show(comp, e.getX(), e.getY());
                    }
                }
            }
        } else {
            Unit u;
            if (comp instanceof AbstractGoodsLabel) {
                AbstractGoodsLabel label = (AbstractGoodsLabel)comp;
                if (e.isShiftDown()) {
                    label.setPartialChosen(true);
                } else if (e.isAltDown()) {
                    label.toEquip(true);
                } else {
                    label.setPartialChosen(false);
                    label.setDefaultAmount();
                }
            } else if (comp instanceof UnitLabel && (u = ((UnitLabel)comp).getUnit()).isCarrier() && !u.isAtSea() && this.parentPanel instanceof PortPanel) {
                ((PortPanel)this.parentPanel).setSelectedUnitLabel((UnitLabel)comp);
            }
            TransferHandler handler = comp.getTransferHandler();
            if (handler != null) {
                handler.exportAsDrag(comp, e, 1);
            }
        }
    }
}

