/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.resources.ResourceManager;

public class ConstructionPanel
extends JPanel
implements PropertyChangeListener {
    private final boolean openBuildQueue;
    private Colony colony;
    public static final String EVENT = Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString();
    private StringTemplate defaultLabel = StringTemplate.key("colonyPanel.clickToBuild");
    private GUI gui;

    public ConstructionPanel(GUI gui, Colony colony, boolean openBuildQueue) {
        this.gui = gui;
        this.openBuildQueue = openBuildQueue;
        this.setLayout((LayoutManager)new MigLayout("fill, gapy 2:5, wrap 2", "push[]10[center]push"));
        this.setColony(colony);
    }

    public void setColony(Colony newColony) {
        if (newColony != this.colony) {
            if (this.colony != null) {
                this.colony.removePropertyChangeListener(EVENT, this);
                for (MouseListener listener : this.getMouseListeners()) {
                    this.removeMouseListener(listener);
                }
            }
            this.colony = newColony;
            this.colony.addPropertyChangeListener(EVENT, this);
            if (this.openBuildQueue) {
                this.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        ConstructionPanel.this.gui.showBuildQueuePanel(ConstructionPanel.this.colony);
                    }
                });
            }
        }
        this.initialize(this.colony.getCurrentlyBuilding());
    }

    private void initialize(BuildableType buildable) {
        this.removeAll();
        if (buildable == null) {
            String clickToBuild = Messages.message(this.getDefaultLabel());
            int breakingPoint = Messages.getBreakingPoint(clickToBuild);
            if (breakingPoint > 0) {
                this.add((Component)new JLabel(clickToBuild.substring(0, breakingPoint)), "span, align center");
                this.add((Component)new JLabel(clickToBuild.substring(breakingPoint + 1)), "span, align center");
            } else {
                this.add((Component)new JLabel(clickToBuild), "span, align center");
            }
        } else {
            int turnsToComplete = this.colony.getTurnsToComplete(buildable);
            String turnsStr = Messages.getTurnsText(turnsToComplete);
            this.add((Component)new JLabel(new ImageIcon(ResourceManager.getImage(buildable.getId() + ".image", 0.75))), "spany");
            this.add(new JLabel(Messages.message(StringTemplate.template("colonyPanel.currentlyBuilding").addName("%buildable%", buildable))));
            this.add(new JLabel(Messages.message(StringTemplate.template("turnsToComplete.long").addName("%number%", turnsStr))));
            for (AbstractGoods ag : buildable.getRequiredGoods()) {
                int amountNeeded = ag.getAmount();
                int amountAvailable = this.colony.getGoodsCount(ag.getType());
                int amountProduced = this.colony.getAdjustedNetProductionOf(ag.getType());
                this.add((Component)new FreeColProgressBar(this.gui, ag.getType(), 0, amountNeeded, amountAvailable, amountProduced), "height 20:");
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void update() {
        this.initialize(this.colony.getCurrentlyBuilding());
    }

    public final StringTemplate getDefaultLabel() {
        return this.defaultLabel;
    }

    public final void setDefaultLabel(StringTemplate newDefaultLabel) {
        this.defaultLabel = newDefaultLabel;
    }

    public void propertyChange(PropertyChangeEvent event) {
        List buildQueue = (List)event.getNewValue();
        if (buildQueue == null || buildQueue.isEmpty()) {
            this.initialize(null);
        } else {
            this.initialize((BuildableType)buildQueue.get(0));
        }
    }

    public void removePropertyChangeListeners() {
        this.colony.removePropertyChangeListener(EVENT, this);
    }

    public String getUIClassID() {
        return "ConstructionPanelUI";
    }
}

