/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.AbstractUnitOptionUI;
import net.sf.freecol.client.gui.option.AudioMixerOptionUI;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.FileOptionUI;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.option.IntegerOptionUI;
import net.sf.freecol.client.gui.option.LanguageOptionUI;
import net.sf.freecol.client.gui.option.ListOptionUI;
import net.sf.freecol.client.gui.option.ModOptionUI;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.client.gui.option.PercentageOptionUI;
import net.sf.freecol.client.gui.option.RangeOptionUI;
import net.sf.freecol.client.gui.option.SelectOptionUI;
import net.sf.freecol.client.gui.option.StringOptionUI;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.ModListOption;
import net.sf.freecol.common.option.ModOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitListOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionUI<T extends Option<?>>
implements OptionUpdater {
    private boolean editable;
    private JLabel label = new JLabel();
    private T option;
    protected final GUI gui;

    public OptionUI(GUI gui, T option, boolean editable) {
        this.gui = gui;
        this.option = option;
        this.editable = editable;
        String name = Messages.getName(option);
        String text = Messages.getDescription(option);
        this.label.setText(name);
        this.label.setToolTipText(text);
    }

    protected void initialize() {
        JComponent component = this.getComponent();
        component.setToolTipText(this.label.getToolTipText());
        component.setEnabled(this.editable);
        component.setOpaque(false);
    }

    public final T getOption() {
        return this.option;
    }

    public final void setOption(T newOption) {
        this.option = newOption;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public JLabel getLabel() {
        return this.label;
    }

    protected void setLabel(JLabel label) {
        this.label = label;
    }

    public abstract JComponent getComponent();

    @Override
    public abstract void updateOption();

    @Override
    public abstract void reset();

    public ListCellRenderer getListCellRenderer() {
        return null;
    }

    public static OptionUI getOptionUI(GUI gui, Option option, boolean editable) {
        if (option instanceof BooleanOption) {
            return new BooleanOptionUI(gui, (BooleanOption)option, editable);
        }
        if (option instanceof FileOption) {
            return new FileOptionUI(gui, (FileOption)option, editable);
        }
        if (option instanceof PercentageOption) {
            return new PercentageOptionUI(gui, (PercentageOption)option, editable);
        }
        if (option instanceof RangeOption) {
            return new RangeOptionUI(gui, (RangeOption)option, editable);
        }
        if (option instanceof SelectOption) {
            return new SelectOptionUI(gui, (SelectOption)option, editable);
        }
        if (option instanceof IntegerOption) {
            return new IntegerOptionUI(gui, (IntegerOption)option, editable);
        }
        if (option instanceof StringOption) {
            return new StringOptionUI(gui, (StringOption)option, editable);
        }
        if (option instanceof LanguageOption) {
            return new LanguageOptionUI(gui, (LanguageOption)option, editable);
        }
        if (option instanceof AudioMixerOption) {
            return new AudioMixerOptionUI(gui, (AudioMixerOption)option, editable);
        }
        if (option instanceof FreeColAction) {
            return new FreeColActionUI(gui, (FreeColAction)option, editable);
        }
        if (option instanceof AbstractUnitOption) {
            return new AbstractUnitOptionUI(gui, (AbstractUnitOption)option, editable);
        }
        if (option instanceof ModOption) {
            return new ModOptionUI(gui, (ModOption)option, editable);
        }
        if (option instanceof UnitListOption) {
            return new ListOptionUI<AbstractUnit>(gui, (UnitListOption)option, editable);
        }
        if (option instanceof ModListOption) {
            return new ListOptionUI<FreeColModFile>(gui, (ModListOption)option, editable);
        }
        return null;
    }
}

