/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.ListOption;
import net.sf.freecol.common.option.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListOptionUI<T>
extends OptionUI<ListOption<T>>
implements ListSelectionListener {
    private static Logger logger = Logger.getLogger(ListOptionUI.class.getName());
    private JPanel panel = new JPanel();
    private JList list;
    private DefaultListModel model;
    private JButton editButton = new JButton(Messages.message("list.edit"));
    private JButton addButton = new JButton(Messages.message("list.add"));
    private JButton removeButton = new JButton(Messages.message("list.remove"));
    private JButton upButton = new JButton(Messages.message("list.up"));
    private JButton downButton = new JButton(Messages.message("list.down"));
    private JButton[] buttons = new JButton[]{this.editButton, this.addButton, this.removeButton, this.upButton, this.downButton};

    public ListOptionUI(final GUI gui, ListOption<T> option, boolean editable) {
        super(gui, option, editable);
        OptionUI ui;
        AbstractOption o;
        this.panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), super.getLabel().getText()));
        this.panel.setLayout((LayoutManager)new MigLayout("wrap 2, fill", "[fill, grow]20[fill]"));
        this.model = new DefaultListModel();
        Iterator i$ = option.getValue().iterator();
        while (i$.hasNext()) {
            AbstractOption o2 = (AbstractOption)i$.next();
            try {
                this.model.addElement(o2.clone());
            }
            catch (CloneNotSupportedException e) {
                logger.warning(e.toString());
            }
        }
        this.list = new JList(this.model);
        AbstractOption abstractOption = o = option.getValue().isEmpty() ? option.getTemplate() : (AbstractOption)option.getValue().get(0);
        if (o != null && (ui = OptionUI.getOptionUI(gui, o, editable)) != null && ui.getListCellRenderer() != null) {
            this.list.setCellRenderer(ui.getListCellRenderer());
        }
        this.list.setVisibleRowCount(4);
        JScrollPane pane = new JScrollPane(this.list);
        this.panel.add((Component)pane, "grow, spany 5");
        for (JButton button : this.buttons) {
            button.setEnabled(editable);
            this.panel.add(button);
        }
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractOption oldValue = (AbstractOption)ListOptionUI.this.list.getSelectedValue();
                if (oldValue == null) {
                    oldValue = ((ListOption)ListOptionUI.this.getOption()).getTemplate();
                }
                try {
                    Option value = oldValue.clone();
                    if (gui.showEditOptionDialog(value)) {
                        ListOptionUI.this.model.addElement(value);
                        ListOptionUI.this.list.setSelectedValue(value, true);
                        ListOptionUI.this.list.repaint();
                    }
                }
                catch (CloneNotSupportedException ex) {
                    logger.warning(ex.toString());
                }
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object object = ListOptionUI.this.list.getSelectedValue();
                if (object != null && gui.showEditOptionDialog((Option)object)) {
                    ListOptionUI.this.list.repaint();
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ListOptionUI.this.model.removeElementAt(ListOptionUI.this.list.getSelectedIndex());
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ListOptionUI.this.list.getSelectedIndex() == 0) {
                    return;
                }
                int index = ListOptionUI.this.list.getSelectedIndex();
                Object temp = ListOptionUI.this.model.getElementAt(index);
                ListOptionUI.this.model.setElementAt(ListOptionUI.this.model.getElementAt(index - 1), index);
                ListOptionUI.this.model.setElementAt(temp, index - 1);
                ListOptionUI.this.list.setSelectedIndex(index - 1);
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ListOptionUI.this.list.getSelectedIndex() == ListOptionUI.this.model.getSize() - 1) {
                    return;
                }
                int index = ListOptionUI.this.list.getSelectedIndex();
                Object temp = ListOptionUI.this.model.getElementAt(index);
                ListOptionUI.this.model.setElementAt(ListOptionUI.this.model.getElementAt(index + 1), index);
                ListOptionUI.this.model.setElementAt(temp, index + 1);
                ListOptionUI.this.list.setSelectedIndex(index + 1);
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.list.addListSelectionListener(this);
        this.initialize();
    }

    @Override
    public final JLabel getLabel() {
        return null;
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        ((ListOption)this.getOption()).setValue(this.getValue());
    }

    private List<AbstractOption<T>> getValue() {
        ArrayList<AbstractOption<T>> result = new ArrayList<AbstractOption<T>>();
        Enumeration e = this.model.elements();
        while (e.hasMoreElements()) {
            result.add((AbstractOption)e.nextElement());
        }
        return result;
    }

    @Override
    public void reset() {
        this.model.clear();
        Iterator i$ = ((ListOption)this.getOption()).getValue().iterator();
        while (i$.hasNext()) {
            AbstractOption o = (AbstractOption)i$.next();
            this.model.addElement(o);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            boolean enabled = this.isEditable() && this.list.getSelectedValue() != null;
            this.editButton.setEnabled(enabled);
            this.removeButton.setEnabled(enabled);
            this.upButton.setEnabled(enabled);
            this.downButton.setEnabled(enabled);
        }
    }
}

