/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.animation.UnitImageAnimation;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

final class UnitAttackAnimation {
    private final Unit attacker;
    private final Unit defender;
    private final Tile attackerTile;
    private final Tile defenderTile;
    private final boolean success;
    private GUI gui;

    public UnitAttackAnimation(GUI gui, Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        this.gui = gui;
        this.attacker = attacker;
        this.defender = defender;
        this.attackerTile = attackerTile;
        this.defenderTile = defenderTile;
        this.success = success;
    }

    private SimpleZippedAnimation getAnimation(Unit unit, Map.Direction direction) {
        float scale = this.gui.getMapScale();
        String roleStr = unit.getRole() == Unit.Role.DEFAULT ? "" : "." + unit.getRole().getId();
        String startStr = unit.getType().getId() + roleStr + ".attack.";
        String specialId = startStr + direction.toString().toLowerCase() + ".animation";
        SimpleZippedAnimation sza = ResourceManager.getSimpleZippedAnimation(specialId, scale);
        if (sza == null) {
            String genericDirection;
            switch (direction) {
                case SW: 
                case W: 
                case NW: {
                    genericDirection = "w";
                    break;
                }
                default: {
                    genericDirection = "e";
                }
            }
            String genericId = startStr + genericDirection + ".animation";
            sza = ResourceManager.getSimpleZippedAnimation(genericId, scale);
        }
        return sza;
    }

    public void animate() {
        SimpleZippedAnimation sza;
        Map.Direction direction = this.attackerTile.getDirection(this.defenderTile);
        if (this.gui.getAnimationSpeed(this.attacker) > 0 && (sza = this.getAnimation(this.attacker, direction)) != null) {
            new UnitImageAnimation(this.gui, this.attacker, this.attackerTile, sza).animate();
        }
        if (!this.success && this.gui.getAnimationSpeed(this.defender) > 0 && (sza = this.getAnimation(this.defender, direction = direction.getReverseDirection())) != null) {
            new UnitImageAnimation(this.gui, this.defender, this.defenderTile, sza).animate();
        }
    }
}

