/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.common.model.Map;

public class ScrollThread
extends Thread {
    public static final String COPYRIGHT = "Copyright (C) 2003-2012 The FreeCol Team";
    public static final String LICENSE = "http://www.gnu.org/licenses/gpl.html";
    public static final String REVISION = "$Revision: 9839 $";
    private static final Logger logger = Logger.getLogger(ScrollThread.class.getName());
    private final MapViewer mapViewer;
    private Map.Direction direction;
    private boolean cont;

    public ScrollThread(MapViewer mapViewer) {
        super("FreeColClient:Mouse scroller");
        this.mapViewer = mapViewer;
        this.cont = true;
    }

    public void setDirection(Map.Direction d) {
        this.direction = d;
    }

    public void stopScrolling() {
        this.cont = false;
    }

    public void run() {
        do {
            try {
                ScrollThread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ScrollThread.this.mapViewer.scrollMap(ScrollThread.this.direction);
                    }
                });
            }
            catch (InvocationTargetException e) {
                logger.log(Level.WARNING, "Scroll thread caught error", e);
                this.cont = false;
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Scroll thread interrupted", e);
                this.cont = false;
            }
        } while (this.cont);
    }
}

