/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.AbstractCanvasListener;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.server.generator.TerrainGenerator;

public final class CanvasMapEditorMouseListener
extends AbstractCanvasListener
implements MouseListener,
MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMapEditorMouseListener.class.getName());
    private final Canvas canvas;
    private Point oldPoint;
    private Point startPoint;
    private GUI gui;

    public CanvasMapEditorMouseListener(FreeColClient freeColClient, GUI gui, Canvas canvas) {
        super(freeColClient, gui.getMapViewer());
        this.gui = gui;
        this.canvas = canvas;
    }

    private Map getMap() {
        Map map = null;
        if (this.freeColClient.getGame() != null) {
            map = this.freeColClient.getGame().getMap();
        }
        return map;
    }

    public void mouseClicked(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        try {
            if (e.getClickCount() > 1) {
                Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
                this.canvas.showColonyPanel(tile);
            } else {
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseClicked!", ex);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        if (this.getMap() == null) {
            return;
        }
        try {
            if (e.getButton() == 3 || e.isPopupTrigger()) {
                Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
                if (tile != null) {
                    if (tile.hasRiver()) {
                        TileImprovement river = tile.getRiver();
                        String style = this.canvas.showRiverStyleDialog();
                        if (style == null) {
                            tile.getTileItemContainer().removeTileItem(river);
                        } else if (!style.equals("CANCEL")) {
                            river.setStyle(TileImprovementStyle.getInstance(style));
                        }
                    }
                    if (tile.getIndianSettlement() != null) {
                        this.canvas.showEditSettlementDialog(tile.getIndianSettlement());
                    }
                } else {
                    this.gui.setSelectedTile(null, true);
                }
            } else if (e.getButton() == 1) {
                this.startPoint = e.getPoint();
                this.oldPoint = e.getPoint();
                JComponent component = (JComponent)e.getSource();
                this.drawBox(component, this.startPoint, this.oldPoint);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mousePressed!", ex);
        }
    }

    public void mouseReleased(MouseEvent e) {
        boolean isTransformActive;
        if (this.getMap() == null) {
            return;
        }
        JComponent component = (JComponent)e.getSource();
        MapEditorController controller = this.freeColClient.getMapEditorController();
        boolean bl = isTransformActive = controller.getMapTransform() != null;
        if (this.startPoint == null) {
            this.startPoint = e.getPoint();
        }
        if (this.oldPoint == null) {
            this.oldPoint = e.getPoint();
        }
        this.drawBox(component, this.startPoint, this.oldPoint);
        if (this.gui.getFocus() != null) {
            int y;
            int x;
            int max_y;
            int min_y;
            int max_x;
            int min_x;
            Tile start;
            Tile end = start = this.mapViewer.convertToMapTile(this.startPoint.x, this.startPoint.y);
            if (this.startPoint.x != this.oldPoint.x || this.startPoint.y != this.oldPoint.y) {
                end = this.mapViewer.convertToMapTile(this.oldPoint.x, this.oldPoint.y);
            }
            if (!isTransformActive) {
                this.gui.setFocus(end);
                return;
            }
            if (start.getX() < end.getX()) {
                min_x = start.getX();
                max_x = end.getX();
            } else {
                min_x = end.getX();
                max_x = start.getX();
            }
            if (start.getY() < end.getY()) {
                min_y = start.getY();
                max_y = end.getY();
            } else {
                min_y = end.getY();
                max_y = start.getY();
            }
            Tile t = null;
            for (x = min_x; x <= max_x; ++x) {
                for (y = min_y; y <= max_y; ++y) {
                    t = this.getMap().getTile(x, y);
                    if (t == null) continue;
                    controller.transform(t);
                }
            }
            if (controller.getMapTransform() instanceof MapEditorTransformPanel.TileTypeTransform) {
                for (x = min_x - 2; x <= max_x + 2; ++x) {
                    for (y = min_y - 2; y <= max_y + 2; ++y) {
                        t = this.getMap().getTile(x, y);
                        if (t == null || !t.getType().isWater()) continue;
                        TerrainGenerator.encodeStyle(t);
                    }
                }
            }
            this.gui.refresh();
            this.canvas.requestFocus();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        if (e.getY() < 1) {
            return;
        }
        this.performAutoScrollIfActive(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        JComponent component = (JComponent)e.getSource();
        this.drawBox(component, this.startPoint, this.oldPoint);
        this.oldPoint = e.getPoint();
        this.drawBox(component, this.startPoint, this.oldPoint);
        this.performDragScrollIfActive(e);
        this.gui.refresh();
    }

    private void drawBox(JComponent component, Point startPoint, Point endPoint) {
        if (startPoint == null || endPoint == null) {
            return;
        }
        if (startPoint.distance(endPoint) == 0.0) {
            return;
        }
        MapEditorController controller = this.freeColClient.getMapEditorController();
        if (controller.getMapTransform() == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)component.getGraphics();
        graphics.setColor(Color.WHITE);
        int x = Math.min(startPoint.x, endPoint.x);
        int y = Math.min(startPoint.y, endPoint.y);
        int width = Math.abs(startPoint.x - endPoint.x);
        int height = Math.abs(startPoint.y - endPoint.y);
        graphics.drawRect(x, y, width, height);
    }
}

