/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.option.OptionGroup;

public final class PreGameController {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());
    private FreeColClient freeColClient;
    private GUI gui;

    public PreGameController(FreeColClient freeColClient, GUI gui) {
        this.freeColClient = freeColClient;
        this.gui = gui;
    }

    public void setReady(boolean ready) {
        this.freeColClient.getMyPlayer().setReady(ready);
        this.freeColClient.askServer().setReady(ready);
    }

    public void setNation(Nation nation) {
        this.freeColClient.getMyPlayer().setNation(nation);
        this.freeColClient.askServer().setNation(nation);
    }

    public void setNationType(NationType nationType) {
        this.freeColClient.getMyPlayer().setNationType(nationType);
        this.freeColClient.askServer().setNationType(nationType);
    }

    public void setAvailable(Nation nation, NationOptions.NationState state) {
        this.freeColClient.getGame().getNationOptions().getNations().put(nation, state);
        this.freeColClient.askServer().setAvailable(nation, state);
    }

    public void requestLaunch() {
        if (this.freeColClient.getGame().isAllPlayersReadyToLaunch()) {
            this.gui.showStatusPanel(Messages.message("status.startingGame"));
            this.freeColClient.askServer().requestLaunch();
        } else {
            this.gui.errorMessage("server.notAllReady");
        }
    }

    public void chat(String message) {
        this.freeColClient.askServer().chat(this.freeColClient.getMyPlayer(), message);
    }

    public void sendGameOptions() {
        Specification spec = this.freeColClient.getGame().getSpecification();
        OptionGroup gameOptions = spec.getOptionGroup("gameOptions");
        spec.clean();
        this.freeColClient.askServer().updateGameOptions(gameOptions);
    }

    public void sendMapGeneratorOptions() {
        OptionGroup mapOptions = this.freeColClient.getGame().getMapGeneratorOptions();
        this.freeColClient.askServer().updateMapGeneratorOption(mapOptions);
    }

    public void startGame() {
        Player myPlayer = this.freeColClient.getMyPlayer();
        if (!this.freeColClient.isHeadless()) {
            this.gui.closeMainPanel();
            this.gui.closeMenus();
            this.gui.closeStatusPanel();
            this.gui.playSound(null);
            this.gui.playSound("sound.intro." + myPlayer.getNationID());
        }
        this.freeColClient.askServer().registerMessageHandler(this.freeColClient.getInGameInputHandler());
        if (!this.freeColClient.isHeadless()) {
            this.freeColClient.setInGame(true);
            this.gui.setupInGameMenuBar();
        }
        InGameController igc = this.freeColClient.getInGameController();
        this.gui.setSelectedTile((Tile)myPlayer.getEntryLocation(), false);
        if (this.freeColClient.currentPlayerIsMyPlayer()) {
            igc.nextActiveUnit();
        }
        this.gui.setUpMouseListenersForCanvas();
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && FreeColDebugger.getDebugRunTurns() > 0) {
            this.freeColClient.skipTurns(FreeColDebugger.getDebugRunTurns());
        } else if (this.freeColClient.getGame().getTurn().getNumber() == 1) {
            ModelMessage message = new ModelMessage(ModelMessage.MessageType.TUTORIAL, "tutorial.startGame", myPlayer);
            String direction = myPlayer.getNation().startsOnEastCoast() ? "west" : "east";
            message.add("%direction%", direction);
            myPlayer.addModelMessage(message);
            igc.nextModelMessage();
        }
    }
}

