/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyWas;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeWas;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TransactionListener;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.NetworkConstants;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.server.FreeColServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InGameController
implements NetworkConstants {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    private final FreeColClient freeColClient;
    private final short UNIT_LAST_MOVE_DELAY = (short)300;
    private final int MODE_NEXT_ACTIVE_UNIT = 0;
    private final int MODE_EXECUTE_GOTO_ORDERS = 1;
    private final int MODE_END_TURN = 2;
    private int moveMode = 0;
    private int turnsPlayed = 0;
    private static FileFilter FSG_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".fsg");
        }
    };
    private HashMap<String, Integer> messagesToIgnore = new HashMap();
    private ModelMessage[] turnReportMessages;
    private GUI gui;

    public InGameController(FreeColClient freeColClient, GUI gui) {
        this.freeColClient = freeColClient;
        this.gui = gui;
    }

    public void setGameConnected() {
        this.turnsPlayed = 0;
        Player player = this.freeColClient.getMyPlayer();
        if (player != null) {
            player.refilterModelMessages(this.freeColClient.getClientOptions());
        }
        this.gui.updateMenuBar();
    }

    public void setInDebugMode() {
        FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
        this.gui.updateMenuBar();
    }

    private ServerAPI askServer() {
        return this.freeColClient.askServer();
    }

    private Specification getSpecification() {
        return this.freeColClient.getGame().getSpecification();
    }

    private boolean requireOurTurn() {
        if (!this.freeColClient.currentPlayerIsMyPlayer()) {
            if (this.freeColClient.isInGame()) {
                this.gui.showInformationMessage("notYourTurn");
            }
            return false;
        }
        return true;
    }

    private boolean confirmHostileAction(Unit attacker, Tile target) {
        Player enemy;
        if (attacker.hasAbility("model.ability.piracy")) {
            return true;
        }
        if (target.getSettlement() != null) {
            enemy = target.getSettlement().getOwner();
        } else if (target == attacker.getTile()) {
            enemy = target.getOwner();
            if (enemy == null) {
                return true;
            }
        } else {
            Unit defender = target.getDefendingUnit(attacker);
            if (defender == null) {
                logger.warning("Attacking, but no defender - will try!");
                return true;
            }
            if (defender.hasAbility("model.ability.piracy")) {
                return true;
            }
            enemy = defender.getOwner();
        }
        String messageID = null;
        switch (attacker.getOwner().getStance(enemy)) {
            case WAR: {
                logger.finest("Player at war, no confirmation needed");
                return true;
            }
            case UNCONTACTED: 
            case PEACE: {
                messageID = "model.diplomacy.attack.peace";
                break;
            }
            case CEASE_FIRE: {
                messageID = "model.diplomacy.attack.ceaseFire";
                break;
            }
            case ALLIANCE: {
                messageID = "model.diplomacy.attack.alliance";
            }
        }
        return this.gui.showConfirmDialog(attacker.getTile(), StringTemplate.template(messageID).addStringTemplate("%nation%", enemy.getNationName()), "model.diplomacy.attack.confirm", "cancel");
    }

    private boolean confirmPreCombat(Unit attacker, Tile tile) {
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowPreCombat")) {
            Settlement settlement = tile.getSettlement();
            Settlement defender = settlement != null ? settlement : tile.getDefendingUnit(attacker);
            return this.gui.showPreCombatDialog(attacker, defender, tile);
        }
        return true;
    }

    private Settlement getSettlementAt(Tile tile, Map.Direction direction) {
        return tile.getNeighbourOrNull(direction).getSettlement();
    }

    private StringTemplate getNationAt(Tile tile, Map.Direction direction) {
        Tile newTile = tile.getNeighbourOrNull(direction);
        Player player = null;
        player = newTile.getSettlement() != null ? newTile.getSettlement().getOwner() : (newTile.getFirstUnit() != null ? newTile.getFirstUnit().getOwner() : this.freeColClient.getGame().getUnknownEnemy());
        return player.getNationName();
    }

    private void updateAfterMove() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InGameController.this.freeColClient.updateActions();
                InGameController.this.gui.updateMenuBar();
            }
        });
    }

    private boolean doExecuteGotoOrders() {
        Player player = this.freeColClient.getMyPlayer();
        Unit active = this.gui.getActiveUnit();
        if (this.moveMode < 1) {
            this.moveMode = 1;
        }
        if (active != null) {
            player.setNextGoingToUnit(active);
        }
        Unit stillActive = null;
        while (player.hasNextGoingToUnit()) {
            Unit unit = player.getNextGoingToUnit();
            this.gui.setActiveUnit(unit);
            if (this.moveToDestination(unit)) {
                stillActive = unit;
            }
            this.nextModelMessage();
            if (!this.gui.isShowingSubPanel()) continue;
            this.gui.requestFocusForSubPanel();
            break;
        }
        this.gui.setActiveUnit(stillActive != null ? stillActive : active);
        return stillActive == null;
    }

    private void doEndTurn() {
        this.gui.setActiveUnit(null);
        for (Unit unit : this.freeColClient.getMyPlayer().getUnits()) {
            if (unit.getState() != Unit.UnitState.SKIPPED) continue;
            unit.setState(Unit.UnitState.ACTIVE);
        }
        this.moveMode = 0;
        ++this.turnsPlayed;
        this.turnReportMessages = null;
        this.askServer().endTurn();
    }

    private boolean followTradeRoute(Unit unit) {
        Player player = unit.getOwner();
        TradeRoute tr = unit.getTradeRoute();
        String name = tr.getName();
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        boolean detailed = this.freeColClient.getClientOptions().getBoolean("model.option.guiShowGoodsMovement");
        List<TradeRoute.Stop> stops = tr.getStops();
        boolean result = false;
        boolean more = true;
        int tries = stops.size();
        while (true) {
            boolean atStop;
            TradeRoute.Stop stop;
            if (!TradeRoute.isStopValid(unit, stop = unit.getStop())) {
                messages.add(new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.broken", unit).addName("%route%", name));
                this.clearOrders(unit);
                result = true;
                break;
            }
            if (stop.getLocation() instanceof Europe) {
                atStop = unit.isInEurope();
            } else if (stop.getLocation() instanceof Colony) {
                atStop = unit.getTile() == stop.getLocation().getTile();
            } else {
                throw new IllegalStateException("Bogus stop location: " + (FreeColGameObject)((Object)stop.getLocation()));
            }
            if (atStop) {
                Location loc;
                this.unloadUnitAtStop(unit, detailed ? messages : null);
                this.loadUnitAtStop(unit, detailed ? messages : null);
                if (unit.getMovesLeft() <= 0) break;
                int index = unit.validateCurrentStop();
                this.askServer().updateCurrentStop(unit);
                int next = unit.validateCurrentStop();
                while (true) {
                    if (++index >= stops.size()) {
                        index = 0;
                    }
                    --tries;
                    if (index == next) break;
                    if (!detailed) continue;
                    loc = stops.get(index).getLocation();
                    messages.add(new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.skipStop", unit).addName("%route%", name).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)));
                }
                if (tries >= 0) continue;
                loc = stop.getLocation();
                if (detailed) {
                    int i = 0;
                    while (i < messages.size()) {
                        ModelMessage m = (ModelMessage)messages.get(i);
                        if (m.getId().equals("traderoute.skipStop")) {
                            messages.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    messages.add(new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.noWork", unit).addName("%route%", name).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)));
                }
                unit.setState(Unit.UnitState.SKIPPED);
                break;
            }
            if (unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED || !more) break;
            Location destination = stop.getLocation();
            PathNode path = unit.findPath(destination);
            if (path == null) {
                StringTemplate dest = destination.getLocationNameFor(player);
                messages.add(new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "traderoute.noPath", unit).addName("%route%", name).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", dest));
                unit.setState(Unit.UnitState.SKIPPED);
                break;
            }
            more = this.followPath(unit, path);
            if (more) continue;
            unit.setState(Unit.UnitState.SKIPPED);
        }
        for (ModelMessage m : messages) {
            player.addModelMessage(m);
        }
        return result;
    }

    private boolean loadUnitAtStop(Unit unit, List<ModelMessage> messages) {
        TradeRoute.Stop stop = unit.getStop();
        ArrayList<GoodsType> goodsTypesToLoad = new ArrayList<GoodsType>(stop.getCargo());
        boolean ret = false;
        Colony colony = unit.getColony();
        Colony loc = unit.isInEurope() ? unit.getOwner().getEurope() : colony;
        Game game = this.freeColClient.getGame();
        for (Goods goods : unit.getGoodsList()) {
            int present;
            int atStop;
            int index;
            GoodsType type = goods.getType();
            int toLoad = 100 - goods.getAmount();
            if (toLoad <= 0 || (index = goodsTypesToLoad.indexOf(type)) < 0) continue;
            if (unit.isInEurope()) {
                atStop = Integer.MAX_VALUE;
                present = Integer.MAX_VALUE;
            } else {
                present = colony.getGoodsCount(type);
                atStop = colony.getExportAmount(type);
            }
            if (atStop > 0) {
                Goods cargo = new Goods(game, loc, type, Math.min(toLoad, atStop));
                if (this.loadGoods(cargo, unit)) {
                    if (messages != null) {
                        messages.add(this.getLoadGoodsMessage(unit, type, cargo.getAmount(), present, atStop, toLoad));
                    }
                    ret = true;
                }
            } else if (present > 0 && messages != null) {
                messages.add(this.getLoadGoodsMessage(unit, type, 0, present, 0, toLoad));
            }
            goodsTypesToLoad.remove(index);
        }
        for (GoodsType type : goodsTypesToLoad) {
            int present;
            int atStop;
            if (!unit.hasSpaceLeft()) break;
            int toLoad = 100;
            if (unit.isInEurope()) {
                atStop = Integer.MAX_VALUE;
                present = Integer.MAX_VALUE;
            } else {
                present = colony.getGoodsCount(type);
                atStop = colony.getExportAmount(type);
            }
            if (atStop > 0) {
                Goods cargo = new Goods(game, loc, type, Math.min(toLoad, atStop));
                if (!this.loadGoods(cargo, unit)) continue;
                if (messages != null) {
                    messages.add(this.getLoadGoodsMessage(unit, type, cargo.getAmount(), present, atStop, toLoad));
                }
                ret = true;
                continue;
            }
            if (present <= 0 || messages == null) continue;
            messages.add(this.getLoadGoodsMessage(unit, type, 0, present, 0, toLoad));
        }
        return ret;
    }

    private ModelMessage getLoadGoodsMessage(Unit unit, GoodsType type, int amount, int present, int atStop, int toLoad) {
        Player player = unit.getOwner();
        Location loc = unit.getLocation();
        String route = unit.getTradeRoute().getName();
        String key = null;
        int more = 0;
        if (toLoad < atStop) {
            key = "traderoute.loadImportLimited";
            more = atStop - toLoad;
        } else if (present > atStop && toLoad > atStop) {
            key = "traderoute.loadExportLimited";
            more = present - atStop;
        } else {
            key = "traderoute.load";
        }
        return new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, key, unit).addName("%route%", route).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc.getLocationNameFor(player)).addAmount("%amount%", amount).add("%goods%", type.getNameKey()).addAmount("%more%", more);
    }

    private boolean unloadUnitAtStop(Unit unit, List<ModelMessage> messages) {
        Colony colony = unit.getColony();
        TradeRoute.Stop stop = unit.getStop();
        List<GoodsType> goodsTypesToLoad = stop.getCargo();
        boolean ret = false;
        Game game = this.freeColClient.getGame();
        for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
            Goods cargo;
            GoodsType type = goods.getType();
            if (goodsTypesToLoad.contains(type)) continue;
            int atStop = colony == null ? Integer.MAX_VALUE : colony.getImportAmount(type);
            int toUnload = goods.getAmount();
            if (toUnload > atStop) {
                String locName = colony.getName();
                String overflow = Integer.toString(toUnload - atStop);
                int option = this.freeColClient.getClientOptions().getInteger("model.option.unloadOverflowResponse");
                switch (option) {
                    case 0: {
                        StringTemplate template = StringTemplate.template("traderoute.warehouseCapacity").addStringTemplate("%unit%", Messages.getLabel(unit)).addName("%colony%", locName).addName("%amount%", overflow).add("%goods%", goods.getNameKey());
                        if (this.gui.showConfirmDialog(colony.getTile(), template, "yes", "no")) break;
                        toUnload = atStop;
                        break;
                    }
                    case 1: {
                        toUnload = atStop;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        logger.warning("Illegal UNLOAD_OVERFLOW_RESPONSE: " + Integer.toString(option));
                    }
                }
            }
            if (!this.unloadGoods(cargo = goods.getAmount() == toUnload ? goods : new Goods(game, unit, type, toUnload), unit, colony)) continue;
            if (messages != null) {
                messages.add(this.getUnloadGoodsMessage(unit, type, cargo.getAmount(), atStop, goods.getAmount(), toUnload));
            }
            ret = true;
        }
        return ret;
    }

    private ModelMessage getUnloadGoodsMessage(Unit unit, GoodsType type, int amount, int atStop, int present, int toUnload) {
        String key = null;
        int overflow = 0;
        if (present == toUnload) {
            key = "traderoute.unload";
        } else if (toUnload > atStop) {
            key = "traderoute.overflow";
            overflow = toUnload - atStop;
        } else {
            key = "traderoute.nounload";
            overflow = present - atStop;
        }
        StringTemplate loc = unit.getLocation().getLocationNameFor(unit.getOwner());
        return new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, key, unit).addName("%route%", unit.getTradeRoute().getName()).addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", loc).addAmount("%amount%", amount).addAmount("%overflow%", overflow).add("%goods%", type.getNameKey());
    }

    private boolean claimTile(Player player, Tile tile, FreeColGameObject claimant, int price, int offer) {
        Player owner = tile.getOwner();
        if (price < 0) {
            return false;
        }
        if (price > 0) {
            if (offer >= price) {
                price = offer;
            } else if (offer < 0) {
                price = -1;
            } else {
                boolean canAccept = player.checkGold(price);
                switch (this.gui.showClaimDialog(tile, player, price, owner, canAccept)) {
                    case CANCEL: {
                        return false;
                    }
                    case ACCEPT: {
                        break;
                    }
                    case STEAL: {
                        price = -1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("showClaimDialog fail");
                    }
                }
            }
        }
        if (this.askServer().claimLand(tile, claimant, price) && player.owns(tile)) {
            this.gui.updateMenuBar();
            return true;
        }
        return false;
    }

    private Unit emigrate(Player player, int slot) {
        Europe europe = player.getEurope();
        EuropeWas europeWas = new EuropeWas(europe);
        if (this.askServer().emigrate(slot)) {
            europeWas.fireChanges();
            this.gui.updateMenuBar();
            return europeWas.getNewUnit();
        }
        return null;
    }

    private boolean followPath(Unit unit, PathNode path) {
        while (path != null) {
            if (!unit.isAtLocation(path.getLocation())) {
                if (path.getLocation() instanceof Europe) {
                    if (unit.getTile() != null && unit.getTile().isDirectlyHighSeasConnected()) {
                        this.moveTo(unit, path.getLocation());
                    } else {
                        logger.warning("Can not move to Europe from " + unit.getLocation() + " on path: " + path.fullPathToString());
                    }
                    return false;
                }
                if (path.getLocation() instanceof Tile) {
                    if (path.getDirection() == null) {
                        if (unit.isInEurope()) {
                            this.moveTo(unit, unit.getGame().getMap());
                        } else {
                            logger.warning("Null direction on path: " + path.fullPathToString());
                        }
                        return false;
                    }
                    if (!this.moveDirection(unit, path.getDirection(), false)) {
                        return false;
                    }
                } else {
                    logger.warning("Bad path: " + path.fullPathToString());
                }
            }
            path = path.next;
        }
        return true;
    }

    private boolean loadGoods(Goods goods, Unit carrier) {
        ColonyWas colonyWas;
        if (carrier.isInEurope() && goods.getLocation() instanceof Europe) {
            if (!carrier.getOwner().canTrade(goods)) {
                return false;
            }
            return this.buyGoods(goods.getType(), goods.getAmount(), carrier);
        }
        GoodsType type = goods.getType();
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        UnitWas unitWas = new UnitWas(carrier);
        Colony colony = carrier.getColony();
        ColonyWas colonyWas2 = colonyWas = colony == null ? null : new ColonyWas(colony);
        if (this.askServer().loadCargo(goods, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    private boolean unloadGoods(Goods goods, Unit carrier, Colony colony) {
        if (colony == null && carrier.isInEurope() && carrier.getOwner().canTrade(goods)) {
            return this.sellGoods(goods);
        }
        GoodsType type = goods.getType();
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askServer().unloadCargo(goods) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    private void autosave_game() {
        Game game = this.freeColClient.getGame();
        if (game == null) {
            return;
        }
        String autosave_text = Messages.message("clientOptions.savegames.autosave.fileprefix");
        String filename = autosave_text + "-" + Messages.message("clientOptions.savegames.autosave.lastturn") + ".fsg";
        String beforeFilename = autosave_text + "-" + Messages.message("clientOptions.savegames.autosave.beforelastturn") + ".fsg";
        File autosaveDir = FreeColDirectories.getAutosaveDirectory();
        File saveGameFile = new File(autosaveDir, filename);
        File beforeSaveFile = new File(autosaveDir, beforeFilename);
        if (saveGameFile.exists()) {
            beforeSaveFile.delete();
            saveGameFile.renameTo(beforeSaveFile);
        }
        this.saveGame(saveGameFile);
        ClientOptions options = this.freeColClient.getClientOptions();
        int savegamePeriod = options.getInteger("model.option.autosavePeriod");
        int turnNumber = game.getTurn().getNumber();
        if (savegamePeriod <= 1 || savegamePeriod != 0 && turnNumber % savegamePeriod == 0) {
            Player player = game.getCurrentPlayer();
            String playerNation = player == null ? "" : Messages.message(player.getNation().getNameKey());
            String gid = Integer.toHexString(game.getUUID().hashCode());
            filename = Messages.message("clientOptions.savegames.autosave.fileprefix") + '-' + gid + "_" + playerNation + "_" + this.getSaveGameString(game.getTurn()) + ".fsg";
            saveGameFile = new File(autosaveDir, filename);
            this.saveGame(saveGameFile);
        }
    }

    private String getSaveGameString(Turn turn) {
        int year = turn.getYear();
        switch (turn.getSeason()) {
            case SPRING: {
                return Integer.toString(year) + "_1_" + Messages.message("spring");
            }
            case AUTUMN: {
                return Integer.toString(year) + "_2_" + Messages.message("autumn");
            }
        }
        return Integer.toString(year);
    }

    public File getLastSaveGameFile() {
        File lastSave = null;
        for (File directory : new File[]{FreeColDirectories.getSaveDirectory(), FreeColDirectories.getAutosaveDirectory()}) {
            for (File savegame : directory.listFiles(FSG_FILTER)) {
                if (lastSave != null && savegame.lastModified() <= lastSave.lastModified()) continue;
                lastSave = savegame;
            }
        }
        return lastSave;
    }

    public void loadGame() {
        File file = this.gui.showLoadDialog(FreeColDirectories.getSaveDirectory());
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            this.gui.errorMessage("fileNotFound");
            return;
        }
        if (this.freeColClient.isInGame() && !this.gui.showConfirmDialog("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no")) {
            return;
        }
        this.freeColClient.getConnectController().quitGame(true);
        this.gui.setActiveUnit(null);
        this.gui.removeInGameComponents();
        this.freeColClient.getConnectController().loadGame(file);
    }

    public boolean quickReload() {
        Game game = this.freeColClient.getGame();
        if (game != null) {
            boolean ok;
            String gid = Integer.toHexString(game.getUUID().hashCode());
            String filename = "quicksave-" + gid + ".fsg";
            File file = new File(FreeColDirectories.getAutosaveDirectory(), filename);
            if (file.isFile() && (ok = true)) {
                this.freeColClient.getConnectController().quitGame(true);
                this.gui.removeInGameComponents();
                this.freeColClient.getConnectController().loadGame(file);
                return true;
            }
        }
        return false;
    }

    public boolean saveGame() {
        File file;
        Player player = this.freeColClient.getMyPlayer();
        Game game = this.freeColClient.getGame();
        String gid = Integer.toHexString(game.getUUID().hashCode());
        String fileName = gid + "_" + Messages.message(player.getNationName()) + "_" + this.getSaveGameString(game.getTurn());
        fileName = fileName.replaceAll(" ", "_");
        if (this.freeColClient.canSaveCurrentGame() && (file = this.gui.showSaveDialog(FreeColDirectories.getSaveDirectory(), fileName)) != null) {
            FreeColDirectories.setSaveDirectory(file.getParentFile());
            return this.saveGame(file);
        }
        return false;
    }

    public boolean saveGame(File file) {
        FreeColServer server = this.freeColClient.getFreeColServer();
        boolean result = false;
        this.gui.showStatusPanel(Messages.message("status.savingGame"));
        try {
            server.setActiveUnit(this.gui.getActiveUnit());
            server.saveGame(file, this.freeColClient.getMyPlayer().getName(), this.freeColClient.getClientOptions());
            this.gui.closeStatusPanel();
            result = true;
        }
        catch (IOException e) {
            this.gui.errorMessage("couldNotSaveGame");
        }
        this.gui.requestFocusInWindow();
        return result;
    }

    public boolean quicksaveGame() {
        Game game = this.freeColClient.getGame();
        if (game != null) {
            String gid = Integer.toHexString(game.getUUID().hashCode());
            String filename = "quicksave-" + gid + ".fsg";
            File file = new File(FreeColDirectories.getAutosaveDirectory(), filename);
            return this.saveGame(file);
        }
        return false;
    }

    private boolean shouldAllowMessage(ModelMessage message) {
        BooleanOption option = this.freeColClient.getClientOptions().getBooleanOption(message);
        return option == null ? true : option.getValue();
    }

    private synchronized void startIgnoringMessage(String key, int turn) {
        logger.finer("Ignoring model message with key " + key);
        this.messagesToIgnore.put(key, new Integer(turn));
    }

    private synchronized void stopIgnoringMessage(String key) {
        logger.finer("Removing model message with key " + key + " from ignored messages.");
        this.messagesToIgnore.remove(key);
    }

    private synchronized Integer getTurnForMessageIgnored(String key) {
        return this.messagesToIgnore.get(key);
    }

    public synchronized void ignoreMessage(ModelMessage message, boolean flag) {
        String otherkey;
        Iterator<String> i$;
        String key = message.getSourceId();
        if (message.getTemplateType() == StringTemplate.TemplateType.TEMPLATE && (i$ = message.getKeys().iterator()).hasNext() && "%goods%".equals(otherkey = i$.next())) {
            key = key + otherkey;
        }
        if (flag) {
            this.startIgnoringMessage(key, this.freeColClient.getGame().getTurn().getNumber());
        } else {
            this.stopIgnoringMessage(key);
        }
    }

    public void displayTurnReportMessages() {
        this.gui.showReportTurnPanel(this.turnReportMessages);
    }

    public void displayModelMessages(boolean allMessages) {
        this.displayModelMessages(allMessages, false);
    }

    public void displayModelMessages(boolean allMessages, boolean endOfTurn) {
        Player player = this.freeColClient.getMyPlayer();
        int thisTurn = this.freeColClient.getGame().getTurn().getNumber();
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        for (ModelMessage modelMessage : allMessages ? player.getModelMessages() : player.getNewModelMessages()) {
            if (this.shouldAllowMessage(modelMessage)) {
                if (modelMessage.getMessageType() == ModelMessage.MessageType.WAREHOUSE_CAPACITY) {
                    String key = modelMessage.getSourceId();
                    block1 : switch (modelMessage.getTemplateType()) {
                        case TEMPLATE: {
                            for (String otherkey : modelMessage.getKeys()) {
                                if (!"%goods%".equals(otherkey)) continue;
                                key = key + otherkey;
                                break block1;
                            }
                            break;
                        }
                    }
                    Integer turn = this.getTurnForMessageIgnored(key);
                    if (turn != null && turn == thisTurn - 1) {
                        this.startIgnoringMessage(key, thisTurn);
                        modelMessage.setBeenDisplayed(true);
                        continue;
                    }
                }
                messages.add(modelMessage);
            }
            modelMessage.setBeenDisplayed(true);
        }
        for (Map.Entry entry : this.messagesToIgnore.entrySet()) {
            if ((Integer)entry.getValue() >= thisTurn - 1) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Removing old model message with key " + (String)entry.getKey() + " from ignored messages.");
            }
            this.stopIgnoringMessage((String)entry.getKey());
        }
        if (messages.size() > 0) {
            Runnable uiTask;
            if (endOfTurn) {
                this.turnReportMessages = messages.toArray(new ModelMessage[0]);
                uiTask = new Runnable(){

                    public void run() {
                        InGameController.this.displayTurnReportMessages();
                    }
                };
            } else {
                final ModelMessage[] modelMessageArray = messages.toArray(new ModelMessage[0]);
                uiTask = new Runnable(){

                    public void run() {
                        InGameController.this.gui.showModelMessages(modelMessageArray);
                    }
                };
            }
            this.freeColClient.updateActions();
            if (SwingUtilities.isEventDispatchThread()) {
                uiTask.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(uiTask);
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.WARNING, "Message display", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.log(Level.WARNING, "Message display", invocationTargetException);
                }
            }
        }
    }

    public void nextModelMessage() {
        this.displayModelMessages(false);
    }

    public void abandonColony(Colony colony) {
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (colony == null || !player.owns(colony) || colony.getUnitCount() > 0) {
            throw new IllegalStateException("Abandon bogus colony");
        }
        Tile tile = colony.getTile();
        if (this.askServer().abandonColony(colony) && tile.getSettlement() == null) {
            player.invalidateCanSeeTiles();
            this.gui.setActiveUnit(null);
            this.gui.setSelectedTile(tile, false);
        }
    }

    public void assignTeacher(Unit student, Unit teacher) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(this.requireOurTurn() && student != null && player.owns(student) && student.getColony() != null && student.getLocation() instanceof WorkLocation && teacher != null && player.owns(teacher) && student.canBeStudent(teacher) && teacher.getColony() != null && student.getColony() == teacher.getColony() && teacher.getColony().canTrain(teacher))) {
            return;
        }
        this.askServer().assignTeacher(student, teacher);
    }

    public void assignTradeRoute(Unit unit) {
        TradeRoute oldRoute = unit.getTradeRoute();
        if (!this.gui.showTradeRouteDialog(unit)) {
            return;
        }
        TradeRoute route = unit.getTradeRoute();
        if (oldRoute != route) {
            this.assignTradeRoute(unit, route);
        }
    }

    public void assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (this.askServer().assignTradeRoute(unit, tradeRoute) && (tradeRoute = unit.getTradeRoute()) != null && this.freeColClient.currentPlayerIsMyPlayer()) {
            this.moveToDestination(unit);
        }
    }

    public boolean boardShip(Unit unit, Unit carrier) {
        if (!this.requireOurTurn()) {
            return false;
        }
        if (unit == null) {
            logger.warning("unit == null");
            return false;
        }
        if (carrier == null) {
            logger.warning("Trying to load onto a non-existent carrier.");
            return false;
        }
        if (unit.isNaval()) {
            logger.warning("Trying to load a ship onto another carrier.");
            return false;
        }
        if (unit.isInEurope() != carrier.isInEurope() || unit.getTile() != carrier.getTile()) {
            logger.warning("Unit and carrier are not co-located.");
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().embark(unit, carrier, null) && unit.getLocation() == carrier) {
            this.gui.playSound("sound.event.loadCargo");
            unitWas.fireChanges();
            this.nextActiveUnit();
            return true;
        }
        return false;
    }

    public void buildColony() {
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit unit = this.gui.getActiveUnit();
        if (unit == null) {
            return;
        }
        if (!unit.canBuildColony()) {
            this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("buildColony.badUnit").addName("%unit%", unit.getName()));
            return;
        }
        Tile tile = unit.getTile();
        if (tile.getColony() != null) {
            this.askServer().joinColony(unit, tile.getColony());
            return;
        }
        Player.NoClaimReason reason = player.canClaimToFoundSettlementReason(tile);
        if (reason != Player.NoClaimReason.NONE && reason != Player.NoClaimReason.NATIVES) {
            this.gui.showInformationMessage("noClaimReason." + reason.toString().toLowerCase(Locale.US));
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowColonyWarnings") && !this.buildColonyShowWarnings(tile, unit)) {
            return;
        }
        if (tile.getOwner() != null && !player.owns(tile)) {
            if (!this.claimTile(player, tile, unit, player.getLandPrice(tile), 0)) {
                return;
            }
            if (!player.canClaimToFoundSettlement(tile)) {
                return;
            }
        }
        String name = player.getSettlementName(null);
        name = this.gui.showInputDialog(tile, StringTemplate.key("nameColony.text"), name, "nameColony.yes", "nameColony.no", true);
        if (name == null) {
            return;
        }
        if (player.getSettlement(name) != null) {
            this.gui.showInformationMessage((FreeColObject)tile, StringTemplate.template("nameColony.notUnique").addName("%name%", name));
            return;
        }
        if (this.askServer().buildColony(name, unit) && tile.getSettlement() != null) {
            player.invalidateCanSeeTiles();
            this.gui.playSound("sound.event.buildingComplete");
            this.gui.setActiveUnit(null);
            this.gui.setSelectedTile(tile, false);
            for (Unit unitInTile : tile.getUnitList()) {
                this.checkCashInTreasureTrain(unitInTile);
            }
        }
    }

    private boolean buildColonyShowWarnings(Tile tile, Unit unit) {
        boolean landLocked = true;
        boolean ownedByEuropeans = false;
        boolean ownedBySelf = false;
        boolean ownedByIndians = false;
        HashMap<GoodsType, Integer> goodsMap = new HashMap<GoodsType, Integer>();
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            int potential;
            if (goodsType.isFoodType()) {
                potential = 0;
                if (tile.getType().isPrimaryGoodsType(goodsType)) {
                    potential = tile.potential(goodsType, null);
                }
                goodsMap.put(goodsType, new Integer(potential));
                continue;
            }
            if (!goodsType.isBuildingMaterial()) continue;
            while (goodsType.isRefined()) {
                goodsType = goodsType.getRawMaterial();
            }
            potential = 0;
            if (tile.getType().isSecondaryGoodsType(goodsType)) {
                potential = tile.potential(goodsType, null);
            }
            goodsMap.put(goodsType, new Integer(potential));
        }
        block2: for (Tile newTile : tile.getSurroundingTiles(1)) {
            if (!newTile.isLand()) {
                landLocked = false;
            }
            for (Map.Entry entry : goodsMap.entrySet()) {
                entry.setValue((Integer)entry.getValue() + newTile.potential((GoodsType)entry.getKey(), null));
            }
            Player tileOwner = newTile.getOwner();
            if (unit.getOwner() == tileOwner) {
                if (newTile.getOwningSettlement() != null) {
                    ownedBySelf = true;
                    continue;
                }
                for (Tile ownTile : newTile.getSurroundingTiles(1)) {
                    Colony colony = ownTile.getColony();
                    if (colony == null || colony.getOwner() != unit.getOwner()) continue;
                    ownedBySelf = true;
                    continue block2;
                }
                continue;
            }
            if (tileOwner != null && tileOwner.isEuropean()) {
                ownedByEuropeans = true;
                continue;
            }
            if (tileOwner == null) continue;
            ownedByIndians = true;
        }
        int food = 0;
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (!((GoodsType)entry.getKey()).isFoodType()) continue;
            food += ((Integer)entry.getValue()).intValue();
        }
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        if (landLocked) {
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.landLocked", unit, this.getSpecification().getGoodsType("model.goods.fish")));
        }
        if (food < 8) {
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.noFood", unit, this.getSpecification().getPrimaryFoodType()));
        }
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (((GoodsType)entry.getKey()).isFoodType() || (Integer)entry.getValue() >= 4) continue;
            messages.add(new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "buildColony.noBuildingMaterials", unit, (FreeColObject)entry.getKey()).add("%goods%", ((GoodsType)entry.getKey()).getNameKey()));
        }
        if (ownedBySelf) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.ownLand", unit));
        }
        if (ownedByEuropeans) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.EuropeanLand", unit));
        }
        if (ownedByIndians) {
            messages.add(new ModelMessage(ModelMessage.MessageType.WARNING, "buildColony.IndianLand", unit));
        }
        if (messages.isEmpty()) {
            return true;
        }
        ModelMessage[] modelMessages = messages.toArray(new ModelMessage[messages.size()]);
        return this.gui.showConfirmDialog(unit.getTile(), modelMessages, "buildColony.yes", "buildColony.no");
    }

    public boolean buyGoods(GoodsType type, int amount, Unit carrier) {
        Market market;
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (type == null) {
            throw new NullPointerException("Goods type must not be null.");
        }
        if (carrier == null) {
            throw new NullPointerException("Carrier must not be null.");
        }
        if (!player.owns(carrier)) {
            throw new IllegalArgumentException("Carrier owned by someone else.");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive.");
        }
        if (!player.canTrade(type)) {
            throw new IllegalArgumentException("Goods are boycotted.");
        }
        int toBuy = 100;
        if (!carrier.hasSpaceLeft()) {
            int partial = carrier.getGoodsContainer().getGoodsCount(type) % 100;
            if (partial == 0) {
                return false;
            }
            toBuy -= partial;
        }
        if (amount < toBuy) {
            toBuy = amount;
        }
        if (!player.checkGold((market = player.getMarket()).getBidPrice(type, toBuy))) {
            this.gui.errorMessage("notEnoughGold");
            return false;
        }
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        int price = market.getCostToBuy(type);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askServer().buyGoods(carrier, type, toBuy) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            this.gui.playSound("sound.event.loadCargo");
            unitWas.fireChanges();
            for (TransactionListener l : market.getTransactionListener()) {
                l.logPurchase(type, toBuy, price);
            }
            this.gui.updateMenuBar();
            this.nextModelMessage();
            return true;
        }
        return false;
    }

    public void changeState(Unit unit, Unit.UnitState state) {
        Player enemy;
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        if (!unit.checkSetState(state)) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (state == Unit.UnitState.FORTIFYING && unit.isOffensiveUnit() && !unit.hasAbility("model.ability.piracy") && (tile = unit.getTile()) != null && tile.getOwningSettlement() != null && player != (enemy = tile.getOwningSettlement().getOwner()) && player.getStance(enemy) != Player.Stance.ALLIANCE && !this.confirmHostileAction(unit, tile)) {
            return;
        }
        if (this.askServer().changeState(unit, state)) {
            if (unit == this.gui.getActiveUnit() && !unit.couldMove()) {
                this.nextActiveUnit();
            } else {
                this.gui.refresh();
            }
        }
    }

    public void changeWorkImprovementType(Unit unit, TileImprovementType improvementType) {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        if (!unit.checkSetState(Unit.UnitState.IMPROVING) || improvementType.isNatural()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!(player.owns(tile = unit.getTile()) || this.claimTile(player, tile, unit, player.getLandPrice(tile), 0) && player.owns(tile))) {
            return;
        }
        if (this.askServer().changeWorkImprovementType(unit, improvementType)) {
            // empty if block
        }
        this.nextActiveUnit();
    }

    public void changeWorkType(Unit unit, GoodsType workType) {
        if (!this.requireOurTurn()) {
            return;
        }
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().changeWorkType(unit, workType)) {
            unitWas.fireChanges();
        }
    }

    public boolean checkCashInTreasureTrain(Unit unit) {
        boolean cash;
        if (!(unit.canCarryTreasure() && unit.canCashInTreasureTrain() && this.requireOurTurn())) {
            return false;
        }
        Tile tile = unit.getTile();
        Europe europe = unit.getOwner().getEurope();
        if (europe == null || unit.isInEurope()) {
            cash = true;
        } else {
            StringTemplate template;
            int fee = unit.getTransportFee();
            if (fee == 0) {
                template = StringTemplate.template("cashInTreasureTrain.free");
            } else {
                int percent = this.getSpecification().getInteger("model.option.treasureTransportFee");
                template = StringTemplate.template("cashInTreasureTrain.pay").addAmount("%fee%", percent);
            }
            cash = this.gui.showConfirmDialog(unit.getTile(), template, "cashInTreasureTrain.yes", "cashInTreasureTrain.no");
        }
        UnitWas unitWas = new UnitWas(unit);
        if (cash && this.askServer().cashInTreasureTrain(unit) && unit.isDisposed()) {
            this.gui.playSound("sound.event.cashInTreasureTrain");
            unitWas.fireChanges();
            this.gui.updateMenuBar();
            this.nextActiveUnit(tile);
            return true;
        }
        return false;
    }

    public boolean claimLand(Tile tile, FreeColGameObject claimant, int offer) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int price = (claimant instanceof Settlement ? player.canClaimForSettlement(tile) : player.canClaimForImprovement(tile)) ? 0 : player.getLandPrice(tile);
        return this.claimTile(player, tile, claimant, price, offer);
    }

    public void clearGotoOrders(Unit unit) {
        if (unit != null && unit.getDestination() != null) {
            this.setDestination(unit, null);
            if (unit == this.gui.getActiveUnit()) {
                this.gui.getMapViewer().updateGotoPathForActiveUnit();
            }
        }
    }

    public boolean clearOrders(Unit unit) {
        if (!this.requireOurTurn() || unit == null || !unit.checkSetState(Unit.UnitState.ACTIVE)) {
            return false;
        }
        if (unit.getState() == Unit.UnitState.IMPROVING && !this.gui.showConfirmDialog(unit.getTile(), StringTemplate.template("model.unit.confirmCancelWork").addAmount("%turns%", unit.getWorkTurnsLeft()), "yes", "no")) {
            return false;
        }
        if (unit.getTradeRoute() != null) {
            this.assignTradeRoute(unit, null);
        }
        this.clearGotoOrders(unit);
        return this.askServer().changeState(unit, Unit.UnitState.ACTIVE);
    }

    public void clearSpeciality(Unit unit) {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        UnitType oldType = unit.getType();
        UnitType newType = oldType.getTargetType(UnitTypeChange.ChangeType.CLEAR_SKILL, unit.getOwner());
        if (newType == null) {
            this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("clearSpeciality.impossible").addStringTemplate("%unit%", Messages.getLabel(unit)));
            return;
        }
        Tile tile2 = tile = this.gui.isShowingSubPanel() ? null : unit.getTile();
        if (!this.gui.showConfirmDialog(tile, StringTemplate.template("clearSpeciality.areYouSure").addStringTemplate("%oldUnit%", Messages.getLabel(unit)).add("%unit%", newType.getNameKey()), "yes", "no")) {
            return;
        }
        if (!this.askServer().clearSpeciality(unit) || unit.getType() == newType) {
            // empty if block
        }
        this.nextActiveUnit();
    }

    public void declareIndependence() {
        if (!this.requireOurTurn()) {
            return;
        }
        Game game = this.freeColClient.getGame();
        Player player = this.freeColClient.getMyPlayer();
        Event event = this.getSpecification().getEvent("model.event.declareIndependence");
        for (Limit limit : event.getLimits()) {
            if (limit.evaluate(player)) continue;
            this.gui.showInformationMessage(StringTemplate.template(limit.getDescriptionKey()).addAmount("%limit%", limit.getRightHandSide().getValue(game)));
            return;
        }
        if (player.getNewLandName() == null) {
            return;
        }
        List<String> names = this.gui.showConfirmDeclarationDialog();
        if (names == null || names.get(0) == null || names.get(0).length() == 0 || names.get(1) == null || names.get(1).length() == 0) {
            return;
        }
        String nationName = names.get(0);
        String countryName = names.get(1);
        if (this.askServer().declareIndependence(nationName, countryName) && player.getPlayerType() == Player.PlayerType.REBEL) {
            this.gui.showDeclarationDialog();
            this.freeColClient.updateActions();
            this.nextModelMessage();
        }
    }

    public void disbandActiveUnit() {
        Tile tile;
        if (!this.requireOurTurn()) {
            return;
        }
        Unit unit = this.gui.getActiveUnit();
        if (unit == null) {
            return;
        }
        if (unit.getColony() != null && !this.gui.tryLeaveColony(unit)) {
            return;
        }
        Tile tile2 = tile = this.gui.isShowingSubPanel() ? null : unit.getTile();
        if (!this.gui.showConfirmDialog(tile, StringTemplate.key("disbandUnit.text"), "disbandUnit.yes", "disbandUnit.no")) {
            return;
        }
        if (this.askServer().disbandUnit(unit)) {
            this.nextActiveUnit();
        }
    }

    public void endTurn() {
        if (!this.requireOurTurn()) {
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.showEndTurnDialog")) {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Unit unit : this.freeColClient.getMyPlayer().getUnits()) {
                if (!unit.couldMove()) continue;
                units.add(unit);
            }
            if (!units.isEmpty() && !this.gui.showEndTurnDialog(units)) {
                return;
            }
        }
        if (this.moveMode < 2) {
            this.moveMode = 2;
        }
        if (!this.doExecuteGotoOrders()) {
            return;
        }
        this.doEndTurn();
    }

    public void equipUnit(Unit unit, EquipmentType type, int amount) {
        if (!this.requireOurTurn() || amount == 0) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        Colony colony = null;
        if (unit.isInEurope()) {
            for (AbstractGoods goods : type.getRequiredGoods()) {
                GoodsType goodsType = goods.getType();
                if (player.canTrade(goodsType) || this.payArrears(goodsType)) continue;
                return;
            }
        } else {
            colony = unit.getColony();
            if (colony == null) {
                throw new IllegalStateException("Equip unit not in settlement/Europe");
            }
        }
        ColonyWas colonyWas = colony == null ? null : new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().equipUnit(unit, type, amount)) {
            if (colonyWas != null) {
                colonyWas.fireChanges();
            }
            unitWas.fireChanges();
            this.gui.updateMenuBar();
        }
    }

    public void executeGotoOrders() {
        if (!this.requireOurTurn()) {
            return;
        }
        this.doExecuteGotoOrders();
    }

    public java.util.Map<String, String> getClientStatistics() {
        return this.freeColClient.getGame().getStatistics();
    }

    public List<HighScore> getHighScores() {
        return this.askServer().getHighScores();
    }

    public NationSummary getNationSummary(Player player) {
        return this.askServer().getNationSummary(player);
    }

    public TradeRoute getNewTradeRoute(Player player) {
        int n = player.getTradeRoutes().size();
        if (this.askServer().getNewTradeRoute() && player.getTradeRoutes().size() == n + 1) {
            return player.getTradeRoutes().get(n);
        }
        return null;
    }

    public List<AbstractUnit> getREFUnits() {
        if (!this.requireOurTurn()) {
            return Collections.emptyList();
        }
        return this.askServer().getREFUnits();
    }

    public java.util.Map<String, String> getServerStatistics() {
        return this.askServer().getStatistics();
    }

    public void goToTile(Unit unit, Tile tile) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (!this.setDestination(unit, tile)) {
            return;
        }
        if (!this.moveToDestination(unit)) {
            this.nextActiveUnit();
        }
        this.updateAfterMove();
    }

    public boolean leaveShip(Unit unit) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Unit carrier = unit.getCarrier();
        if (carrier == null) {
            logger.warning("Unit " + unit.getId() + " is not on a carrier.");
            return false;
        }
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().disembark(unit) && unit.getLocation() != carrier) {
            this.checkCashInTreasureTrain(unit);
            unitWas.fireChanges();
            this.nextActiveUnit();
            return true;
        }
        return false;
    }

    public void loadCargo(Goods goods, Unit carrier) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (goods == null) {
            throw new IllegalArgumentException("Null goods.");
        }
        if (goods.getAmount() <= 0) {
            throw new IllegalArgumentException("Empty goods.");
        }
        if (carrier == null) {
            throw new IllegalArgumentException("Null carrier.");
        }
        if (!carrier.isInEurope() && carrier.getColony() == null) {
            throw new IllegalArgumentException("Carrier not at colony or Europe.");
        }
        if (this.loadGoods(goods, carrier)) {
            this.gui.playSound("sound.event.loadCargo");
        }
    }

    public boolean moveTo(Unit unit, Location destination) {
        if (!this.requireOurTurn()) {
            return false;
        }
        if (unit == null || destination == null) {
            throw new IllegalArgumentException("moveTo null argument");
        }
        if (destination instanceof Europe) {
            if (unit.isInEurope()) {
                this.gui.playSound("sound.event.illegalMove");
                return false;
            }
        } else if (destination instanceof Map) {
            if (unit.getTile() != null && unit.getTile().getMap() == destination) {
                this.gui.playSound("sound.event.illegalMove");
                return false;
            }
        } else if (destination instanceof Settlement && unit.getTile() != null) {
            this.gui.playSound("sound.event.illegalMove");
            return false;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.autoloadEmigrants") && unit.isInEurope()) {
            for (Unit u : unit.getOwner().getEurope().getUnitList()) {
                if (u.isNaval() || u.getState() != Unit.UnitState.SENTRY || !unit.canAdd(u)) continue;
                this.boardShip(u, unit);
            }
        }
        if (this.askServer().moveTo(unit, destination)) {
            this.nextActiveUnit();
        }
        return false;
    }

    public void moveActiveUnit(Map.Direction direction) {
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && this.requireOurTurn()) {
            unit.setState(Unit.UnitState.ACTIVE);
            this.clearGotoOrders(unit);
            this.move(unit, direction);
        }
    }

    public void move(Unit unit, Map.Direction direction) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (!this.moveDirection(unit, direction, true)) {
            this.nextActiveUnit();
        }
        this.updateAfterMove();
    }

    public boolean moveToDestination(Unit unit) {
        if (!this.requireOurTurn() || unit.isAtSea() || unit.getMovesLeft() <= 0 || unit.getState() == Unit.UnitState.SKIPPED) {
            return false;
        }
        if (unit.getTradeRoute() != null) {
            return this.followTradeRoute(unit);
        }
        Location destination = unit.getDestination();
        if (destination == null) {
            return unit.getMovesLeft() > 0;
        }
        Player player = this.freeColClient.getMyPlayer();
        PathNode path = unit.findPath(destination);
        if (path == null) {
            StringTemplate src = unit.getLocation().getLocationNameFor(player);
            StringTemplate dst = destination.getLocationNameFor(player);
            this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("selectDestination.failed").addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%location%", src).addStringTemplate("%destination%", dst));
            return false;
        }
        this.gui.setActiveUnit(unit);
        this.followPath(unit, path);
        if (destination != null && unit.isAtLocation(destination)) {
            this.clearGotoOrders(unit);
            if (!this.checkCashInTreasureTrain(unit) && unit.getMovesLeft() > 0 && unit.getState() != Unit.UnitState.SKIPPED) {
                return true;
            }
        }
        return false;
    }

    private boolean moveDirection(Unit unit, Map.Direction direction, boolean interactive) {
        Unit.MoveType mt = unit.getMoveType(direction);
        Location destination = unit.getDestination();
        boolean clearDestination = destination != null && unit.getTile() != null && Map.isSameLocation(unit.getTile().getNeighbourOrNull(direction), destination);
        boolean result = mt.isLegal();
        switch (mt) {
            case MOVE_HIGH_SEAS: {
                if (destination == null) {
                    result = this.moveHighSeas(unit, direction);
                    break;
                }
                if (destination instanceof Europe) {
                    result = this.moveTo(unit, destination);
                    break;
                }
            }
            case MOVE: {
                result = this.moveMove(unit, direction);
                break;
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                result = this.moveExplore(unit, direction);
                break;
            }
            case ATTACK_UNIT: 
            case ATTACK_SETTLEMENT: {
                result = this.moveAttack(unit, direction);
                break;
            }
            case EMBARK: {
                result = this.moveEmbark(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST: {
                result = this.moveLearnSkill(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_SCOUT: {
                result = this.moveScoutIndianSettlement(unit, direction);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: {
                result = this.moveUseMissionary(unit, direction);
                break;
            }
            case ENTER_FOREIGN_COLONY_WITH_SCOUT: {
                result = this.moveScoutColony(unit, direction);
                break;
            }
            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                result = this.moveTrade(unit, direction);
                break;
            }
            case MOVE_NO_ACCESS_BEACHED: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessBeached").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_CONTACT: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessContact").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_GOODS: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessGoods").addStringTemplate("%nation%", nation).addStringTemplate("%unit%", Messages.getLabel(unit)));
                break;
            }
            case MOVE_NO_ACCESS_LAND: {
                if (this.moveDisembark(unit, direction) || !interactive) break;
                this.gui.playSound("sound.event.illegalMove");
                break;
            }
            case MOVE_NO_ACCESS_SETTLEMENT: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessSettlement").addStringTemplate("%unit%", Messages.getLabel(unit)).addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_SKILL: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessSkill").addStringTemplate("%unit%", Messages.getLabel(unit)));
                break;
            }
            case MOVE_NO_ACCESS_TRADE: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessTrade").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_WAR: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                StringTemplate nation = this.getNationAt(unit.getTile(), direction);
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessWar").addStringTemplate("%nation%", nation));
                break;
            }
            case MOVE_NO_ACCESS_WATER: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAccessWater").addStringTemplate("%unit%", Messages.getLabel(unit)));
                break;
            }
            case MOVE_NO_ATTACK_MARINE: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noAttackWater").addStringTemplate("%unit%", Messages.getLabel(unit)));
                break;
            }
            case MOVE_NO_MOVES: {
                clearDestination = false;
                unit.setState(Unit.UnitState.SKIPPED);
                break;
            }
            case MOVE_NO_TILE: {
                if (!interactive && !clearDestination) break;
                this.gui.playSound("sound.event.illegalMove");
                this.gui.showInformationMessage((FreeColObject)unit, StringTemplate.template("move.noTile").addStringTemplate("%unit%", Messages.getLabel(unit)));
                break;
            }
            default: {
                if (interactive || clearDestination) {
                    this.gui.playSound("sound.event.illegalMove");
                }
                result = false;
            }
        }
        if (clearDestination) {
            this.clearGotoOrders(unit);
        }
        return result;
    }

    private boolean moveAttack(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        Tile tile = unit.getTile();
        Tile target = tile.getNeighbourOrNull(direction);
        IndianSettlement is = target.getIndianSettlement();
        if (is != null && unit.isArmed()) {
            switch (this.gui.showArmedUnitIndianSettlementDialog(is)) {
                case CANCEL: {
                    return true;
                }
                case INDIAN_SETTLEMENT_ATTACK: {
                    break;
                }
                case INDIAN_SETTLEMENT_TRIBUTE: {
                    this.moveTribute(unit, direction);
                    return false;
                }
                default: {
                    logger.warning("showArmedUnitIndianSettlementDialog failure.");
                    return false;
                }
            }
        }
        if (this.confirmHostileAction(unit, target) && this.confirmPreCombat(unit, target)) {
            this.askServer().attack(unit, direction);
            this.nextActiveUnit();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveDisembark(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile.getFirstUnit() != null && tile.getFirstUnit().getOwner() != unit.getOwner()) {
            return false;
        }
        ArrayList<Unit> disembarkable = new ArrayList<Unit>();
        unit.setStateToAllChildren(Unit.UnitState.ACTIVE);
        for (Unit u : unit.getUnitList()) {
            if (!u.getMoveType(tile).isProgress()) continue;
            disembarkable.add(u);
        }
        if (disembarkable.size() == 0) {
            return false;
        }
        while (disembarkable.size() > 0) {
            Unit u;
            if (disembarkable.size() == 1) {
                if (!this.gui.showConfirmDialog("disembark.text", "yes", "no")) break;
                this.move((Unit)disembarkable.get(0), direction);
                break;
            }
            ArrayList choices = new ArrayList();
            for (Unit dUnit : disembarkable) {
                choices.add(new ChoiceItem<Unit>(Messages.message(Messages.getLabel(dUnit)), dUnit));
            }
            if (disembarkable.size() > 1) {
                choices.add(new ChoiceItem<Unit>(Messages.message("all"), unit));
            }
            if ((u = (Unit)this.gui.showChoiceDialog(unit.getTile(), Messages.message("disembark.text"), Messages.message("disembark.cancel"), choices)) == null) break;
            if (u == unit) {
                for (Unit dUnit : disembarkable) {
                    try {
                        this.moveDirection(dUnit, direction, false);
                    }
                    catch (Throwable throwable) {}
                }
                return true;
            }
            this.moveDirection(u, direction, false);
            disembarkable.remove(u);
        }
        return true;
    }

    private boolean moveEmbark(Unit unit, Map.Direction direction) {
        if (unit.getColony() != null && !this.gui.tryLeaveColony(unit)) {
            return false;
        }
        Tile sourceTile = unit.getTile();
        Tile destinationTile = sourceTile.getNeighbourOrNull(direction);
        Unit carrier = null;
        ArrayList choices = new ArrayList();
        for (Unit u : destinationTile.getUnitList()) {
            if (!u.canAdd(unit)) continue;
            String m = Messages.message(Messages.getLabel(u));
            choices.add(new ChoiceItem<Unit>(m, u));
            carrier = u;
        }
        if (choices.size() == 0) {
            throw new RuntimeException("Unit " + unit.getId() + " found no carrier to embark upon.");
        }
        if (choices.size() != 1 && (carrier = (Unit)this.gui.showChoiceDialog(unit.getTile(), Messages.message("embark.text"), Messages.message("embark.cancel"), choices)) == null) {
            return true;
        }
        this.clearGotoOrders(unit);
        if (this.askServer().embark(unit, carrier, direction) && unit.getLocation() == carrier) {
            if (carrier.getMovesLeft() > 0) {
                this.gui.setActiveUnit(carrier);
            } else {
                this.nextActiveUnit();
            }
        }
        return false;
    }

    private boolean moveExplore(Unit unit, Map.Direction direction) {
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (!this.gui.showConfirmDialog(unit.getTile(), StringTemplate.key("exploreLostCityRumour.text"), "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            return true;
        }
        if (tile.getLostCityRumour().getType() == LostCityRumour.RumourType.MOUNDS && !this.gui.showConfirmDialog(unit.getTile(), StringTemplate.key("exploreMoundsRumour.text"), "exploreLostCityRumour.yes", "exploreLostCityRumour.no")) {
            this.askServer().declineMounds(unit, direction);
        }
        return this.moveMove(unit, direction);
    }

    private boolean moveHighSeas(Unit unit, Map.Direction direction) {
        Tile oldTile = unit.getTile();
        Tile newTile = oldTile.getNeighbourOrNull(direction);
        if (newTile == null || !oldTile.isDirectlyHighSeasConnected() && newTile.isDirectlyHighSeasConnected()) {
            if (unit.getTradeRoute() != null) {
                TradeRoute.Stop stop = unit.getStop();
                if (stop != null && TradeRoute.isStopValid(unit, stop) && stop.getLocation() instanceof Europe) {
                    this.moveTo(unit, stop.getLocation());
                    return false;
                }
            } else {
                if (unit.getDestination() instanceof Europe) {
                    this.moveTo(unit, unit.getDestination());
                    return false;
                }
                if (this.gui.showConfirmDialog(oldTile, StringTemplate.template("highseas.text").addAmount("%number%", unit.getSailTurns()), "highseas.yes", "highseas.no")) {
                    this.moveTo(unit, unit.getOwner().getEurope());
                    return false;
                }
            }
        }
        return this.moveMove(unit, direction);
    }

    private boolean moveLearnSkill(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        if (!this.askServer().askSkill(unit, direction)) {
            return false;
        }
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        UnitType skill = settlement.getLearnableSkill();
        if (skill == null) {
            this.gui.showInformationMessage((FreeColObject)settlement, "indianSettlement.noMoreSkill");
        } else if (!unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
            this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("indianSettlement.cantLearnSkill").addStringTemplate("%unit%", Messages.getLabel(unit)).add("%skill%", skill.getNameKey()));
        } else if (this.gui.showConfirmDialog(unit.getTile(), StringTemplate.template("learnSkill.text").add("%skill%", skill.getNameKey()), "learnSkill.yes", "learnSkill.no") && this.askServer().learnSkill(unit, direction)) {
            if (unit.isDisposed()) {
                this.gui.showInformationMessage((FreeColObject)settlement, "learnSkill.die");
                this.nextActiveUnit(unit.getTile());
                return false;
            }
            if (unit.getType() != skill) {
                this.gui.showInformationMessage((FreeColObject)settlement, "learnSkill.leave");
            }
        }
        this.nextActiveUnit();
        return false;
    }

    private boolean moveMove(Unit unit, Map.Direction direction) {
        if (unit.canCarryUnits() && unit.hasSpaceLeft() && (unit.getColony() != null || unit.isInEurope())) {
            for (Unit sentry : unit.getLocation().getUnitList()) {
                if (sentry.getState() != Unit.UnitState.SENTRY) continue;
                if (unit.canAdd(sentry)) {
                    this.boardShip(sentry, unit);
                    logger.finest("Unit " + unit.toString() + " loaded sentry " + sentry.toString());
                    continue;
                }
                logger.finest("Unit " + sentry.toString() + " is too big to board " + unit.toString());
            }
        }
        UnitWas unitWas = new UnitWas(unit);
        if (!this.askServer().move(unit, direction)) {
            return false;
        }
        unitWas.fireChanges();
        Tile tile = unit.getTile();
        ClientOptions options = this.freeColClient.getClientOptions();
        if (unit.getMovesLeft() <= 0 && options.getBoolean("model.option.unitLastMoveDelay")) {
            this.gui.paintImmediatelyCanvasInItsBounds();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (unit.isDisposed() || this.checkCashInTreasureTrain(unit)) {
            return false;
        }
        if (tile.getColony() != null && unit.isCarrier() && unit.getTradeRoute() == null && (unit.getDestination() == null || unit.getDestination().getTile() == tile.getTile())) {
            this.gui.showColonyPanel(tile.getColony());
        }
        if (unit.getMovesLeft() <= 0) {
            return false;
        }
        this.displayModelMessages(false);
        if (!this.gui.onScreen(tile)) {
            this.gui.setSelectedTile(tile, false);
        }
        return true;
    }

    private boolean moveScoutColony(Unit unit, Map.Direction direction) {
        Colony colony = (Colony)this.getSettlementAt(unit.getTile(), direction);
        boolean canNeg = colony.getOwner() != unit.getOwner().getREFPlayer();
        this.clearGotoOrders(unit);
        switch (this.gui.showScoutForeignColonyDialog(colony, unit, canNeg)) {
            case CANCEL: {
                return true;
            }
            case FOREIGN_COLONY_ATTACK: {
                return this.moveAttack(unit, direction);
            }
            case FOREIGN_COLONY_NEGOTIATE: {
                return this.moveTradeColony(unit, direction);
            }
            case FOREIGN_COLONY_SPY: {
                return this.moveSpy(unit, direction);
            }
        }
        throw new IllegalArgumentException("showScoutForeignColonyDialog fail");
    }

    private boolean moveScoutIndianSettlement(Unit unit, Map.Direction direction) {
        Tile unitTile = unit.getTile();
        Tile tile = unitTile.getNeighbourOrNull(direction);
        IndianSettlement settlement = tile.getIndianSettlement();
        Player player = unit.getOwner();
        this.clearGotoOrders(unit);
        NationSummary ns = this.getNationSummary(settlement.getOwner());
        String number = ns == null ? Messages.message("many") : ns.getNumberOfSettlements();
        switch (this.gui.showScoutIndianSettlementDialog(settlement, number)) {
            case CANCEL: {
                return true;
            }
            case INDIAN_SETTLEMENT_ATTACK: {
                if (!this.confirmPreCombat(unit, tile)) {
                    return true;
                }
                this.askServer().attack(unit, direction);
                return false;
            }
            case INDIAN_SETTLEMENT_SPEAK: {
                int oldGold = player.getGold();
                String result = this.askServer().scoutSpeak(unit, direction);
                if (result == null) {
                    return false;
                }
                if ("die".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakDie");
                    this.nextActiveUnit(unitTile);
                    return false;
                }
                if ("expert".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.expertScout").add("%unit%", unit.getType().getNameKey()));
                } else if ("tales".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, "scoutSettlement.speakTales");
                } else if ("beads".equals(result)) {
                    this.gui.updateMenuBar();
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.speakBeads").addAmount("%amount%", player.getGold() - oldGold));
                } else if ("nothing".equals(result)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("scoutSettlement.speakNothing").addStringTemplate("%nation%", player.getNationName()));
                } else {
                    logger.warning("Invalid result from askScoutSpeak: " + result);
                }
                this.nextActiveUnit();
                return false;
            }
            case INDIAN_SETTLEMENT_TRIBUTE: {
                return this.moveTribute(unit, direction);
            }
        }
        throw new IllegalArgumentException("showScoutIndianSettlementDialog fail");
    }

    private boolean moveSpy(Unit unit, Map.Direction direction) {
        if (this.askServer().spy(unit, direction)) {
            this.nextActiveUnit();
        }
        return false;
    }

    private boolean moveTrade(Unit unit, Map.Direction direction) {
        this.clearGotoOrders(unit);
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        if (settlement instanceof Colony) {
            return this.moveTradeColony(unit, direction);
        }
        if (settlement instanceof IndianSettlement) {
            return this.moveTradeIndianSettlement(unit, direction);
        }
        throw new IllegalStateException("Bogus settlement: " + settlement.getId());
    }

    private boolean moveTradeColony(Unit unit, Map.Direction direction) {
        block9: {
            Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
            if (settlement == null) {
                return false;
            }
            Player player = unit.getOwner();
            if (settlement.getOwner() == player.getREFPlayer()) {
                throw new IllegalStateException("Unit tried to negotiate with REF");
            }
            ModelMessage m = null;
            String nation = Messages.message(settlement.getOwner().getNationName());
            DiplomaticTrade ourAgreement = null;
            DiplomaticTrade agreement = null;
            block5: while (true) {
                ourAgreement = this.gui.showNegotiationDialog(unit, settlement, agreement);
                if (agreement == null && (ourAgreement == null || ourAgreement.getStatus() == DiplomaticTrade.TradeStatus.REJECT_TRADE)) break block9;
                agreement = ourAgreement;
                if (agreement.getStatus() != DiplomaticTrade.TradeStatus.PROPOSE_TRADE) {
                    this.askServer().diplomacy(this.freeColClient.getGame(), unit, settlement, agreement);
                    this.gui.updateMenuBar();
                    break block9;
                }
                agreement = this.askServer().diplomacy(this.freeColClient.getGame(), unit, settlement, agreement);
                DiplomaticTrade.TradeStatus status = agreement == null ? DiplomaticTrade.TradeStatus.REJECT_TRADE : agreement.getStatus();
                switch (status) {
                    case PROPOSE_TRADE: {
                        continue block5;
                    }
                    case ACCEPT_TRADE: {
                        m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "negotiationDialog.offerAccepted", settlement).addName("%nation%", nation);
                        break block5;
                    }
                    case REJECT_TRADE: {
                        m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "negotiationDialog.offerRejected", settlement).addName("%nation%", nation);
                        break block5;
                    }
                    default: {
                        throw new IllegalStateException("Bogus trade status" + (Object)((Object)status));
                    }
                }
                break;
            }
            player.addModelMessage(m);
        }
        this.nextActiveUnit();
        return false;
    }

    private boolean moveTradeIndianSettlement(Unit unit, Map.Direction direction) {
        boolean[] results;
        Settlement settlement = this.getSettlementAt(unit.getTile(), direction);
        boolean done = false;
        block6: while (!done && (results = this.askServer().openTransactionSession(unit, settlement)) != null) {
            boolean gif;
            boolean buy = results[0] && unit.hasSpaceLeft();
            boolean sel = results[1] && unit.hasGoodsCargo();
            boolean bl = gif = results[2] && unit.hasGoodsCargo();
            if (!buy && !sel && !gif) break;
            switch (this.gui.showIndianSettlementTradeDialog(settlement, buy, sel, gif)) {
                case CANCEL: {
                    done = true;
                    continue block6;
                }
                case BUY: {
                    this.attemptBuyFromSettlement(unit, settlement);
                    continue block6;
                }
                case SELL: {
                    this.attemptSellToSettlement(unit, settlement);
                    continue block6;
                }
                case GIFT: {
                    this.attemptGiftToSettlement(unit, settlement);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("showIndianSettlementTradeDialog fail");
        }
        this.askServer().closeTransactionSession(unit, settlement);
        if (unit.getMovesLeft() > 0) {
            this.gui.setActiveUnit(unit);
            return true;
        }
        this.nextActiveUnit();
        return false;
    }

    private void showTradeFail(int fail, Settlement settlement, Goods goods) {
        switch (fail) {
            case 0: {
                this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("trade.noTradeGoods").add("%goods%", goods.getNameKey()));
                return;
            }
            case -2: {
                this.gui.showInformationMessage((FreeColObject)settlement, "trade.noTradeHaggle");
                break;
            }
            case -3: {
                this.gui.showInformationMessage((FreeColObject)settlement, "trade.noTradeHostile");
                break;
            }
            default: {
                this.gui.showInformationMessage((FreeColObject)settlement, "trade.noTrade");
            }
        }
    }

    private void attemptBuyFromSettlement(Unit unit, Settlement settlement) {
        Player player = this.freeColClient.getMyPlayer();
        Goods goods = null;
        List<Goods> forSale = this.askServer().getGoodsForSaleInSettlement(this.freeColClient.getGame(), unit, settlement);
        if (forSale.isEmpty()) {
            this.gui.showInformationMessage((FreeColObject)settlement, "trade.nothingToSell");
            return;
        }
        goods = this.gui.showSimpleChoiceDialog(unit.getTile(), "buyProposition.text", "buyProposition.nothing", forSale);
        if (goods != null) {
            int gold = -1;
            block5: while (true) {
                if ((gold = this.askServer().buyProposition(unit, settlement, goods, gold)) <= 0) {
                    this.showTradeFail(gold, settlement, goods);
                    return;
                }
                boolean canBuy = player.checkGold(gold);
                switch (this.gui.showBuyDialog(unit, settlement, goods, gold, canBuy)) {
                    case CANCEL: {
                        return;
                    }
                    case BUY: {
                        if (this.askServer().buyFromSettlement(unit, settlement, goods, gold)) {
                            this.gui.updateMenuBar();
                        }
                        return;
                    }
                    case HAGGLE: {
                        gold = gold * 9 / 10;
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalStateException("showBuyDialog fail");
        }
    }

    private void attemptSellToSettlement(Unit unit, Settlement settlement) {
        Goods goods = null;
        goods = this.gui.showSimpleChoiceDialog(unit.getTile(), "sellProposition.text", "sellProposition.nothing", unit.getGoodsList());
        if (goods != null) {
            int gold = -1;
            block6: while (true) {
                if ((gold = this.askServer().sellProposition(unit, settlement, goods, gold)) <= 0) {
                    this.showTradeFail(gold, settlement, goods);
                    return;
                }
                switch (this.gui.showSellDialog(unit, settlement, goods, gold)) {
                    case CANCEL: {
                        return;
                    }
                    case SELL: {
                        if (this.askServer().sellToSettlement(unit, settlement, goods, gold)) {
                            this.gui.updateMenuBar();
                        }
                        return;
                    }
                    case HAGGLE: {
                        gold = gold * 11 / 10;
                        continue block6;
                    }
                    case GIFT: {
                        this.askServer().deliverGiftToSettlement(unit, settlement, goods);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("showSellDialog fail");
        }
    }

    private void attemptGiftToSettlement(Unit unit, Settlement settlement) {
        Goods goods = this.gui.showSimpleChoiceDialog(unit.getTile(), "gift.text", "cancel", unit.getGoodsList());
        if (goods != null) {
            this.askServer().deliverGiftToSettlement(unit, settlement, goods);
        }
    }

    private boolean moveTribute(Unit unit, Map.Direction direction) {
        if (this.askServer().demandTribute(unit, direction)) {
            this.gui.updateMenuBar();
            this.nextActiveUnit();
        }
        return false;
    }

    private boolean moveUseMissionary(Unit unit, Map.Direction direction) {
        IndianSettlement settlement = (IndianSettlement)this.getSettlementAt(unit.getTile(), direction);
        Unit missionary = settlement.getMissionary();
        boolean canEstablish = missionary == null;
        boolean canDenounce = missionary != null && missionary.getOwner() != unit.getOwner();
        this.clearGotoOrders(unit);
        switch (this.gui.showUseMissionaryDialog(unit, settlement, canEstablish, canDenounce)) {
            case CANCEL: {
                return true;
            }
            case ESTABLISH_MISSION: {
                if (!this.askServer().missionary(unit, direction, false)) break;
                if (settlement.getMissionary() == unit) {
                    this.gui.playSound("sound.event.missionEstablished");
                }
                this.nextActiveUnit();
                break;
            }
            case DENOUNCE_HERESY: {
                if (!this.askServer().missionary(unit, direction, true)) break;
                if (settlement.getMissionary() == unit) {
                    this.gui.playSound("sound.event.missionEstablished");
                }
                this.nextModelMessage();
                this.nextActiveUnit();
                break;
            }
            case INCITE_INDIANS: {
                ArrayList<Player> enemies = new ArrayList<Player>(this.freeColClient.getGame().getLiveEuropeanPlayers());
                Player player = this.freeColClient.getMyPlayer();
                enemies.remove(player);
                Player enemy = this.gui.showSimpleChoiceDialog(unit.getTile(), "missionarySettlement.inciteQuestion", "missionarySettlement.cancel", enemies);
                if (enemy == null) {
                    return true;
                }
                int gold = this.askServer().incite(unit, direction, enemy, -1);
                if (gold < 0) break;
                if (!player.checkGold(gold)) {
                    this.gui.showInformationMessage((FreeColObject)settlement, StringTemplate.template("missionarySettlement.inciteGoldFail").add("%player%", enemy.getName()).addAmount("%amount%", gold));
                    break;
                }
                if (this.gui.showConfirmDialog(unit.getTile(), StringTemplate.template("missionarySettlement.inciteConfirm").add("%player%", enemy.getName()).addAmount("%amount%", gold), "yes", "no") && this.askServer().incite(unit, direction, enemy, gold) >= 0) {
                    this.gui.updateMenuBar();
                }
                this.nextActiveUnit();
                break;
            }
            default: {
                logger.warning("showUseMissionaryDialog fail");
            }
        }
        return false;
    }

    public void moveTileCursor(Map.Direction direction) {
        if (this.gui.getSelectedTile() != null) {
            Tile newTile = this.gui.getSelectedTile().getNeighbourOrNull(direction);
            if (newTile != null) {
                this.gui.setSelectedTile(newTile, false);
            }
        } else {
            logger.warning("selectedTile is null");
        }
    }

    public void nextActiveUnit() {
        this.nextActiveUnit(null);
    }

    public void nextActiveUnit(Tile tile) {
        if (!this.requireOurTurn()) {
            return;
        }
        this.nextModelMessage();
        if (this.moveMode >= 1 && !this.doExecuteGotoOrders()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && unit.couldMove()) {
            return;
        }
        if (player.hasNextActiveUnit()) {
            this.gui.setActiveUnit(player.getNextActiveUnit());
            return;
        }
        if (!this.doExecuteGotoOrders()) {
            return;
        }
        this.gui.setActiveUnit(null);
        ClientOptions options = this.freeColClient.getClientOptions();
        if (tile != null) {
            this.gui.setSelectedTile(tile, false);
        } else if (options.getBoolean("model.option.autoEndTurn")) {
            this.endTurn();
        }
    }

    public boolean payArrears(GoodsType type) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        int arrears = player.getArrears(type);
        if (arrears <= 0) {
            return false;
        }
        if (!player.checkGold(arrears)) {
            this.gui.showInformationMessage(StringTemplate.template("model.europe.cantPayArrears").addAmount("%amount%", arrears));
            return false;
        }
        if (this.gui.showConfirmDialog(null, StringTemplate.template("model.europe.payArrears").addAmount("%amount%", arrears), "ok", "cancel") && this.askServer().payArrears(type) && player.canTrade(type)) {
            this.gui.updateMenuBar();
            return true;
        }
        return false;
    }

    public void payForBuilding(Colony colony) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (!colony.canPayToFinishBuilding()) {
            this.gui.errorMessage("notEnoughGold");
            return;
        }
        int price = colony.getPriceForBuilding();
        if (!this.gui.showConfirmDialog(null, StringTemplate.template("payForBuilding.text").addAmount("%amount%", price), "payForBuilding.yes", "payForBuilding.no")) {
            return;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        if (this.askServer().payForBuilding(colony) && colony.getPriceForBuilding() == 0) {
            colonyWas.fireChanges();
            this.gui.updateMenuBar();
        }
    }

    public boolean putOutsideColony(Unit unit) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Colony colony = unit.getColony();
        if (colony == null) {
            throw new IllegalStateException("Unit is not in colony.");
        }
        if (!this.gui.tryLeaveColony(unit)) {
            return false;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().putOutsideColony(unit)) {
            colonyWas.fireChanges();
            unitWas.fireChanges();
            return true;
        }
        return false;
    }

    public void recruitUnitInEurope(int index) {
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.checkGold(player.getRecruitPrice())) {
            this.gui.errorMessage("notEnoughGold");
            return;
        }
        Unit newUnit = this.emigrate(player, index + 1);
        if (newUnit != null) {
            player.setNextActiveUnit(newUnit);
            this.gui.setActiveUnit(newUnit);
        }
    }

    public void rename(Nameable object) {
        Player player = this.freeColClient.getMyPlayer();
        if (!(object instanceof Ownable) || !player.owns((Ownable)((Object)object))) {
            return;
        }
        String name = null;
        if (object instanceof Colony) {
            Colony colony = (Colony)object;
            name = this.gui.showInputDialog(colony.getTile(), StringTemplate.key("renameColony.text"), colony.getName(), "renameColony.yes", "renameColony.no", true);
            if (name == null) {
                return;
            }
            if (colony.getName().equals(name)) {
                return;
            }
            if (player.getSettlement(name) != null) {
                this.gui.showInformationMessage((FreeColObject)((Colony)object), StringTemplate.template("nameColony.notUnique").addName("%name%", name));
                return;
            }
        } else if (object instanceof Unit) {
            Unit unit = (Unit)object;
            name = this.gui.showInputDialog(unit.getTile(), StringTemplate.key("renameUnit.text"), unit.getName(), "renameUnit.yes", "renameUnit.no", false);
            if (name == null) {
                return;
            }
        } else {
            logger.warning("Tried to rename an unsupported Nameable: " + object.toString());
            return;
        }
        this.askServer().rename((FreeColGameObject)((Object)object), name);
    }

    public void selectDestination(Unit unit) {
        Location destination = this.gui.showSelectDestinationDialog(unit);
        if (destination == null) {
            return;
        }
        if (this.setDestination(unit, destination) && this.freeColClient.currentPlayerIsMyPlayer()) {
            if (destination instanceof Europe) {
                if (unit.getTile() != null && unit.getTile().isDirectlyHighSeasConnected()) {
                    this.moveTo(unit, destination);
                } else {
                    this.moveToDestination(unit);
                }
            } else if (unit.isInEurope()) {
                this.moveTo(unit, destination);
            } else {
                this.moveToDestination(unit);
            }
        }
        this.nextActiveUnit();
    }

    public boolean sellGoods(Goods goods) {
        if (!this.requireOurTurn()) {
            return false;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (goods == null) {
            throw new NullPointerException("Goods must not be null.");
        }
        Unit carrier = null;
        if (goods.getLocation() instanceof Unit) {
            carrier = (Unit)goods.getLocation();
        }
        if (carrier == null) {
            throw new IllegalStateException("Goods not on carrier.");
        }
        if (!carrier.isInEurope()) {
            throw new IllegalStateException("Goods not on carrier in Europe.");
        }
        if (!player.canTrade(goods)) {
            throw new IllegalStateException("Goods are boycotted.");
        }
        Market market = player.getMarket();
        GoodsType type = goods.getType();
        int amount = goods.getAmount();
        int price = market.getPaidForSale(type);
        int tax = player.getTax();
        int oldAmount = carrier.getGoodsContainer().getGoodsCount(type);
        UnitWas unitWas = new UnitWas(carrier);
        if (this.askServer().sellGoods(goods, carrier) && carrier.getGoodsContainer().getGoodsCount(type) != oldAmount) {
            this.gui.playSound("sound.event.sellCargo");
            unitWas.fireChanges();
            for (TransactionListener l : market.getTransactionListener()) {
                l.logSale(type, amount, price, tax);
            }
            this.gui.updateMenuBar();
            this.nextModelMessage();
            return true;
        }
        return false;
    }

    public void sendChat(String chat) {
        this.askServer().chat(this.freeColClient.getMyPlayer(), chat);
    }

    public void setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        if (!this.requireOurTurn()) {
            return;
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        if (this.askServer().setBuildQueue(colony, buildQueue)) {
            colonyWas.fireChanges();
        }
    }

    public void setCurrentPlayer(Player player) {
        logger.finest("Entering client setCurrentPlayer: " + player.getName());
        Game game = this.freeColClient.getGame();
        game.setCurrentPlayer(player);
        if (this.freeColClient.getMyPlayer().equals(player) && this.freeColClient.getFreeColServer() != null) {
            if (this.turnsPlayed > 0) {
                this.autosave_game();
            }
            player.invalidateCanSeeTiles();
            while (player.checkEmigrate()) {
                if (player.hasAbility("model.ability.selectRecruit") && player.getEurope().recruitablesDiffer()) {
                    int index = this.gui.showEmigrationPanel(false);
                    this.emigrate(player, index + 1);
                    continue;
                }
                this.emigrate(player, 0);
            }
            if (!this.freeColClient.isSinglePlayer()) {
                this.gui.playSound("sound.anthem." + player.getNationID());
            }
            this.displayModelMessages(true, true);
        }
        logger.finest("Exiting client setCurrentPlayer: " + player.getName());
    }

    public boolean setDestination(Unit unit, Location destination) {
        if (unit.getTradeRoute() != null) {
            StringTemplate template = StringTemplate.template("traderoute.reassignRoute").addStringTemplate("%unit%", Messages.getLabel(unit)).addName("%route%", unit.getTradeRoute().getName());
            if (!this.gui.showConfirmDialog(unit.getTile(), template, "yes", "no")) {
                return false;
            }
        }
        return this.askServer().setDestination(unit, destination) && unit.getDestination() == destination;
    }

    public void setGoodsLevels(Colony colony, GoodsType goodsType) {
        this.askServer().setGoodsLevels(colony, colony.getExportData(goodsType));
    }

    public void setTradeRoutes(List<TradeRoute> routes) {
        this.askServer().setTradeRoutes(routes);
    }

    public void skipActiveUnit() {
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && unit.getState() != Unit.UnitState.SKIPPED) {
            unit.setState(Unit.UnitState.SKIPPED);
        }
        this.nextActiveUnit();
    }

    public void trainUnitInEurope(UnitType unitType) {
        Europe europe;
        if (!this.requireOurTurn()) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        if (!player.checkGold((europe = player.getEurope()).getUnitPrice(unitType))) {
            this.gui.errorMessage("notEnoughGold");
            return;
        }
        EuropeWas europeWas = new EuropeWas(europe);
        if (this.askServer().trainUnitInEurope(unitType)) {
            this.gui.updateMenuBar();
            europeWas.fireChanges();
            Unit newUnit = europeWas.getNewUnit();
            if (newUnit != null) {
                player.setNextActiveUnit(newUnit);
                this.gui.setActiveUnit(newUnit);
            }
        }
    }

    public void unload(Unit unit) {
        block9: {
            List<Goods> goodsList;
            boolean inEurope;
            Player player;
            block8: {
                if (!this.requireOurTurn()) {
                    return;
                }
                if (unit == null) {
                    throw new IllegalArgumentException("Null unit.");
                }
                if (!unit.isCarrier()) {
                    throw new IllegalArgumentException("Unit is not a carrier.");
                }
                player = this.freeColClient.getMyPlayer();
                inEurope = unit.isInEurope();
                if (unit.getColony() == null) break block8;
                for (Unit u : unit.getUnitList()) {
                    this.leaveShip(u);
                }
                for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
                    this.unloadCargo(goods, false);
                }
                break block9;
            }
            if (inEurope) {
                for (Goods goods : new ArrayList<Goods>(unit.getGoodsList())) {
                    if (!player.canTrade(goods)) continue;
                    this.unloadCargo(goods, false);
                }
            }
            if (!unit.hasGoodsCargo() || (goodsList = this.gui.showDumpCargoDialog(unit)) == null) break block9;
            for (Goods goods : goodsList) {
                this.unloadCargo(goods, true);
            }
        }
    }

    public void unloadCargo(Goods goods, boolean dump) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (goods == null) {
            throw new IllegalArgumentException("Null goods.");
        }
        if (goods.getAmount() <= 0) {
            throw new IllegalArgumentException("Empty goods.");
        }
        Unit carrier = null;
        if (!(goods.getLocation() instanceof Unit)) {
            throw new IllegalArgumentException("Unload from non-unit.");
        }
        carrier = (Unit)goods.getLocation();
        Colony colony = null;
        if (!carrier.isInEurope()) {
            if (carrier.getTile() == null) {
                throw new IllegalArgumentException("Carrier with null location.");
            }
            colony = carrier.getColony();
            if (!dump && colony == null) {
                throw new IllegalArgumentException("Unload is really a dump.");
            }
        }
        this.unloadGoods(goods, carrier, colony);
    }

    public void updateTradeRoute(TradeRoute route) {
        this.askServer().updateTradeRoute(route);
    }

    public void waitActiveUnit() {
        this.gui.setActiveUnit(null);
        this.nextActiveUnit();
    }

    public void work(Unit unit, WorkLocation workLocation) {
        if (!this.requireOurTurn()) {
            return;
        }
        if (unit.getStudent() != null && !this.gui.confirmAbandonEducation(unit, false)) {
            return;
        }
        Colony colony = workLocation.getColony();
        if (workLocation instanceof ColonyTile) {
            Tile tile = ((ColonyTile)workLocation).getWorkTile();
            if (tile.hasLostCityRumour()) {
                this.gui.showInformationMessage("tileHasRumour");
                return;
            }
            if (tile.getOwner() != unit.getOwner() && !this.claimLand(tile, colony != null ? colony : unit, 0)) {
                return;
            }
        }
        ColonyWas colonyWas = new ColonyWas(colony);
        UnitWas unitWas = new UnitWas(unit);
        if (this.askServer().work(unit, workLocation) && unit.getLocation() == workLocation) {
            colonyWas.fireChanges();
            unitWas.fireChanges();
        }
    }
}

