/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.mission.PrivateerMission;

public abstract class Mission
extends AIObject {
    private static final Logger logger = Logger.getLogger(Mission.class.getName());
    protected static final int MINIMUM_TRANSPORT_PRIORITY = 60;
    protected static final int NORMAL_TRANSPORT_PRIORITY = 100;
    protected static final int NO_PATH_TO_TARGET = -2;
    protected static final int NO_MORE_MOVES_LEFT = -1;
    private AIUnit aiUnit;

    public Mission(AIMain aiMain) {
        this(aiMain, (AIUnit)null);
    }

    public Mission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain);
        this.aiUnit = aiUnit;
    }

    public void dispose() {
    }

    public Unit getUnit() {
        return this.aiUnit.getUnit();
    }

    public AIUnit getAIUnit() {
        return this.aiUnit;
    }

    protected void setAIUnit(AIUnit aiUnit) {
        this.aiUnit = aiUnit;
    }

    protected Random getAIRandom() {
        return this.aiUnit.getAIRandom();
    }

    protected EuropeanAIPlayer getEuropeanAIPlayer() {
        return (EuropeanAIPlayer)this.getAIMain().getAIPlayer(this.getUnit().getOwner());
    }

    protected Map.Direction moveTowards(Tile tile) {
        PathNode pathNode = this.getUnit().findPath(tile);
        return pathNode == null ? null : this.moveTowards(pathNode);
    }

    protected Map.Direction moveTowards(PathNode pathNode) {
        if (this.getUnit().getMovesLeft() <= 0) {
            return null;
        }
        while (pathNode.next != null && pathNode.getTurns() == 0) {
            if (!this.isValid()) {
                return null;
            }
            if (!this.getUnit().getMoveType(pathNode.getDirection()).isProgress()) break;
            if (!AIMessage.askMove(this.aiUnit, pathNode.getDirection()) || this.getUnit() == null || this.getUnit().isDisposed()) {
                return null;
            }
            pathNode = pathNode.next;
        }
        return pathNode.getTurns() == 0 && this.getUnit().getMoveType(pathNode.getDirection()).isLegal() ? pathNode.getDirection() : null;
    }

    protected void moveRandomly() {
        Unit unit = this.getUnit();
        Map.Direction[] randomDirections = Map.Direction.getRandomDirections("moveRandomly", this.getAIRandom());
        while (this.isValid() && unit.getMovesLeft() > 0) {
            Tile thisTile = this.getUnit().getTile();
            for (int j = 0; j < randomDirections.length; ++j) {
                Map.Direction direction = randomDirections[j];
                if (thisTile.getNeighbourOrNull(direction) == null || unit.getMoveType(direction) != Unit.MoveType.MOVE) continue;
                AIMessage.askMove(this.aiUnit, direction);
                break;
            }
            unit.setMovesLeft(0);
        }
    }

    protected void moveUnitToAmerica() {
        AIMessage.askMoveTo(this.aiUnit, this.getUnit().getOwner().getGame().getMap());
    }

    protected void moveUnitToEurope() {
        AIMessage.askMoveTo(this.aiUnit, this.getUnit().getOwner().getEurope());
    }

    protected boolean moveButDontAttack(Map.Direction direction) {
        Unit unit = this.getUnit();
        if (direction != null && unit != null && unit.getMoveType(direction).isProgress()) {
            AIMessage.askMove(this.aiUnit, direction);
        }
        return this.getUnit() != null && !this.getUnit().isDisposed();
    }

    protected PathNode findTarget(int maxTurns) {
        if (!this.getUnit().isOffensiveUnit()) {
            throw new IllegalStateException("A target can only be found for offensive units. You tried with: " + this.getUnit().toString());
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode bestTarget = null;
            private int higherTension = 0;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit unit, PathNode pathNode) {
                CombatModel combatModel = Mission.this.getGame().getCombatModel();
                Tile newTile = pathNode.getTile();
                Unit defender = newTile.getDefendingUnit(unit);
                if (defender == null) {
                    return false;
                }
                if (defender.getOwner() == unit.getOwner()) {
                    return false;
                }
                if (newTile.isLand() && unit.isNaval() || !newTile.isLand() && !unit.isNaval()) {
                    return false;
                }
                int tension = unit.getOwner().getTension(defender.getOwner()).getValue();
                if (unit.getIndianSettlement() != null && unit.getIndianSettlement().hasContactedSettlement(defender.getOwner())) {
                    tension += unit.getIndianSettlement().getAlarm(defender.getOwner()).getValue();
                }
                if (defender.canCarryTreasure()) {
                    tension += Math.min(defender.getTreasureAmount() / 10, 600);
                }
                if (defender.getType().getDefence() > 0 && newTile.getSettlement() == null) {
                    tension = (int)((float)tension + (100.0f - combatModel.getDefencePower(unit, defender) * 2.0f));
                }
                if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                    tension = (int)((float)tension + (50.0f - combatModel.getDefencePower(unit, defender) * 2.0f));
                }
                if (unit.hasAbility("model.ability.piracy")) {
                    tension += PrivateerMission.getModifierValueForTarget(combatModel, unit, defender);
                }
                if (unit.getOwner().isIndian() && defender.getOwner().isAI()) {
                    tension -= 200;
                }
                if (tension > Tension.Level.CONTENT.getLimit()) {
                    if (this.bestTarget == null) {
                        this.bestTarget = pathNode;
                        this.higherTension = tension;
                        return true;
                    }
                    if (this.bestTarget.getTurns() == pathNode.getTurns() && tension > this.higherTension) {
                        this.bestTarget = pathNode;
                        this.higherTension = tension;
                        return true;
                    }
                }
                return false;
            }
        };
        return this.getUnit().search(this.getUnit().getTile(), gd, CostDeciders.avoidIllegal(), maxTurns, null);
    }

    protected PathNode findNearestOtherSettlement(Unit unit) {
        Player player = unit.getOwner();
        PathNode nearest = null;
        int dist = Integer.MAX_VALUE;
        for (Settlement settlement : player.getSettlements()) {
            int d;
            if (settlement.getTile() == unit.getTile()) {
                return null;
            }
            PathNode path = unit.findPath(settlement.getTile());
            if (path == null || (d = path.getTotalTurns()) >= dist) continue;
            nearest = path;
            dist = d;
        }
        return nearest;
    }

    protected boolean unitLeavesShip(AIUnit aiUnit) {
        Colony colony = aiUnit.getUnit().getColony();
        if (colony != null) {
            AIColony ac = this.getAIMain().getAIColony(colony);
            if (ac != null) {
                ac.completeWish(aiUnit.getUnit());
            }
            colony.firePropertyChange("rearrangeWorkers", true, false);
        }
        return AIMessage.askDisembark(aiUnit);
    }

    protected boolean unloadCargoInColony(Goods goods) {
        AIColony ac;
        Colony colony = this.aiUnit.getUnit().getColony();
        if (colony != null && (ac = this.getAIMain().getAIColony(colony)) != null) {
            ac.completeWish(goods);
        }
        return AIMessage.askUnloadCargo(this.aiUnit, goods);
    }

    protected boolean sellCargoInEurope(Goods goods) {
        Player p = this.getUnit().getOwner();
        if (p.isAI() && this.getAIMain().getFreeColServer().isSingleplayer()) {
            p.modifyGold(p.getMarket().getSalePrice(goods));
        }
        return AIMessage.askSellGoods(this.aiUnit, goods);
    }

    protected boolean shouldTakeTransportToTile(Tile tile) {
        PathNode path;
        int MAX_TURNS = 5;
        Unit unit = this.getUnit();
        return tile != null && unit != null && unit.getTile() != tile && (unit.isOnCarrier() || unit.getTile() == null || (path = unit.findPath(tile)) == null && !unit.getTile().isAdjacent(tile) || path != null && path.getTotalTurns() >= 5);
    }

    protected static Tile getPathStartTile(Unit unit) {
        if (unit.isOnCarrier()) {
            Unit carrier = (Unit)unit.getLocation();
            if (carrier.getTile() != null) {
                return carrier.getTile();
            }
            if (carrier.getDestination() instanceof Map) {
                return carrier.getFullEntryLocation();
            }
            if (carrier.getDestination() instanceof Colony) {
                return ((Colony)carrier.getDestination()).getTile();
            }
        } else if (unit.getTile() != null) {
            return unit.getTile();
        }
        return null;
    }

    protected Unit.MoveType travelToTarget(String logMe, Location target) {
        Tile targetTile = target.getTile();
        if (!(target instanceof Europe) && targetTile == null) {
            throw new IllegalStateException("Target neither Europe nor Tile");
        }
        Unit unit = this.getUnit();
        Unit carrier = unit.isOnCarrier() ? (Unit)unit.getLocation() : null;
        PathNode path = null;
        boolean inTransit = false;
        boolean needTransport = false;
        if (target instanceof Europe) {
            if (unit.isInEurope()) {
                return Unit.MoveType.MOVE;
            }
            if (unit.isOnCarrier()) {
                inTransit = true;
            } else {
                needTransport = true;
            }
        } else {
            if (unit.getTile() == targetTile) {
                return Unit.MoveType.MOVE;
            }
            if (unit.isOnCarrier()) {
                if (carrier.getTile() == null) {
                    inTransit = true;
                } else {
                    path = unit.findPath(unit.getTile(), targetTile, carrier);
                    if (path == null) {
                        logger.finest(logMe + " can not get from " + unit.getTile() + " to " + targetTile + ": " + unit);
                        return Unit.MoveType.MOVE_ILLEGAL;
                    }
                    inTransit = path.isOnCarrier();
                }
            } else if (unit.isInEurope()) {
                needTransport = true;
            } else {
                if (unit.getTile() == null) {
                    throw new IllegalStateException("No tile or carrier: " + unit);
                }
                path = unit.findPath(targetTile);
                if (path == null) {
                    needTransport = true;
                }
            }
        }
        if (inTransit) {
            logger.finest(logMe + " in transit to " + target + ": " + unit);
            return Unit.MoveType.MOVE_ILLEGAL;
        }
        if (needTransport) {
            logger.finest(logMe + " needs transport to " + target + ": " + unit);
            return Unit.MoveType.MOVE_ILLEGAL;
        }
        if (path == null) {
            throw new IllegalStateException("Path == null");
        }
        while (path != null) {
            if (unit.getMovesLeft() <= 0) {
                logger.finest(logMe + " en route to " + targetTile + ": " + unit);
                return Unit.MoveType.MOVE_NO_MOVES;
            }
            Unit.MoveType mt = unit.getMoveType(path.getDirection());
            if (!mt.isProgress()) {
                return mt;
            }
            if (!AIMessage.askMove(this.aiUnit, path.getDirection())) {
                logger.finest(logMe + " move failed at " + unit.getTile() + ": " + unit);
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            if (unit.isDisposed()) {
                logger.finest(logMe + " died en route to " + targetTile + ": " + unit);
                return Unit.MoveType.MOVE_NO_REPAIR;
            }
            path = path.next;
        }
        return Unit.MoveType.MOVE;
    }

    public Location getTransportDestination() {
        Unit unit = this.getUnit();
        if (unit.getTile() == null) {
            return (unit.isOnCarrier() ? (Unit)unit.getLocation() : unit).getFullEntryLocation();
        }
        if (!unit.isOnCarrier()) {
            return null;
        }
        Unit carrier = (Unit)unit.getLocation();
        if (carrier.getSettlement() != null) {
            return carrier.getTile();
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode bestTarget = null;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit unit, PathNode pathNode) {
                boolean hasOurSettlement;
                Tile newTile = pathNode.getTile();
                boolean bl = hasOurSettlement = newTile.getSettlement() != null && newTile.getSettlement().getOwner() == unit.getOwner();
                if (hasOurSettlement) {
                    this.bestTarget = pathNode;
                }
                return hasOurSettlement;
            }
        };
        PathNode path = carrier.search(carrier.getTile(), gd, CostDeciders.avoidSettlementsAndBlockingUnits(), Integer.MAX_VALUE, null);
        return path == null ? null : path.getLastNode().getTile();
    }

    public int getTransportPriority() {
        return this.getTransportDestination() != null ? 100 : 0;
    }

    public static boolean isValid(AIUnit aiUnit) {
        return aiUnit != null && aiUnit.getMission() == null && aiUnit.getUnit() != null && !aiUnit.getUnit().isDisposed() && !aiUnit.getUnit().isUnderRepair();
    }

    public boolean isValid() {
        return this.getUnit() != null && !this.getUnit().isDisposed();
    }

    public boolean isOneTime() {
        return false;
    }

    public abstract void doMission(Connection var1);

    public String getDebuggingInfo() {
        return "";
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        out.writeAttribute("unit", this.getUnit().getId());
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        String unit = in.getAttributeValue(null, "unit");
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(unit));
    }
}

