/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.IdleAtColonyMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class DefendSettlementMission
extends Mission {
    private static final Logger logger = Logger.getLogger(DefendSettlementMission.class.getName());
    private Settlement settlement;

    public DefendSettlementMission(AIMain aiMain, AIUnit aiUnit, Settlement settlement) {
        super(aiMain, aiUnit);
        this.settlement = settlement;
    }

    public DefendSettlementMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public DefendSettlementMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public Location getTransportDestination() {
        return this.settlement != null && this.shouldTakeTransportToTile(this.settlement.getTile()) ? this.settlement.getTile() : null;
    }

    public int getTransportPriority() {
        return this.getTransportDestination() == null ? 0 : 105;
    }

    public static boolean isValid(AIUnit aiUnit) {
        return Mission.isValid(aiUnit) && aiUnit.getUnit().isDefensiveUnit() && aiUnit.getUnit().getOwner().getNumberOfSettlements() > 0;
    }

    public boolean isValid() {
        return super.isValid() && this.getUnit().isDefensiveUnit() && this.settlement != null && !this.settlement.isDisposed() && this.settlement.getOwner() == this.getUnit().getOwner();
    }

    public void doMission(Connection connection) {
        Unit unit = this.getUnit();
        if (unit == null || unit.isDisposed()) {
            return;
        }
        if (!this.isValid()) {
            logger.finest("AI defender has invalid settlement " + this.settlement + ": " + unit);
            return;
        }
        if (this.travelToTarget("AI defender", this.settlement.getTile()) != Unit.MoveType.MOVE) {
            return;
        }
        AIMain aiMain = this.getAIMain();
        AIUnit aiUnit = this.getAIUnit();
        Mission m = null;
        if (this.settlement instanceof Colony) {
            Colony colony = (Colony)this.settlement;
            if (unit.getLocation() instanceof WorkLocation || unit.isPerson() && this.settlement.getUnitCount() <= 1) {
                m = new WorkInsideColonyMission(aiMain, aiUnit, aiMain.getAIColony(colony));
            }
        } else if (this.settlement instanceof IndianSettlement && unit.isPerson() && this.settlement.getUnitCount() <= 1) {
            m = new IdleAtColonyMission(aiMain, aiUnit);
        }
        if (m != null) {
            aiUnit.setMission(m);
            m.doMission(aiUnit.getConnection());
            return;
        }
        if (unit.getState() == Unit.UnitState.FORTIFIED || unit.getState() == Unit.UnitState.FORTIFYING) {
            return;
        }
        int defenderCount = 0;
        int fortifiedCount = 0;
        List<Unit> units = this.settlement.getUnitList();
        units.addAll(this.settlement.getTile().getUnitList());
        for (Unit u : units) {
            if (!unit.isDefensiveUnit()) continue;
            ++defenderCount;
            if (unit.getState() != Unit.UnitState.FORTIFIED) continue;
            ++fortifiedCount;
        }
        if (defenderCount <= 2 || fortifiedCount <= 1) {
            String logMe = !unit.checkSetState(Unit.UnitState.FORTIFYING) ? "waiting to fortify at " : (AIMessage.askChangeState(this.getAIUnit(), Unit.UnitState.FORTIFYING) && unit.getState() == Unit.UnitState.FORTIFYING ? "fortifying at " : "fortify failed at ");
            logger.finest("AI defender " + logMe + this.settlement.getName() + ": " + unit);
            return;
        }
        if (!unit.isOffensiveUnit()) {
            return;
        }
        CombatModel combatModel = unit.getGame().getCombatModel();
        Unit bestTarget = null;
        float bestDifference = Float.MIN_VALUE;
        Map.Direction bestDirection = null;
        for (Map.Direction direction : Map.Direction.getRandomDirections("defendSettlements", this.getAIRandom())) {
            float weDefend;
            float enemyDefend;
            Unit defender;
            Tile t = unit.getTile().getNeighbourOrNull(direction);
            if (t == null || (defender = t.getFirstUnit()) == null || !defender.getOwner().atWarWith(unit.getOwner()) || !unit.getMoveType(direction).isAttack()) continue;
            Unit enemyUnit = t.getDefendingUnit(unit);
            float enemyAttack = combatModel.getOffencePower(enemyUnit, unit);
            float weAttack = combatModel.getOffencePower(unit, enemyUnit);
            float difference = weAttack / (weAttack + (enemyDefend = combatModel.getDefencePower(unit, enemyUnit))) - enemyAttack / (enemyAttack + (weDefend = combatModel.getDefencePower(enemyUnit, unit)));
            if (!(difference > bestDifference) || !(difference > 0.0f) && !(weAttack > enemyDefend)) continue;
            bestDifference = difference;
            bestTarget = enemyUnit;
            bestDirection = direction;
        }
        if (bestTarget != null) {
            logger.finest("AI defender attacking " + bestTarget + " from " + this.settlement.getName() + ": " + unit);
            AIMessage.askAttack(this.getAIUnit(), bestDirection);
        }
    }

    public String getDebuggingInfo() {
        return this.settlement.getTile().getPosition().toString() + " " + this.settlement.getName();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, DefendSettlementMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("settlement", this.settlement.getId());
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.settlement = (Settlement)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "settlement"));
    }

    public static String getXMLElementTagName() {
        return "defendSettlementMission";
    }
}

