/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class BuildColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(BuildColonyMission.class.getName());
    private static final int MAX_TURNS = 5;
    private Tile target = null;
    private int colonyValue = -1;

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit, Tile target) {
        super(aiMain, aiUnit);
        this.target = target;
        this.colonyValue = target == null || target.getColony() != null ? -1 : aiUnit.getUnit().getOwner().getColonyValue(target);
        logger.finest("AI colony builder starts with target " + target + " and value " + this.colonyValue + ": " + aiUnit.getUnit());
    }

    public BuildColonyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public BuildColonyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public Tile getTarget() {
        return this.target;
    }

    private static float getSiteValue(PathNode path, Player player) {
        Tile tile = path.getTile();
        if (tile == null || !tile.isLand()) {
            return -1.0f;
        }
        float turns = (float)path.getTotalTurns() + 1.0f;
        switch (player.canClaimToFoundSettlementReason(tile)) {
            case NONE: {
                break;
            }
            case NATIVES: {
                int price = player.getLandPrice(tile);
                if (price <= 0 || player.checkGold(price)) break;
                turns *= 2.0f;
                break;
            }
            default: {
                return -1.0f;
            }
        }
        return (float)player.getColonyValue(tile) / turns;
    }

    private static Tile getBestColonyTile(Player player) {
        int bestValue = -1;
        Settlement best = null;
        for (Colony colony : player.getColonies()) {
            int value = (colony.isConnected() ? 10 : 0) + colony.getUnitCount() + colony.getAvailableWorkLocations().size();
            if (value <= bestValue) continue;
            bestValue = value;
            best = colony;
        }
        return best == null ? null : best.getTile();
    }

    private static GoalDecider getColonyDecider(final boolean deferOK) {
        return new GoalDecider(){
            private PathNode best = null;
            private float bestValue = 0.0f;
            private PathNode backup = null;
            private int backupTurns = Integer.MAX_VALUE;

            public PathNode getGoal() {
                return this.best != null ? this.best : this.backup;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                Colony colony = path.getTile().getColony();
                if (colony != null) {
                    if (deferOK && colony.getOwner() == u.getOwner() && colony.isConnected() && path.getTotalTurns() < this.backupTurns) {
                        this.backupTurns = path.getTotalTurns();
                        this.backup = path;
                    }
                    return false;
                }
                float value = BuildColonyMission.getSiteValue(path, u.getOwner());
                if (value > this.bestValue) {
                    this.bestValue = value;
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
    }

    public static Tile findTargetTile(AIUnit aiUnit, boolean deferOK) {
        Unit unit = aiUnit.getUnit();
        if (unit == null || unit.isDisposed()) {
            return null;
        }
        Tile startTile = BuildColonyMission.getPathStartTile(unit);
        Player player = unit.getOwner();
        if (startTile == null) {
            return BuildColonyMission.getBestColonyTile(player);
        }
        Unit carrier = unit.isOnCarrier() ? (Unit)unit.getLocation() : null;
        GoalDecider colonyDecider = BuildColonyMission.getColonyDecider(deferOK);
        PathNode path = unit.search(startTile, colonyDecider, CostDeciders.avoidIllegal(), 5, carrier);
        if (path != null) {
            return path.getLastNode().getTile();
        }
        path = unit.search(startTile, colonyDecider, CostDeciders.avoidIllegal(), 15, carrier);
        if (path != null) {
            return path.getLastNode().getTile();
        }
        path = unit.search(startTile, colonyDecider, CostDeciders.numberOfTiles(), Integer.MAX_VALUE, carrier);
        if (path != null) {
            return path.getLastNode().getTile();
        }
        return null;
    }

    public Location getTransportDestination() {
        return this.shouldTakeTransportToTile(this.target) ? this.target : null;
    }

    public static boolean isValid(AIUnit aiUnit) {
        if (!Mission.isValid(aiUnit)) {
            return false;
        }
        return aiUnit.getUnit().hasAbility("model.ability.foundColony");
    }

    public boolean isValid() {
        return super.isValid() && this.getUnit().hasAbility("model.ability.foundColony") && this.target != null;
    }

    public void doMission(Connection connection) {
        int value;
        Unit unit = this.getUnit();
        Player player = unit.getOwner();
        AIUnit aiUnit = this.getAIUnit();
        if (this.target == null || (value = player.getColonyValue(this.target)) < this.colonyValue || this.target.getColony() != null && this.target.getColony().getOwner() != player) {
            this.target = BuildColonyMission.findTargetTile(aiUnit, true);
            if (this.target == null) {
                logger.finest("AI colony builder could not find a target: " + unit);
                return;
            }
            this.colonyValue = player.getColonyValue(this.target);
        }
        if (this.travelToTarget("AI colony builder", this.target) != Unit.MoveType.MOVE) {
            return;
        }
        if (this.target.getColony() != null) {
            String name = unit.getTile().getColony().getName();
            if (this.getEuropeanAIPlayer().hasFewColonies()) {
                this.target = BuildColonyMission.findTargetTile(aiUnit, false);
                logger.finest("AI colony builder arrived at " + name + ", retargeting " + this.target + ": " + unit);
            } else {
                logger.finest("AI colony builder gives up and joins " + name + ": " + unit);
                this.target = null;
            }
            return;
        }
        if (this.target.getOwner() != null) {
            if (player.owns(this.target)) {
                Colony colony = (Colony)this.target.getOwningSettlement();
                if (colony != null && colony.getColonyTile(this.target) != null) {
                    colony.getColonyTile(this.target).relocateWorkers();
                }
            } else {
                boolean fail;
                int price = player.getLandPrice(this.target);
                boolean bl = fail = price < 0;
                if (price > 0 && !player.checkGold(price) && Utils.randomInt(logger, "Cheat gold", this.getAIRandom(), 4) == 0) {
                    player.modifyGold(price);
                }
                if (price >= 0) {
                    boolean bl2 = fail = !AIMessage.askClaimLand(connection, this.target, null, price == 0 ? 0 : (player.checkGold(price) ? price : -1)) || !player.owns(this.target);
                }
                if (fail) {
                    logger.finest("AI colony builder failed to claim land at " + unit.getTile() + ": " + unit);
                    this.target = null;
                    return;
                }
            }
        }
        if (unit.getMovesLeft() <= 0) {
            logger.finest("AI colony builder waiting to build at " + this.target + ": " + unit);
            return;
        }
        if (AIMessage.askBuildColony(aiUnit, "") && this.target.getColony() != null) {
            aiUnit.setMission(new WorkInsideColonyMission(this.getAIMain(), aiUnit, this.getAIMain().getAIColony(this.target.getColony())));
            logger.finest("AI colony builder built " + this.target.getColony().getName() + ": " + unit);
        } else {
            logger.warning("AI colony builder failed to build at " + this.target + ": " + unit);
        }
        this.target = null;
    }

    public String getDebuggingInfo() {
        String targetName = this.target != null ? this.target.toString() : "unassigned";
        return targetName + " " + this.colonyValue;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, BuildColonyMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, "target", this.target);
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String targetStr = in.getAttributeValue(null, "target");
        this.target = targetStr == null ? null : (Tile)this.getGame().getFreeColGameObject(targetStr);
        Unit unit = this.getUnit();
        this.colonyValue = unit == null ? -1 : unit.getOwner().getColonyValue(this.target);
    }

    public static String getXMLElementTagName() {
        return "buildColonyMission";
    }
}

