/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.NativeAIPlayer;
import net.sf.freecol.server.ai.REFAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIMain
extends FreeColObject
implements FreeColGameObjectListener {
    private static final Logger logger = Logger.getLogger(AIMain.class.getName());
    private FreeColServer freeColServer;
    private int nextID = 1;
    private HashMap<String, AIObject> aiObjects = new HashMap();

    public AIMain(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
        this.findNewObjects();
    }

    public AIMain(FreeColServer freeColServer, Element element) {
        this(freeColServer);
        this.readFromXMLElement(element);
    }

    public AIMain(FreeColServer freeColServer, XMLStreamReader in) throws XMLStreamException {
        this(freeColServer);
        this.readFromXML(in);
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public String getNextID() {
        String id = "am" + Integer.toString(this.nextID);
        ++this.nextID;
        return id;
    }

    public int getRandomSeed(String logMe) {
        return Utils.randomInt(logger, logMe, this.freeColServer.getServerRandom(), Integer.MAX_VALUE);
    }

    public boolean checkIntegrity() {
        for (AIObject ao : new ArrayList<AIObject>(this.aiObjects.values())) {
            GoodsWish gw;
            Transportable tr;
            if (!(ao instanceof GoodsWish) || (tr = (gw = (GoodsWish)ao).getTransportable()) == null || !(tr instanceof AIGoods) || !((AIGoods)tr).isUninitialized()) continue;
            gw.setTransportable(null);
            ((AIGoods)tr).dispose();
            logger.warning("Dropping bad GoodsWish: " + gw);
            gw.dispose();
        }
        boolean ok = true;
        for (AIObject ao : this.aiObjects.values()) {
            if (!ao.isUninitialized()) continue;
            logger.warning("Uninitialized object: " + ao.getId() + " (" + ao.getClass() + ")");
            ok = false;
        }
        Iterator<FreeColGameObject> fit = this.getGame().getFreeColGameObjectIterator();
        while (fit.hasNext()) {
            FreeColGameObject f = fit.next();
            if (!(f instanceof Unit) && !(f instanceof Colony) && (!(f instanceof Player) || ((Player)f).isUnknownEnemy()) || this.aiObjects.containsKey(f.getId())) continue;
            logger.warning("Missing AIObject for: " + f.getId());
            ok = false;
        }
        if (ok) {
            logger.info("AIMain integrity ok.");
        } else {
            logger.warning("AIMain integrity test failed.");
        }
        return ok;
    }

    public Game getGame() {
        return this.freeColServer.getGame();
    }

    private void findNewObjects() {
        this.findNewObjects(true);
    }

    public void findNewObjects(boolean overwrite) {
        Iterator<FreeColGameObject> i = this.freeColServer.getGame().getFreeColGameObjectIterator();
        while (i.hasNext()) {
            FreeColGameObject fcgo = i.next();
            if (!overwrite && this.getAIObject(fcgo) != null) continue;
            this.setFreeColGameObject(fcgo.getId(), fcgo);
        }
    }

    public AIObject getAIObject(FreeColGameObject fcgo) {
        return this.getAIObject(fcgo.getId());
    }

    public AIObject getAIObject(String id) {
        return this.aiObjects.get(id);
    }

    public AIColony getAIColony(Colony colony) {
        AIObject aio = this.getAIObject(colony.getId());
        return aio instanceof AIColony ? (AIColony)aio : null;
    }

    public AIPlayer getAIPlayer(Player player) {
        AIObject aio = this.getAIObject(player.getId());
        return aio instanceof AIPlayer ? (AIPlayer)aio : null;
    }

    public AIUnit getAIUnit(Unit unit) {
        AIObject aio = this.getAIObject(unit.getId());
        return aio instanceof AIUnit ? (AIUnit)aio : null;
    }

    public void addAIObject(String id, AIObject aiObject) {
        if (this.aiObjects.containsKey(id)) {
            throw new IllegalStateException("AIObject already created: " + id);
        }
        if (aiObject == null) {
            throw new NullPointerException("aiObject == null");
        }
        this.aiObjects.put(id, aiObject);
    }

    public void removeAIObject(String id) {
        this.aiObjects.remove(id);
    }

    public FreeColGameObject getFreeColGameObject(String id) {
        return this.freeColServer.getGame().getFreeColGameObject(id);
    }

    @Override
    public void ownerChanged(FreeColGameObject source, Player oldOwner, Player newOwner) {
        AIObject ao = this.getAIObject(source);
        if (ao != null) {
            ao.dispose();
            this.setFreeColGameObject(source.getId(), source);
        }
    }

    @Override
    public void setFreeColGameObject(String id, FreeColGameObject freeColGameObject) {
        if (this.aiObjects.containsKey(id)) {
            return;
        }
        if (!id.equals(freeColGameObject.getId())) {
            throw new IllegalArgumentException("!id.equals(freeColGameObject.getId())");
        }
        if (freeColGameObject instanceof Unit) {
            new AIUnit(this, (Unit)freeColGameObject);
        } else if (freeColGameObject instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)freeColGameObject;
            if (p.isIndian()) {
                new NativeAIPlayer(this, p);
            } else if (p.isREF()) {
                new REFAIPlayer(this, p);
            } else if (p.isEuropean()) {
                new EuropeanAIPlayer(this, p);
            }
        } else if (freeColGameObject instanceof Colony) {
            new AIColony(this, (Colony)freeColGameObject);
        }
    }

    @Override
    public void removeFreeColGameObject(String id) {
        AIObject o = this.getAIObject(id);
        if (o != null) {
            o.dispose();
        }
        this.removeAIObject(id);
    }

    public HashMap<String, String> getAIStatistics() {
        HashMap<String, String> stats = new HashMap<String, String>();
        HashMap<String, Long> objStats = new HashMap<String, Long>();
        for (AIObject obj : this.aiObjects.values()) {
            Long count;
            String className = obj.getClass().getSimpleName();
            if (objStats.containsKey(className)) {
                Long l = count = (Long)objStats.get(className);
                Long l2 = count = Long.valueOf(count + 1L);
                objStats.put(className, count);
                continue;
            }
            count = new Long(1L);
            objStats.put(className, count);
        }
        for (String k : objStats.keySet()) {
            stats.put(k, Long.toString((Long)objStats.get(k)));
        }
        return stats;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, AIMain.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("nextID", Integer.toString(this.nextID));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (AIObject aio : new ArrayList<AIObject>(this.aiObjects.values())) {
            if (aio instanceof Wish && !((Wish)aio).shouldBeStored()) continue;
            try {
                if (aio.getId() != null) {
                    aio.toXML(out);
                    continue;
                }
                logger.warning("aio.getId() == null, for: " + aio.getClass().getName());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
            }
        }
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String nextIDStr;
        this.aiObjects.clear();
        if (!in.getLocalName().equals(AIMain.getXMLElementTagName())) {
            logger.warning("Expected element name, got: " + in.getLocalName());
        }
        if ((nextIDStr = in.getAttributeValue(null, "nextID")) != null) {
            this.nextID = Integer.parseInt(nextIDStr);
        }
        String lastTag = "";
        while (in.nextTag() != 2) {
            String tagName = in.getLocalName();
            String oid = in.getAttributeValue(null, "ID");
            try {
                if (oid != null && this.aiObjects.containsKey(oid)) {
                    this.getAIObject(oid).readFromXML(in);
                } else if (tagName.equals(AIUnit.getXMLElementTagName())) {
                    new AIUnit(this, in);
                } else if (tagName.equals(AIPlayer.getXMLElementTagName())) {
                    Player p = (Player)this.getGame().getFreeColGameObject(oid);
                    if (p != null) {
                        if (p.isIndian()) {
                            new NativeAIPlayer(this, in);
                        } else if (p.isREF()) {
                            new REFAIPlayer(this, in);
                        } else if (p.isEuropean()) {
                            new EuropeanAIPlayer(this, in);
                        } else {
                            logger.warning("Bogus AIPlayer: " + p);
                            in.nextTag();
                        }
                    }
                } else if (tagName.equals("colonialAIPlayer")) {
                    new EuropeanAIPlayer(this, in);
                } else if (tagName.equals(AIColony.getXMLElementTagName())) {
                    new AIColony(this, in);
                } else if (tagName.equals(AIGoods.getXMLElementTagName())) {
                    new AIGoods(this, in);
                } else if (tagName.equals(WorkerWish.getXMLElementTagName())) {
                    new WorkerWish(this, in);
                } else if (tagName.equals(GoodsWish.getXMLElementTagName()) || tagName.equals("GoodsWish")) {
                    new GoodsWish(this, in);
                } else if (tagName.equals(TileImprovementPlan.getXMLElementTagName()) || tagName.equals("tileimprovementplan")) {
                    new TileImprovementPlan(this, in);
                } else {
                    logger.warning("Unknown AI-object read: " + tagName + "(" + lastTag + ")");
                }
                lastTag = in.getLocalName();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning("Exception while reading an AIObject(" + tagName + ", " + oid + "): " + sw.toString());
                while (!in.getLocalName().equals(tagName) && !in.getLocalName().equals(AIMain.getXMLElementTagName())) {
                    in.nextTag();
                }
                if (in.getLocalName().equals(AIMain.getXMLElementTagName())) continue;
                in.nextTag();
            }
        }
        if (!in.getLocalName().equals(AIMain.getXMLElementTagName())) {
            logger.warning("Expected element name (2), got: " + in.getLocalName());
        }
        this.findNewObjects(false);
    }

    public static String getXMLElementTagName() {
        return "aiMain";
    }
}

