/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.Resource;

public class FontResource
extends Resource {
    private static final Logger logger = Logger.getLogger(FontResource.class.getName());
    public static final String SCHEME = "font:";
    private Font font;

    public FontResource(Font font) {
        this.font = font;
    }

    FontResource(URI resourceLocator) throws Exception {
        super(resourceLocator);
        this.font = null;
        if (resourceLocator.getPath() != null && resourceLocator.getPath().endsWith(".ttf")) {
            URL url = resourceLocator.toURL();
            this.font = Font.createFont(0, url.openStream());
        } else {
            String name = resourceLocator.getSchemeSpecificPart();
            this.font = Font.decode(name.substring(SCHEME.length()));
        }
        if (this.font != null) {
            try {
                GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Method registerFont = environment.getClass().getMethod("registerFont", Font.class);
                registerFont.invoke((Object)environment, this.font);
            }
            catch (Exception e) {
                logger.warning("Failed to register font " + this.font.getName() + ": " + e.toString());
            }
        }
        logger.info("Loaded font: " + (this.font == null ? "(null)" : this.font.getFontName()) + " from: " + resourceLocator);
    }

    public void preload() {
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = FontResource.getEmergencyFont();
        }
        return this.font;
    }

    public static Font getEmergencyFont() {
        return Font.decode(null);
    }
}

