/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Movable;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.EmptyIterator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unit
extends FreeColGameObject
implements Consumer,
Locatable,
Location,
Movable,
Nameable,
Ownable {
    private static Comparator<Unit> skillLevelComp = new Comparator<Unit>(){

        @Override
        public int compare(Unit u1, Unit u2) {
            return u1.getSkillLevel() - u2.getSkillLevel();
        }
    };
    private static final Logger logger = Logger.getLogger(Unit.class.getName());
    private static final String EQUIPMENT_TAG = "equipment";
    public static final String CARGO_CHANGE = "CARGO_CHANGE";
    public static final String EQUIPMENT_CHANGE = "EQUIPMENT_CHANGE";
    protected UnitType unitType;
    protected int movesLeft;
    protected UnitState state = UnitState.ACTIVE;
    protected Role role = Role.DEFAULT;
    protected int workLeft;
    protected int hitpoints;
    protected Player owner;
    protected String nationality = null;
    protected String ethnicity = null;
    protected List<Unit> units = Collections.emptyList();
    protected GoodsContainer goodsContainer;
    protected Location entryLocation;
    protected Location location;
    protected IndianSettlement indianSettlement = null;
    protected Location destination = null;
    protected TradeRoute tradeRoute = null;
    protected int currentStop = -1;
    protected int treasureAmount;
    protected TileImprovement workImprovement;
    protected GoodsType workType;
    private GoodsType experienceType;
    protected int experience = 0;
    protected int turnsOfTraining = 0;
    protected int attrition = 0;
    protected String name = null;
    protected int visibleGoodsCount;
    protected Unit student;
    protected Unit teacher;
    protected TypeCountMap<EquipmentType> equipment = new TypeCountMap();

    protected Unit() {
    }

    protected Unit(Game game) {
        super(game);
    }

    public Unit(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Unit(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Unit(Game game, String id) {
        super(game, id);
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean canCarryUnit(Unit u) {
        return this.canCarryUnits() && this.getType().getSpace() >= u.getSpaceTaken();
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.template("onBoard").addStringTemplate("%unit%", this.getLabel());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return this.getLocationName();
    }

    public final UnitType getType() {
        return this.unitType;
    }

    public int getTreasureAmount() {
        if (this.canCarryTreasure()) {
            return this.treasureAmount;
        }
        throw new IllegalStateException("Unit can't carry treasure");
    }

    public void setTreasureAmount(int amt) {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Unit can't carry treasure");
        }
        this.treasureAmount = amt;
    }

    public final TypeCountMap<EquipmentType> getEquipment() {
        return this.equipment;
    }

    public final void setEquipment(TypeCountMap<EquipmentType> newEquipment) {
        this.equipment = newEquipment;
    }

    public void clearEquipment() {
        this.setEquipment(new TypeCountMap<EquipmentType>());
    }

    public final TradeRoute getTradeRoute() {
        return this.tradeRoute;
    }

    public final void setTradeRoute(TradeRoute newTradeRoute) {
        this.tradeRoute = newTradeRoute;
    }

    public TradeRoute.Stop getStop() {
        return this.validateCurrentStop() < 0 ? null : this.getTradeRoute().getStops().get(this.currentStop);
    }

    public int getCurrentStop() {
        return this.currentStop;
    }

    public void setCurrentStop(int currentStop) {
        this.currentStop = currentStop;
    }

    public int validateCurrentStop() {
        if (this.tradeRoute == null) {
            this.currentStop = -1;
        } else {
            List<TradeRoute.Stop> stops = this.tradeRoute.getStops();
            if (stops == null || stops.size() == 0) {
                this.currentStop = -1;
            } else if (this.currentStop < 0 || this.currentStop >= stops.size()) {
                this.currentStop = 0;
            }
        }
        return this.currentStop;
    }

    public boolean canCashInTreasureTrain() {
        return this.canCashInTreasureTrain(this.getLocation());
    }

    public boolean canCashInTreasureTrain(Location loc) {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Can't carry treasure");
        }
        if (loc == null) {
            return false;
        }
        if (this.getOwner().getEurope() == null) {
            return loc.getColony() != null;
        }
        if (loc.getColony() != null) {
            return loc.getColony().isConnected();
        }
        return loc instanceof Europe || loc instanceof Unit && ((Unit)loc).isInEurope();
    }

    public int getTransportFee() {
        if (!this.isInEurope() && this.getOwner().getEurope() != null) {
            float fee = this.getSpecification().getInteger("model.option.treasureTransportFee") * this.getTreasureAmount() / 100;
            return (int)this.getOwner().getFeatureContainer().applyModifier(fee, "model.modifier.treasureTransportFee", this.unitType, this.getGame().getTurn());
        }
        return 0;
    }

    public boolean isTradingUnit() {
        return this.canCarryGoods() && this.owner.isEuropean();
    }

    public boolean isColonist() {
        return this.unitType.hasAbility("model.ability.foundColony") && this.owner.isEuropean();
    }

    public boolean isOffensiveUnit() {
        return this.unitType.getOffence() > 0 || this.isArmed() || this.isMounted();
    }

    public int getNeededTurnsOfTraining() {
        int result = 0;
        if (this.student != null) {
            result = this.getNeededTurnsOfTraining(this.unitType, this.student.unitType);
            if (this.getColony() != null) {
                result -= this.getColony().getProductionBonus();
            }
        }
        return result;
    }

    public int getNeededTurnsOfTraining(UnitType typeTeacher, UnitType typeStudent) {
        UnitType teaching = Unit.getUnitTypeTeaching(typeTeacher, typeStudent);
        if (teaching != null) {
            return typeStudent.getEducationTurns(teaching);
        }
        throw new IllegalStateException("typeTeacher=" + typeTeacher + " typeStudent=" + typeStudent);
    }

    public static UnitType getUnitTypeTeaching(UnitType typeTeacher, UnitType typeStudent) {
        UnitType skillTaught = typeTeacher.getSkillTaught();
        if (typeStudent.canBeUpgraded(skillTaught, UnitTypeChange.ChangeType.EDUCATION)) {
            return skillTaught;
        }
        return typeStudent.getEducationUnit(0);
    }

    public int getSkillLevel() {
        return Unit.getSkillLevel(this.unitType);
    }

    public static int getSkillLevel(UnitType unitType) {
        if (unitType.hasSkill()) {
            return unitType.getSkill();
        }
        return 0;
    }

    public static Comparator<Unit> getSkillLevelComparator() {
        return skillLevelComp;
    }

    public int getTurnsOfTraining() {
        return this.turnsOfTraining;
    }

    public void setTurnsOfTraining(int turnsOfTraining) {
        this.turnsOfTraining = turnsOfTraining;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = Math.min(experience, this.getType().getMaximumExperience());
    }

    public void modifyExperience(int value) {
        this.experience += value;
    }

    public int getAttrition() {
        return this.attrition;
    }

    public void setAttrition(int attrition) {
        this.attrition = attrition;
    }

    @Override
    public boolean hasAbility(String id) {
        HashSet<Ability> result = new HashSet<Ability>();
        result.addAll(this.unitType.getFeatureContainer().getAbilitySet(id));
        result.addAll(this.getOwner().getFeatureContainer().getAbilitySet(id, this.unitType, this.getGame().getTurn()));
        for (EquipmentType equipmentType : this.equipment.keySet()) {
            result.addAll(equipmentType.getFeatureContainer().getAbilitySet(id));
            result.addAll(this.getOwner().getFeatureContainer().getAbilitySet(id, equipmentType, this.getGame().getTurn()));
        }
        if (this.getColony() != null) {
            result.addAll(this.getColony().getFeatureContainer().getAbilitySet(id, this.unitType, this.getGame().getTurn()));
        } else if (this.isInEurope() && this.getOwner().getEurope() != null && this.getOwner().getEurope().getFeatureContainer() != null) {
            result.addAll(this.getOwner().getEurope().getFeatureContainer().getAbilitySet(id, this.unitType, this.getGame().getTurn()));
        }
        return FeatureContainer.hasAbility(result);
    }

    @Override
    public Set<Modifier> getModifierSet(String id) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(this.unitType.getModifierSet(id));
        result.addAll(this.getOwner().getFeatureContainer().getModifierSet(id, this.unitType, this.getGame().getTurn()));
        for (EquipmentType equipmentType : this.equipment.keySet()) {
            result.addAll(equipmentType.getFeatureContainer().getModifierSet(id));
            result.addAll(this.getOwner().getFeatureContainer().getModifierSet(id, equipmentType, this.getGame().getTurn()));
        }
        return result;
    }

    public Set<Modifier> getModifierSet(String id, Ownable ownable) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        NationType nationType = ownable.getOwner().getNationType();
        Turn turn = this.getGame().getTurn();
        result.addAll(this.unitType.getFeatureContainer().getModifierSet(id, nationType, turn));
        result.addAll(this.getOwner().getFeatureContainer().getModifierSet(id, nationType, turn));
        for (EquipmentType equipmentType : this.equipment.keySet()) {
            result.addAll(equipmentType.getFeatureContainer().getModifierSet(id, nationType, turn));
        }
        return result;
    }

    public void addFeature(Feature feature) {
        throw new UnsupportedOperationException("Can not add Feature to Unit directly!");
    }

    public boolean canBeStudent(Unit teacher) {
        return teacher != this && this.canBeStudent(this.unitType, teacher.unitType);
    }

    public boolean canBeStudent(UnitType typeStudent, UnitType typeTeacher) {
        return Unit.getUnitTypeTeaching(typeTeacher, typeStudent) != null;
    }

    public final Unit getStudent() {
        return this.student;
    }

    public final void setStudent(Unit newStudent) {
        Unit oldStudent = this.student;
        if (oldStudent == newStudent) {
            return;
        }
        if (newStudent == null) {
            this.student = null;
            if (oldStudent != null && oldStudent.getTeacher() == this) {
                oldStudent.setTeacher(null);
            }
        } else if (newStudent.getColony() != null && newStudent.getColony() == this.getColony() && newStudent.canBeStudent(this)) {
            if (oldStudent != null && oldStudent.getTeacher() == this) {
                oldStudent.setTeacher(null);
            }
            this.student = newStudent;
            newStudent.setTeacher(this);
        } else {
            throw new IllegalStateException("unit can not be student: " + newStudent);
        }
    }

    public final Unit getTeacher() {
        return this.teacher;
    }

    public final void setTeacher(Unit newTeacher) {
        Unit oldTeacher = this.teacher;
        if (newTeacher == oldTeacher) {
            return;
        }
        if (newTeacher == null) {
            this.teacher = null;
            if (oldTeacher != null && oldTeacher.getStudent() == this) {
                oldTeacher.setStudent(null);
            }
        } else {
            UnitType skillTaught = newTeacher.getType().getSkillTaught();
            if (newTeacher.getColony() != null && newTeacher.getColony() == this.getColony() && this.getColony().canTrain(skillTaught)) {
                if (oldTeacher != null && oldTeacher.getStudent() == this) {
                    oldTeacher.setStudent(null);
                }
                this.teacher = newTeacher;
                this.teacher.setStudent(this);
            } else {
                throw new IllegalStateException("unit can not be teacher: " + newTeacher);
            }
        }
    }

    public Building getWorkLocation() {
        if (this.getLocation() instanceof Building) {
            return (Building)this.getLocation();
        }
        return null;
    }

    public Location getWorkLocation2() {
        if (this.getLocation() instanceof Building) {
            return this.getLocation();
        }
        if (this.getLocation() instanceof ColonyTile) {
            return this.getLocation();
        }
        return null;
    }

    public Building getWorkBuilding() {
        if (this.getLocation() instanceof Building) {
            return (Building)this.getLocation();
        }
        return null;
    }

    public ColonyTile getWorkTile() {
        if (this.getLocation() instanceof ColonyTile) {
            return (ColonyTile)this.getLocation();
        }
        return null;
    }

    public GoodsType getExperienceType() {
        return this.experienceType;
    }

    public GoodsType getWorkType() {
        return this.workType;
    }

    public void setWorkType(GoodsType type) {
        this.workType = type;
        if (type != null) {
            this.experienceType = type;
        }
    }

    public TileImprovement getWorkImprovement() {
        return this.workImprovement;
    }

    public void setWorkImprovement(TileImprovement imp) {
        this.workImprovement = imp;
    }

    public Location getDestination() {
        return this.destination;
    }

    public void setDestination(Location newDestination) {
        this.destination = newDestination;
    }

    public PathNode findPath(Tile end) {
        if (this.getTile() == null) {
            logger.warning("getTile() == null for " + this.toString() + " at location: " + this.getLocation());
        }
        return this.findPath(this.getTile(), end);
    }

    public PathNode findPath(Tile start, Tile end) {
        return this.findPath(start, end, null);
    }

    public PathNode findPath(Tile start, Tile end, Unit carrier) {
        return this.findPath(start, end, carrier, null);
    }

    public PathNode findPath(Tile start, Tile end, Unit carrier, CostDecider costDecider) {
        Location dest = this.getDestination();
        this.setDestination(end);
        PathNode path = this.getGame().getMap().findPath(this, start, end, carrier, costDecider);
        this.setDestination(dest);
        return path;
    }

    public PathNode findPathToEurope() {
        Location loc = this.getLocation();
        return loc instanceof Tile ? this.findPathToEurope((Tile)loc) : null;
    }

    public PathNode findPathToEurope(Tile start) {
        return this.getGame().getMap().findPathToEurope(this, start, null);
    }

    public int getTurnsToReach(Tile start, Tile end) {
        PathNode p;
        if (start == end) {
            return 0;
        }
        if (this.isOnCarrier()) {
            Location dest = this.getDestination();
            this.setDestination(end);
            Unit carrier = (Unit)this.getLocation();
            p = this.findPath(start, end, carrier);
            this.setDestination(dest);
        } else {
            p = this.findPath(start, end);
        }
        return p != null ? p.getTotalTurns() : Integer.MAX_VALUE;
    }

    public int getTurnsToReach(Location destination) {
        Unit carrier;
        if (destination == null) {
            logger.log(Level.WARNING, "destination == null", new Throwable());
        }
        Map map = this.getGame().getMap();
        boolean toEurope = destination instanceof Europe;
        Unit unit = carrier = this.isOnCarrier() ? (Unit)this.getLocation() : null;
        if (toEurope) {
            PathNode p;
            if (this.isInEurope()) {
                return 0;
            }
            if (this.isNaval()) {
                p = this.findPathToEurope();
            } else if (carrier != null) {
                p = carrier.findPathToEurope();
            } else {
                return Integer.MAX_VALUE;
            }
            return p == null ? Integer.MAX_VALUE : p.getTotalTurns();
        }
        if (this.isInEurope()) {
            PathNode p;
            if (this.isNaval()) {
                p = this.findPath(this.getFullEntryLocation(), destination.getTile());
            } else {
                if (carrier == null) {
                    for (Unit u : this.getOwner().getUnits()) {
                        if (!u.isNaval()) continue;
                        carrier = u;
                        break;
                    }
                    if (carrier == null) {
                        return Integer.MAX_VALUE;
                    }
                }
                if (carrier.getFullEntryLocation().getTile() == destination.getTile()) {
                    return carrier.getSailTurns();
                }
                p = this.findPath(carrier.getFullEntryLocation(), destination.getTile(), carrier);
            }
            return p == null ? Integer.MAX_VALUE : p.getTotalTurns() + carrier.getSailTurns();
        }
        if (this.isAtSea()) {
            PathNode p;
            if (this.isNaval()) {
                p = this.findPath(this.getFullEntryLocation(), destination.getTile());
                carrier = this;
            } else {
                if (carrier == null) {
                    return Integer.MAX_VALUE;
                }
                p = this.findPath(carrier.getFullEntryLocation(), destination.getTile(), carrier);
            }
            return p == null ? Integer.MAX_VALUE : p.getTotalTurns() + carrier.getWorkLeft();
        }
        Tile start = carrier == null ? this.getTile() : carrier.getTile();
        return this.getTurnsToReach(start, destination.getTile());
    }

    public PathNode search(Tile start, GoalDecider gd, CostDecider cd, int maxTurns, Unit carrier) {
        return this.getGame().getMap().search(this, start, gd, cd, maxTurns, carrier);
    }

    public int getMoveCost(Tile target) {
        return this.getMoveCost(this.getTile(), target, this.getMovesLeft());
    }

    public int getMoveCost(Tile from, Tile target, int ml) {
        TileItemContainer container;
        int cost = target.getType().getBasicMoveCost();
        if (target.isLand() && (container = target.getTileItemContainer()) != null) {
            cost = container.getMoveCost(cost, from);
        }
        if (this.isNaval() && from.isLand() && from.getSettlement() == null) {
            cost = ml;
        } else if (cost > ml && (ml + 2 >= this.getInitialMovesLeft() || cost <= ml + 2 || target.getSettlement() != null) && ml != 0) {
            cost = ml;
        }
        return cost;
    }

    public MoveType getMoveType(Map.Direction direction) {
        Tile tile = this.getTile();
        if (tile == null) {
            throw new IllegalStateException("getTile() == null, location is " + this.location);
        }
        Tile target = tile.getNeighbourOrNull(direction);
        return target == null ? MoveType.MOVE_ILLEGAL : this.getMoveType(target);
    }

    public MoveType getMoveType(Tile target) {
        return this.getMoveType(this.getTile(), target, this.getMovesLeft());
    }

    public MoveType getMoveType(Tile from, Tile target, int ml) {
        MoveType move = this.getSimpleMoveType(from, target);
        if (move.isLegal()) {
            switch (move) {
                case ATTACK_UNIT: 
                case ATTACK_SETTLEMENT: {
                    if (ml > 0) break;
                    move = MoveType.MOVE_NO_MOVES;
                    break;
                }
                default: {
                    if (ml > 0 && (from == null || this.getMoveCost(from, target, ml) <= ml)) break;
                    move = MoveType.MOVE_NO_MOVES;
                }
            }
        }
        return move;
    }

    public MoveType getSimpleMoveType(Tile from, Tile target) {
        return this.isNaval() ? this.getNavalMoveType(from, target) : this.getLandMoveType(from, target);
    }

    public MoveType getSimpleMoveType(Tile target) {
        Tile tile = this.getTile();
        if (tile == null) {
            throw new IllegalStateException("Null tile");
        }
        return this.getSimpleMoveType(tile, target);
    }

    public MoveType getSimpleMoveType(Map.Direction direction) {
        Tile tile = this.getTile();
        if (tile == null) {
            throw new IllegalStateException("Null tile");
        }
        Tile target = tile.getNeighbourOrNull(direction);
        return this.getSimpleMoveType(tile, target);
    }

    private MoveType getNavalMoveType(Tile from, Tile target) {
        if (target == null) {
            return this.getOwner().canMoveToEurope() ? MoveType.MOVE_HIGH_SEAS : MoveType.MOVE_NO_EUROPE;
        }
        if (this.isUnderRepair()) {
            return MoveType.MOVE_NO_REPAIR;
        }
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement == null) {
                return MoveType.MOVE_NO_ACCESS_LAND;
            }
            if (settlement.getOwner() == this.getOwner()) {
                return MoveType.MOVE;
            }
            if (this.isTradingUnit()) {
                return this.getTradeMoveType(settlement);
            }
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        Unit defender = target.getFirstUnit();
        if (defender != null && !this.getOwner().owns(defender)) {
            return this.isOffensiveUnit() ? MoveType.ATTACK_UNIT : MoveType.MOVE_NO_ATTACK_CIVILIAN;
        }
        if (target.canMoveToEurope() && this.getOwner().canMoveToEurope()) {
            return MoveType.MOVE_HIGH_SEAS;
        }
        return MoveType.MOVE;
    }

    private MoveType getLandMoveType(Tile from, Tile target) {
        if (target == null) {
            return MoveType.MOVE_ILLEGAL;
        }
        Player owner = this.getOwner();
        Unit defender = target.getFirstUnit();
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement == null) {
                if (defender != null && owner != defender.getOwner()) {
                    if (defender.isNaval()) {
                        return MoveType.ATTACK_UNIT;
                    }
                    if (!this.isOffensiveUnit()) {
                        return MoveType.MOVE_NO_ATTACK_CIVILIAN;
                    }
                    return this.allowMoveFrom(from) ? MoveType.ATTACK_UNIT : MoveType.MOVE_NO_ATTACK_MARINE;
                }
                if (target.hasLostCityRumour() && owner.isEuropean()) {
                    return MoveType.EXPLORE_LOST_CITY_RUMOUR;
                }
                return MoveType.MOVE;
            }
            if (owner == settlement.getOwner()) {
                return MoveType.MOVE;
            }
            if (this.isTradingUnit()) {
                return this.getTradeMoveType(settlement);
            }
            if (this.isColonist()) {
                switch (this.getRole()) {
                    case DEFAULT: 
                    case PIONEER: {
                        return this.getLearnMoveType(from, settlement);
                    }
                    case MISSIONARY: {
                        return this.getMissionaryMoveType(from, settlement);
                    }
                    case SCOUT: {
                        return this.getScoutMoveType(from, settlement);
                    }
                    case SOLDIER: 
                    case DRAGOON: {
                        return this.allowMoveFrom(from) ? MoveType.ATTACK_SETTLEMENT : MoveType.MOVE_NO_ATTACK_MARINE;
                    }
                }
                return MoveType.MOVE_ILLEGAL;
            }
            if (this.isOffensiveUnit()) {
                return this.allowMoveFrom(from) ? MoveType.ATTACK_SETTLEMENT : MoveType.MOVE_NO_ATTACK_MARINE;
            }
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (defender == null || !this.getOwner().owns(defender)) {
            return MoveType.MOVE_NO_ACCESS_EMBARK;
        }
        for (Unit unit : target.getUnitList()) {
            if (unit.getSpaceLeft() < this.getSpaceTaken()) continue;
            return MoveType.EMBARK;
        }
        return MoveType.MOVE_NO_ACCESS_FULL;
    }

    private MoveType getTradeMoveType(Settlement settlement) {
        if (settlement instanceof Colony) {
            return this.getOwner().atWarWith(settlement.getOwner()) ? MoveType.MOVE_NO_ACCESS_WAR : (!this.hasAbility("model.ability.tradeWithForeignColonies") ? MoveType.MOVE_NO_ACCESS_TRADE : MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS);
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (this.goodsContainer.getGoodsCount() > 0 ? MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS : MoveType.MOVE_NO_ACCESS_GOODS);
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getLearnMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (settlement instanceof IndianSettlement) {
            UnitType scoutSkill = this.getSpecification().getUnitType("model.unit.seasonedScout");
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (!this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : (!this.getType().canBeUpgraded(null, UnitTypeChange.ChangeType.NATIVES) ? MoveType.MOVE_NO_ACCESS_SKILL : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST));
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getMissionaryMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (!this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY);
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getScoutMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT;
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT;
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private boolean allowMoveFrom(Tile from) {
        return from.isLand() || this.getSpecification().getBooleanOption("model.option.amphibiousMoves").getValue() != false;
    }

    private boolean allowContact(Settlement settlement) {
        return this.getOwner().hasContacted(settlement.getOwner());
    }

    @Override
    public int getMovesLeft() {
        return this.movesLeft;
    }

    public void setMovesLeft(int movesLeft) {
        if (movesLeft < 0) {
            movesLeft = 0;
        }
        this.movesLeft = movesLeft;
    }

    @Override
    public int getSpaceTaken() {
        int space = this.unitType.getSpaceTaken() + this.getGoodsCount();
        for (Unit u : this.units) {
            space += u.getSpaceTaken();
        }
        return space;
    }

    public int getLineOfSight() {
        float line = this.unitType.getLineOfSight();
        Set<Modifier> modifierSet = this.getModifierSet("model.modifier.lineOfSightBonus");
        if (this.getTile() != null && this.getTile().getType() != null) {
            modifierSet.addAll(this.getTile().getType().getFeatureContainer().getModifierSet("model.modifier.lineOfSightBonus", this.unitType, this.getGame().getTurn()));
        }
        return (int)FeatureContainer.applyModifierSet(line, this.getGame().getTurn(), modifierSet);
    }

    public boolean isOnCarrier() {
        return this.getLocation() instanceof Unit;
    }

    public void setStateToAllChildren(UnitState state) {
        if (this.canCarryUnits()) {
            for (Unit u : this.getUnitList()) {
                u.setState(state);
            }
        }
    }

    private void spendAllMoves() {
        if (this.getColony() != null && this.getMovesLeft() < this.getInitialMovesLeft()) {
            this.setMovesLeft(0);
        }
    }

    public boolean couldMove() {
        return this.getState() == UnitState.ACTIVE && this.getMovesLeft() > 0 && this.destination == null && this.tradeRoute == null && !this.isUnderRepair() && !this.isAtSea() && (!this.isInEurope() || !this.isOnCarrier()) && !(this.location instanceof WorkLocation);
    }

    public Location getRepairLocation() {
        boolean connected;
        Location closestLocation = null;
        int shortestDistance = Integer.MAX_VALUE;
        Player player = this.getOwner();
        Tile tile = this.getTile();
        for (Colony colony : player.getColonies()) {
            int distance;
            PathNode pn;
            if (colony == null || colony == tile.getColony() || !colony.hasAbility("model.ability.repairUnits") || (pn = this.findPath(colony.getTile())) == null || (distance = pn.getTotalTurns()) >= shortestDistance) continue;
            closestLocation = colony;
            shortestDistance = distance;
        }
        boolean bl = connected = tile.isConnected() || tile.getColony() != null && tile.getColony().isConnected();
        return closestLocation != null ? closestLocation.getTile() : (connected ? player.getEurope() : null);
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (!this.canCarryUnits()) {
                throw new IllegalStateException("Can not carry units: " + this.toString());
            }
            Unit unit = (Unit)locatable;
            if (this.getSpaceLeft() < unit.getSpaceTaken()) {
                throw new IllegalStateException("Not enough space for " + unit.toString() + " on " + this.toString());
            }
            if (this.units.contains(locatable)) {
                logger.warning("Already on carrier: " + unit.toString());
                return true;
            }
            if (((Object)this.units).equals(Collections.emptyList())) {
                this.units = new ArrayList<Unit>();
            }
            this.spendAllMoves();
            unit.setState(UnitState.SENTRY);
            return this.units.add(unit);
        }
        if (locatable instanceof Goods) {
            if (!this.canCarryGoods()) {
                throw new IllegalStateException("Can not carry goods: " + this.toString());
            }
            Goods goods = (Goods)locatable;
            if (this.getLoadableAmount(goods.getType()) < goods.getAmount()) {
                throw new IllegalStateException("Not enough space for " + goods.toString() + " on " + this.toString());
            }
            this.spendAllMoves();
            return this.goodsContainer.addGoods(goods);
        }
        throw new IllegalStateException("Can not be added to unit: " + ((FreeColGameObject)((Object)locatable)).toString());
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable == null) {
            throw new IllegalArgumentException("Locatable must not be 'null'.");
        }
        if (locatable instanceof Unit && this.canCarryUnits()) {
            this.spendAllMoves();
            return this.units.remove(locatable);
        }
        if (locatable instanceof Goods && this.canCarryGoods()) {
            this.spendAllMoves();
            return this.goodsContainer.removeGoods((Goods)locatable) != null;
        }
        logger.warning("Tried to remove a 'Locatable' from a non-carrier unit.");
        return false;
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit && this.canCarryUnits()) {
            return this.units.contains(locatable);
        }
        if (locatable instanceof Goods && this.canCarryGoods()) {
            return this.goodsContainer.contains((Goods)locatable);
        }
        return false;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable == this) {
            return false;
        }
        if (locatable instanceof Unit && this.canCarryUnits()) {
            return this.getSpaceLeft() >= locatable.getSpaceTaken();
        }
        if (locatable instanceof Goods) {
            Goods g = (Goods)locatable;
            return this.getLoadableAmount(g.getType()) >= g.getAmount();
        }
        return false;
    }

    public int getLoadableAmount(GoodsType type) {
        if (this.canCarryGoods()) {
            int result = this.getSpaceLeft() * 100;
            int count = this.getGoodsContainer().getGoodsCount(type) % 100;
            if (count > 0 && count < 100) {
                result += 100 - count;
            }
            return result;
        }
        return 0;
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    public boolean isVisibleTo(Player player) {
        if (player == this.getOwner()) {
            return true;
        }
        Tile unitTile = this.getTile();
        if (unitTile == null) {
            return false;
        }
        if (!player.canSee(unitTile)) {
            return false;
        }
        Settlement settlement = this.getSettlement();
        if (settlement != null && !player.owns(settlement)) {
            return false;
        }
        return !this.isOnCarrier() || player.owns((Unit)this.getLocation());
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return new ArrayList<Unit>(this.units).iterator();
    }

    @Override
    public List<Unit> getUnitList() {
        return new ArrayList<Unit>(this.units);
    }

    public Iterator<Goods> getGoodsIterator() {
        if (this.canCarryGoods()) {
            return this.goodsContainer.getGoodsIterator();
        }
        return EmptyIterator.getInstance();
    }

    public List<Goods> getGoodsList() {
        if (this.canCarryGoods()) {
            return this.goodsContainer.getGoods();
        }
        return Collections.emptyList();
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return this.goodsContainer;
    }

    public void setLocationNoUpdate(Location newLocation) {
        this.location = newLocation;
    }

    @Override
    public void setLocation(Location newLocation) {
        Colony newColony;
        Location oldLocation = this.location;
        Colony oldColony = this.location instanceof WorkLocation ? this.getColony() : null;
        Colony colony = newColony = newLocation instanceof WorkLocation ? newLocation.getColony() : null;
        if (oldColony == newColony) {
            newColony = null;
            oldColony = null;
        }
        boolean result = true;
        if (this.location != null) {
            result = oldColony != null ? oldColony.removeUnit(this) : this.location.remove(this);
        }
        this.location = newLocation;
        this.getOwner().setExplored(this);
        if (newLocation instanceof Colony) {
            newColony = (Colony)newLocation;
            this.location = newLocation = newColony.getWorkLocationFor(this);
        }
        if (newLocation != null) {
            result = newColony != null ? newColony.addUnit(this, (WorkLocation)newLocation) : newLocation.add(this);
        }
    }

    public void setIndianSettlement(IndianSettlement indianSettlement) {
        if (this.indianSettlement != null) {
            this.indianSettlement.removeOwnedUnit(this);
        }
        this.indianSettlement = indianSettlement;
        if (indianSettlement != null) {
            indianSettlement.addOwnedUnit(this);
        }
    }

    public IndianSettlement getIndianSettlement() {
        return this.indianSettlement;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public boolean canBeEquippedWith(EquipmentType equipmentType) {
        for (Map.Entry<String, Boolean> entry : equipmentType.getUnitAbilitiesRequired().entrySet()) {
            if (this.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return false;
        }
        return this.equipment.getCount(equipmentType) < equipmentType.getMaximumCount();
    }

    public List<EquipmentType> changeEquipment(EquipmentType type, int amount) {
        ArrayList<EquipmentType> result = new ArrayList<EquipmentType>();
        this.equipment.incrementCount(type, amount);
        if (amount > 0) {
            for (EquipmentType oldType : new HashSet<EquipmentType>(this.equipment.keySet())) {
                if (oldType.isCompatibleWith(type)) continue;
                result.add(oldType);
            }
        }
        this.setRole();
        return result;
    }

    public int getEquipmentCount(EquipmentType equipmentType) {
        return this.equipment.getCount(equipmentType);
    }

    public boolean isInEurope() {
        if (this.location instanceof Unit) {
            return ((Unit)this.location).isInEurope();
        }
        return this.getLocation() instanceof Europe;
    }

    public boolean isAtSea() {
        if (this.location instanceof Unit) {
            return ((Unit)this.location).isAtSea();
        }
        return this.location instanceof HighSeas;
    }

    public boolean isCarrier() {
        return this.unitType.canCarryGoods() || this.unitType.canCarryUnits();
    }

    public boolean isPerson() {
        return this.hasAbility("model.ability.person") || this.hasAbility("model.ability.bornInColony") || this.hasAbility("model.ability.bornInIndianSettlement") || this.hasAbility("model.ability.foundColony");
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    public StringTemplate getApparentOwnerName() {
        return (this.hasAbility("model.ability.piracy") ? this.getGame().getUnknownEnemy() : this.owner).getNationName();
    }

    @Override
    public void setOwner(Player owner) {
        Player oldOwner = this.owner;
        if (oldOwner == owner) {
            return;
        }
        if (oldOwner == null) {
            logger.warning("Unit " + this.getId() + " had no previous owner, when changing owner to " + owner.getId());
        }
        if (this.getTradeRoute() != null) {
            this.setTradeRoute(null);
        }
        if (this.getDestination() != null) {
            this.setDestination(null);
        }
        this.owner = owner;
        for (Unit unit : this.getUnitList()) {
            unit.setOwner(owner);
        }
        if (oldOwner != null) {
            oldOwner.removeUnit(this);
            oldOwner.modifyScore(-this.getType().getScoreValue());
            if (!this.isOnCarrier()) {
                oldOwner.invalidateCanSeeTiles();
            }
        }
        owner.setUnit(this);
        if (this.getType() != null) {
            owner.modifyScore(this.getType().getScoreValue());
        }
        if (!this.isOnCarrier()) {
            this.getOwner().setExplored(this);
        }
        if (this.getGame().getFreeColGameObjectListener() != null) {
            this.getGame().getFreeColGameObjectListener().ownerChanged(this, oldOwner, owner);
        }
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String newNationality) {
        if (!this.isPerson()) {
            throw new UnsupportedOperationException("Can not set the nationality of a Unit which is not a person!");
        }
        this.nationality = newNationality;
    }

    public String getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(String newEthnicity) {
        throw new UnsupportedOperationException("Can not change a Unit's ethnicity!");
    }

    public boolean hasNativeEthnicity() {
        try {
            return this.getGame().getSpecification().getNation(this.ethnicity).getType().isIndian();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setType(UnitType newUnitType) {
        if (newUnitType.isAvailableTo(this.owner)) {
            if (this.unitType == null) {
                this.owner.modifyScore(newUnitType.getScoreValue());
            } else {
                this.owner.modifyScore(newUnitType.getScoreValue() - this.unitType.getScoreValue());
            }
            this.unitType = newUnitType;
            if (this.getMovesLeft() > this.getInitialMovesLeft()) {
                this.setMovesLeft(this.getInitialMovesLeft());
            }
            this.hitpoints = this.unitType.getHitPoints();
            if (this.getTeacher() != null && !this.canBeStudent(this.getTeacher())) {
                this.getTeacher().setStudent(null);
                this.setTeacher(null);
            }
        } else {
            logger.warning("Units of type: " + newUnitType + " are not available to " + (Object)((Object)this.owner.getPlayerType()) + " player " + this.owner.getName());
        }
    }

    public boolean isArmed() {
        if (this.getOwner().isIndian()) {
            return this.equipment.containsKey(this.getSpecification().getEquipmentType("model.equipment.indian.muskets"));
        }
        return this.equipment.containsKey(this.getSpecification().getEquipmentType("model.equipment.muskets"));
    }

    public boolean isMounted() {
        if (this.getOwner().isIndian()) {
            return this.equipment.containsKey(this.getSpecification().getEquipmentType("model.equipment.indian.horses"));
        }
        return this.equipment.containsKey(this.getSpecification().getEquipmentType("model.equipment.horses"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public StringTemplate getLabel() {
        Role role;
        StringTemplate result = StringTemplate.label(" ").add(this.getType().getNameKey());
        if (this.name != null) {
            result.addName(this.name);
        }
        if ((role = this.getRole()) != Role.DEFAULT) {
            result = StringTemplate.template("model.unit." + role.getId() + ".name").addAmount("%number%", 1).add("%unit%", this.getType().getNameKey());
        }
        return result;
    }

    public StringTemplate getEquipmentLabel() {
        if (this.equipment != null && !this.equipment.isEmpty()) {
            StringTemplate result = StringTemplate.label("/");
            for (Map.Entry<EquipmentType, Integer> entry : this.equipment.getValues().entrySet()) {
                EquipmentType type = entry.getKey();
                int amount = entry.getValue();
                if (type.getGoodsRequired().isEmpty()) {
                    result.addStringTemplate(StringTemplate.template("model.goods.goodsAmount").add("%goods%", type.getNameKey()).addName("%amount%", Integer.toString(amount)));
                    continue;
                }
                for (AbstractGoods goods : type.getGoodsRequired()) {
                    result.addStringTemplate(StringTemplate.template("model.goods.goodsAmount").add("%goods%", goods.getType().getNameKey()).addName("%amount%", Integer.toString(amount * goods.getAmount())));
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public int getInitialMovesLeft() {
        return (int)FeatureContainer.applyModifierSet(this.unitType.getMovement(), this.getGame().getTurn(), this.getModifierSet("model.modifier.movementBonus"));
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
        if (hitpoints >= this.unitType.getHitPoints()) {
            this.setState(UnitState.ACTIVE);
        }
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isUnderRepair() {
        return this.hitpoints < this.unitType.getHitPoints();
    }

    public boolean isInMission() {
        return this.getRole() == Role.MISSIONARY && this.getTile() == null && !(this.getLocation() instanceof Unit);
    }

    @Override
    public String toString() {
        return this.getId() + " [" + this.getType().getId() + " " + this.getMovesAsString() + "] " + this.owner.getNationID() + " (" + (Object)((Object)this.getRole()) + ")";
    }

    public String getMovesAsString() {
        String moves = "";
        int quotient = this.getMovesLeft() / 3;
        int remainder = this.getMovesLeft() % 3;
        if (remainder == 0 || quotient > 0) {
            moves = moves + Integer.toString(quotient);
        }
        if (remainder > 0) {
            if (quotient > 0) {
                moves = moves + " ";
            }
            moves = moves + "(" + Integer.toString(remainder) + "/3) ";
        }
        moves = moves + "/" + Integer.toString(this.getInitialMovesLeft() / 3);
        return moves;
    }

    public boolean isNaval() {
        return this.getType().isNaval();
    }

    public UnitState getState() {
        return this.state;
    }

    public Role getRole() {
        return this.role;
    }

    protected void setRole() {
        Role oldRole = this.role;
        this.role = Role.DEFAULT;
        for (EquipmentType type : this.equipment.keySet()) {
            this.role = this.role.newRole(type.getRole());
        }
        if (this.getState() == UnitState.IMPROVING && this.role != Role.PIONEER) {
            this.setStateUnchecked(UnitState.ACTIVE);
            this.setMovesLeft(0);
        }
        if (!this.role.isCompatibleWith(oldRole)) {
            this.experience = 0;
        }
    }

    public boolean checkSetState(UnitState s) {
        switch (s) {
            case ACTIVE: 
            case SENTRY: {
                return true;
            }
            case IN_COLONY: {
                return !this.isNaval();
            }
            case FORTIFIED: {
                return this.getState() == UnitState.FORTIFYING;
            }
            case IMPROVING: {
                if (this.location instanceof Tile && this.getOwner().canAcquireForImprovement(this.location.getTile())) {
                    return this.getMovesLeft() > 0;
                }
                return false;
            }
            case SKIPPED: {
                if (this.getState() == UnitState.ACTIVE) {
                    return true;
                }
            }
            case FORTIFYING: {
                return this.getMovesLeft() > 0;
            }
        }
        logger.warning("Invalid unit state: " + (Object)((Object)s));
        return false;
    }

    public int getSailTurns() {
        return (int)this.getOwner().getFeatureContainer().applyModifier(this.getSpecification().getIntegerOption("model.option.turnsToSail").getValue().intValue(), "model.modifier.sailHighSeas", this.unitType, this.getGame().getTurn());
    }

    public void setState(UnitState s) {
        if (this.state == s) {
            return;
        }
        if (!this.checkSetState(s)) {
            throw new IllegalStateException("Illegal UnitState transition: " + (Object)((Object)this.state) + " -> " + (Object)((Object)s));
        }
        this.setStateUnchecked(s);
    }

    protected void setStateUnchecked(UnitState s) {
        switch (this.state) {
            case IMPROVING: {
                if (this.workImprovement == null || this.getWorkLeft() <= 0) break;
                if (!this.workImprovement.isComplete() && this.workImprovement.getTile() != null && this.workImprovement.getTile().getTileItemContainer() != null) {
                    this.workImprovement.getTile().getTileItemContainer().removeTileItem(this.workImprovement);
                }
                this.setWorkImprovement(null);
                break;
            }
        }
        switch (s) {
            case ACTIVE: {
                this.setWorkLeft(-1);
                break;
            }
            case SENTRY: {
                this.setWorkLeft(-1);
                break;
            }
            case FORTIFIED: {
                this.setWorkLeft(-1);
                this.movesLeft = 0;
                break;
            }
            case FORTIFYING: {
                this.setWorkLeft(1);
                this.movesLeft = 0;
                break;
            }
            case IMPROVING: {
                if (this.workImprovement == null) {
                    this.setWorkLeft(-1);
                } else {
                    this.setWorkLeft(this.workImprovement.getTurnsToComplete());
                }
                this.movesLeft = 0;
                break;
            }
            case SKIPPED: {
                break;
            }
            default: {
                this.setWorkLeft(-1);
            }
        }
        this.state = s;
    }

    public boolean canMoveToEurope() {
        if (this.getLocation() instanceof Europe) {
            return true;
        }
        if (!this.getOwner().canMoveToEurope()) {
            return false;
        }
        for (Tile tile : this.getTile().getSurroundingTiles(1)) {
            if (!tile.canMoveToEurope()) continue;
            return true;
        }
        return false;
    }

    public boolean canBuildColony() {
        return this.unitType.hasAbility("model.ability.foundColony") && this.getMovesLeft() > 0 && this.getTile() != null;
    }

    @Override
    public Tile getTile() {
        return this.location != null ? this.location.getTile() : null;
    }

    public int getSpaceLeft() {
        int space = this.unitType.getSpace() - this.getGoodsCount();
        Iterator<Unit> unitIterator = this.getUnitIterator();
        while (unitIterator.hasNext()) {
            Unit u = unitIterator.next();
            space -= u.getSpaceTaken();
        }
        return space;
    }

    public int getVisibleGoodsCount() {
        if (this.visibleGoodsCount >= 0) {
            return this.visibleGoodsCount;
        }
        return this.getGoodsCount();
    }

    public int getGoodsCount() {
        return this.canCarryGoods() ? this.goodsContainer.getGoodsCount() : 0;
    }

    public void moveToFront(Unit u) {
        if (this.canCarryUnits() && this.units.remove(u)) {
            this.units.add(0, u);
        }
    }

    public int getWorkLeft() {
        return this.workLeft;
    }

    public void setWorkLeft(int workLeft) {
        this.workLeft = workLeft;
    }

    public int getWorkTurnsLeft() {
        return this.state == UnitState.IMPROVING && this.unitType.hasAbility("model.ability.expertPioneer") ? (this.getWorkLeft() + 1) / 2 : this.getWorkLeft();
    }

    public void setEntryLocation(Location entryLocation) {
        this.entryLocation = entryLocation;
        if (entryLocation != null) {
            this.owner.setEntryLocation(entryLocation);
        }
    }

    public Location getEntryLocation() {
        if (this.entryLocation == null) {
            this.entryLocation = this.owner.getEntryLocation();
        }
        return this.entryLocation;
    }

    public Tile getFullEntryLocation() {
        return this.entryLocation != null ? (Tile)this.entryLocation : (this.owner.getEntryLocation() == null ? null : this.owner.getEntryLocation().getTile());
    }

    public boolean isDefensiveUnit() {
        return (this.unitType.getDefence() > 1 || this.isArmed() || this.isMounted()) && !this.isNaval();
    }

    public static boolean betterDefender(Unit defender, float defenderPower, Unit other, float otherPower) {
        if (defender == null) {
            return true;
        }
        if (!defender.isArmed() && other.isArmed()) {
            return true;
        }
        if (defender.isArmed() && !other.isArmed()) {
            return false;
        }
        if (!defender.isDefensiveUnit() && other.isDefensiveUnit()) {
            return true;
        }
        if (defender.isDefensiveUnit() && !other.isDefensiveUnit()) {
            return false;
        }
        return defenderPower < otherPower;
    }

    public boolean isUndead() {
        return this.hasAbility("model.ability.undead");
    }

    public boolean canCarryTreasure() {
        return this.unitType.hasAbility("model.ability.carryTreasure");
    }

    public boolean canCaptureGoods() {
        return this.unitType.hasAbility("model.ability.captureGoods");
    }

    public EquipmentType canCaptureEquipment(EquipmentType equip, Unit loser) {
        if (this.hasAbility("model.ability.captureEquipment")) {
            if (this.getOwner().isIndian() != loser.getOwner().isIndian()) {
                equip = equip.getCaptureEquipment(this.getOwner().isIndian());
            }
            return this.canBeEquippedWith(equip) ? equip : null;
        }
        return null;
    }

    @Override
    public Settlement getSettlement() {
        Location location = this.getLocation();
        return location != null ? location.getSettlement() : null;
    }

    @Override
    public Colony getColony() {
        Location location = this.getLocation();
        return location != null ? location.getColony() : null;
    }

    public int getProductionOf(GoodsType goodsType, int base) {
        if (base == 0) {
            return 0;
        }
        return Math.round(FeatureContainer.applyModifierSet(base, this.getGame().getTurn(), this.getModifierSet(goodsType.getId())));
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        while (this.units.size() > 0) {
            objects.addAll(this.units.remove(0).disposeList());
        }
        if (this.location != null) {
            this.location.remove(this);
        }
        if (this.teacher != null) {
            this.teacher.setStudent(null);
            this.teacher = null;
        }
        if (this.student != null) {
            this.student.setTeacher(null);
            this.student = null;
        }
        this.setIndianSettlement(null);
        this.getOwner().invalidateCanSeeTiles();
        this.getOwner().removeUnit(this);
        if (this.unitType.canCarryGoods()) {
            objects.addAll(this.goodsContainer.disposeList());
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    public int getTurnsForRepair() {
        return this.unitType.getHitPoints() - this.getHitpoints();
    }

    public TypeCountMap<EquipmentType> getAutomaticEquipment() {
        if (this.isArmed()) {
            return null;
        }
        if (!this.getOwner().hasAbility("model.ability.automaticEquipment")) {
            return null;
        }
        Settlement settlement = null;
        if (this.getLocation() instanceof WorkLocation) {
            settlement = this.getColony();
        }
        if (this.getLocation() instanceof IndianSettlement) {
            settlement = (Settlement)this.getLocation();
        }
        if (settlement == null) {
            return null;
        }
        TypeCountMap<EquipmentType> equipmentList = null;
        Set<Ability> autoDefence = this.getOwner().getFeatureContainer().getAbilitySet("model.ability.automaticEquipment");
        for (EquipmentType equipment : this.getSpecification().getEquipmentTypeList()) {
            for (Ability ability : autoDefence) {
                if (!ability.appliesTo(equipment) || !this.canBeEquippedWith(equipment)) continue;
                boolean hasReqGoods = true;
                for (AbstractGoods goods : equipment.getGoodsRequired()) {
                    if (settlement.getGoodsCount(goods.getType()) >= goods.getAmount()) continue;
                    hasReqGoods = false;
                    break;
                }
                if (!hasReqGoods) continue;
                if (equipmentList == null) {
                    equipmentList = new TypeCountMap<EquipmentType>();
                }
                equipmentList.incrementCount(equipment, 1);
            }
        }
        return equipmentList;
    }

    public boolean losingEquipmentKillsUnit(EquipmentType lose) {
        if (this.hasAbility("model.ability.disposeOnAllEquipLost")) {
            for (EquipmentType equip : this.getEquipment().keySet()) {
                if (equip == lose) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean losingEquipmentDemotesUnit(EquipmentType lose) {
        if (this.hasAbility("model.ability.demoteOnAllEquipLost")) {
            for (EquipmentType equip : this.getEquipment().keySet()) {
                if (equip == lose) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public float getConvertProbability() {
        Specification spec = this.getSpecification();
        int opt = spec.getIntegerOption("model.option.nativeConvertProbability").getValue();
        return 0.01f * FeatureContainer.applyModifierSet(opt, this.getGame().getTurn(), this.getModifierSet("model.modifier.nativeConvertBonus"));
    }

    public float getBurnProbability() {
        return 0.01f * (float)this.getSpecification().getIntegerOption("model.option.burnProbability").getValue().intValue();
    }

    public UnitType getTypeChange(UnitTypeChange.ChangeType change, Player owner) {
        return this.getType().getTargetType(change, owner);
    }

    public EquipmentType getBestCombatEquipmentType(TypeCountMap<EquipmentType> equipment) {
        EquipmentType lose = null;
        if (equipment != null) {
            int priority = -1;
            for (EquipmentType equipmentType : equipment.keySet()) {
                if (equipmentType.getCombatLossPriority() <= priority) continue;
                lose = equipmentType;
                priority = equipmentType.getCombatLossPriority();
            }
        }
        return lose;
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        return this.unitType.getConsumedGoods();
    }

    public ProductionInfo getProductionInfo(List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        result.setConsumption(this.getType().getConsumedGoods());
        result.setMaximumConsumption(this.getType().getConsumedGoods());
        return result;
    }

    @Override
    public int getPriority() {
        return this.unitType.getPriority();
    }

    private void unitsToXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (!this.units.isEmpty()) {
            out.writeStartElement("units");
            for (Unit unit : this.units) {
                unit.toXML(out, player, showAll, toSavedGame);
            }
            out.writeEndElement();
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        boolean full = showAll || toSavedGame || player == this.getOwner();
        out.writeStartElement(Unit.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        if (this.name != null) {
            out.writeAttribute("name", this.name);
        }
        out.writeAttribute("unitType", this.unitType.getId());
        out.writeAttribute("movesLeft", Integer.toString(this.movesLeft));
        out.writeAttribute("state", this.state.toString());
        out.writeAttribute("role", this.role.toString());
        if (!full && this.hasAbility("model.ability.piracy")) {
            out.writeAttribute("owner", this.getGame().getUnknownEnemy().getId());
        } else {
            out.writeAttribute("owner", this.getOwner().getId());
            if (this.isPerson()) {
                out.writeAttribute("nationality", this.nationality != null ? this.nationality : this.getOwner().getNationID());
                out.writeAttribute("ethnicity", this.ethnicity != null ? this.ethnicity : this.getOwner().getNationID());
            }
        }
        out.writeAttribute("turnsOfTraining", Integer.toString(this.turnsOfTraining));
        if (this.workType != null) {
            out.writeAttribute("workType", this.workType.getId());
        }
        if (this.experienceType != null) {
            out.writeAttribute("experienceType", this.experienceType.getId());
        }
        out.writeAttribute("experience", Integer.toString(this.experience));
        out.writeAttribute("treasureAmount", Integer.toString(this.treasureAmount));
        out.writeAttribute("hitpoints", Integer.toString(this.hitpoints));
        out.writeAttribute("attrition", Integer.toString(this.attrition));
        this.writeAttribute(out, "student", this.student);
        this.writeAttribute(out, "teacher", this.teacher);
        if (full) {
            this.writeAttribute(out, "indianSettlement", this.indianSettlement);
            out.writeAttribute("workLeft", Integer.toString(this.workLeft));
        } else {
            out.writeAttribute("workLeft", Integer.toString(-1));
        }
        if (this.entryLocation != null) {
            out.writeAttribute("entryLocation", this.entryLocation.getId());
        }
        if (this.location != null) {
            if (full || !(this.location instanceof Building) && !(this.location instanceof ColonyTile)) {
                out.writeAttribute("location", this.location.getId());
            } else {
                out.writeAttribute("location", this.getColony().getId());
            }
        }
        if (this.destination != null) {
            out.writeAttribute("destination", this.destination.getId());
        }
        if (this.tradeRoute != null) {
            out.writeAttribute("tradeRoute", this.tradeRoute.getId());
            out.writeAttribute("currentStop", String.valueOf(this.currentStop));
        }
        if (this.workImprovement != null) {
            this.workImprovement.toXML(out, player, showAll, toSavedGame);
        }
        if (full) {
            this.unitsToXML(out, player, showAll, toSavedGame);
            if (this.getType().canCarryGoods()) {
                this.goodsContainer.toXML(out, player, showAll, toSavedGame);
            }
        } else if (this.getType().canCarryGoods()) {
            out.writeAttribute("visibleGoodsCount", Integer.toString(this.getGoodsCount()));
            this.goodsContainer.toXML(out, player, showAll, toSavedGame);
        }
        if (!this.equipment.isEmpty()) {
            for (Map.Entry<EquipmentType, Integer> entry : this.equipment.getValues().entrySet()) {
                out.writeStartElement(EQUIPMENT_TAG);
                out.writeAttribute("id", entry.getKey().getId());
                out.writeAttribute("count", entry.getValue().toString());
                out.writeEndElement();
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.setName(in.getAttributeValue(null, "name"));
        UnitType oldUnitType = this.unitType;
        this.unitType = this.getSpecification().getUnitType(in.getAttributeValue(null, "unitType"));
        this.movesLeft = Integer.parseInt(in.getAttributeValue(null, "movesLeft"));
        this.state = Enum.valueOf(UnitState.class, in.getAttributeValue(null, "state"));
        this.role = Enum.valueOf(Role.class, in.getAttributeValue(null, "role"));
        this.workLeft = Integer.parseInt(in.getAttributeValue(null, "workLeft"));
        this.attrition = this.getAttribute(in, "attrition", 0);
        String ownerId = in.getAttributeValue(null, "owner");
        this.owner = (Player)this.getGame().getFreeColGameObject(ownerId);
        if (this.owner == null) {
            this.owner = new Player(this.getGame(), ownerId);
        }
        this.nationality = in.getAttributeValue(null, "nationality");
        this.ethnicity = in.getAttributeValue(null, "ethnicity");
        if (oldUnitType == null) {
            this.owner.modifyScore(this.unitType.getScoreValue());
        } else {
            this.owner.modifyScore(this.unitType.getScoreValue() - oldUnitType.getScoreValue());
        }
        this.turnsOfTraining = Integer.parseInt(in.getAttributeValue(null, "turnsOfTraining"));
        this.hitpoints = Integer.parseInt(in.getAttributeValue(null, "hitpoints"));
        this.teacher = this.getFreeColGameObject(in, "teacher", Unit.class);
        this.student = this.getFreeColGameObject(in, "student", Unit.class);
        String indianSettlementStr = in.getAttributeValue(null, "indianSettlement");
        if (indianSettlementStr != null) {
            this.indianSettlement = (IndianSettlement)this.getGame().getFreeColGameObject(indianSettlementStr);
            if (this.indianSettlement == null) {
                this.indianSettlement = new IndianSettlement(this.getGame(), indianSettlementStr);
            }
        } else {
            this.setIndianSettlement(null);
        }
        this.treasureAmount = this.getAttribute(in, "treasureAmount", 0);
        this.destination = this.newLocation(in.getAttributeValue(null, "destination"));
        this.currentStop = -1;
        this.tradeRoute = null;
        String tradeRouteStr = in.getAttributeValue(null, "tradeRoute");
        if (tradeRouteStr != null) {
            this.tradeRoute = (TradeRoute)this.getGame().getFreeColGameObject(tradeRouteStr);
            String currentStopStr = in.getAttributeValue(null, "currentStop");
            if (currentStopStr != null) {
                this.currentStop = Integer.parseInt(currentStopStr);
            }
        }
        this.workType = this.getSpecification().getType(in, "workType", GoodsType.class, null);
        this.experienceType = this.getSpecification().getType(in, "experienceType", GoodsType.class, null);
        if (this.experienceType == null && this.workType != null) {
            this.experienceType = this.workType;
        }
        try {
            GoodsType grain = this.getSpecification().getGoodsType("model.goods.grain");
            GoodsType food = this.getSpecification().getPrimaryFoodType();
            if (food.equals(this.workType)) {
                this.workType = grain;
            }
            if (food.equals(this.experienceType)) {
                this.experienceType = grain;
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Failed to update food to grain.", e);
        }
        this.experience = this.getAttribute(in, "experience", 0);
        this.visibleGoodsCount = this.getAttribute(in, "visibleGoodsCount", -1);
        this.entryLocation = this.newLocation(in.getAttributeValue(null, "entryLocation"));
        this.location = this.newLocation(in.getAttributeValue(null, "location"));
        this.units.clear();
        if (this.goodsContainer != null) {
            this.goodsContainer.removeAll();
        }
        this.equipment.clear();
        this.setWorkImprovement(null);
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals("units")) {
                this.units = new ArrayList<Unit>();
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                    this.units.add(this.updateFreeColGameObject(in, Unit.class));
                }
                continue;
            }
            if (in.getLocalName().equals(GoodsContainer.getXMLElementTagName())) {
                this.goodsContainer = (GoodsContainer)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (this.goodsContainer != null) {
                    this.goodsContainer.readFromXML(in);
                    continue;
                }
                this.goodsContainer = new GoodsContainer(this.getGame(), (Location)this, in);
                continue;
            }
            if (in.getLocalName().equals(EQUIPMENT_TAG)) {
                String xLength = in.getAttributeValue(null, "xLength");
                if (xLength == null) {
                    String equipmentId = in.getAttributeValue(null, "id");
                    int count = Integer.parseInt(in.getAttributeValue(null, "count"));
                    this.equipment.incrementCount(this.getSpecification().getEquipmentType(equipmentId), count);
                } else {
                    int length = Integer.parseInt(xLength);
                    for (int index = 0; index < length; ++index) {
                        String equipmentId = in.getAttributeValue(null, "x" + String.valueOf(index));
                        this.equipment.incrementCount(this.getSpecification().getEquipmentType(equipmentId), 1);
                    }
                }
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(TileImprovement.getXMLElementTagName())) {
                this.setWorkImprovement(this.updateFreeColGameObject(in, TileImprovement.class));
                continue;
            }
            logger.warning("Found unknown child element '" + in.getLocalName() + "' of Unit " + this.getId() + ", skipping to next tag.");
            in.nextTag();
        }
        if (this.goodsContainer == null && this.getType().canCarryGoods()) {
            logger.warning("Carrier with ID " + this.getId() + " did not have a \"goodsContainer\"-tag.");
            this.goodsContainer = new GoodsContainer(this.getGame(), this);
        }
        this.setRole();
        this.getOwner().setUnit(this);
        this.getOwner().invalidateCanSeeTiles();
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "unit";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoveType {
        MOVE(null, true),
        MOVE_HIGH_SEAS(null, true),
        EXPLORE_LOST_CITY_RUMOUR(null, true),
        ATTACK_UNIT(null, false),
        ATTACK_SETTLEMENT(null, false),
        EMBARK(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_SCOUT(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY(null, false),
        ENTER_FOREIGN_COLONY_WITH_SCOUT(null, false),
        ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS(null, false),
        MOVE_NO_MOVES("Attempt to move without moves left"),
        MOVE_NO_ACCESS_LAND("Attempt to move a naval unit onto land"),
        MOVE_NO_ACCESS_BEACHED("Attempt to move onto foreign beached ship"),
        MOVE_NO_ACCESS_EMBARK("Attempt to embark onto absent or foreign carrier"),
        MOVE_NO_ACCESS_FULL("Attempt to embark onto full carrier"),
        MOVE_NO_ACCESS_GOODS("Attempt to trade without goods"),
        MOVE_NO_ACCESS_CONTACT("Attempt to interact with natives before contact"),
        MOVE_NO_ACCESS_SETTLEMENT("Attempt to move into foreign settlement"),
        MOVE_NO_ACCESS_SKILL("Attempt to learn skill with incapable unit"),
        MOVE_NO_ACCESS_TRADE("Attempt to trade without authority"),
        MOVE_NO_ACCESS_WAR("Attempt to trade while at war"),
        MOVE_NO_ACCESS_WATER("Attempt to move into a settlement by water"),
        MOVE_NO_ATTACK_CIVILIAN("Attempt to attack with civilian unit"),
        MOVE_NO_ATTACK_MARINE("Attempt to attack from on board ship"),
        MOVE_NO_EUROPE("Attempt to move to Europe by incapable unit"),
        MOVE_NO_REPAIR("Attempt to move a unit that is under repair"),
        MOVE_ILLEGAL("Unspecified illegal move");

        private String reason;
        private boolean progress;

        private MoveType(String reason) {
            this.reason = reason;
            this.progress = false;
        }

        private MoveType(String reason, boolean progress) {
            this.reason = reason;
            this.progress = progress;
        }

        public boolean isLegal() {
            return this.reason == null;
        }

        public String whyIllegal() {
            return this.reason == null ? "(none)" : this.reason;
        }

        public boolean isProgress() {
            return this.progress;
        }

        public boolean isAttack() {
            return this == ATTACK_UNIT || this == ATTACK_SETTLEMENT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        DEFAULT,
        PIONEER,
        MISSIONARY,
        SOLDIER,
        SCOUT,
        DRAGOON;

        private static final HashMap<Role, List<EquipmentType>> roleEquipment;

        private void initializeRoleEquipment(Specification spec) {
            if (!roleEquipment.isEmpty()) {
                return;
            }
            UnitType defaultUnit = spec.getDefaultUnitType();
            for (EquipmentType e : spec.getEquipmentTypeList()) {
                Role r = e.getRole();
                if (r == null) continue;
                List<EquipmentType> eq = roleEquipment.get((Object)r);
                if (eq == null) {
                    eq = new ArrayList<EquipmentType>();
                    roleEquipment.put(r, eq);
                }
                eq.add(e);
            }
            for (EquipmentType e : spec.getEquipmentTypeList()) {
                if (!e.isMilitaryEquipment()) continue;
                List<EquipmentType> eq = roleEquipment.get((Object)DRAGOON);
                if (eq == null) {
                    eq = new ArrayList<EquipmentType>();
                    roleEquipment.put(DRAGOON, eq);
                }
                if (eq.contains(e)) continue;
                eq.add(e);
            }
            for (Role r : Role.values()) {
                List<EquipmentType> e = roleEquipment.get((Object)r);
                if (e != null) continue;
                e = new ArrayList<EquipmentType>();
                roleEquipment.put(r, e);
            }
        }

        public List<EquipmentType> getRoleEquipment(Specification spec) {
            this.initializeRoleEquipment(spec);
            return new ArrayList<EquipmentType>((Collection)roleEquipment.get((Object)this));
        }

        public boolean isCompatibleWith(Role oldRole) {
            return this == oldRole || this == SOLDIER && oldRole == DRAGOON || this == DRAGOON && oldRole == SOLDIER;
        }

        public Role newRole(Role role) {
            if (this == SOLDIER && role == SCOUT) {
                return DRAGOON;
            }
            if (this == SCOUT && role == SOLDIER) {
                return DRAGOON;
            }
            return role;
        }

        public String getId() {
            return this.toString().toLowerCase(Locale.US);
        }

        static {
            roleEquipment = new HashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnitState {
        ACTIVE,
        FORTIFIED,
        SENTRY,
        IN_COLONY,
        IMPROVING,
        TO_EUROPE,
        TO_AMERICA,
        FORTIFYING,
        SKIPPED;

    }
}

