/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.PlayerExploredTile;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileItemContainer
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(TileItemContainer.class.getName());
    private Tile tile;
    private List<TileItem> tileItems = new ArrayList<TileItem>();
    private final Comparator<TileItem> tileItemComparator = new Comparator<TileItem>(){

        @Override
        public int compare(TileItem tileItem1, TileItem tileItem2) {
            return tileItem1.getZIndex() - tileItem2.getZIndex();
        }
    };

    public TileItemContainer(Game game, Tile tile) {
        super(game);
        if (tile == null) {
            throw new IllegalArgumentException("Tile must not be 'null'.");
        }
        this.tile = tile;
    }

    public TileItemContainer(Game game, Tile tile, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        if (tile == null) {
            throw new IllegalArgumentException("Tile must not be 'null'.");
        }
        this.tile = tile;
        this.readFromXML(in);
    }

    private void invalidateCache() {
        Colony colony = this.tile.getColony();
        if (colony != null && colony.isTileInUse(this.tile)) {
            colony.invalidateCache();
        }
    }

    public Tile getTile() {
        return this.tile;
    }

    public final List<TileItem> getTileItems() {
        return this.tileItems;
    }

    public final void setTileItems(List<TileItem> newTileItems) {
        this.tileItems = newTileItems;
        this.invalidateCache();
    }

    public Resource getResource() {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof Resource)) continue;
            return (Resource)item;
        }
        return null;
    }

    public TileImprovement getImprovement(TileImprovementType type) {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || ((TileImprovement)item).getType() != type) continue;
            return (TileImprovement)item;
        }
        return null;
    }

    public TileImprovement getRoad() {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || !((TileImprovement)item).isRoad()) continue;
            return (TileImprovement)item;
        }
        return null;
    }

    public TileImprovement getRiver() {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || !((TileImprovement)item).isRiver()) continue;
            return (TileImprovement)item;
        }
        return null;
    }

    public final LostCityRumour getLostCityRumour() {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof LostCityRumour)) continue;
            return (LostCityRumour)item;
        }
        return null;
    }

    public void removeIncompatibleImprovements() {
        TileType tileType = this.tile.getType();
        Iterator<TileItem> iterator = this.tileItems.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            TileItem item = iterator.next();
            if (item.isTileTypeAllowed(tileType)) continue;
            iterator.remove();
            item.dispose();
            removed = true;
        }
        if (removed) {
            this.invalidateCache();
        }
    }

    public List<TileImprovement> getImprovements() {
        return this.getImprovements(false);
    }

    public List<TileImprovement> getCompletedImprovements() {
        return this.getImprovements(true);
    }

    private List<TileImprovement> getImprovements(boolean completedOnly) {
        ArrayList<TileImprovement> improvements = new ArrayList<TileImprovement>();
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || completedOnly && !((TileImprovement)item).isComplete()) continue;
            improvements.add((TileImprovement)item);
        }
        return improvements;
    }

    public int getTotalBonusPotential(GoodsType g, UnitType unitType, int tilePotential, boolean onlyNatural) {
        int potential = tilePotential;
        int improvementBonus = 0;
        for (TileItem item : this.tileItems) {
            if (item instanceof TileImprovement) {
                TileImprovement improvement = (TileImprovement)item;
                if (!improvement.getType().isNatural() && onlyNatural) continue;
                improvementBonus += improvement.getBonus(g);
                continue;
            }
            if (!(item instanceof Resource)) continue;
            potential = ((Resource)item).getBonus(g, unitType, potential);
        }
        if (potential > 0) {
            potential += improvementBonus;
        }
        return potential;
    }

    public Set<Modifier> getProductionBonus(GoodsType goodsType, UnitType unitType) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (TileItem item : this.tileItems) {
            Modifier modifier;
            if (item instanceof Resource) {
                result.addAll(((Resource)item).getType().getProductionModifier(goodsType, unitType));
                continue;
            }
            if (!(item instanceof TileImprovement) || (modifier = ((TileImprovement)item).getProductionModifier(goodsType)) == null) continue;
            result.add(modifier);
        }
        return result;
    }

    public int getMoveCost(int basicMoveCost, Tile fromTile) {
        int moveCost = basicMoveCost;
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || !((TileImprovement)item).isComplete()) continue;
            moveCost = ((TileImprovement)item).getMovementCost(moveCost, fromTile);
        }
        return moveCost;
    }

    public TileItem addTileItem(TileItem item) {
        if (item == null) {
            return null;
        }
        for (int index = 0; index < this.tileItems.size(); ++index) {
            TileItem oldItem = this.tileItems.get(index);
            if (item instanceof TileImprovement && oldItem instanceof TileImprovement && ((TileImprovement)oldItem).getType().getId().equals(((TileImprovement)item).getType().getId())) {
                if (((TileImprovement)oldItem).getMagnitude() < ((TileImprovement)item).getMagnitude()) {
                    this.tileItems.set(index, item);
                    oldItem.dispose();
                    this.invalidateCache();
                    return item;
                }
                return oldItem;
            }
            if (oldItem.getZIndex() <= item.getZIndex()) continue;
            this.tileItems.add(index, item);
            this.invalidateCache();
            return item;
        }
        this.tileItems.add(item);
        this.invalidateCache();
        return item;
    }

    public TileItem removeTileItem(TileItem item) {
        boolean removed = this.tileItems.remove(item);
        if (removed) {
            this.invalidateCache();
            return item;
        }
        return null;
    }

    public <T extends TileItem> void removeAll(Class<T> c) {
        Iterator<TileItem> iterator = this.tileItems.iterator();
        while (iterator.hasNext()) {
            if (!c.isInstance(iterator.next())) continue;
            iterator.remove();
        }
    }

    public void copyFrom(TileItemContainer tic) {
        this.copyFrom(tic, true, false);
    }

    public void copyFrom(TileItemContainer tic, boolean importResources) {
        this.copyFrom(tic, importResources, false);
    }

    public void copyFrom(TileItemContainer tic, boolean importResources, boolean copyOnlyNatural) {
        this.tileItems.clear();
        for (TileItem item : tic.getTileItems()) {
            TileItem r;
            TileItem ticR;
            if (item instanceof Resource) {
                if (!importResources) continue;
                ticR = (Resource)item;
                r = new Resource(this.getGame(), this.tile, ((Resource)ticR).getType(), ((Resource)ticR).getQuantity());
                this.tileItems.add(r);
                continue;
            }
            if (item instanceof LostCityRumour && !copyOnlyNatural) {
                ticR = (LostCityRumour)item;
                r = new LostCityRumour(this.getGame(), this.tile, ((LostCityRumour)ticR).getType(), ((LostCityRumour)ticR).getName());
                this.addTileItem(r);
                continue;
            }
            if (!(item instanceof TileImprovement) || copyOnlyNatural && !((TileImprovement)item).getType().isNatural()) continue;
            TileImprovement ti = (TileImprovement)item;
            TileImprovement newTI = new TileImprovement(this.getGame(), this.tile, ti.getType());
            newTI.setMagnitude(ti.getMagnitude());
            newTI.setStyle(ti.getStyle());
            newTI.setTurnsToComplete(ti.getTurnsToComplete());
            this.addTileItem(newTI);
        }
    }

    public boolean contains(TileItem t) {
        return this.tileItems.contains(t);
    }

    public TileImprovement findTileImprovementType(TileImprovementType type) {
        for (TileItem item : this.tileItems) {
            if (!(item instanceof TileImprovement) || ((TileImprovement)item).getType() != type) continue;
            return (TileImprovement)item;
        }
        return null;
    }

    public boolean hasImprovement(TileImprovementType type) {
        TileImprovement improvement = this.findTileImprovementType(type);
        return improvement != null && improvement.isComplete();
    }

    @Override
    public void dispose() {
        this.tileItems.clear();
        super.dispose();
    }

    public TileImprovement addRiver(int magnitude, int style) {
        if (magnitude == 0) {
            return null;
        }
        TileImprovement river = new TileImprovement(this.getGame(), this.tile, this.getSpecification().getTileImprovementType("model.improvement.river"));
        river = (TileImprovement)this.addTileItem(river);
        river.setMagnitude(magnitude);
        river.setStyle(style);
        this.invalidateCache();
        return river;
    }

    public TileImprovement removeRiver() {
        Iterator<TileItem> iterator = this.tileItems.iterator();
        while (iterator.hasNext()) {
            TileItem item = iterator.next();
            if (!(item instanceof TileImprovement) || !((TileImprovement)item).isRiver()) continue;
            iterator.remove();
            this.invalidateCache();
            return (TileImprovement)item;
        }
        return null;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        PlayerExploredTile pet = showAll || toSavedGame ? null : this.tile.getPlayerExploredTile(player);
        out.writeStartElement(TileItemContainer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("tile", this.tile.getId());
        if (showAll || toSavedGame || player.canSee(this.tile)) {
            for (TileItem item : this.tileItems) {
                item.toXML(out, player, showAll, toSavedGame);
            }
        } else if (pet != null) {
            List<TileItem> petItems = pet.getAllTileItems();
            Collections.sort(petItems, this.tileItemComparator);
            for (TileItem item : petItems) {
                item.toXML(out, player, showAll, toSavedGame);
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.tile = (Tile)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "tile"));
        if (this.tile == null) {
            this.tile = new Tile(this.getGame(), in.getAttributeValue(null, "tile"));
        }
        this.tileItems.clear();
        while (in.nextTag() != 2) {
            TileItem item = (TileItem)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
            if (item == null) {
                if (in.getLocalName().equals(Resource.getXMLElementTagName())) {
                    item = new Resource(this.getGame(), in);
                } else if (in.getLocalName().equals(LostCityRumour.getXMLElementTagName())) {
                    item = new LostCityRumour(this.getGame(), in);
                } else if (in.getLocalName().equals(TileImprovement.getXMLElementTagName())) {
                    item = new TileImprovement(this.getGame(), in);
                }
            } else {
                item.readFromXML(in);
            }
            this.tileItems.add(item);
        }
        Collections.sort(this.tileItems, this.tileItemComparator);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        sb.append("TileItemContainer with: ");
        for (TileItem item : this.tileItems) {
            sb.append(item.toString() + ", ");
        }
        return sb.toString();
    }

    public static String getXMLElementTagName() {
        return "tileitemcontainer";
    }
}

