/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import org.w3c.dom.Element;

public class Goods
extends AbstractGoods
implements Locatable,
Ownable,
Named {
    private static Logger logger = Logger.getLogger(Goods.class.getName());
    private Game game;
    private Location location;

    public Goods(Game game, Location location, GoodsType type, int amount) {
        if (game == null) {
            throw new IllegalArgumentException("Parameter 'game' must not be 'null'.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be 'null'.");
        }
        if (location != null && location.getGoodsContainer() == null) {
            throw new IllegalArgumentException("This location cannot store goods: " + location.toString());
        }
        this.game = game;
        this.location = location;
        this.setType(type);
        this.setAmount(amount);
    }

    public Goods(Game game, XMLStreamReader in) throws XMLStreamException {
        this.game = game;
        this.readFromXML(in);
    }

    public Goods(Game game, Element e) {
        this.game = game;
        this.readFromXMLElement(e);
    }

    public Player getOwner() {
        return this.location instanceof Ownable ? ((Ownable)((Object)this.location)).getOwner() : null;
    }

    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return Goods.toString(this);
    }

    public static String toString(Goods goods) {
        return Goods.toString(goods.getType(), goods.getAmount());
    }

    public static String toString(GoodsType goodsType, int amount) {
        return Integer.toString(amount) + " " + goodsType.getId();
    }

    public StringTemplate getLabel(boolean sellable) {
        return StringTemplate.template(sellable ? "model.goods.goodsAmount" : "model.goods.goodsBoycotted").addAmount("%amount%", this.getAmount()).add("%goods%", this.getType().getNameKey());
    }

    public Tile getTile() {
        return this.location != null ? this.location.getTile() : null;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void changeLocation(Location location) {
        if (location != null && location.getGoodsContainer() == null) {
            throw new IllegalArgumentException("Goods have to be located in a GoodsContainers.");
        }
        if (this.location != null) {
            this.location.remove(this);
        }
        this.location = null;
        if (location != null) {
            location.add(this);
        }
        this.location = location;
    }

    public int getSpaceTaken() {
        return 1;
    }

    public void adjustAmount() {
        int maxAmount = this.location.getGoodsContainer().getGoodsCount(this.getType());
        if (this.getAmount() > maxAmount) {
            this.setAmount(maxAmount);
        }
    }

    public Game getGame() {
        return this.game;
    }

    public int hashCode() {
        int value = 19;
        value = 303 * value + (this.getLocation() == null ? 1 : this.getLocation().getId().hashCode());
        value = 303 * value + this.getType().hashCode();
        value = 303 * value + this.getAmount();
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Goods) {
            Goods g = (Goods)obj;
            return this.getLocation() == g.getLocation() && this.getType() == g.getType() && this.getAmount() == g.getAmount();
        }
        return false;
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(Goods.getXMLElementTagName());
        out.writeAttribute("type", this.getType().getId());
        out.writeAttribute("amount", Integer.toString(this.getAmount()));
        if (this.location != null) {
            out.writeAttribute("location", this.location.getId());
        } else {
            logger.warning("Creating an XML-element for a 'Goods' without a 'Location'.");
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setType(this.game.getSpecification().getGoodsType(in.getAttributeValue(null, "type")));
        this.setAmount(Integer.parseInt(in.getAttributeValue(null, "amount")));
        String locationStr = in.getAttributeValue(null, "location");
        if (locationStr != null) {
            this.location = (Location)((Object)this.getGame().getFreeColGameObject(locationStr));
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "goods";
    }
}

