/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonyTile
extends WorkLocation
implements Ownable {
    private static final Logger logger = Logger.getLogger(ColonyTile.class.getName());
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    public static final int UNIT_CAPACITY = 1;
    protected Tile workTile;
    protected boolean colonyCenterTile;

    protected ColonyTile() {
    }

    protected ColonyTile(Game game, Colony colony, Tile workTile) {
        super(game);
        this.setColony(colony);
        this.workTile = workTile;
        this.colonyCenterTile = this.getTile() == workTile;
    }

    public ColonyTile(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public ColonyTile(Game game, String id) {
        super(game, id);
    }

    @Override
    public StringTemplate getLocationName() {
        String name = this.getColony().getName();
        if (this.isColonyCenterTile()) {
            return StringTemplate.name(name);
        }
        return StringTemplate.template("nearLocation").add("%direction%", "direction." + this.getTile().getDirection(this.workTile).toString()).addName("%location%", name);
    }

    public StringTemplate getLabel() {
        return this.workTile.getLabel();
    }

    public boolean isColonyCenterTile() {
        return this.colonyCenterTile;
    }

    public Tile getWorkTile() {
        return this.workTile;
    }

    public Unit getUnit() {
        return this.isEmpty() ? null : this.getUnitList().get(0);
    }

    @Override
    public int getUnitCapacity() {
        return this.isColonyCenterTile() ? 0 : 1;
    }

    @Override
    public UnitLocation.NoAddReason getNoWorkReason() {
        Player.NoClaimReason claim;
        Tile tile = this.getWorkTile();
        UnitLocation.NoAddReason noAddReason = this.isColonyCenterTile() ? UnitLocation.NoAddReason.COLONY_CENTER : (tile.getOccupyingUnit() != null ? UnitLocation.NoAddReason.OCCUPIED_BY_ENEMY : (!this.getColony().hasAbility("model.ability.produceInWater") && !tile.isLand() ? UnitLocation.NoAddReason.MISSING_ABILITY : (tile.getOwningSettlement() == this.getColony() ? UnitLocation.NoAddReason.NONE : ((claim = this.getOwner().canClaimForSettlementReason(tile)) == Player.NoClaimReason.NONE ? UnitLocation.NoAddReason.CLAIM_REQUIRED : (claim == Player.NoClaimReason.TERRAIN || claim == Player.NoClaimReason.RUMOUR || claim == Player.NoClaimReason.WATER ? UnitLocation.NoAddReason.MISSING_ABILITY : (claim == Player.NoClaimReason.SETTLEMENT ? (tile.getSettlement().getOwner() == this.getOwner() ? UnitLocation.NoAddReason.ANOTHER_COLONY : UnitLocation.NoAddReason.OWNED_BY_ENEMY) : (claim == Player.NoClaimReason.WORKED ? UnitLocation.NoAddReason.ANOTHER_COLONY : (claim == Player.NoClaimReason.EUROPEANS ? UnitLocation.NoAddReason.OWNED_BY_ENEMY : (claim == Player.NoClaimReason.NATIVES ? UnitLocation.NoAddReason.CLAIM_REQUIRED : UnitLocation.NoAddReason.WRONG_TYPE)))))))));
        return noAddReason;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoWorkReason();
        return reason != UnitLocation.NoAddReason.NONE ? reason : super.getNoAddReason(locatable);
    }

    @Override
    public boolean add(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoAddReason(locatable);
        if (reason != UnitLocation.NoAddReason.NONE) {
            throw new IllegalStateException("Can not add " + locatable + " to " + this.toString() + " because " + (Object)((Object)reason));
        }
        Unit unit = (Unit)locatable;
        if (this.contains(unit)) {
            return true;
        }
        if (super.add(unit)) {
            unit.setState(Unit.UnitState.IN_COLONY);
            if (unit.getWorkType() == null) {
                AbstractGoods goods = this.workTile.getType().getPrimaryGoods();
                if (goods == null && (goods = this.workTile.getType().getSecondaryGoods()) == null && !this.workTile.getType().getProduction().isEmpty()) {
                    goods = this.workTile.getType().getProduction().get(0);
                }
                if (goods != null) {
                    unit.setWorkType(goods.getType());
                }
            }
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (!this.contains(unit)) {
            return true;
        }
        if (super.remove(unit)) {
            unit.setState(Unit.UnitState.ACTIVE);
            unit.setMovesLeft(0);
            this.getColony().invalidateCache();
            return true;
        }
        return false;
    }

    public void relocateWorkers() {
        block0: for (Unit unit : this.getUnitList()) {
            for (WorkLocation wl : this.getColony().getCurrentWorkLocations()) {
                if (wl == this || !wl.canAdd(unit)) continue;
                unit.setLocation(wl);
                continue block0;
            }
        }
    }

    public Unit getOccupyingUnit() {
        return this.workTile.getOccupyingUnit();
    }

    public boolean isOccupied() {
        return this.workTile.isOccupied();
    }

    public GoodsType getWorkType(Unit unit) {
        int amount;
        GoodsType workType = unit.getWorkType();
        int n = amount = workType == null ? 0 : this.getProductionOf(unit, workType);
        if (amount == 0) {
            List<GoodsType> farmedGoodsTypes = this.getSpecification().getFarmedGoodsTypeList();
            for (GoodsType farmedGoods : farmedGoodsTypes) {
                int newAmount = this.getProductionOf(unit, farmedGoods);
                if (newAmount <= amount) continue;
                amount = newAmount;
                workType = farmedGoods;
            }
        }
        return workType;
    }

    private AbstractGoods getPrimaryProduction() {
        if (this.workTile.getType().getPrimaryGoods() == null) {
            return null;
        }
        AbstractGoods primaryProduction = new AbstractGoods(this.workTile.getType().getPrimaryGoods());
        int potential = primaryProduction.getAmount();
        if (this.workTile.getTileItemContainer() != null) {
            potential = this.workTile.getTileItemContainer().getTotalBonusPotential(primaryProduction.getType(), null, potential, false);
        }
        primaryProduction.setAmount(potential + Math.max(0, this.getColony().getProductionBonus()));
        return primaryProduction;
    }

    private AbstractGoods getSecondaryProduction() {
        if (this.workTile.getType().getSecondaryGoods() == null) {
            return null;
        }
        AbstractGoods secondaryProduction = new AbstractGoods(this.workTile.getType().getSecondaryGoods());
        int potential = secondaryProduction.getAmount();
        if (this.workTile.getTileItemContainer() != null) {
            potential = this.workTile.getTileItemContainer().getTotalBonusPotential(secondaryProduction.getType(), null, potential, true);
        }
        secondaryProduction.setAmount(potential + Math.max(0, this.getColony().getProductionBonus()));
        return secondaryProduction;
    }

    public List<AbstractGoods> getProduction() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>(2);
        if (this.isColonyCenterTile()) {
            AbstractGoods secondaryProduction;
            AbstractGoods primaryProduction = this.getPrimaryProduction();
            if (primaryProduction != null) {
                result.add(primaryProduction);
            }
            if ((secondaryProduction = this.getSecondaryProduction()) != null) {
                result.add(secondaryProduction);
            }
        } else {
            for (Unit unit : this.getUnitList()) {
                GoodsType goodsType = unit.getWorkType();
                result.add(new AbstractGoods(goodsType, this.getProductionOf(unit, goodsType)));
            }
        }
        return result;
    }

    public Set<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            throw new IllegalArgumentException("GoodsType must not be 'null'.");
        }
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (Unit unit : this.getUnitList()) {
            if (this.isColonyCenterTile() && (this.workTile.getType().isPrimaryGoodsType(goodsType) || this.workTile.getType().isSecondaryGoodsType(goodsType))) {
                result.addAll(this.workTile.getProductionBonus(goodsType, null));
                result.addAll(this.getColony().getFeatureContainer().getModifierSet(goodsType.getId()));
                continue;
            }
            if (!goodsType.equals(unit.getWorkType())) continue;
            result.addAll(this.workTile.getProductionBonus(goodsType, unitType));
            result.addAll(unit.getModifierSet(goodsType.getId()));
        }
        return result;
    }

    @Override
    public int getProductionOf(GoodsType goodsType) {
        if (goodsType == null) {
            throw new IllegalArgumentException("GoodsType must not be 'null'.");
        }
        if (this.isColonyCenterTile()) {
            TileType type = this.workTile.getType();
            return type.getPrimaryGoods() != null && type.getPrimaryGoods().getType() == goodsType ? this.getPrimaryProduction().getAmount() : (type.getSecondaryGoods() != null && type.getSecondaryGoods().getType() == goodsType ? this.getSecondaryProduction().getAmount() : 0);
        }
        int production = 0;
        for (Unit unit : this.getUnitList()) {
            if (!goodsType.equals(unit.getWorkType())) continue;
            production += this.getProductionOf(unit, goodsType);
        }
        return production;
    }

    @Override
    public int getProductionOf(Unit unit, GoodsType goodsType) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        if (this.workTile.isLand() || this.getColony().hasAbility("model.ability.produceInWater")) {
            Set<Modifier> modifiers = this.workTile.getProductionBonus(goodsType, unit.getType());
            if (FeatureContainer.applyModifierSet(0.0f, this.getGame().getTurn(), modifiers) > 0.0f) {
                modifiers.addAll(unit.getModifierSet(goodsType.getId()));
                modifiers.add(this.getColony().getProductionModifier(goodsType));
                modifiers.addAll(this.getColony().getModifierSet(goodsType.getId()));
                ArrayList<Modifier> modifierList = new ArrayList<Modifier>(modifiers);
                Collections.sort(modifierList);
                return Math.max(1, (int)FeatureContainer.applyModifiers(0.0f, this.getGame().getTurn(), modifierList));
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getPotentialProduction(UnitType unitType, GoodsType goodsType) {
        int production = 0;
        if (this.isColonyCenterTile()) {
            TileType type = this.workTile.getType();
            return type.getPrimaryGoods() != null && type.getPrimaryGoods().getType() == goodsType ? this.getPrimaryProduction().getAmount() : (type.getSecondaryGoods() != null && type.getSecondaryGoods().getType() == goodsType ? this.getSecondaryProduction().getAmount() : 0);
        }
        if (this.workTile.isLand() || this.getColony().hasAbility("model.ability.produceInWater")) {
            Set<Modifier> modifiers = this.workTile.getProductionBonus(goodsType, unitType);
            if (FeatureContainer.applyModifierSet(0.0f, this.getGame().getTurn(), modifiers) > 0.0f) {
                if (unitType != null) {
                    modifiers.addAll(unitType.getModifierSet(goodsType.getId()));
                }
                modifiers.add(this.getColony().getProductionModifier(goodsType));
                modifiers.addAll(this.getColony().getModifierSet(goodsType.getId()));
                ArrayList<Modifier> modifierList = new ArrayList<Modifier>(modifiers);
                Collections.sort(modifierList);
                production = Math.max((int)FeatureContainer.applyModifiers(0.0f, this.getGame().getTurn(), modifierList), 1);
            }
        }
        return production;
    }

    @Override
    public boolean canAutoProduce() {
        return this.isColonyCenterTile();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(ColonyTile.getXMLElementTagName());
        super.writeAttributes(out);
        out.writeAttribute("workTile", this.workTile.getId());
        super.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.workTile = this.getFreeColGameObject(in, "workTile", Tile.class);
        this.colonyCenterTile = this.getTile() == this.workTile;
        super.readChildren(in);
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        return "ColonyTile " + this.getWorkTile().getPosition().toString() + " in '" + this.getColony().getName() + "'";
    }

    public static String getXMLElementTagName() {
        return "colonyTile";
    }
}

