/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;

public class AbstractGoods
extends FreeColObject {
    private GoodsType type;
    private int amount;

    public AbstractGoods() {
    }

    public AbstractGoods(GoodsType type, int amount) {
        this.setId(type.getId());
        this.type = type;
        this.amount = amount;
    }

    public AbstractGoods(AbstractGoods other) {
        this.setId(other.type.getId());
        this.type = other.type;
        this.amount = other.amount;
    }

    public final GoodsType getType() {
        return this.type;
    }

    public String getNameKey() {
        return this.getType().getNameKey();
    }

    public final void setType(GoodsType newType) {
        this.type = newType;
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int newAmount) {
        this.amount = newAmount;
    }

    public boolean equals(AbstractGoods other) {
        return this.type == other.type && this.amount == other.amount;
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, AbstractGoods.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("type", this.getId());
        out.writeAttribute("amount", Integer.toString(this.amount));
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.type = this.getSpecification().getGoodsType(in.getAttributeValue(null, "type"));
        this.amount = Integer.parseInt(in.getAttributeValue(null, "amount"));
        in.nextTag();
    }

    public String toString() {
        return Integer.toString(this.amount) + " " + this.type.getId();
    }

    public static String getXMLElementTagName() {
        return "abstractGoods";
    }
}

