/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Unit;

public final class ReportEducationPanel
extends ReportPanel {
    public ReportEducationPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, Messages.message("reportEducationAction.name"));
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 2, fill", "[]20[fill, growprio 200]"));
        List<Colony> colonies = this.getSortedColonies();
        for (Colony colony : colonies) {
            for (Building building : colony.getBuildings()) {
                if (!building.canTeach()) continue;
                int maxSkill = Integer.MIN_VALUE;
                this.reportPanel.add((Component)this.createColonyButton(colony), "newline, split 2, flowy");
                this.reportPanel.add(new BuildingPanel(this.getFreeColClient(), building, this.getGUI()));
                JPanel teacherPanel = this.getPanel("report.education.teachers");
                for (Unit unit : colony.getUnitList()) {
                    if (!building.canAdd(unit)) continue;
                    teacherPanel.add(new UnitLabel(this.getFreeColClient(), unit, this.getGUI(), true, true));
                    maxSkill = Math.max(maxSkill, unit.getType().getSkill());
                }
                this.reportPanel.add((Component)teacherPanel, "split 2, flowy, grow");
                JPanel studentPanel = this.getPanel("report.education.students");
                for (Unit unit : colony.getUnitList()) {
                    if (unit.getType().getEducationUnit(maxSkill) == null) continue;
                    studentPanel.add(new UnitLabel(this.getFreeColClient(), unit, this.getGUI(), true, true));
                }
                this.reportPanel.add((Component)studentPanel, "grow");
            }
        }
    }

    private JPanel getPanel(String title) {
        JPanel result = new JPanel(new FlowLayout(0));
        result.setOpaque(false);
        result.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY, 1), Messages.message(title)));
        return result;
    }
}

