/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingDetailPanel
extends ColopediaGameObjectTypePanel<BuildingType> {
    private static final Font arrowFont = ResourceManager.getFont("SimpleFont", 1, 24.0f);

    public BuildingDetailPanel(FreeColClient freeColClient, GUI gui, ColopediaPanel colopediaPanel) {
        super(freeColClient, gui, colopediaPanel, ColopediaAction.PanelType.BUILDINGS.toString(), 0.75);
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        Image buildingImage = ResourceManager.getImage("Colopedia.buildingSection.image");
        ImageIcon buildingIcon = new ImageIcon(buildingImage != null ? buildingImage : null);
        ArrayList<BuildingType> buildingTypes = new ArrayList<BuildingType>();
        HashMap<BuildingType, DefaultMutableTreeNode> buildingHash = new HashMap<BuildingType, DefaultMutableTreeNode>();
        for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
            if (buildingType.getUpgradesFrom() == null) {
                String name = Messages.message(buildingType.getNameKey());
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(this, buildingType.getId(), name, buildingIcon));
                buildingHash.put(buildingType, item);
                parent.add(item);
                continue;
            }
            buildingTypes.add(buildingType);
        }
        while (!buildingTypes.isEmpty()) {
            Iterator iterator = buildingTypes.iterator();
            while (iterator.hasNext()) {
                BuildingType buildingType;
                buildingType = (BuildingType)iterator.next();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)buildingHash.get(buildingType.getUpgradesFrom());
                if (node == null) continue;
                String name = Messages.message(buildingType.getNameKey());
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(this, buildingType.getId(), name, buildingIcon));
                node.add(item);
                buildingHash.put(buildingType, item);
                iterator.remove();
            }
        }
        root.add(parent);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        BuildingType buildingType = this.getSpecification().getBuildingType(id);
        panel.setLayout((LayoutManager)new MigLayout("wrap 7, gapx 20", "", ""));
        JLabel name = this.localizedLabel(buildingType.getNameKey());
        name.setFont(smallHeaderFont);
        panel.add((Component)name, "span, align center, wrap 40");
        JTextPane textPane = BuildingDetailPanel.getDefaultTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        try {
            if (buildingType.getUpgradesFrom() != null) {
                StyleConstants.setComponent(doc.getStyle("button"), this.getButton(buildingType.getUpgradesFrom()));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
            }
            if (buildingType.getPopulationRequired() > 0) {
                StringTemplate template = StringTemplate.template("colonist").addAmount("%number%", buildingType.getPopulationRequired());
                doc.insertString(doc.getLength(), Messages.message(template) + "\n", doc.getStyle("regular"));
            }
            this.appendRequiredAbilities(doc, buildingType);
            panel.add((Component)this.localizedLabel("colopedia.buildings.requires"), "top");
            panel.add((Component)textPane, "span, growx");
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        panel.add(this.localizedLabel("colopedia.buildings.cost"));
        if (buildingType.getGoodsRequired().isEmpty()) {
            panel.add((Component)this.localizedLabel("colopedia.buildings.autoBuilt"), "span");
        } else {
            AbstractGoods goodsRequired = buildingType.getGoodsRequired().get(0);
            if (buildingType.getGoodsRequired().size() > 1) {
                panel.add((Component)this.getGoodsButton(goodsRequired.getType(), goodsRequired.getAmount()), "span, split " + buildingType.getGoodsRequired().size());
                for (int index = 1; index < buildingType.getGoodsRequired().size(); ++index) {
                    goodsRequired = buildingType.getGoodsRequired().get(index);
                    panel.add(this.getGoodsButton(goodsRequired.getType(), goodsRequired.getAmount()));
                }
            } else {
                panel.add((Component)this.getGoodsButton(goodsRequired.getType(), goodsRequired.getAmount()), "span");
            }
        }
        if (buildingType.hasAbility("model.ability.teach")) {
            panel.add((Component)this.localizedLabel("colopedia.buildings.teaches"), "newline, top");
            int count = 0;
            for (UnitType unitType2 : this.getSpecification().getUnitTypeList()) {
                if (!buildingType.canAdd(unitType2)) continue;
                if (count > 0 && count % 3 == 0) {
                    panel.add((Component)this.getButton(unitType2), "skip, span 2");
                } else {
                    panel.add((Component)this.getButton(unitType2), "span 2");
                }
                ++count;
            }
        } else {
            GoodsType inputType = buildingType.getConsumedGoodsType();
            GoodsType outputType = buildingType.getProducedGoodsType();
            if (outputType != null) {
                panel.add((Component)this.localizedLabel("colopedia.buildings.production"), "newline");
                if (inputType != null) {
                    panel.add((Component)this.getGoodsButton(inputType), "span, split 3");
                    JLabel arrow = new JLabel("\u2192");
                    arrow.setFont(arrowFont);
                    panel.add(arrow);
                }
                panel.add(this.getGoodsButton(outputType));
            }
        }
        int workplaces = buildingType.getWorkPlaces();
        panel.add((Component)this.localizedLabel("colopedia.buildings.workplaces"), "newline");
        panel.add((Component)new JLabel(Integer.toString(workplaces)), "span");
        if (workplaces > 0) {
            panel.add((Component)this.localizedLabel("colopedia.buildings.specialist"), "newline");
            UnitType unitType = this.getSpecification().getExpertForProducing(buildingType.getProducedGoodsType());
            if (unitType == null) {
                panel.add((Component)this.localizedLabel("none"), "span");
            } else {
                panel.add((Component)this.getUnitButton(unitType), "span");
            }
        }
        Set<Modifier> bonusList = buildingType.getFeatureContainer().getModifiers();
        ArrayList<JComponent> labels = new ArrayList<JComponent>();
        for (Modifier productionBonus : bonusList) {
            JComponent component = this.getModifierComponent(productionBonus);
            if (component instanceof JButton) {
                labels.add(0, component);
                continue;
            }
            labels.add(component);
        }
        Set<Ability> abilities = buildingType.getFeatureContainer().getAbilities();
        for (Ability ability : abilities) {
            JLabel jLabel = this.getAbilityComponent(ability);
            if (jLabel == null) continue;
            labels.add(jLabel);
        }
        if (!labels.isEmpty()) {
            panel.add((Component)this.localizedLabel(StringTemplate.template("colopedia.buildings.modifiers").addAmount("%number%", labels.size())), "newline, top");
            int count = 0;
            for (JComponent jComponent : labels) {
                if (count > 0 && count % 2 == 0) {
                    panel.add((Component)jComponent, "skip, span 3");
                } else {
                    panel.add((Component)jComponent, "span 3");
                }
                ++count;
            }
        }
        panel.add((Component)this.localizedLabel("colopedia.buildings.notes"), "newline 20, top");
        panel.add((Component)BuildingDetailPanel.getDefaultTextArea(Messages.message(buildingType.getDescriptionKey()), 20), "span, growx");
    }
}

