/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;

public final class OptionGroupUI
extends JPanel
implements OptionUpdater {
    private static final Logger logger = Logger.getLogger(OptionGroupUI.class.getName());
    public static final int H_GAP = 10;
    private final List<OptionUpdater> optionUpdaters = new ArrayList<OptionUpdater>();
    private final HashMap<String, OptionUI> optionUIs;
    private final JTabbedPane tb;
    private GUI gui;
    private FreeColClient freeColClient;

    public OptionGroupUI(FreeColClient freeColClient, GUI gui, OptionGroup option) {
        this(freeColClient, gui, option, true);
    }

    public OptionGroupUI(FreeColClient freeColClient, GUI gui, OptionGroup option, boolean editable) {
        super(new BorderLayout());
        this.gui = gui;
        this.freeColClient = freeColClient;
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new MigLayout("wrap 4", "[fill]related[fill]unrelated[fill]related[fill]"));
        northPanel.setOpaque(false);
        this.optionUIs = new HashMap();
        this.tb = new JTabbedPane(1);
        this.tb.setOpaque(false);
        Iterator<Option> it = option.iterator();
        while (it.hasNext()) {
            Option o = it.next();
            if (o instanceof OptionGroup) {
                OptionGroup group = (OptionGroup)o;
                JPanel groupPanel = new JPanel();
                groupPanel.setLayout((LayoutManager)new MigLayout("wrap 4", "[fill]related[fill]unrelated[fill]related[fill]"));
                groupPanel.setOpaque(true);
                this.addOptionGroupUI(group, groupPanel, editable);
                JScrollPane scroll = new JScrollPane(groupPanel, 20, 31);
                scroll.getVerticalScrollBar().setUnitIncrement(16);
                scroll.setBorder(BorderFactory.createEmptyBorder());
                groupPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
                this.tb.addTab(Messages.getName(group), null, scroll, Messages.getShortDescription(group));
                continue;
            }
            this.addOptionUI(o, northPanel, editable);
        }
        if (this.tb.getTabCount() > 0) {
            this.add((Component)this.tb, "Center");
        } else {
            this.add((Component)northPanel, "Center");
        }
        this.setOpaque(false);
    }

    private void addOptionGroupUI(OptionGroup group, JPanel panel, boolean editable) {
        Iterator<Option> iterator = group.iterator();
        while (iterator.hasNext()) {
            Option o = iterator.next();
            if (o instanceof OptionGroup) {
                OptionGroup subgroup = (OptionGroup)o;
                panel.add((Component)new JLabel(Messages.getName(subgroup)), "newline 20, span, split 2");
                panel.add((Component)new JSeparator(), "growx");
                this.addOptionGroupUI(subgroup, panel, editable);
                continue;
            }
            this.addOptionUI(o, panel, editable);
        }
    }

    private void addOptionUI(Option option, JPanel panel, boolean editable) {
        OptionUI ui = OptionUI.getOptionUI(this.freeColClient, this.gui, option, editable);
        if (ui == null) {
            logger.warning("Unknown option type: " + ((Object)option).toString());
        } else if (ui instanceof FreeColActionUI) {
            ((FreeColActionUI)ui).setOptionGroupUI(this);
        }
        JLabel label = ui.getLabel();
        if (label == null) {
            panel.add((Component)ui.getComponent(), "newline, span");
        } else {
            if (label.getText().length() > 30) {
                panel.add((Component)label, "newline, span 3");
            } else {
                panel.add(label);
            }
            panel.add(ui.getComponent());
        }
        if (editable) {
            this.optionUpdaters.add(ui);
        }
        if (!option.getId().equals("NO_ID")) {
            this.optionUIs.put(option.getId(), ui);
        }
    }

    public void updateOption() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.updateOption();
        }
    }

    public OptionUI getOptionUI(String key) {
        return this.optionUIs.get(key);
    }

    public void removeKeyStroke(KeyStroke keyStroke) {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            if (!(optionUpdater instanceof FreeColActionUI)) continue;
            ((FreeColActionUI)optionUpdater).removeKeyStroke(keyStroke);
        }
    }

    public void reset() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.reset();
        }
    }

    public String getUIClassID() {
        return "ReportPanelUI";
    }
}

