/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class DebugMenu
extends JMenu {
    private FreeColClient freeColClient;
    private GUI gui;
    private static final String ERROR_MESSAGE = "This is a long error message, indicating that some error has occurred. This is a long error message, indicating that some error has occurred. This is a long error message, indicating that some error has occurred.";

    public DebugMenu(FreeColClient fcc, GUI gui) {
        super(Messages.message("menuBar.debug"));
        this.freeColClient = fcc;
        this.gui = gui;
        this.buildDebugMenu();
    }

    private void buildDebugMenu() {
        final Game game = this.freeColClient.getGame();
        final FreeColServer server = this.freeColClient.getFreeColServer();
        final ServerGame serverGame = server == null ? null : server.getGame();
        final Player player = this.freeColClient.getMyPlayer();
        final Player serverPlayer = server == null ? null : (Player)serverGame.getFreeColGameObject(player.getId());
        this.setOpaque(false);
        this.setMnemonic(68);
        this.add(this);
        JCheckBoxMenuItem sc = new JCheckBoxMenuItem(Messages.message("menuBar.debug.showCoordinates"), this.gui.getMapViewer().displayCoordinates);
        sc.setOpaque(false);
        sc.setMnemonic(83);
        this.add(sc);
        sc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.getMapViewer().displayCoordinates = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                DebugMenu.this.gui.refresh();
            }
        });
        sc.setEnabled(true);
        final JCheckBoxMenuItem reveal = new JCheckBoxMenuItem(Messages.message("menuBar.debug.revealEntireMap"));
        reveal.setOpaque(false);
        reveal.setMnemonic(82);
        this.add(reveal);
        reveal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                server.revealMapForAllPlayers();
                reveal.setEnabled(false);
                game.getSpecification().getBooleanOption("model.option.fogOfWar").setValue(false);
            }
        });
        reveal.setEnabled(server != null);
        JMenu cvpMenu = new JMenu(Messages.message("menuBar.debug.showColonyValue"));
        cvpMenu.setOpaque(false);
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem cv1 = new JRadioButtonMenuItem("Do not display", !this.gui.getMapViewer().displayColonyValue);
        cv1.setOpaque(false);
        cv1.setMnemonic(67);
        cvpMenu.add(cv1);
        bg.add(cv1);
        cv1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.getMapViewer().displayColonyValue = false;
                ((DebugMenu)DebugMenu.this).gui.getMapViewer().displayColonyValuePlayer = null;
                DebugMenu.this.gui.refresh();
            }
        });
        this.add(cvpMenu);
        JRadioButtonMenuItem cv3 = new JRadioButtonMenuItem(Messages.message("menuBar.debug.showCommonOutpostValue"), this.gui.getMapViewer().displayColonyValue && this.gui.getMapViewer().displayColonyValuePlayer == null);
        cv3.setOpaque(false);
        cvpMenu.add(cv3);
        bg.add(cv3);
        cv3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.getMapViewer().displayColonyValue = true;
                ((DebugMenu)DebugMenu.this).gui.getMapViewer().displayColonyValuePlayer = null;
                DebugMenu.this.gui.refresh();
            }
        });
        this.add(cvpMenu);
        cvpMenu.addSeparator();
        Iterator<Player> it = game.getPlayerIterator();
        while (it.hasNext()) {
            final Player p = it.next();
            if (!p.isEuropean() || !p.canBuildColonies()) continue;
            JRadioButtonMenuItem cv2 = new JRadioButtonMenuItem(Messages.message(p.getNationName()), this.gui.getMapViewer().displayColonyValue && this.gui.getMapViewer().displayColonyValuePlayer == p);
            cv2.setOpaque(false);
            cvpMenu.add(cv2);
            bg.add(cv2);
            cv2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((DebugMenu)DebugMenu.this).gui.getMapViewer().displayColonyValue = true;
                    ((DebugMenu)DebugMenu.this).gui.getMapViewer().displayColonyValuePlayer = p;
                    DebugMenu.this.gui.refresh();
                }
            });
        }
        this.addSeparator();
        final JMenuItem skipTurns = new JMenuItem(Messages.message("menuBar.debug.skipTurns"));
        skipTurns.setOpaque(false);
        skipTurns.setMnemonic(84);
        this.add(skipTurns);
        skipTurns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int skip;
                boolean isSkipping;
                InGameController igc = server.getInGameController();
                boolean bl = isSkipping = igc.getSkippedTurns() > 0;
                if (isSkipping) {
                    igc.setSkippedTurns(0);
                    return;
                }
                String response = DebugMenu.this.gui.showInputDialog(null, StringTemplate.key("menuBar.debug.skipTurns"), Integer.toString(10), "ok", "cancel", true);
                if (response == null) {
                    return;
                }
                try {
                    skip = Integer.parseInt(response);
                }
                catch (NumberFormatException nfe) {
                    skip = -1;
                }
                if (skip > 0) {
                    DebugMenu.this.freeColClient.skipTurns(skip);
                }
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean skipping = server.getInGameController().getSkippedTurns() > 0;
                skipTurns.setText(Messages.message(skipping ? "menuBar.debug.stopSkippingTurns" : "menuBar.debug.skipTurns"));
            }
        });
        skipTurns.setEnabled(server != null);
        final String buildingTitle = Messages.message("menuBar.debug.addBuilding");
        JMenuItem addBuilding = new JMenuItem(buildingTitle);
        addBuilding.setOpaque(false);
        addBuilding.setMnemonic(66);
        this.add(addBuilding);
        addBuilding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.addBuildingAction(game, server, serverPlayer, buildingTitle);
            }
        });
        addBuilding.setEnabled(server != null);
        final String fatherTitle = Messages.message("menuBar.debug.addFoundingFather");
        JMenuItem addFather = new JMenuItem(fatherTitle);
        addFather.setOpaque(false);
        addFather.setMnemonic(70);
        this.add(addFather);
        addFather.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.addFatherAction(game, server, serverPlayer, fatherTitle);
            }
        });
        addFather.setEnabled(server != null);
        final String monarchTitle = Messages.message("menuBar.debug.runMonarch");
        JMenuItem runMonarch = new JMenuItem(monarchTitle);
        runMonarch.setOpaque(false);
        runMonarch.setMnemonic(77);
        this.add(runMonarch);
        runMonarch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArrayList<ChoiceItem<Monarch.MonarchAction>> actions = new ArrayList<ChoiceItem<Monarch.MonarchAction>>();
                for (Monarch.MonarchAction action : Monarch.MonarchAction.values()) {
                    actions.add(new ChoiceItem<Monarch.MonarchAction>(action));
                }
                Monarch.MonarchAction action = DebugMenu.this.gui.showChoiceMonarchActionDialog(monarchTitle, actions);
                server.getInGameController().setMonarchAction(serverPlayer, action);
            }
        });
        runMonarch.setEnabled(server != null);
        JMenuItem addGold = new JMenuItem(Messages.message("menuBar.debug.addGold"));
        addGold.setOpaque(false);
        addGold.setMnemonic(71);
        this.add(addGold);
        addGold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int gold;
                String response = DebugMenu.this.gui.showInputDialog(null, StringTemplate.key("menuBar.debug.addGold"), Integer.toString(1000), "ok", "cancel", true);
                try {
                    gold = Integer.parseInt(response);
                }
                catch (NumberFormatException x) {
                    return;
                }
                player.modifyGold(gold);
                serverPlayer.modifyGold(gold);
            }
        });
        addGold.setEnabled(server != null);
        String immigrationTitle = Messages.message("menuBar.debug.addImmigration");
        JMenuItem addCrosses = new JMenuItem(immigrationTitle);
        addCrosses.setOpaque(false);
        addCrosses.setMnemonic(73);
        this.add(addCrosses);
        addCrosses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int crosses;
                String response = DebugMenu.this.gui.showInputDialog(null, StringTemplate.key("menuBar.debug.addImmigration"), Integer.toString(100), "ok", "cancel", true);
                try {
                    crosses = Integer.parseInt(response);
                }
                catch (NumberFormatException x) {
                    return;
                }
                player.incrementImmigration(crosses);
                serverPlayer.incrementImmigration(crosses);
            }
        });
        addCrosses.setEnabled(server != null);
        JMenuItem giveBells = new JMenuItem(Messages.message("menuBar.debug.addLiberty"));
        giveBells.setOpaque(false);
        giveBells.setMnemonic(76);
        this.add(giveBells);
        giveBells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int liberty;
                String response = DebugMenu.this.gui.showInputDialog(null, StringTemplate.key("menuBar.debug.addLiberty"), Integer.toString(100), "ok", "cancel", true);
                try {
                    liberty = Integer.parseInt(response);
                }
                catch (NumberFormatException x) {
                    return;
                }
                for (Colony c : player.getColonies()) {
                    c.addLiberty(liberty);
                    ((Colony)serverGame.getFreeColGameObject(c.getId())).addLiberty(liberty);
                }
            }
        });
        giveBells.setEnabled(server != null);
        JMenuItem rng = new JMenuItem(Messages.message("menuBar.debug.stepRandomNumberGenerator"));
        rng.setOpaque(false);
        rng.setMnemonic(88);
        this.add(rng);
        rng.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InGameController igc = server.getInGameController();
                boolean more = true;
                while (more) {
                    int val = igc.stepRandom();
                    more = DebugMenu.this.gui.showConfirmDialog(null, StringTemplate.template("menuBar.debug.randomValue").addAmount("%value%", val), "more", "ok");
                }
            }
        });
        rng.setEnabled(server != null);
        this.addSeparator();
        JMenu panelMenu = new JMenu(Messages.message("menuBar.debug.displayPanels"));
        panelMenu.setOpaque(false);
        JMenuItem monarchPanel = new JMenuItem(Messages.message("menuBar.debug.displayMonarchPanel"));
        monarchPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.gui.showMonarchPanelDialog(Monarch.MonarchAction.RAISE_TAX_WAR, null);
            }
        });
        panelMenu.add(monarchPanel);
        JMenuItem victoryPanel = new JMenuItem(Messages.message("menuBar.debug.displayVictoryPanel"));
        victoryPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.gui.showVictoryPanel();
            }
        });
        panelMenu.add(victoryPanel);
        for (final Canvas.EventType eventType : Canvas.EventType.values()) {
            JMenuItem mItem = new JMenuItem("Display " + (Object)((Object)eventType) + " panel");
            mItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DebugMenu.this.gui.showEventPanel(eventType);
                }
            });
            panelMenu.add(mItem);
        }
        JMenuItem errorMessage = new JMenuItem(Messages.message("menuBar.debug.displayErrorMessage"));
        errorMessage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.gui.errorMessage(DebugMenu.ERROR_MESSAGE);
            }
        });
        panelMenu.add(errorMessage);
        this.add(panelMenu);
        JMenuItem europeStatus = new JMenuItem(Messages.message("menuBar.debug.displayEuropeStatus"));
        europeStatus.setOpaque(false);
        europeStatus.setMnemonic(69);
        this.add(europeStatus);
        europeStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.displayEuropeAction(serverGame, server.getAIMain());
            }
        });
        europeStatus.setEnabled(server != null);
        JCheckBoxMenuItem dam = new JCheckBoxMenuItem("Display AI-missions", this.gui.getMapViewer().debugShowMission);
        final JCheckBoxMenuItem dami = new JCheckBoxMenuItem("Additional AI-mission info", this.gui.getMapViewer().debugShowMissionInfo);
        dam.setOpaque(false);
        dam.setMnemonic(65);
        this.add(dam);
        dam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.getMapViewer().debugShowMission = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                dami.setEnabled(((DebugMenu)DebugMenu.this).gui.getMapViewer().debugShowMission);
                DebugMenu.this.gui.refresh();
            }
        });
        dam.setEnabled(true);
        JMenuItem useAI = new JMenuItem(Messages.message("menuBar.debug.useAI"));
        useAI.setOpaque(false);
        useAI.setMnemonic(65);
        useAI.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(useAI);
        useAI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AIMain aiMain = server.getAIMain();
                AIPlayer ap = aiMain.getAIPlayer(player);
                ap.setDebuggingConnection(DebugMenu.this.freeColClient.getClient().getConnection());
                ap.startWorking();
                DebugMenu.this.freeColClient.getConnectController().reconnect();
            }
        });
        useAI.setEnabled(server != null);
        dami.setOpaque(false);
        dami.setMnemonic(73);
        this.add(dami);
        dami.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.getMapViewer().debugShowMissionInfo = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                DebugMenu.this.gui.refresh();
            }
        });
        dami.setEnabled(this.gui.getMapViewer().debugShowMission);
        this.addSeparator();
        JMenuItem compareMaps = new JMenuItem(Messages.message("menuBar.debug.compareMaps"));
        compareMaps.setOpaque(false);
        compareMaps.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(compareMaps);
        compareMaps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.checkDesyncAction(serverGame, serverPlayer);
            }
        });
        compareMaps.setEnabled(server != null);
        JMenuItem showResourceKeys = new JMenuItem(Messages.message("menuBar.debug.showResourceKeys"));
        showResourceKeys.setOpaque(false);
        this.add(showResourceKeys);
        showResourceKeys.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                java.util.Map<String, Resource> resources = ResourceManager.getResources();
                ArrayList<String> keys = new ArrayList<String>(resources.keySet());
                Collections.sort(keys);
                StringBuilder builder = new StringBuilder();
                for (String key : keys) {
                    builder.append(key);
                    Resource resource = resources.get(key);
                    if (resource instanceof ImageResource) {
                        ImageResource ir = (ImageResource)resource;
                        builder.append(" (");
                        builder.append(ir.getCount());
                        builder.append(")");
                    }
                    builder.append("\n");
                }
                DebugMenu.this.gui.showInformationMessage(builder.toString());
            }
        });
        showResourceKeys.setEnabled(true);
        JMenuItem statistics = new JMenuItem(Messages.message("menuBar.debug.statistics"));
        statistics.setOpaque(false);
        this.add(statistics);
        statistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.gui.showStatisticsPanel();
            }
        });
        statistics.setEnabled(true);
        JMenuItem gc = new JMenuItem(Messages.message("menuBar.debug.memoryManager.gc"));
        gc.setOpaque(false);
        this.add(gc);
        gc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        gc.setEnabled(true);
        this.addSeparator();
    }

    private void addBuildingAction(Game game, FreeColServer server, Player serverPlayer, String buildingTitle) {
        ArrayList buildings = new ArrayList();
        for (BuildingType b : game.getSpecification().getBuildingTypeList()) {
            buildings.add(new ChoiceItem<BuildingType>(Messages.message(b.toString() + ".name"), b));
        }
        BuildingType buildingType = (BuildingType)this.gui.showChoiceDialog(null, buildingTitle, "Cancel", buildings);
        if (buildingType == null) {
            return;
        }
        ServerGame sGame = server.getGame();
        BuildingType sBuildingType = server.getSpecification().getBuildingType(buildingType.getId());
        ArrayList<String> results = new ArrayList<String>();
        int fails = 0;
        for (Colony sColony : serverPlayer.getColonies()) {
            Colony.NoBuildReason reason = sColony.getNoBuildReason(sBuildingType);
            results.add(sColony.getName() + ": " + reason.toString());
            if (reason == Colony.NoBuildReason.NONE) {
                ServerBuilding sBuilding = new ServerBuilding(sGame, sColony, sBuildingType);
                sColony.addBuilding(sBuilding);
                continue;
            }
            ++fails;
        }
        this.gui.showInformationMessage(Utils.join(", ", results));
        if (fails < serverPlayer.getNumberOfSettlements()) {
            this.freeColClient.getConnectController().reconnect();
        }
    }

    private void addFatherAction(Game game, FreeColServer server, Player serverPlayer, String fatherTitle) {
        ArrayList<ChoiceItem<FoundingFather>> fathers = new ArrayList<ChoiceItem<FoundingFather>>();
        for (FoundingFather father : game.getSpecification().getFoundingFathers()) {
            if (serverPlayer.hasFather(father)) continue;
            ChoiceItem<FoundingFather> choice = new ChoiceItem<FoundingFather>(Messages.message(father.getNameKey()), father);
            fathers.add(choice);
        }
        FoundingFather father = this.gui.showChooseFoundingFatherDialog(fathers, fatherTitle);
        if (father != null) {
            server.getInGameController().addFoundingFather((ServerPlayer)serverPlayer, server.getGame().getSpecification().getFoundingFather(father.getId()));
        }
    }

    private void checkDesyncAction(Game serverGame, Player serverPlayer) {
        Game game = this.freeColClient.getGame();
        boolean problemDetected = false;
        Map serverMap = serverGame.getMap();
        for (Tile t : serverMap.getAllTiles()) {
            if (!serverPlayer.canSee(t)) continue;
            Iterator<Unit> unitIterator = t.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit u = unitIterator.next();
                if (!u.isVisibleTo(serverPlayer)) continue;
                if (game.getFreeColGameObject(u.getId()) == null) {
                    System.out.println("Desynchronization detected: Unit missing on client-side");
                    System.out.println(Messages.message(Messages.getLabel(u)) + "(" + u.getId() + "). Position: " + u.getTile().getPosition());
                    try {
                        System.out.println("Possible unit on client-side: " + game.getMap().getTile(u.getTile().getPosition()).getFirstUnit().getId());
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    System.out.println();
                    problemDetected = true;
                    continue;
                }
                Unit clientSideUnit = (Unit)game.getFreeColGameObject(u.getId());
                if (clientSideUnit.getTile() == null || clientSideUnit.getTile().getId().equals(u.getTile().getId())) continue;
                System.out.println("Unsynchronization detected: Unit located on different tiles");
                System.out.println("Server: " + Messages.message(Messages.getLabel(u)) + "(" + u.getId() + "). Position: " + u.getTile().getPosition());
                System.out.println("Client: " + Messages.message(Messages.getLabel(clientSideUnit)) + "(" + clientSideUnit.getId() + "). Position: " + clientSideUnit.getTile().getPosition());
                System.out.println();
                problemDetected = true;
            }
        }
        this.gui.showInformationMessage(problemDetected ? "menuBar.debug.compareMaps.problem" : "menuBar.debug.compareMaps.checkComplete");
    }

    private void displayEuropeAction(Game serverGame, AIMain aiMain) {
        StringBuilder sb = new StringBuilder();
        for (Player tp : serverGame.getPlayers()) {
            Player p = (Player)serverGame.getFreeColGameObject(tp.getId());
            if (p.getEurope() == null) continue;
            ArrayList<Unit> inEurope = new ArrayList<Unit>();
            ArrayList<Unit> toEurope = new ArrayList<Unit>();
            ArrayList<Unit> toAmerica = new ArrayList<Unit>();
            LinkedHashMap<String, ArrayList<Unit>> units = new LinkedHashMap<String, ArrayList<Unit>>();
            units.put("To Europe", toEurope);
            units.put("In Europe", inEurope);
            units.put("To America", toAmerica);
            sb.append("\n==");
            sb.append(Messages.message(p.getNationName()));
            sb.append("==\n");
            for (Unit u : p.getEurope().getUnitList()) {
                if (u.getDestination() instanceof Map) {
                    toAmerica.add(u);
                    continue;
                }
                if (u.getDestination() instanceof Europe) {
                    toEurope.add(u);
                    continue;
                }
                inEurope.add(u);
            }
            for (String label : units.keySet()) {
                List list = (List)units.get(label);
                if (list.size() <= 0) continue;
                sb.append("\n->" + label + "\n");
                for (Unit u : list) {
                    sb.append('\n');
                    sb.append(Messages.message(Messages.getLabel(u)));
                    if (u.isUnderRepair()) {
                        sb.append(" (Repairing)");
                        continue;
                    }
                    sb.append("    ");
                    AIUnit aiu = aiMain.getAIUnit(u);
                    if (aiu.getMission() == null) {
                        sb.append(" (None)");
                        continue;
                    }
                    sb.append(aiu.getMission().toString().replaceAll("\n", "    \n"));
                }
                sb.append('\n');
            }
        }
        this.gui.showInformationMessage(sb.toString());
    }
}

