/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.client.gui.animation.UnitImageAnimation;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

final class UnitAttackAnimation {
    private final Unit attacker;
    private final Unit defender;
    private final boolean success;
    private GUI gui;
    private FreeColClient freeColClient;

    public UnitAttackAnimation(FreeColClient freeColClient, GUI gui, Unit attacker, Unit defender, boolean success) {
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.attacker = attacker;
        this.defender = defender;
        this.success = success;
    }

    private SimpleZippedAnimation getAnimation(Unit unit, Map.Direction direction) {
        float scale = this.gui.getMapScale();
        String roleStr = unit.getRole() == Unit.Role.DEFAULT ? "" : "." + unit.getRole().getId();
        String startStr = unit.getType().getId() + roleStr + ".attack.";
        String specialId = startStr + direction.toString().toLowerCase() + ".animation";
        SimpleZippedAnimation sza = ResourceManager.getSimpleZippedAnimation(specialId, scale);
        if (sza == null) {
            String genericDirection;
            switch (direction) {
                case SW: 
                case W: 
                case NW: {
                    genericDirection = "w";
                    break;
                }
                default: {
                    genericDirection = "e";
                }
            }
            String genericId = startStr + genericDirection + ".animation";
            sza = ResourceManager.getSimpleZippedAnimation(genericId, scale);
        }
        return sza;
    }

    public void animate() {
        SimpleZippedAnimation sza;
        Map.Direction direction = this.attacker.getTile().getDirection(this.defender.getTile());
        if (Animations.getAnimationSpeed(this.freeColClient, this.attacker) > 0 && (sza = this.getAnimation(this.attacker, direction)) != null) {
            new UnitImageAnimation(this.gui, this.attacker, sza).animate();
        }
        if (!this.success && Animations.getAnimationSpeed(this.freeColClient, this.defender) > 0 && (sza = this.getAnimation(this.defender, direction = direction.getReverseDirection())) != null) {
            new UnitImageAnimation(this.gui, this.defender, sza).animate();
        }
    }
}

