/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.server.generator.TerrainGenerator;

public class DetermineHighSeasAction
extends FreeColAction {
    public static final String id = "determineHighSeasAction";

    DetermineHighSeasAction(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, id);
    }

    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && this.freeColClient.isMapEditor() && this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null;
    }

    public void actionPerformed(ActionEvent e) {
        Game game = this.freeColClient.getGame();
        Map map = game.getMap();
        Parameters p = this.showParametersDialog();
        if (p != null) {
            TerrainGenerator.determineHighSeas(map, p.distToLandFromHighSeas, p.maxDistanceToEdge);
        }
    }

    private Parameters showParametersDialog() {
        int COLUMNS = 5;
        int DEFAULT_distToLandFromHighSeas = 4;
        int DEFAULT_maxDistanceToEdge = 12;
        final JTextField inputD = new JTextField(Integer.toString(4), 5);
        final JTextField inputM = new JTextField(Integer.toString(12), 5);
        final FreeColDialog<Parameters> inputDialog = new FreeColDialog<Parameters>(this.freeColClient, this.gui){

            @Override
            public void requestFocus() {
                inputD.requestFocus();
            }
        };
        inputDialog.setLayout(new BoxLayout(inputDialog, 1));
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int d = Integer.parseInt(inputD.getText());
                    int m = Integer.parseInt(inputM.getText());
                    if (d <= 0 || m <= 0) {
                        throw new NumberFormatException();
                    }
                    inputDialog.setResponse(new Parameters(d, m));
                }
                catch (NumberFormatException nfe) {
                    DetermineHighSeasAction.this.gui.errorMessage("integerAboveZero");
                }
            }
        };
        JButton okButton = new JButton(Messages.message("ok"));
        buttons.add(okButton);
        JButton cancelButton = new JButton(Messages.message("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inputDialog.setResponse(null);
            }
        });
        buttons.add(cancelButton);
        inputDialog.setCancelComponent(cancelButton);
        okButton.addActionListener(al);
        inputD.addActionListener(al);
        inputM.addActionListener(al);
        JLabel widthLabel = new JLabel(Messages.message("menuBar.tools.determineHighSeas.distToLandFromHighSeas"));
        widthLabel.setLabelFor(inputD);
        JLabel heightLabel = new JLabel(Messages.message("menuBar.tools.determineHighSeas.maxDistanceToEdge"));
        heightLabel.setLabelFor(inputM);
        JPanel widthPanel = new JPanel(new FlowLayout());
        widthPanel.setOpaque(false);
        widthPanel.add(widthLabel);
        widthPanel.add(inputD);
        JPanel heightPanel = new JPanel(new FlowLayout());
        heightPanel.setOpaque(false);
        heightPanel.add(heightLabel);
        heightPanel.add(inputM);
        inputDialog.add(widthPanel);
        inputDialog.add(heightPanel);
        inputDialog.add(buttons);
        inputDialog.setSize(inputDialog.getPreferredSize());
        return this.gui.getCanvas().showFreeColDialog(inputDialog);
    }

    private class Parameters {
        int distToLandFromHighSeas;
        int maxDistanceToEdge;

        Parameters(int distToLandFromHighSeas, int maxDistanceToEdge) {
            this.distToLandFromHighSeas = distToLandFromHighSeas;
            this.maxDistanceToEdge = maxDistanceToEdge;
        }
    }
}

