/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.client.gui.TerrainCursor;
import net.sf.freecol.client.gui.ViewMode;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.server.ai.AIUnit;

public final class MapViewer {
    private static final Logger logger = Logger.getLogger(MapViewer.class.getName());
    private final FreeColClient freeColClient;
    private Dimension size;
    private ImageLibrary lib;
    private TerrainCursor cursor;
    private ViewMode viewMode;
    private final Vector<GUIMessage> messages;
    private Tile selectedTile;
    private Tile focus = null;
    private Unit activeUnit;
    private PathNode currentPath;
    private PathNode gotoPath = null;
    private boolean gotoStarted = false;
    private int tileHeight;
    private int tileWidth;
    private int halfHeight;
    private int halfWidth;
    private int topSpace;
    private int topRows;
    private int bottomRows;
    private int leftSpace;
    private int rightSpace;
    private int bottomRow = -1;
    private int topRow;
    private int bottomRowY;
    private int topRowY;
    private int leftColumn;
    private int rightColumn;
    private int leftColumnX;
    private static final int UNIT_OFFSET = 20;
    private static final int STATE_OFFSET_X = 25;
    private static final int STATE_OFFSET_Y = 10;
    private static final int OTHER_UNITS_OFFSET_X = -5;
    private static final int OTHER_UNITS_OFFSET_Y = 1;
    private static final int OTHER_UNITS_WIDTH = 3;
    private static final int MAX_OTHER_UNITS = 10;
    private static final int MESSAGE_COUNT = 3;
    private static final int MESSAGE_AGE = 30000;
    public static final int OVERLAY_INDEX = 100;
    public static final int FOREST_INDEX = 200;
    private GeneralPath gridPath = null;
    private GeneralPath fog = new GeneralPath();
    public boolean displayCoordinates = false;
    public boolean displayColonyValue = false;
    public Player displayColonyValuePlayer = null;
    public boolean debugShowMission = false;
    public boolean debugShowMissionInfo = false;
    private volatile boolean blinkingMarqueeEnabled;
    private Image cursorImage;
    private GrayLayer greyLayer;
    private java.util.Map<Unit, Integer> unitsOutForAnimation;
    private java.util.Map<Unit, JLabel> unitsOutForAnimationLabels;
    private EnumMap<Map.Direction, Point2D.Float> corners = new EnumMap(Map.Direction.class);
    private EnumMap<Map.Direction, List<Map.Direction>> prohibitedRoads = new EnumMap(Map.Direction.class);
    private Stroke roadStroke = new BasicStroke(2.0f);
    private EnumMap<Map.Direction, Point2D.Float> borderPoints = new EnumMap(Map.Direction.class);
    private EnumMap<Map.Direction, Point2D.Float> controlPoints = new EnumMap(Map.Direction.class);
    private Stroke borderStroke = new BasicStroke(4.0f);
    private Stroke gridStroke = new BasicStroke(1.0f);
    private GUI gui;

    public MapViewer(FreeColClient freeColClient, GUI gui, Dimension size, ImageLibrary lib) {
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.size = size;
        this.setImageLibrary(lib);
        this.unitsOutForAnimation = new HashMap<Unit, Integer>();
        this.unitsOutForAnimationLabels = new HashMap<Unit, JLabel>();
        logger.info("GUI created.");
        this.messages = new Vector(3);
        this.viewMode = new ViewMode(this);
        logger.info("Starting in Move Units View Mode");
        this.blinkingMarqueeEnabled = true;
        this.cursor = new TerrainCursor();
    }

    public synchronized void addMessage(GUIMessage message) {
        if (this.getMessageCount() == 3) {
            this.messages.remove(0);
        }
        this.messages.add(message);
    }

    public void centerActiveUnit() {
        if (this.activeUnit != null && this.activeUnit.getTile() != null) {
            this.setFocus(this.activeUnit.getTile());
        }
    }

    public Tile convertToMapTile(int x, int y) {
        Game gameData = this.freeColClient.getGame();
        if (gameData == null || gameData.getMap() == null) {
            return null;
        }
        int leftOffset = this.focus.getX() < this.getLeftColumns() ? (this.focus.getY() % 2 == 0 ? this.tileWidth * this.focus.getX() + this.halfWidth : this.tileWidth * (this.focus.getX() + 1)) : (this.focus.getX() >= gameData.getMap().getWidth() - this.getRightColumns() ? (this.focus.getY() % 2 == 0 ? this.size.width - (gameData.getMap().getWidth() - this.focus.getX()) * this.tileWidth : this.size.width - (gameData.getMap().getWidth() - this.focus.getX() - 1) * this.tileWidth - this.halfWidth) : (this.focus.getY() % 2 == 0 ? this.size.width / 2 : this.size.width / 2 + this.halfWidth));
        int topOffset = this.focus.getY() < this.topRows ? (this.focus.getY() + 1) * this.halfHeight : (this.focus.getY() >= gameData.getMap().getHeight() - this.bottomRows ? this.size.height - (gameData.getMap().getHeight() - this.focus.getY()) * this.halfHeight : this.size.height / 2);
        int diffUp = (topOffset - y) / (this.tileHeight / 4);
        int diffLeft = (leftOffset - x) / (this.tileWidth / 4);
        int orDiffUp = diffUp;
        int orDiffLeft = diffLeft;
        int remainderUp = (topOffset - y) % (this.tileHeight / 4);
        int remainderLeft = (leftOffset - x) % (this.tileWidth / 4);
        diffUp = diffUp % 2 == 0 ? (diffUp /= 2) : (diffUp < 0 ? diffUp / 2 - 1 : diffUp / 2 + 1);
        diffLeft = diffLeft % 2 == 0 ? (diffLeft /= 2) : (diffLeft < 0 ? diffLeft / 2 - 1 : diffLeft / 2 + 1);
        boolean done = false;
        while (!done) {
            if (diffUp % 2 == 0) {
                if (diffLeft % 2 == 0) {
                    diffLeft /= 2;
                    done = true;
                    continue;
                }
                if (orDiffLeft % 2 == 0 && orDiffUp % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 > remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 > -remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0 && orDiffUp == 0) {
                        if (remainderUp > 0) {
                            if (remainderUp * 2 > remainderLeft) {
                                ++diffUp;
                                continue;
                            }
                            ++diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 > remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffUp == 0) {
                        if (remainderUp > 0) {
                            if (remainderUp * 2 > -remainderLeft) {
                                ++diffUp;
                                continue;
                            }
                            --diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 > -remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 > remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (-remainderUp * 2 > -remainderLeft) {
                        --diffUp;
                        continue;
                    }
                    --diffLeft;
                    continue;
                }
                if (orDiffLeft % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffLeft;
                            continue;
                        }
                        ++diffUp;
                        continue;
                    }
                    if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                        --diffLeft;
                        continue;
                    }
                    ++diffUp;
                    continue;
                }
                if (orDiffUp % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            ++diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0 && orDiffUp == 0) {
                        if (remainderUp > 0) {
                            if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                                ++diffUp;
                                continue;
                            }
                            --diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffUp == 0) {
                        if (remainderUp > 0) {
                            if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                                ++diffUp;
                                continue;
                            }
                            ++diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                        --diffUp;
                        continue;
                    }
                    ++diffLeft;
                    continue;
                }
                if (orDiffLeft > 0 && orDiffUp > 0) {
                    if (remainderUp * 2 > remainderLeft) {
                        --diffLeft;
                        continue;
                    }
                    --diffUp;
                    continue;
                }
                if (orDiffUp > 0) {
                    if (remainderUp * 2 > -remainderLeft) {
                        ++diffLeft;
                        continue;
                    }
                    --diffUp;
                    continue;
                }
                if (orDiffLeft > 0) {
                    if (-remainderUp * 2 > remainderLeft) {
                        --diffLeft;
                        continue;
                    }
                    ++diffUp;
                    continue;
                }
                if (-remainderUp * 2 > -remainderLeft) {
                    ++diffLeft;
                    continue;
                }
                ++diffUp;
                continue;
            }
            if (diffLeft % 2 == 0) {
                if (orDiffLeft % 2 == 0 && orDiffUp % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 > remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 > remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0 && orDiffLeft == 0) {
                        if (remainderLeft > 0) {
                            if (remainderUp * 2 > remainderLeft) {
                                ++diffUp;
                                continue;
                            }
                            ++diffLeft;
                            continue;
                        }
                        if (remainderUp * 2 > -remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffLeft == 0) {
                        if (remainderLeft > 0) {
                            if (-remainderUp * 2 > remainderLeft) {
                                --diffUp;
                                continue;
                            }
                            ++diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 > -remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 > -remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (-remainderUp * 2 > -remainderLeft) {
                        --diffUp;
                        continue;
                    }
                    --diffLeft;
                    continue;
                }
                if (orDiffLeft % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffLeft;
                            continue;
                        }
                        ++diffUp;
                        continue;
                    }
                    if (orDiffUp > 0 && orDiffLeft == 0) {
                        if (remainderLeft > 0) {
                            if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                                ++diffLeft;
                                continue;
                            }
                            --diffUp;
                            continue;
                        }
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (orDiffLeft == 0) {
                        if (remainderLeft > 0) {
                            if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                                ++diffLeft;
                                continue;
                            }
                            ++diffUp;
                            continue;
                        }
                        if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffLeft;
                            continue;
                        }
                        ++diffUp;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                        --diffLeft;
                        continue;
                    }
                    ++diffUp;
                    continue;
                }
                if (orDiffUp % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            ++diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                        --diffUp;
                        continue;
                    }
                    ++diffLeft;
                    continue;
                }
                if (orDiffLeft > 0 && orDiffUp > 0) {
                    if (remainderUp * 2 > remainderLeft) {
                        --diffLeft;
                        continue;
                    }
                    --diffUp;
                    continue;
                }
                if (orDiffUp > 0) {
                    if (remainderUp * 2 > -remainderLeft) {
                        ++diffLeft;
                        continue;
                    }
                    --diffUp;
                    continue;
                }
                if (orDiffLeft > 0) {
                    if (-remainderUp * 2 > remainderLeft) {
                        --diffLeft;
                        continue;
                    }
                    ++diffUp;
                    continue;
                }
                if (-remainderUp * 2 > -remainderLeft) {
                    ++diffLeft;
                    continue;
                }
                ++diffUp;
                continue;
            }
            diffLeft = this.focus.getY() % 2 == 0 ? (diffLeft < 0 ? (diffLeft /= 2) : diffLeft / 2 + 1) : (diffLeft < 0 ? diffLeft / 2 - 1 : (diffLeft /= 2));
            done = true;
        }
        Map.Position position = new Map.Position(this.focus.getX() - diffLeft, this.focus.getY() - diffUp);
        if (!this.freeColClient.getGame().getMap().isValid(position)) {
            return null;
        }
        return this.freeColClient.getGame().getMap().getTile(position);
    }

    public Image createStringImage(Graphics g, String nameString, Color color, Font font) {
        String key;
        Image image;
        if (color == null) {
            logger.warning("createStringImage called with color null");
            color = Color.WHITE;
        }
        if ((image = ResourceManager.getImage(key = "dynamic.stringImage." + nameString + "." + font.getFontName().replace(' ', '-') + "." + Integer.toString(font.getSize()) + "." + Integer.toHexString(color.getRGB()))) != null) {
            return image;
        }
        FontMetrics fontMetrics = g.getFontMetrics(font);
        BufferedImage bi = new BufferedImage(fontMetrics.stringWidth(nameString) + 4, fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent(), 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(color);
        big.setFont(font);
        big.drawString(nameString, 2, fontMetrics.getMaxAscent());
        int textColor = color.getRGB();
        int borderColor = this.getStringBorderColor(color).getRGB();
        for (int biX = 0; biX < bi.getWidth(); ++biX) {
            for (int biY = 0; biY < bi.getHeight(); ++biY) {
                int r = bi.getRGB(biX, biY);
                if (r == textColor) continue;
                for (int cX = -1; cX <= 1; ++cX) {
                    for (int cY = -1; cY <= 1; ++cY) {
                        if (biX + cX < 0 || biY + cY < 0 || biX + cX >= bi.getWidth() || biY + cY >= bi.getHeight() || bi.getRGB(biX + cX, biY + cY) != textColor) continue;
                        bi.setRGB(biX, biY, borderColor);
                    }
                }
            }
        }
        ResourceManager.addGameMapping(key, new ImageResource(bi));
        return ResourceManager.getImage(key);
    }

    public void display(Graphics2D g) {
        if (this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null && this.focus != null && this.freeColClient.isInGame()) {
            this.removeOldMessages();
            this.displayMap(g);
        } else if (this.freeColClient.isMapEditor()) {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.size.width, this.size.height);
        } else {
            Image bgImage = ResourceManager.getImage("CanvasBackgroundImage", this.size);
            if (bgImage != null) {
                g.drawImage(bgImage, 0, 0, this.gui.getCanvas());
                String versionStr = "v. " + FreeCol.getVersion();
                Font oldFont = g.getFont();
                Color oldColor = g.getColor();
                Font newFont = oldFont.deriveFont(1);
                TextLayout layout = new TextLayout(versionStr, newFont, g.getFontRenderContext());
                Rectangle2D bounds = layout.getBounds();
                float x = (float)this.getWidth() - (float)bounds.getWidth() - 5.0f;
                float y = (float)this.getHeight() - (float)bounds.getHeight();
                g.setColor(Color.white);
                layout.draw(g, x, y);
                g.setFont(oldFont);
                g.setColor(oldColor);
            } else {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.size.width, this.size.height);
            }
        }
    }

    public void displayColonyTile(Graphics2D g, Tile tile, Colony colony) {
        Object image;
        boolean tileCannotBeWorked = false;
        Unit occupyingUnit = null;
        int price = 0;
        if (colony != null) {
            ColonyTile colonyTile = colony.getColonyTile(tile);
            occupyingUnit = colonyTile.getOccupyingUnit();
            price = colony.getOwner().getLandPrice(tile);
            switch (colonyTile.getNoWorkReason()) {
                case NONE: 
                case COLONY_CENTER: 
                case CLAIM_REQUIRED: {
                    break;
                }
                default: {
                    tileCannotBeWorked = true;
                }
            }
        }
        this.displayBaseTile(g, tile, false);
        this.displayTileOverlays(g, tile, false, false);
        if (tileCannotBeWorked) {
            g.drawImage(this.lib.getMiscImage("tileTaken.image"), 0, 0, null);
        }
        if (price > 0 && tile.getSettlement() == null) {
            image = this.lib.getMiscImage("nativeLand.image");
            this.centerImage(g, (Image)image);
        }
        if (occupyingUnit != null) {
            image = this.lib.getUnitImageIcon(occupyingUnit, 0.5);
            g.drawImage(((ImageIcon)image).getImage(), this.tileWidth / 4 - ((ImageIcon)image).getIconWidth() / 2, this.halfHeight - ((ImageIcon)image).getIconHeight() / 2, null);
            g.drawImage(this.getOccupationIndicatorImage(g, occupyingUnit), (int)(25.0f * this.lib.getScalingFactor()), 0, null);
        }
    }

    public void displayTerrain(Graphics2D g, Tile tile) {
        this.displayBaseTile(g, tile, true);
        this.displayTileItems(g, tile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithUnitOutForAnimation(Unit unit, Tile sourceTile, OutForAnimationCallback r) {
        JLabel unitLabel = this.enterUnitOutForAnimation(unit, sourceTile);
        try {
            r.executeWithUnitOutForAnimation(unitLabel);
        }
        finally {
            this.releaseUnitOutForAnimation(unit);
        }
    }

    public void forceReposition() {
        this.bottomRow = -1;
    }

    public Unit getActiveUnit() {
        return this.activeUnit;
    }

    public TerrainCursor getCursor() {
        return this.cursor;
    }

    public Tile getFocus() {
        if (this.focus == null) {
            return null;
        }
        return this.focus;
    }

    public PathNode getGotoPath() {
        return this.gotoPath;
    }

    public int getHeight() {
        return this.size.height;
    }

    public float getMapScale() {
        return this.lib.getScalingFactor();
    }

    public Image getOccupationIndicatorImage(Graphics g, Unit unit) {
        String occupationString;
        Color backgroundColor = this.lib.getColor(unit.getOwner());
        Color foregroundColor = this.getForegroundColor(backgroundColor);
        if (!this.freeColClient.getMyPlayer().owns(unit)) {
            occupationString = unit.isNaval() ? Integer.toString(unit.getVisibleGoodsCount()) : Messages.message("model.unit.occupation.activeNoMovesLeft");
        } else {
            occupationString = unit.isUnderRepair() ? "model.unit.occupation.underRepair" : (unit.getTradeRoute() != null ? "model.unit.occupation.inTradeRoute" : (unit.getDestination() != null ? "model.unit.occupation.goingSomewhere" : (unit.getState() == Unit.UnitState.IMPROVING && unit.getWorkImprovement() != null ? unit.getWorkImprovement().getType().getId() + ".occupationString" : (unit.getState() == Unit.UnitState.ACTIVE && unit.getMovesLeft() == 0 ? "model.unit.occupation.activeNoMovesLeft" : "model.unit.occupation." + unit.getState().toString().toLowerCase(Locale.US)))));
            occupationString = Messages.message(occupationString);
            if (unit.getState() == Unit.UnitState.FORTIFIED) {
                foregroundColor = Color.GRAY;
            }
        }
        String key = "dynamic.occupationIndicator." + occupationString + "." + Integer.toHexString(backgroundColor.getRGB());
        Image img = ResourceManager.getImage(key, this.lib.getScalingFactor());
        if (img == null) {
            img = this.lib.createChip(occupationString, Color.BLACK, backgroundColor, foregroundColor);
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    public Tile getSelectedTile() {
        return this.selectedTile;
    }

    public Rectangle getTileBounds(Tile tile) {
        Rectangle result = new Rectangle(0, 0, this.size.width, this.size.height);
        if (this.isTileVisible(tile)) {
            result.x = (tile.getX() - this.leftColumn) * this.tileWidth + this.leftColumnX;
            result.y = (tile.getY() - this.topRow) * this.halfHeight + this.topRowY - this.tileHeight;
            if (tile.getY() % 2 != 0) {
                result.x += this.halfWidth;
            }
            result.width = this.tileWidth;
            result.height = this.tileHeight * 2;
        }
        return result;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public Point getTilePosition(Tile t) {
        this.repositionMapIfNeeded();
        if (this.isTileVisible(t)) {
            int x = (t.getX() - this.leftColumn) * this.tileWidth + this.leftColumnX;
            int y = (t.getY() - this.topRow) * this.halfHeight + this.topRowY;
            if (t.getY() % 2 != 0) {
                x += this.halfWidth;
            }
            return new Point(x, y);
        }
        return null;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public Point getUnitLabelPositionInTile(JLabel unitLabel, Point tileP) {
        if (tileP != null) {
            int labelX = tileP.x + this.getTileWidth() / 2 - unitLabel.getWidth() / 2;
            int labelY = tileP.y + this.getTileHeight() / 2 - unitLabel.getHeight() / 2 - (int)(20.0f * this.lib.getScalingFactor());
            return new Point(labelX, labelY);
        }
        return null;
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public int getWidth() {
        return this.size.width;
    }

    public boolean isGotoStarted() {
        return this.gotoStarted;
    }

    public boolean isMapNearBottom(int y) {
        return y >= this.freeColClient.getGame().getMap().getHeight() - this.bottomRows;
    }

    public boolean isMapNearLeft(int x, int y) {
        return x < this.getLeftColumns(y);
    }

    public boolean isMapNearRight(int x, int y) {
        return x >= this.freeColClient.getGame().getMap().getWidth() - this.getRightColumns(y);
    }

    public boolean isMapNearTop(int y) {
        return y < this.topRows;
    }

    public void moveTileCursor(Map.Direction direction) {
        if (this.selectedTile != null) {
            Tile newTile = this.selectedTile.getNeighbourOrNull(direction);
            if (newTile != null) {
                this.setSelectedTile(newTile, false);
            }
        } else {
            logger.warning("selectedTile is null");
        }
    }

    public boolean onScreen(Tile tileToCheck) {
        this.repositionMapIfNeeded();
        return tileToCheck.getY() - 2 > this.topRow && tileToCheck.getY() + 4 < this.bottomRow && tileToCheck.getX() - 1 > this.leftColumn && tileToCheck.getX() + 2 < this.rightColumn;
    }

    public void restartBlinking() {
        this.blinkingMarqueeEnabled = true;
    }

    public boolean setActiveUnit(Unit activeUnit) {
        boolean ret = false;
        if (activeUnit != null && !this.freeColClient.getMyPlayer().owns(activeUnit)) {
            this.gui.getCanvas().repaint(0, 0, this.getWidth(), this.getHeight());
            return ret;
        }
        if (activeUnit != null && activeUnit.getTile() == null) {
            activeUnit = null;
        }
        this.activeUnit = activeUnit;
        if (activeUnit != null) {
            if (this.freeColClient.currentPlayerIsMyPlayer()) {
                if (activeUnit.getState() != Unit.UnitState.ACTIVE) {
                    this.freeColClient.getInGameController().clearOrders(activeUnit);
                }
            } else {
                this.freeColClient.getInGameController().clearGotoOrders(activeUnit);
            }
        }
        this.updateGotoPathForActiveUnit();
        if (this.viewMode.getView() == 1 && activeUnit != null) {
            this.viewMode.changeViewMode(0);
        }
        if (activeUnit != null) {
            Tile tile = activeUnit.getTile();
            if (!this.setSelectedTile(tile, false) || this.freeColClient.getClientOptions().getBoolean("model.option.jumpToActiveUnit")) {
                this.setFocus(tile);
                ret = true;
            }
        } else {
            this.freeColClient.getActionManager().update();
            this.gui.updateMenuBar();
            this.redrawMapControls();
        }
        return ret;
    }

    public void setFocus(Tile focus) {
        this.focus = focus;
        this.gui.refresh();
    }

    public void setFocusImmediately(Tile focus) {
        this.focus = focus;
        this.forceReposition();
        this.gui.getCanvas().paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public void setGotoPath(PathNode gotoPath) {
        this.gotoPath = gotoPath;
        this.gui.refresh();
    }

    public int setOffsetFocus(Tile tile) {
        int where = 0;
        if (tile != null) {
            this.positionMap(tile);
            Map map = this.freeColClient.getGame().getMap();
            if (this.leftColumn == 0) {
                where = -1;
            } else if (this.rightColumn == map.getWidth() - 1) {
                where = 1;
            } else {
                int x = tile.getX() - (tile.getX() - this.leftColumn) / 2;
                tile = map.getTile(x, tile.getY());
                where = 1;
            }
            this.setFocus(tile);
        }
        return where;
    }

    public boolean setSelectedTile(Tile newTileToSelect, boolean clearGoToOrders) {
        Tile oldTile = this.selectedTile;
        boolean ret = false;
        this.selectedTile = newTileToSelect;
        if (this.viewMode.getView() == 0) {
            if (this.noActiveUnitIsAt(this.selectedTile)) {
                if (this.selectedTile != null && this.selectedTile.getSettlement() != null) {
                    Settlement s = this.selectedTile.getSettlement();
                    this.gui.getCanvas().showSettlement(s);
                    return ret;
                }
                Unit unitInFront = this.getUnitInFront(this.selectedTile);
                if (unitInFront != null) {
                    ret = this.setActiveUnit(unitInFront);
                    this.updateGotoPathForActiveUnit();
                } else {
                    this.setFocus(this.selectedTile);
                    ret = true;
                }
            } else if (clearGoToOrders) {
                this.freeColClient.getInGameController().clearGotoOrders(this.activeUnit);
                this.updateGotoPathForActiveUnit();
            }
        }
        this.freeColClient.getActionManager().update();
        this.gui.updateMenuBar();
        this.redrawMapControls();
        if (!this.onScreen(this.selectedTile) || this.freeColClient.getClientOptions().getBoolean("model.option.alwaysCenter")) {
            this.setFocus(this.selectedTile);
            ret = true;
        } else {
            if (oldTile != null) {
                this.gui.refreshTile(oldTile);
            }
            if (this.selectedTile != null) {
                this.gui.refreshTile(this.selectedTile);
            }
        }
        return ret;
    }

    public void setSize(Dimension size) {
        this.size = size;
        this.updateMapDisplayVariables();
    }

    public void startCursorBlinking() {
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Tile tile;
                if (!MapViewer.this.blinkingMarqueeEnabled) {
                    return;
                }
                if (MapViewer.this.getActiveUnit() != null && MapViewer.this.getActiveUnit().getTile() != null && MapViewer.this.isTileVisible(tile = MapViewer.this.getActiveUnit().getTile())) {
                    MapViewer.this.gui.refreshTile(tile);
                }
            }
        };
        this.cursor.addActionListener(taskPerformer);
        this.cursor.startBlinking();
    }

    public void startGoto() {
        this.gotoStarted = true;
        this.gui.getCanvas().setCursor((Cursor)UIManager.get("cursor.go"));
        this.setGotoPath(null);
    }

    public void stopBlinking() {
        this.blinkingMarqueeEnabled = false;
    }

    public void stopGoto() {
        this.gui.getCanvas().setCursor(null);
        this.setGotoPath(null);
        this.updateGotoPathForActiveUnit();
        this.gotoStarted = false;
    }

    public void updateGotoPathForActiveUnit() {
        this.currentPath = this.activeUnit == null || this.activeUnit.getDestination() == null ? null : (this.activeUnit.getDestination() instanceof Europe ? this.activeUnit.findPathToEurope() : (this.activeUnit.getDestination().getTile() == this.activeUnit.getTile() ? null : this.activeUnit.findPath(this.activeUnit.getDestination().getTile())));
    }

    void scaleMap(float delta) {
        float newScale = this.lib.getScalingFactor() + delta;
        try {
            if (newScale >= 1.0f) {
                this.setImageLibrary(this.gui.getImageLibrary());
            } else {
                this.setImageLibrary(this.gui.getImageLibrary().getScaledImageLibrary(newScale));
            }
        }
        catch (Exception ex) {
            logger.warning("Failed to retrieve scaled image library.");
        }
    }

    private void centerImage(Graphics2D g, Image image) {
        g.drawImage(image, (this.tileWidth - image.getWidth(null)) / 2, (this.tileHeight - image.getHeight(null)) / 2, null);
    }

    private void centerString(Graphics2D g, String text) {
        g.setColor(Color.BLACK);
        g.setFont(ResourceManager.getFont("NormalFont", 12.0f));
        g.drawString(text, (this.tileWidth - g.getFontMetrics().stringWidth(text)) / 2, (this.tileHeight - g.getFontMetrics().getAscent()) / 2);
    }

    private Image createCapitalLabel(int extent, int padding, Color backgroundColor) {
        String key = "dynamic.label.nativeCapital." + Integer.toHexString(backgroundColor.getRGB());
        Image image = ResourceManager.getImage(key, this.lib.getScalingFactor());
        if (image != null) {
            return image;
        }
        double deg2rad = Math.PI / 180;
        double angle = -90.0 * deg2rad;
        double offset = (double)extent * 0.5;
        double size = (double)(extent - padding - padding) * 0.5;
        GeneralPath path = new GeneralPath();
        path.moveTo(Math.cos(angle) * size + offset, Math.sin(angle) * size + offset);
        for (int i = 0; i < 4; ++i) {
            path.lineTo(Math.cos(angle += 144.0 * deg2rad) * size + offset, Math.sin(angle) * size + offset);
        }
        path.closePath();
        BufferedImage bi = new BufferedImage(extent, extent, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(backgroundColor);
        g.fill(new RoundRectangle2D.Float(0.0f, 0.0f, extent, extent, padding, padding));
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(2.4f, 1, 1));
        g.draw(path);
        g.setColor(Color.WHITE);
        g.fill(path);
        ResourceManager.addGameMapping(key, new ImageResource(bi));
        return ResourceManager.getImage(key, this.lib.getScalingFactor());
    }

    private Image createLabel(Graphics2D g, String text, Font font, Color backgroundColor) {
        TextSpecification[] specs = new TextSpecification[]{new TextSpecification(text, font)};
        return this.createLabel(g, specs, backgroundColor);
    }

    private Image createLabel(Graphics2D g, TextSpecification[] textSpecs, Color backgroundColor) {
        int i;
        int hPadding = 15;
        int vPadding = 10;
        int linePadding = 2;
        int width = 0;
        int height = vPadding;
        TextLayout[] labels = new TextLayout[textSpecs.length];
        for (i = 0; i < textSpecs.length; ++i) {
            TextLayout label;
            TextSpecification spec = textSpecs[i];
            labels[i] = label = new TextLayout(spec.text, spec.font, g.getFontRenderContext());
            width = Math.max(width, (int)label.getBounds().getWidth() + hPadding);
            height += (int)(label.getAscent() + label.getDescent());
            if (i <= 0) continue;
            height += linePadding;
        }
        int radius = Math.min(hPadding, vPadding);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.scale(this.lib.getScalingFactor(), this.lib.getScalingFactor());
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setColor(backgroundColor);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, radius, radius));
        g2.setColor(this.getForegroundColor(backgroundColor));
        int offset = 0;
        for (i = 0; i < labels.length; ++i) {
            if (i > 0) {
                offset = (int)((float)offset + (labels[i - 1].getAscent() + (float)linePadding + (float)(vPadding / 2)));
            }
            labels[i].draw(g2, (float)((double)width - labels[i].getBounds().getWidth()) / 2.0f, (float)offset + labels[i].getAscent() + (float)(vPadding / 2));
        }
        return bi;
    }

    private Image createReligiousMissionLabel(int extent, int padding, Color backgroundColor, boolean expertMissionary) {
        String key = "dynamic.label.religiousMission" + (expertMissionary ? ".expert" : "") + "." + Integer.toHexString(backgroundColor.getRGB());
        Image image = ResourceManager.getImage(key, this.lib.getScalingFactor());
        if (image != null) {
            return image;
        }
        double offset = (double)extent * 0.5;
        double size = extent - padding - padding;
        double bar = size / 3.0;
        double inset = 0.0;
        double kludge = 0.0;
        GeneralPath circle = new GeneralPath();
        GeneralPath cross = new GeneralPath();
        if (expertMissionary) {
            circle.append(new Ellipse2D.Double(padding - 1, padding - 1, size + 1.0, size + 1.0), false);
            inset = 4.0;
            bar = (size - inset - inset) / 3.0;
            kludge = 1.0;
        }
        cross.moveTo(offset -= 1.0, (double)padding + inset - kludge);
        cross.lineTo(offset, (double)(extent - padding) - inset);
        cross.moveTo(offset - bar, (double)padding + bar + inset);
        cross.lineTo(offset + bar + 1.0, (double)padding + bar + inset);
        BufferedImage bi = new BufferedImage(extent, extent, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(backgroundColor);
        g.fill(new RoundRectangle2D.Float(0.0f, 0.0f, extent, extent, padding, padding));
        g.setColor(this.getForegroundColor(backgroundColor));
        if (expertMissionary) {
            g.setStroke(new BasicStroke(2.0f, 1, 1));
            g.draw(circle);
            g.setStroke(new BasicStroke(1.6f, 1, 1));
        } else {
            g.setStroke(new BasicStroke(2.4f, 1, 1));
        }
        g.draw(cross);
        ResourceManager.addGameMapping(key, new ImageResource(bi));
        return ResourceManager.getImage(key, this.lib.getScalingFactor());
    }

    private void displayBaseTile(Graphics2D g, Tile tile, boolean drawUnexploredBorders) {
        if (tile != null) {
            int x = tile.getX();
            int y = tile.getY();
            g.drawImage(this.lib.getTerrainImage(tile.getType(), x, y), 0, 0, null);
            if (tile.isExplored()) {
                if (!tile.isLand() && tile.getStyle() > 0) {
                    int cornerStyle;
                    int edgeStyle = tile.getStyle() >> 4;
                    if (edgeStyle > 0) {
                        g.drawImage(this.lib.getBeachEdgeImage(edgeStyle, x, y), 0, 0, null);
                    }
                    if ((cornerStyle = tile.getStyle() & 0xF) > 0) {
                        g.drawImage(this.lib.getBeachCornerImage(cornerStyle, x, y), 0, 0, null);
                    }
                }
                for (Map.Direction direction : Map.Direction.values()) {
                    Tile borderingTile = tile.getAdjacentTile(direction);
                    if (borderingTile == null || !drawUnexploredBorders && !borderingTile.isExplored() && (direction == Map.Direction.SE || direction == Map.Direction.S || direction == Map.Direction.SW) || tile.getType() == borderingTile.getType() || tile.isLand() && !borderingTile.isLand()) continue;
                    if (!tile.isLand() && borderingTile.isLand() && borderingTile.isExplored()) {
                        int[] branches;
                        g.drawImage(this.lib.getBorderImage(borderingTile.getType(), direction, x, y), 0, 0, null);
                        TileImprovement river = borderingTile.getRiver();
                        if (river == null || direction != Map.Direction.SE && direction != Map.Direction.SW && direction != Map.Direction.NE && direction != Map.Direction.NW || (branches = river.getStyleBreakdown(Map.Direction.longSides, 3))[direction.getReverseDirection().ordinal()] <= 0) continue;
                        g.drawImage(this.lib.getRiverMouthImage(direction, borderingTile.getRiver().getMagnitude(), x, y), 0, 0, null);
                        continue;
                    }
                    if (!borderingTile.isExplored() || this.lib.getTerrainImage(tile.getType(), 0, 0).equals(this.lib.getTerrainImage(borderingTile.getType(), 0, 0)) || borderingTile.getType().getIndex() >= tile.getType().getIndex()) continue;
                    g.drawImage(this.lib.getBorderImage(borderingTile.getType(), direction, x, y), 0, 0, null);
                }
            }
        }
    }

    private void displayFogOfWar(Graphics2D g, Tile tile) {
        if (this.freeColClient.getGame().getSpecification().getBoolean("model.option.fogOfWar") && this.freeColClient.getMyPlayer() != null && !this.freeColClient.getMyPlayer().canSee(tile)) {
            g.setColor(Color.BLACK);
            Composite oldComposite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 0.2f));
            g.fill(this.fog);
            g.setComposite(oldComposite);
        }
    }

    private void displayGotoPath(Graphics2D g, PathNode gotoPath) {
        if (gotoPath != null) {
            PathNode temp = gotoPath;
            Font font = ResourceManager.getFont("NormalFont", 12.0f);
            while (temp != null) {
                Point p = this.getTilePosition(temp.getTile());
                if (p != null) {
                    Color textColor;
                    Image image;
                    Tile tile = temp.getTile();
                    if (temp.getTurns() == 0) {
                        g.setColor(Color.GREEN);
                        image = this.lib.getPathImage(this.activeUnit);
                        if (this.activeUnit != null && tile.isExplored() && this.activeUnit.isNaval() && tile.isLand() && (tile.getColony() == null || tile.getColony().getOwner() != this.activeUnit.getOwner())) {
                            image = this.lib.getPathImage(this.activeUnit.getFirstUnit());
                        }
                        textColor = Color.BLACK;
                    } else {
                        g.setColor(Color.RED);
                        image = this.lib.getPathNextTurnImage(this.activeUnit);
                        if (this.activeUnit != null && tile.isExplored() && this.activeUnit.isNaval() && tile.isLand() && (tile.getColony() == null || tile.getColony().getOwner() != this.activeUnit.getOwner())) {
                            image = this.lib.getPathNextTurnImage(this.activeUnit.getFirstUnit());
                        }
                        textColor = Color.WHITE;
                    }
                    g.translate(p.x, p.y);
                    if (image != null) {
                        this.centerImage(g, image);
                    } else {
                        g.fillOval(this.halfWidth, this.halfHeight, 10, 10);
                        g.setColor(Color.BLACK);
                        g.drawOval(this.halfWidth, this.halfHeight, 10, 10);
                    }
                    if (temp.getTurns() > 0) {
                        Image stringImage = this.createStringImage(g, Integer.toString(temp.getTurns()), textColor, font);
                        this.centerImage(g, stringImage);
                    }
                    g.translate(-p.x, -p.y);
                }
                temp = temp.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayMap(Graphics2D g) {
        int index;
        AffineTransform originTransform = g.getTransform();
        Rectangle clipBounds = g.getClipBounds();
        Map map = this.freeColClient.getGame().getMap();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.repositionMapIfNeeded();
        int firstRow = (clipBounds.y - this.topRowY) / this.halfHeight - 1;
        int clipTopY = this.topRowY + firstRow * this.halfHeight;
        firstRow = this.topRow + firstRow;
        int firstColumn = (clipBounds.x - this.leftColumnX) / this.tileWidth - 1;
        int clipLeftX = this.leftColumnX + firstColumn * this.tileWidth;
        firstColumn = this.leftColumn + firstColumn;
        int lastRow = (clipBounds.y + clipBounds.height - this.topRowY) / this.halfHeight;
        lastRow = this.topRow + lastRow;
        int lastColumn = (clipBounds.x + clipBounds.width - this.leftColumnX) / this.tileWidth;
        lastColumn = this.leftColumn + lastColumn;
        if (this.freeColClient.getClientOptions().getBoolean("model.option.displayGrid")) {
            this.gridPath = new GeneralPath();
            this.gridPath.moveTo(0.0f, 0.0f);
            int nextX = this.halfWidth;
            int nextY = -this.halfHeight;
            for (int i = 0; i <= (lastColumn - firstColumn) * 2 + 1; ++i) {
                this.gridPath.lineTo(nextX, nextY);
                nextX += this.halfWidth;
                nextY = nextY == 0 ? -this.halfHeight : 0;
            }
        }
        g.setColor(Color.black);
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        g.translate(clipLeftX, clipTopY);
        AffineTransform baseTransform = g.getTransform();
        AffineTransform rowTransform = null;
        for (int row = firstRow; row <= lastRow; ++row) {
            rowTransform = g.getTransform();
            if (row % 2 == 1) {
                g.translate(this.halfWidth, 0);
            }
            for (int column = firstColumn; column <= lastColumn; ++column) {
                Tile tile = map.getTile(column, row);
                this.displayBaseTile(g, tile, true);
                g.translate(this.tileWidth, 0);
            }
            g.setTransform(rowTransform);
            g.translate(0, this.halfHeight);
        }
        g.setTransform(baseTransform);
        ArrayList<Unit> units = new ArrayList<Unit>();
        ArrayList<AffineTransform> unitTransforms = new ArrayList<AffineTransform>();
        ArrayList<Settlement> settlements = new ArrayList<Settlement>();
        ArrayList<AffineTransform> settlementTransforms = new ArrayList<AffineTransform>();
        int colonyLabels = this.freeColClient.getClientOptions().getInteger("model.option.displayColonyLabels");
        boolean withNumbers = colonyLabels == 1;
        for (int row = firstRow; row <= lastRow; ++row) {
            rowTransform = g.getTransform();
            if (row % 2 == 1) {
                g.translate(this.halfWidth, 0);
            }
            if (this.freeColClient.getClientOptions().getBoolean("model.option.displayGrid")) {
                g.translate(0, this.halfHeight);
                g.setStroke(this.gridStroke);
                g.setColor(Color.BLACK);
                g.draw(this.gridPath);
                g.translate(0, -this.halfHeight);
            }
            for (int column = firstColumn; column <= lastColumn; ++column) {
                Tile tile = map.getTile(column, row);
                this.paintBorders(g, tile, BorderType.COUNTRY, true);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                this.displayTileOverlays(g, tile, true, withNumbers);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.paintBorders(g, tile, BorderType.COUNTRY, false);
                if (this.viewMode.displayTileCursor(tile)) {
                    this.drawCursor(g);
                }
                if (tile != null) {
                    Settlement settlement;
                    Unit unitInFront = this.getUnitInFront(tile);
                    if (unitInFront != null && !this.isOutForAnimation(unitInFront)) {
                        units.add(unitInFront);
                        unitTransforms.add(g.getTransform());
                    }
                    if ((settlement = tile.getSettlement()) != null) {
                        settlements.add(settlement);
                        settlementTransforms.add(g.getTransform());
                    }
                }
                g.translate(this.tileWidth, 0);
            }
            g.setTransform(rowTransform);
            g.translate(0, this.halfHeight);
        }
        g.setTransform(baseTransform);
        if (units.size() > 0) {
            g.setColor(Color.BLACK);
            Image im = this.lib.getMiscImage("halo.dark.image");
            for (index = 0; index < units.size(); ++index) {
                Unit unit = (Unit)units.get(index);
                g.setTransform((AffineTransform)unitTransforms.get(index));
                if (unit.isUndead()) {
                    this.centerImage(g, im);
                }
                this.displayUnit(g, unit);
            }
            g.setTransform(baseTransform);
        }
        if (settlements.size() > 0 && colonyLabels != 0) {
            Player clientPlayer = this.freeColClient.getMyPlayer();
            block12: for (index = 0; index < settlements.size(); ++index) {
                Settlement settlement = (Settlement)settlements.get(index);
                String name = Messages.message(settlement.getNameFor(clientPlayer));
                if (name == null) continue;
                Color backgroundColor = this.lib.getColor(settlement.getOwner());
                Font font = ResourceManager.getFont("NormalFont", 18.0f);
                Font productionFont = ResourceManager.getFont("NormalFont", 12.0f);
                int yOffset = this.tileHeight;
                g.setTransform((AffineTransform)settlementTransforms.get(index));
                switch (colonyLabels) {
                    case 1: {
                        Image stringImage = this.createStringImage(g, name, backgroundColor, font);
                        g.drawImage(stringImage, (this.tileWidth - stringImage.getWidth(null)) / 2 + 1, yOffset, null);
                        continue block12;
                    }
                    default: {
                        Colony colony;
                        BuildableType buildable;
                        backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 128);
                        TextSpecification[] specs = new TextSpecification[1];
                        if (settlement instanceof Colony && settlement.getOwner() == clientPlayer && (buildable = (colony = (Colony)settlement).getCurrentlyBuilding()) != null) {
                            specs = new TextSpecification[2];
                            String turnsStr = Messages.getTurnsText(colony.getTurnsToComplete(buildable));
                            String nowBuilding = Messages.message(buildable.getNameKey()) + " " + turnsStr;
                            specs[1] = new TextSpecification(nowBuilding, productionFont);
                        }
                        specs[0] = new TextSpecification(name, font);
                        Image nameImage = this.createLabel(g, specs, backgroundColor);
                        if (nameImage == null) continue block12;
                        int spacing = 3;
                        Image leftImage = null;
                        Image rightImage = null;
                        if (settlement instanceof Colony) {
                            int bonusProduction;
                            String size = Integer.toString(((Colony)settlement).getDisplayUnitCount());
                            leftImage = this.createLabel(g, size, font, backgroundColor);
                            if (clientPlayer.owns(settlement) && (bonusProduction = ((Colony)settlement).getProductionBonus()) != 0) {
                                String bonus = bonusProduction > 0 ? "+" + bonusProduction : Integer.toString(bonusProduction);
                                rightImage = this.createLabel(g, bonus, font, backgroundColor);
                            }
                        } else if (settlement instanceof IndianSettlement) {
                            Unit missionary;
                            IndianSettlement nativeSettlement = (IndianSettlement)settlement;
                            if (nativeSettlement.getType().isCapital()) {
                                leftImage = this.createCapitalLabel(nameImage.getHeight(null), 5, backgroundColor);
                            }
                            if ((missionary = nativeSettlement.getMissionary()) != null) {
                                boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                                backgroundColor = this.lib.getColor(missionary.getOwner());
                                backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 128);
                                rightImage = this.createReligiousMissionLabel(nameImage.getHeight(null), 5, backgroundColor, expert);
                            }
                        }
                        int width = (int)((float)nameImage.getWidth(null) * this.lib.getScalingFactor() + (leftImage != null ? (float)leftImage.getWidth(null) * this.lib.getScalingFactor() + (float)spacing : 0.0f) + (rightImage != null ? (float)rightImage.getWidth(null) * this.lib.getScalingFactor() + (float)spacing : 0.0f));
                        int labelOffset = (this.tileWidth - width) / 2;
                        yOffset = (int)((float)yOffset - (float)nameImage.getHeight(null) * this.lib.getScalingFactor() / 2.0f);
                        if (leftImage != null) {
                            g.drawImage(leftImage, labelOffset, yOffset, null);
                            labelOffset = (int)((float)labelOffset + ((float)leftImage.getWidth(null) * this.lib.getScalingFactor() + (float)spacing));
                        }
                        g.drawImage(nameImage, labelOffset, yOffset, null);
                        if (rightImage == null) continue block12;
                        labelOffset = (int)((float)labelOffset + ((float)nameImage.getWidth(null) * this.lib.getScalingFactor() + (float)spacing));
                        g.drawImage(rightImage, labelOffset, yOffset, null);
                        continue block12;
                    }
                }
            }
        }
        g.setTransform(originTransform);
        this.displayGotoPath(g, this.currentPath);
        this.displayGotoPath(g, this.gotoPath);
        Canvas canvas = this.gui.getCanvas();
        if (!this.freeColClient.isMapEditor() && this.freeColClient.getGame() != null && !this.freeColClient.currentPlayerIsMyPlayer()) {
            if (this.greyLayer == null) {
                this.greyLayer = new GrayLayer(this.lib);
            }
            if (this.greyLayer.getParent() == null) {
                canvas.add((Component)this.greyLayer, JLayeredPane.DEFAULT_LAYER, false);
                canvas.moveToFront(this.greyLayer);
            }
            this.greyLayer.setBounds(0, 0, canvas.getSize().width, canvas.getSize().height);
            this.greyLayer.setPlayer(this.freeColClient.getGame().getCurrentPlayer());
        } else if (this.greyLayer != null && this.greyLayer.getParent() != null) {
            canvas.remove(this.greyLayer, false);
        }
        if (this.getMessageCount() > 0) {
            MapViewer index2 = this;
            synchronized (index2) {
                Font font = ResourceManager.getFont("NormalFont", 12.0f);
                GUIMessage message = this.getMessage(0);
                Image si = this.createStringImage(g, message.getMessage(), message.getColor(), font);
                int yy = this.size.height - 300 - this.getMessageCount() * si.getHeight(null);
                int xx = 40;
                for (int i = 0; i < this.getMessageCount(); ++i) {
                    message = this.getMessage(i);
                    g.drawImage(this.createStringImage(g, message.getMessage(), message.getColor(), font), xx, yy, null);
                    yy += si.getHeight(null);
                }
            }
        }
        Image decoration = ResourceManager.getImage("menuborder.shadow.s.image");
        int width = decoration.getWidth(null);
        for (int index3 = 0; index3 < this.size.width; index3 += width) {
            g.drawImage(decoration, index3, 0, null);
        }
        decoration = ResourceManager.getImage("menuborder.shadow.sw.image");
        g.drawImage(decoration, 0, 0, null);
        decoration = ResourceManager.getImage("menuborder.shadow.se.image");
        g.drawImage(decoration, this.size.width - decoration.getWidth(null), 0, null);
    }

    private void displayOptionalValues(Graphics2D g, Tile tile) {
        String text = null;
        switch (this.freeColClient.getClientOptions().getInteger("model.option.displayTileText")) {
            case 1: {
                if (tile.getNameKey() == null) break;
                text = Messages.message(tile.getNameKey());
                break;
            }
            case 2: {
                if (tile.getOwner() == null) break;
                text = Messages.message(tile.getOwner().getNationName());
                break;
            }
            case 3: {
                if (tile.getRegion() != null) {
                    text = Messages.message(tile.getRegion().getLabel());
                }
                this.paintBorders(g, tile, BorderType.REGION, true);
                break;
            }
            case 0: {
                break;
            }
            default: {
                logger.warning("displayTileText out of range");
            }
        }
        if (text != null) {
            int b = Messages.getBreakingPoint(text);
            if (b == -1) {
                this.centerString(g, text);
            } else {
                g.setColor(Color.BLACK);
                g.setFont(ResourceManager.getFont("NormalFont", 12.0f));
                g.drawString(text.substring(0, b), (this.tileWidth - g.getFontMetrics().stringWidth(text.substring(0, b))) / 2, this.halfHeight - g.getFontMetrics().getAscent() * 2 / 3);
                g.drawString(text.substring(b + 1), (this.tileWidth - g.getFontMetrics().stringWidth(text.substring(b + 1))) / 2, this.halfHeight + g.getFontMetrics().getAscent() * 2 / 3);
            }
        }
        if (this.displayCoordinates) {
            String posString = tile.getX() + ", " + tile.getY();
            if (tile.isConnected()) {
                posString = posString + "C";
            }
            this.centerString(g, posString);
        }
        if (this.displayColonyValue && tile.isExplored() && tile.isLand()) {
            String valueString = this.displayColonyValuePlayer == null ? Integer.toString(this.freeColClient.getGame().getCurrentPlayer().getOutpostValue(tile)) : Integer.toString(this.displayColonyValuePlayer.getColonyValue(tile));
            this.centerString(g, valueString);
        }
    }

    private void displaySettlement(Graphics2D g, Tile tile, boolean withNumber) {
        Settlement settlement = tile.getSettlement();
        if (settlement != null) {
            if (settlement instanceof Colony) {
                Image colonyImage = this.lib.getSettlementImage(settlement);
                this.centerImage(g, colonyImage);
                if (withNumber) {
                    String populationString = Integer.toString(((Colony)settlement).getDisplayUnitCount());
                    int bonus = ((Colony)settlement).getProductionBonus();
                    Color theColor = ResourceManager.getProductionColor(bonus);
                    Font font = ResourceManager.getFont("SimpleFont", 1, 12.0f);
                    Image stringImage = this.createStringImage(g, populationString, theColor, font);
                    this.centerImage(g, stringImage);
                }
            } else if (settlement instanceof IndianSettlement) {
                Player player;
                IndianSettlement indianSettlement = (IndianSettlement)settlement;
                Image settlementImage = this.lib.getSettlementImage(settlement);
                this.centerImage(g, settlementImage);
                String text = null;
                Image chip = null;
                Color background = this.lib.getColor(indianSettlement.getOwner());
                Color foreground = this.getForegroundColor(background);
                float xOffset = 25.0f * this.lib.getScalingFactor();
                float yOffset = 10.0f * this.lib.getScalingFactor();
                int colonyLabels = this.freeColClient.getClientOptions().getInteger("model.option.displayColonyLabels");
                if (colonyLabels != 2) {
                    text = indianSettlement.getType().isCapital() ? "*" : "-";
                    chip = this.lib.createChip(text, Color.BLACK, background, foreground);
                    g.drawImage(chip, (int)xOffset, (int)yOffset, null);
                    xOffset += (float)(chip.getWidth(null) + 2);
                    Unit missionary = indianSettlement.getMissionary();
                    if (missionary != null) {
                        boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                        Color mission = expert ? Color.BLACK : Color.GRAY;
                        Color cross = this.lib.getColor(missionary.getOwner());
                        chip = this.lib.createChip("\u271d", Color.BLACK, mission, cross);
                        g.drawImage(chip, (int)xOffset, (int)yOffset, null);
                        xOffset += (float)(chip.getWidth(null) + 2);
                    }
                }
                if ((player = this.freeColClient.getMyPlayer()) != null && indianSettlement.hasContactedSettlement(player)) {
                    boolean visited = indianSettlement.hasSpokenToChief(player);
                    chip = this.lib.createChip(visited ? "!" : "?", Color.BLACK, background, foreground);
                    g.drawImage(chip, (int)xOffset, (int)yOffset, null);
                }
            } else {
                logger.warning("Requested to draw unknown settlement type.");
            }
        }
    }

    private void displayTileItems(Graphics2D g, Tile tile) {
        if (!tile.isExplored()) {
            g.drawImage(this.lib.getTerrainImage(null, tile.getX(), tile.getY()), 0, 0, null);
        } else {
            int index;
            Image overlayImage;
            int startIndex;
            List<Object> tileItems = new ArrayList();
            if (tile.getTileItemContainer() != null) {
                tileItems = tile.getTileItemContainer().getTileItems();
            }
            for (int index2 = startIndex = 0; index2 < tileItems.size(); ++index2) {
                if (((TileItem)tileItems.get(index2)).getZIndex() >= 100) {
                    startIndex = index2;
                    break;
                }
                this.drawItem(g, tile, (TileItem)tileItems.get(index2));
                startIndex = index2 + 1;
            }
            if ((overlayImage = this.lib.getOverlayImage(tile.getType(), tile.getX(), tile.getY())) != null) {
                g.drawImage(overlayImage, 0, this.tileHeight - overlayImage.getHeight(null), null);
            }
            for (index = startIndex; index < tileItems.size(); ++index) {
                if (((TileItem)tileItems.get(index)).getZIndex() >= 200) {
                    startIndex = index;
                    break;
                }
                this.drawItem(g, tile, (TileItem)tileItems.get(index));
                startIndex = index + 1;
            }
            if (tile.isForested()) {
                Image forestImage = this.lib.getForestImage(tile.getType());
                g.drawImage(forestImage, 0, this.tileHeight - forestImage.getHeight(null), null);
            }
            for (index = startIndex; index < tileItems.size(); ++index) {
                this.drawItem(g, tile, (TileItem)tileItems.get(index));
            }
        }
    }

    private void displayTileOverlays(Graphics2D g, Tile tile, boolean drawUnexploredBorders, boolean withNumber) {
        if (tile != null && tile.isExplored()) {
            if (drawUnexploredBorders) {
                for (Map.Direction direction : Map.Direction.values()) {
                    Tile borderingTile = tile.getAdjacentTile(direction);
                    if (borderingTile == null || borderingTile.isExplored()) continue;
                    g.drawImage(this.lib.getBorderImage(null, direction, tile.getX(), tile.getY()), 0, 0, null);
                }
            }
            this.displayTileItems(g, tile);
            this.displaySettlement(g, tile, withNumber);
            this.displayFogOfWar(g, tile);
            this.displayOptionalValues(g, tile);
        }
    }

    private void displayUnit(Graphics2D g, Unit unit) {
        AIUnit au;
        try {
            if (this.viewMode.displayUnitCursor(unit)) {
                this.drawCursor(g);
            }
            boolean fade = unit.getState() == Unit.UnitState.SENTRY || unit.getTile() != null && !this.freeColClient.getMyPlayer().canSee(unit.getTile());
            Image image = this.lib.getUnitImageIcon(unit, fade).getImage();
            Point p = this.getUnitImagePositionInTile(image);
            g.drawImage(image, p.x, p.y, null);
            g.drawImage(this.getOccupationIndicatorImage(g, unit), (int)(25.0f * this.lib.getScalingFactor()), 0, null);
            int unitsOnTile = 0;
            if (unit.getTile() != null) {
                unitsOnTile = unit.getTile().getTotalUnitCount();
            }
            if (unitsOnTile > 1) {
                g.setColor(Color.WHITE);
                int unitLinesY = 1;
                int x1 = (int)(20.0f * this.lib.getScalingFactor());
                int x2 = (int)(23.0f * this.lib.getScalingFactor());
                for (int i = 0; i < unitsOnTile && i < 10; ++i) {
                    g.drawLine(x1, unitLinesY, x2, unitLinesY);
                    unitLinesY += 2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.debugShowMission && this.freeColClient.getFreeColServer() != null && (unit.getOwner().isAI() || unit.hasAbility("model.ability.piracy")) && (au = this.freeColClient.getFreeColServer().getAIMain().getAIUnit(unit)) != null) {
            g.setColor(Color.WHITE);
            String text = unit.getOwner().isAI() ? "" : "(";
            String debuggingInfo = "";
            if (au.getMission() != null) {
                String missionName = au.getMission().getClass().toString();
                missionName = missionName.substring(missionName.lastIndexOf(46) + 1);
                text = text + missionName;
                if (this.debugShowMissionInfo) {
                    debuggingInfo = au.getMission().getDebuggingInfo();
                }
            } else {
                text = text + "No mission";
            }
            text = text + (unit.getOwner().isAI() ? "" : ")");
            g.drawString(text, 0, 0);
            g.drawString(debuggingInfo, 0, 25);
        }
    }

    private void drawCursor(Graphics2D g) {
        g.drawImage(this.cursorImage, 0, 0, null);
    }

    private void drawItem(Graphics2D g, Tile tile, TileItem item) {
        if (item instanceof Resource) {
            Image bonusImage = this.lib.getBonusImage(((Resource)item).getType());
            if (bonusImage != null) {
                this.centerImage(g, bonusImage);
            }
        } else if (item instanceof LostCityRumour) {
            this.centerImage(g, this.lib.getMiscImage("lostCityRumour.image"));
        } else {
            TileImprovement improvement = (TileImprovement)item;
            if (improvement.isComplete()) {
                String key = improvement.getType().getId() + ".image";
                if (ResourceManager.hasResource(key)) {
                    Image overlay = ResourceManager.getImage(key, this.lib.getScalingFactor());
                    g.drawImage(overlay, 0, 0, null);
                } else if (improvement.isRiver() && improvement.getMagnitude() < 3) {
                    g.drawImage(this.lib.getRiverImage(improvement.getStyle()), 0, 0, null);
                } else if (improvement.isRoad()) {
                    this.drawRoad(g, tile);
                }
            }
        }
    }

    private void drawRoad(Graphics2D g, Tile tile) {
        Color oldColor = g.getColor();
        g.setColor(ResourceManager.getColor("road.color"));
        g.setStroke(this.roadStroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath path = new GeneralPath();
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>(8);
        ArrayList<Map.Direction> directions = new ArrayList<Map.Direction>(8);
        for (Map.Direction direction : Map.Direction.values()) {
            TileImprovement r;
            Tile borderingTile = tile.getAdjacentTile(direction);
            if (borderingTile == null || (r = borderingTile.getRoad()) == null || !r.isComplete()) continue;
            points.add(this.corners.get((Object)direction));
            directions.add(direction);
        }
        switch (points.size()) {
            case 0: {
                path.moveTo(0.35f * (float)this.tileWidth, 0.35f * (float)this.tileHeight);
                path.lineTo(0.65f * (float)this.tileWidth, 0.65f * (float)this.tileHeight);
                path.moveTo(0.35f * (float)this.tileWidth, 0.65f * (float)this.tileHeight);
                path.lineTo(0.65f * (float)this.tileWidth, 0.35f * (float)this.tileHeight);
                break;
            }
            case 1: {
                path.moveTo(this.halfWidth, this.halfHeight);
                path.lineTo(((Point2D.Float)points.get(0)).getX(), ((Point2D.Float)points.get(0)).getY());
                break;
            }
            case 2: {
                path.moveTo(((Point2D.Float)points.get(0)).getX(), ((Point2D.Float)points.get(0)).getY());
                path.quadTo((double)this.halfWidth, (double)this.halfHeight, ((Point2D.Float)points.get(1)).getX(), ((Point2D.Float)points.get(1)).getY());
                break;
            }
            case 3: 
            case 4: {
                Map.Direction pen = (Map.Direction)((Object)directions.get(directions.size() - 1));
                Point2D p = this.corners.get((Object)pen);
                path.moveTo(p.getX(), p.getY());
                for (Map.Direction d : directions) {
                    p = this.corners.get((Object)d);
                    if (this.prohibitedRoads.get((Object)pen).contains((Object)d)) {
                        path.moveTo(p.getX(), p.getY());
                    } else {
                        path.quadTo((double)this.halfWidth, (double)this.halfHeight, p.getX(), p.getY());
                    }
                    pen = d;
                }
                break;
            }
            default: {
                for (Point2D.Float p : points) {
                    path.moveTo(this.halfWidth, this.halfHeight);
                    path.lineTo(((Point2D)p).getX(), ((Point2D)p).getY());
                }
            }
        }
        g.draw(path);
        g.setColor(oldColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private JLabel enterUnitOutForAnimation(Unit unit, Tile sourceTile) {
        Integer i = this.unitsOutForAnimation.get(unit);
        if (i == null) {
            JLabel unitLabel = this.getUnitLabel(unit);
            Integer UNIT_LABEL_LAYER = JLayeredPane.DEFAULT_LAYER;
            i = 1;
            unitLabel.setLocation(this.getUnitLabelPositionInTile(unitLabel, this.getTilePosition(sourceTile)));
            this.unitsOutForAnimationLabels.put(unit, unitLabel);
            this.gui.getCanvas().add((Component)unitLabel, UNIT_LABEL_LAYER, false);
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.unitsOutForAnimation.put(unit, i);
        return this.unitsOutForAnimationLabels.get(unit);
    }

    private Color getForegroundColor(Color background) {
        if ((double)background.getRed() * 0.3 + (double)background.getGreen() * 0.59 + (double)background.getBlue() * 0.11 < 126.0) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private int getLeftColumns() {
        return this.getLeftColumns(this.focus.getY());
    }

    private int getLeftColumns(int y) {
        int leftColumns = this.leftSpace / this.tileWidth + 1;
        if (y % 2 == 0) {
            if (this.leftSpace % this.tileWidth > 32) {
                ++leftColumns;
            }
        } else if (this.leftSpace % this.tileWidth == 0) {
            --leftColumns;
        }
        return leftColumns;
    }

    private GUIMessage getMessage(int index) {
        return this.messages.get(index);
    }

    private int getMessageCount() {
        return this.messages.size();
    }

    private int getRightColumns() {
        return this.getRightColumns(this.focus.getY());
    }

    private int getRightColumns(int y) {
        int rightColumns = this.rightSpace / this.tileWidth + 1;
        if (y % 2 == 0) {
            if (this.rightSpace % this.tileWidth == 0) {
                --rightColumns;
            }
        } else if (this.rightSpace % this.tileWidth > 32) {
            ++rightColumns;
        }
        return rightColumns;
    }

    private Color getStringBorderColor(Color color) {
        if ((double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11 < 10.0) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private Point getUnitImagePositionInTile(Image unitImage) {
        int unitX = (this.tileWidth - unitImage.getWidth(null)) / 2;
        int unitY = (this.tileHeight - unitImage.getHeight(null)) / 2 - (int)(20.0f * this.lib.getScalingFactor());
        return new Point(unitX, unitY);
    }

    private Unit getUnitInFront(Tile unitTile) {
        if (unitTile == null || unitTile.getUnitCount() <= 0) {
            return null;
        }
        if (this.activeUnit != null && this.activeUnit.getTile() == unitTile) {
            return this.activeUnit;
        }
        if (unitTile.getSettlement() == null) {
            Unit bestDefendingUnit = null;
            if (this.activeUnit != null && (bestDefendingUnit = unitTile.getDefendingUnit(this.activeUnit)) != null) {
                return bestDefendingUnit;
            }
            Unit movableUnit = unitTile.getMovableUnit();
            if (movableUnit != null && movableUnit.getLocation() == movableUnit.getTile()) {
                return movableUnit;
            }
            Unit bestPick = null;
            Iterator<Unit> unitIterator = unitTile.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit u = unitIterator.next();
                if (bestPick != null && bestPick.getMovesLeft() >= u.getMovesLeft()) continue;
                bestPick = u;
            }
            return bestPick;
        }
        return null;
    }

    private JLabel getUnitLabel(Unit unit) {
        Image unitImg = this.lib.getUnitImageIcon(unit).getImage();
        int width = this.halfWidth + unitImg.getWidth(null) / 2;
        int height = unitImg.getHeight(null);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics g = img.getGraphics();
        int unitX = (width - unitImg.getWidth(null)) / 2;
        g.drawImage(unitImg, unitX, 0, null);
        JLabel label = new JLabel(new ImageIcon(img));
        label.setSize(width, height);
        return label;
    }

    private boolean isOutForAnimation(Unit unit) {
        return this.unitsOutForAnimation.containsKey(unit);
    }

    private boolean isTileVisible(Tile tile) {
        return tile.getY() >= this.topRow && tile.getY() <= this.bottomRow && tile.getX() >= this.leftColumn && tile.getX() <= this.rightColumn;
    }

    private boolean noActiveUnitIsAt(Tile selectedTile) {
        return this.activeUnit == null || this.activeUnit.getTile() != null && !this.activeUnit.getTile().equals(selectedTile);
    }

    private void paintBorders(Graphics2D g, Tile tile, BorderType type, boolean opaque) {
        if (tile == null || type == BorderType.COUNTRY && !this.freeColClient.getClientOptions().getBoolean("model.option.displayBorders")) {
            return;
        }
        Player owner = tile.getOwner();
        Region region = tile.getRegion();
        if (type == BorderType.COUNTRY && owner != null || type == BorderType.REGION && region != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(this.borderStroke);
            Color oldColor = g.getColor();
            Color newColor = Color.WHITE;
            if (type == BorderType.COUNTRY) {
                newColor = new Color(this.lib.getColor(owner).getRed(), this.lib.getColor(owner).getGreen(), this.lib.getColor(owner).getBlue(), opaque ? 255 : 100);
            }
            g.setColor(newColor);
            GeneralPath path = new GeneralPath(0);
            path.moveTo(this.borderPoints.get((Object)((Object)Map.Direction.longSides[0])).x, this.borderPoints.get((Object)((Object)Map.Direction.longSides[0])).y);
            for (Map.Direction d : Map.Direction.longSides) {
                Tile otherTile = tile.getNeighbourOrNull(d);
                Map.Direction next = d.getNextDirection();
                Map.Direction next2 = next.getNextDirection();
                if (otherTile == null || type == BorderType.COUNTRY && !owner.owns(otherTile) || type == BorderType.REGION && otherTile.getRegion() != region) {
                    Tile tile1 = tile.getNeighbourOrNull(next);
                    Tile tile2 = tile.getNeighbourOrNull(next2);
                    if (tile2 == null || type == BorderType.COUNTRY && !owner.owns(tile2) || type == BorderType.REGION && tile2.getRegion() != region) {
                        path.lineTo(this.borderPoints.get((Object)((Object)next)).x, this.borderPoints.get((Object)((Object)next)).y);
                        path.quadTo(this.controlPoints.get((Object)((Object)next)).x, this.controlPoints.get((Object)((Object)next)).y, this.borderPoints.get((Object)((Object)next2)).x, this.borderPoints.get((Object)((Object)next2)).y);
                        continue;
                    }
                    int dx = 0;
                    int dy = 0;
                    switch (d) {
                        case NW: {
                            dx = this.halfWidth;
                            dy = -this.halfHeight;
                            break;
                        }
                        case NE: {
                            dx = this.halfWidth;
                            dy = this.halfHeight;
                            break;
                        }
                        case SE: {
                            dx = -this.halfWidth;
                            dy = this.halfHeight;
                            break;
                        }
                        case SW: {
                            dx = -this.halfWidth;
                            dy = -this.halfHeight;
                        }
                    }
                    if (tile1 != null && (type == BorderType.COUNTRY && owner.owns(tile1) || type == BorderType.REGION && tile1.getRegion() == region)) {
                        path.lineTo(this.borderPoints.get((Object)((Object)next)).x, this.borderPoints.get((Object)((Object)next)).y);
                        Map.Direction previous = d.getPreviousDirection();
                        Map.Direction previous2 = previous.getPreviousDirection();
                        int ddx = 0;
                        int ddy = 0;
                        switch (d) {
                            case NW: {
                                ddy = -this.tileHeight;
                                break;
                            }
                            case NE: {
                                ddx = this.tileWidth;
                                break;
                            }
                            case SE: {
                                ddy = this.tileHeight;
                                break;
                            }
                            case SW: {
                                ddx = -this.tileWidth;
                            }
                        }
                        path.quadTo(this.controlPoints.get((Object)((Object)previous)).x + (float)dx, this.controlPoints.get((Object)((Object)previous)).y + (float)dy, this.borderPoints.get((Object)((Object)previous2)).x + (float)ddx, this.borderPoints.get((Object)((Object)previous2)).y + (float)ddy);
                        continue;
                    }
                    path.lineTo(this.borderPoints.get((Object)((Object)d)).x + (float)dx, this.borderPoints.get((Object)((Object)d)).y + (float)dy);
                    continue;
                }
                path.moveTo(this.borderPoints.get((Object)((Object)next2)).x, this.borderPoints.get((Object)((Object)next2)).y);
            }
            g.draw(path);
            g.setColor(oldColor);
            g.setStroke(oldStroke);
        }
    }

    private void positionMap(Tile pos) {
        Game gameData = this.freeColClient.getGame();
        int x = pos.getX();
        int y = pos.getY();
        int leftColumns = this.getLeftColumns();
        int rightColumns = this.getRightColumns();
        if (y < this.topRows) {
            this.bottomRow = this.size.height / this.halfHeight - 1;
            if (this.size.height % this.halfHeight != 0) {
                ++this.bottomRow;
            }
            this.topRow = 0;
            this.bottomRowY = this.bottomRow * this.halfHeight;
            this.topRowY = 0;
        } else if (y >= gameData.getMap().getHeight() - this.bottomRows) {
            this.bottomRow = gameData.getMap().getHeight() - 1;
            this.topRow = this.size.height / this.halfHeight;
            if (this.size.height % this.halfHeight > 0) {
                ++this.topRow;
            }
            this.topRow = gameData.getMap().getHeight() - this.topRow;
            this.bottomRowY = this.size.height - this.tileHeight;
            this.topRowY = this.bottomRowY - (this.bottomRow - this.topRow) * this.halfHeight;
        } else {
            this.bottomRow = y + this.bottomRows;
            this.topRow = y - this.topRows;
            this.bottomRowY = this.topSpace + this.halfHeight * this.bottomRows;
            this.topRowY = this.topSpace - this.topRows * this.halfHeight;
        }
        if (x < leftColumns) {
            this.leftColumn = 0;
            this.rightColumn = this.size.width / this.tileWidth - 1;
            if (this.size.width % this.tileWidth > 0) {
                ++this.rightColumn;
            }
            this.leftColumnX = 0;
        } else if (x >= gameData.getMap().getWidth() - rightColumns) {
            this.rightColumn = gameData.getMap().getWidth() - 1;
            this.leftColumn = this.size.width / this.tileWidth;
            if (this.size.width % this.tileWidth > 0) {
                ++this.leftColumn;
            }
            this.leftColumnX = this.size.width - this.tileWidth - this.halfWidth - this.leftColumn * this.tileWidth;
            this.leftColumn = this.rightColumn - this.leftColumn;
        } else {
            this.leftColumn = x - leftColumns;
            this.rightColumn = x + rightColumns;
            this.leftColumnX = (this.size.width - this.tileWidth) / 2 - leftColumns * this.tileWidth;
        }
    }

    private void redrawMapControls() {
        MapControls mapControls = this.gui.getCanvas().getMapControls();
        if (mapControls != null) {
            mapControls.update();
        }
    }

    private void releaseUnitOutForAnimation(Unit unit) {
        Integer i = this.unitsOutForAnimation.get(unit);
        if (i == null) {
            throw new IllegalStateException("Tried to release unit that was not out for animation");
        }
        if (i == 1) {
            this.unitsOutForAnimation.remove(unit);
            this.gui.getCanvas().remove(this.unitsOutForAnimationLabels.remove(unit), false);
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i - 1);
            this.unitsOutForAnimation.put(unit, i);
        }
    }

    private synchronized boolean removeOldMessages() {
        long currentTime = new Date().getTime();
        boolean result = false;
        int i = 0;
        while (i < this.getMessageCount()) {
            long messageCreationTime = this.getMessage(i).getCreationTime().getTime();
            if (currentTime - messageCreationTime >= 30000L) {
                result = true;
                this.messages.remove(i);
                continue;
            }
            ++i;
        }
        return result;
    }

    private void repositionMapIfNeeded() {
        if (this.bottomRow < 0 && this.focus != null) {
            this.positionMap(this.focus);
        }
    }

    private void setImageLibrary(ImageLibrary lib) {
        this.lib = lib;
        this.cursorImage = lib.getMiscImage("unitSelect.image");
        this.tileHeight = lib.getTerrainImageHeight(null);
        this.halfHeight = this.tileHeight / 2;
        this.tileWidth = lib.getTerrainImageWidth(null);
        this.halfWidth = this.tileWidth / 2;
        int dx = this.tileWidth / 16;
        int dy = this.tileHeight / 16;
        int ddx = dx + dx / 2;
        int ddy = dy + dy / 2;
        this.corners.put(Map.Direction.N, new Point2D.Float(this.halfWidth, 0.0f));
        this.corners.put(Map.Direction.NE, new Point2D.Float(0.75f * (float)this.tileWidth, 0.25f * (float)this.tileHeight));
        this.corners.put(Map.Direction.E, new Point2D.Float(this.tileWidth, this.halfHeight));
        this.corners.put(Map.Direction.SE, new Point2D.Float(0.75f * (float)this.tileWidth, 0.75f * (float)this.tileHeight));
        this.corners.put(Map.Direction.S, new Point2D.Float(this.halfWidth, this.tileHeight));
        this.corners.put(Map.Direction.SW, new Point2D.Float(0.25f * (float)this.tileWidth, 0.75f * (float)this.tileHeight));
        this.corners.put(Map.Direction.W, new Point2D.Float(0.0f, this.halfHeight));
        this.corners.put(Map.Direction.NW, new Point2D.Float(0.25f * (float)this.tileWidth, 0.25f * (float)this.tileHeight));
        this.controlPoints.put(Map.Direction.N, new Point2D.Float(this.halfWidth, dy));
        this.controlPoints.put(Map.Direction.E, new Point2D.Float(this.tileWidth - dx, this.halfHeight));
        this.controlPoints.put(Map.Direction.S, new Point2D.Float(this.halfWidth, this.tileHeight - dy));
        this.controlPoints.put(Map.Direction.W, new Point2D.Float(dx, this.halfHeight));
        this.controlPoints.put(Map.Direction.SE, new Point2D.Float(this.halfWidth, this.tileHeight));
        this.controlPoints.put(Map.Direction.NE, new Point2D.Float(this.tileWidth, this.halfHeight));
        this.controlPoints.put(Map.Direction.SW, new Point2D.Float(0.0f, this.halfHeight));
        this.controlPoints.put(Map.Direction.NW, new Point2D.Float(this.halfWidth, 0.0f));
        this.borderPoints.put(Map.Direction.NW, new Point2D.Float(dx + ddx, this.halfHeight - ddy));
        this.borderPoints.put(Map.Direction.N, new Point2D.Float(this.halfWidth - ddx, dy + ddy));
        this.borderPoints.put(Map.Direction.NE, new Point2D.Float(this.halfWidth + ddx, dy + ddy));
        this.borderPoints.put(Map.Direction.E, new Point2D.Float(this.tileWidth - dx - ddx, this.halfHeight - ddy));
        this.borderPoints.put(Map.Direction.SE, new Point2D.Float(this.tileWidth - dx - ddx, this.halfHeight + ddy));
        this.borderPoints.put(Map.Direction.S, new Point2D.Float(this.halfWidth + ddx, this.tileHeight - dy - ddy));
        this.borderPoints.put(Map.Direction.SW, new Point2D.Float(this.halfWidth - ddx, this.tileHeight - dy - ddy));
        this.borderPoints.put(Map.Direction.W, new Point2D.Float(dx + ddx, this.halfHeight + ddy));
        this.prohibitedRoads.put(Map.Direction.N, Arrays.asList(Map.Direction.NW, Map.Direction.NE));
        this.prohibitedRoads.put(Map.Direction.NE, Arrays.asList(Map.Direction.N, Map.Direction.E));
        this.prohibitedRoads.put(Map.Direction.E, Arrays.asList(Map.Direction.NE, Map.Direction.SE));
        this.prohibitedRoads.put(Map.Direction.SE, Arrays.asList(Map.Direction.E, Map.Direction.S));
        this.prohibitedRoads.put(Map.Direction.S, Arrays.asList(Map.Direction.SE, Map.Direction.SW));
        this.prohibitedRoads.put(Map.Direction.SW, Arrays.asList(Map.Direction.S, Map.Direction.W));
        this.prohibitedRoads.put(Map.Direction.W, Arrays.asList(Map.Direction.SW, Map.Direction.NW));
        this.prohibitedRoads.put(Map.Direction.NW, Arrays.asList(Map.Direction.W, Map.Direction.N));
        this.borderStroke = new BasicStroke(dy);
        this.roadStroke = new BasicStroke(dy / 2);
        this.gridStroke = new BasicStroke(lib.getScalingFactor());
        this.fog.reset();
        this.fog.moveTo(this.halfWidth, 0.0f);
        this.fog.lineTo(this.tileWidth, this.halfHeight);
        this.fog.lineTo(this.halfWidth, this.tileHeight);
        this.fog.lineTo(0.0f, this.halfHeight);
        this.fog.closePath();
        this.updateMapDisplayVariables();
    }

    private void updateMapDisplayVariables() {
        this.topSpace = (this.size.height - this.tileHeight) / 2;
        this.topRows = this.topSpace % this.halfHeight != 0 ? this.topSpace / this.halfHeight + 2 : this.topSpace / this.halfHeight + 1;
        this.bottomRows = this.topRows;
        this.rightSpace = this.leftSpace = (this.size.width - this.tileWidth) / 2;
    }

    class TextSpecification {
        public String text;
        public Font font;

        public TextSpecification(String newText, Font newFont) {
            this.text = newText;
            this.font = newFont;
        }
    }

    static class GrayLayer
    extends Component {
        private static final Color MASK_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.6f);
        private static final int DEFAULT_FONT_SIZE = 18;
        private static final int FONT_SIZE_DECREMENT = 2;
        private static final int MAX_TEXT_WIDTH = 640;
        private ImageLibrary imageLibrary;
        private Player player;

        public GrayLayer(ImageLibrary imageLibrary) {
            this.imageLibrary = imageLibrary;
        }

        public void paint(Graphics g) {
            Rectangle textBounds;
            Rectangle clipArea = g.getClipBounds();
            if (clipArea == null) {
                clipArea = this.getBounds();
                clipArea.y = 0;
                clipArea.x = 0;
            }
            if (clipArea.isEmpty()) {
                return;
            }
            g.setColor(MASK_COLOR);
            g.fillRect(clipArea.x, clipArea.y, clipArea.width, clipArea.height);
            if (this.player == null) {
                return;
            }
            ImageIcon coatOfArmsIcon = this.imageLibrary.getCoatOfArmsImageIcon(this.player.getNation());
            Rectangle iconBounds = new Rectangle();
            if (coatOfArmsIcon != null) {
                iconBounds.width = coatOfArmsIcon.getIconWidth();
                iconBounds.height = coatOfArmsIcon.getIconHeight();
            }
            Font nameFont = this.getFont();
            FontMetrics nameFontMetrics = this.getFontMetrics(nameFont);
            StringTemplate t = StringTemplate.template("waitingFor").addStringTemplate("%nation%", this.player.getNationName());
            String message = Messages.message(t);
            int fontSize = 18;
            int maxWidth = Math.min(640, this.getSize().width);
            do {
                nameFont = nameFont.deriveFont(1, fontSize);
                nameFontMetrics = this.getFontMetrics(nameFont);
                textBounds = nameFontMetrics.getStringBounds(message, g).getBounds();
                fontSize -= 2;
            } while (textBounds.width > maxWidth);
            Dimension size = this.getSize();
            textBounds.x = (size.width - textBounds.width) / 2;
            textBounds.y = size.height - 128 - 2 * textBounds.height;
            iconBounds.x = (size.width - iconBounds.width) / 2;
            iconBounds.y = textBounds.y + 3 * textBounds.height / 2;
            if (textBounds.intersects(clipArea)) {
                g.setFont(nameFont);
                g.setColor(this.imageLibrary.getColor(this.player));
                g.drawString(message, textBounds.x, textBounds.y + textBounds.height);
            }
            if (coatOfArmsIcon != null && iconBounds.intersects(clipArea)) {
                coatOfArmsIcon.paintIcon(this, g, iconBounds.x, iconBounds.y);
            }
        }

        public void setPlayer(Player player) {
            if (this.player == player) {
                return;
            }
            this.player = player;
            this.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BorderType {
        COUNTRY,
        REGION;

    }
}

