/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.TilePopup;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.AboutPanel;
import net.sf.freecol.client.gui.panel.BuildQueuePanel;
import net.sf.freecol.client.gui.panel.CaptureGoodsDialog;
import net.sf.freecol.client.gui.panel.ChatPanel;
import net.sf.freecol.client.gui.panel.ChoiceDialog;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ChooseFoundingFatherDialog;
import net.sf.freecol.client.gui.panel.ClientOptionsDialog;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.CompactLabourReport;
import net.sf.freecol.client.gui.panel.ConfirmDeclarationDialog;
import net.sf.freecol.client.gui.panel.DeclarationDialog;
import net.sf.freecol.client.gui.panel.DifficultyDialog;
import net.sf.freecol.client.gui.panel.DumpCargoDialog;
import net.sf.freecol.client.gui.panel.EditSettlementDialog;
import net.sf.freecol.client.gui.panel.EmigrationPanel;
import net.sf.freecol.client.gui.panel.EndTurnDialog;
import net.sf.freecol.client.gui.panel.ErrorPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.EventPanel;
import net.sf.freecol.client.gui.panel.FindSettlementDialog;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GameOptionsDialog;
import net.sf.freecol.client.gui.panel.IndianSettlementPanel;
import net.sf.freecol.client.gui.panel.InformationDialog;
import net.sf.freecol.client.gui.panel.LabourData;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.client.gui.panel.MainPanel;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MapGeneratorOptionsDialog;
import net.sf.freecol.client.gui.panel.MonarchPanel;
import net.sf.freecol.client.gui.panel.NegotiationDialog;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.client.gui.panel.PreCombatDialog;
import net.sf.freecol.client.gui.panel.RecruitDialog;
import net.sf.freecol.client.gui.panel.ReportCargoPanel;
import net.sf.freecol.client.gui.panel.ReportColonyPanel;
import net.sf.freecol.client.gui.panel.ReportContinentalCongressPanel;
import net.sf.freecol.client.gui.panel.ReportEducationPanel;
import net.sf.freecol.client.gui.panel.ReportExplorationPanel;
import net.sf.freecol.client.gui.panel.ReportForeignAffairPanel;
import net.sf.freecol.client.gui.panel.ReportHighScoresPanel;
import net.sf.freecol.client.gui.panel.ReportHistoryPanel;
import net.sf.freecol.client.gui.panel.ReportIndianPanel;
import net.sf.freecol.client.gui.panel.ReportLabourPanel;
import net.sf.freecol.client.gui.panel.ReportMilitaryPanel;
import net.sf.freecol.client.gui.panel.ReportNavalPanel;
import net.sf.freecol.client.gui.panel.ReportProductionPanel;
import net.sf.freecol.client.gui.panel.ReportReligiousPanel;
import net.sf.freecol.client.gui.panel.ReportRequirementsPanel;
import net.sf.freecol.client.gui.panel.ReportTradePanel;
import net.sf.freecol.client.gui.panel.ReportTurnPanel;
import net.sf.freecol.client.gui.panel.RiverStylePanel;
import net.sf.freecol.client.gui.panel.SelectAmountDialog;
import net.sf.freecol.client.gui.panel.SelectDestinationDialog;
import net.sf.freecol.client.gui.panel.ServerListPanel;
import net.sf.freecol.client.gui.panel.StartGamePanel;
import net.sf.freecol.client.gui.panel.StatisticsPanel;
import net.sf.freecol.client.gui.panel.StatusPanel;
import net.sf.freecol.client.gui.panel.TilePanel;
import net.sf.freecol.client.gui.panel.TradeRouteDialog;
import net.sf.freecol.client.gui.panel.TradeRouteInputDialog;
import net.sf.freecol.client.gui.panel.TrainDialog;
import net.sf.freecol.client.gui.panel.VictoryPanel;
import net.sf.freecol.client.gui.panel.WarehouseDialog;
import net.sf.freecol.client.gui.panel.WorkProductionPanel;
import net.sf.freecol.client.gui.video.VideoComponent;
import net.sf.freecol.client.gui.video.VideoListener;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.Video;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Canvas
extends JDesktopPane {
    private static final Logger logger = Logger.getLogger(Canvas.class.getName());
    private static final Integer MAIN_LAYER = JLayeredPane.DEFAULT_LAYER;
    private static final Integer STATUS_LAYER = JLayeredPane.POPUP_LAYER;
    private FreeColDialog<Integer> europeOpenDialog = null;
    private final FreeColClient freeColClient;
    private GUI gui;
    private MainPanel mainPanel;
    private final StartGamePanel startGamePanel;
    private final EuropePanel europePanel;
    private final StatusPanel statusPanel;
    private final ChatPanel chatPanel;
    private final MapViewer mapViewer;
    private final ServerListPanel serverListPanel;
    private final ClientOptionsDialog clientOptionsDialog;
    private final LoadingSavegameDialog loadingSavegameDialog;
    private boolean clientOptionsDialogShowing = false;
    private MapControls mapControls;
    private Dimension oldSize = null;
    private Dimension initialSize = null;

    public Canvas(FreeColClient client, GUI gui, Dimension size, MapViewer mapViewer) {
        this.freeColClient = client;
        this.gui = gui;
        this.mapViewer = mapViewer;
        this.initialSize = size;
        this.setLocation(0, 0);
        this.setSize(size);
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setLayout(null);
        this.startGamePanel = new StartGamePanel(this.freeColClient, gui);
        this.serverListPanel = new ServerListPanel(this.freeColClient, gui, this.freeColClient.getConnectController());
        this.europePanel = new EuropePanel(this.freeColClient, gui, this);
        this.statusPanel = new StatusPanel(this.freeColClient, gui);
        this.chatPanel = new ChatPanel(this.freeColClient, gui);
        this.clientOptionsDialog = new ClientOptionsDialog(this.freeColClient, gui);
        this.loadingSavegameDialog = new LoadingSavegameDialog(this.freeColClient, gui);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread("FreeColClient:Quitting Game"){

            public void run() {
                Canvas.this.freeColClient.getConnectController().quitGame(true);
            }
        });
        this.createKeyBindings();
        logger.info("Canvas created.");
    }

    @Override
    public Component add(Component comp) {
        this.add(comp, null);
        return comp;
    }

    public void add(Component comp, Integer i) {
        this.add(comp, i, true);
    }

    public void add(Component comp, Integer i, boolean update) {
        if (comp != this.statusPanel && !(comp instanceof JMenuItem) && !(comp instanceof FreeColDialog) && this.statusPanel.isVisible()) {
            this.remove(this.statusPanel, false);
        }
        try {
            if (i == null) {
                super.add(comp);
            } else {
                super.add(comp, i);
            }
        }
        catch (Exception e) {
            logger.warning("add component failed with layer " + i);
            e.printStackTrace();
        }
        if (update) {
            this.gui.updateMenuBar();
            this.freeColClient.getActionManager().update();
        }
    }

    public JInternalFrame addAsFrame(JComponent comp) {
        return this.addAsFrame(comp, false, PopupPosition.CENTERED);
    }

    public JInternalFrame addAsToolBox(JComponent comp) {
        return this.addAsFrame(comp, true, PopupPosition.CENTERED);
    }

    public void closeMainPanel() {
        if (this.mainPanel != null) {
            this.remove(this.mainPanel);
            this.mainPanel = null;
        }
    }

    public void closeStatusPanel() {
        if (this.statusPanel.isVisible()) {
            this.remove(this.statusPanel);
        }
    }

    public boolean containsInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        if (keyListeners.length > 0) {
            return true;
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        if (mouseListeners.length > 0) {
            return true;
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        return mouseMotionListeners.length > 0;
    }

    public void debugForeignColony(Settlement settlement) {
        if (settlement instanceof Colony) {
            FreeColGameObject fcgo = this.freeColClient.getFreeColServer().getGame().getFreeColGameObject(settlement.getId());
            this.showColonyPanel((Colony)fcgo);
        }
    }

    public void errorMessage(String messageID, String message) {
        String display = null;
        if (messageID != null) {
            display = Messages.message(messageID);
        }
        if (display == null || "".equals(display)) {
            display = message;
        }
        ErrorPanel errorPanel = new ErrorPanel(this.freeColClient, this.gui, display);
        this.showSubPanel(errorPanel);
    }

    public LoadingSavegameDialog getLoadingSavegameDialog() {
        return this.loadingSavegameDialog;
    }

    public MapControls getMapControls() {
        return this.mapControls;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(640, 480);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.initialSize;
    }

    public Component getShowingSubPanel() {
        Component[] components;
        for (Component c : components = this.getComponents()) {
            if (c instanceof ToolBoxFrame) continue;
            if (c instanceof JInternalFrame) {
                return c;
            }
            if (!(c instanceof JInternalFrame.JDesktopIcon)) continue;
            return c;
        }
        return null;
    }

    public boolean isClientOptionsDialogShowing() {
        return this.clientOptionsDialogShowing;
    }

    public boolean isMapboardActionsEnabled() {
        return !this.isShowingSubPanel();
    }

    public boolean isShowingSubPanel() {
        return this.getShowingSubPanel() != null;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.updateSizes();
        Graphics2D g2d = (Graphics2D)g;
        this.mapViewer.display(g2d);
    }

    public void refreshPlayersTable() {
        this.startGamePanel.refreshPlayersTable();
    }

    @Override
    public void remove(Component comp) {
        this.remove(comp, true);
    }

    public void remove(Component comp, boolean update) {
        boolean takeFocus;
        if (comp == null) {
            return;
        }
        if (comp instanceof FreeColPanel) {
            ((FreeColPanel)comp).notifyClose();
        }
        Rectangle updateBounds = comp.getBounds();
        JInternalFrame frame = this.getInternalFrame(comp);
        if (frame != null && frame != comp) {
            frame.dispose();
        } else {
            super.remove(comp);
        }
        this.repaint(updateBounds.x, updateBounds.y, updateBounds.width, updateBounds.height);
        boolean bl = takeFocus = comp != this.statusPanel;
        if (update) {
            this.gui.updateMenuBar();
            this.freeColClient.getActionManager().update();
            if (takeFocus && !this.isShowingSubPanel()) {
                this.requestFocus();
            }
        }
    }

    public void removeInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        for (int i = 0; i < keyListeners.length; ++i) {
            this.removeKeyListener(keyListeners[i]);
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        for (int i = 0; i < mouseListeners.length; ++i) {
            this.removeMouseListener(mouseListeners[i]);
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListeners.length; ++i) {
            this.removeMouseMotionListener(mouseMotionListeners[i]);
        }
        this.gui.getMapViewer().getViewMode().changeViewMode(0);
        for (Component c : this.getComponents()) {
            this.remove(c, false);
        }
    }

    public void returnToTitle() {
        this.closeMenus();
        this.removeInGameComponents();
        this.showMainPanel();
        this.gui.playSound("sound.intro.general");
        this.repaint();
    }

    public void showAboutPanel() {
        this.showSubPanel(new AboutPanel(this.freeColClient, this.gui));
    }

    public ScoutIndianSettlementAction showArmedUnitIndianSettlementDialog(IndianSettlement settlement) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.tribute"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.attack"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_ATTACK));
        String messageId = settlement.getAlarmLevelMessageId(this.freeColClient.getMyPlayer());
        ScoutIndianSettlementAction result = (ScoutIndianSettlementAction)((Object)this.showChoiceDialog(settlement.getTile(), Messages.message(StringTemplate.template(messageId).addStringTemplate("%nation%", settlement.getOwner().getNationName())), Messages.message("cancel"), choices));
        return result == null ? ScoutIndianSettlementAction.CANCEL : result;
    }

    public BoycottAction showBoycottedGoodsDialog(Goods goods, Europe europe) {
        int arrears = europe.getOwner().getArrears(goods.getType());
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<BoycottAction>(Messages.message("boycottedGoods.payArrears"), BoycottAction.PAY_ARREARS));
        choices.add(new ChoiceItem<BoycottAction>(Messages.message("boycottedGoods.dumpGoods"), BoycottAction.DUMP_CARGO));
        BoycottAction result = (BoycottAction)((Object)this.showChoiceDialog(null, Messages.message(StringTemplate.template("boycottedGoods.text").add("%goods%", goods.getNameKey()).add("%europe%", europe.getNameKey()).addAmount("%amount%", arrears)), Messages.message("cancel"), choices));
        return result == null ? BoycottAction.CANCEL : result;
    }

    public void showBuildQueuePanel(Colony colony) {
        this.showSubPanel(new BuildQueuePanel(this.freeColClient, this.gui, colony));
    }

    public void showBuildQueuePanel(Colony colony, Runnable callBack) {
        BuildQueuePanel panel = new BuildQueuePanel(this.freeColClient, this.gui, colony);
        panel.addClosingCallback(callBack);
        this.showSubPanel(panel);
    }

    public BuyAction showBuyDialog(Unit unit, Settlement settlement, Goods goods, int gold, boolean canBuy) {
        StringTemplate goodsTemplate = StringTemplate.template("model.goods.goodsAmount").add("%goods%", goods.getType().getNameKey()).addAmount("%amount%", goods.getAmount());
        StringTemplate nation = settlement.getOwner().getNationName();
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<BuyAction>(Messages.message("buy.takeOffer"), BuyAction.BUY, canBuy));
        choices.add(new ChoiceItem<BuyAction>(Messages.message("buy.moreGold"), BuyAction.HAGGLE));
        BuyAction result = (BuyAction)((Object)this.showChoiceDialog(unit.getTile(), Messages.message(StringTemplate.template("buy.text").addStringTemplate("%nation%", nation).addStringTemplate("%goods%", goodsTemplate).addAmount("%gold%", gold)), Messages.message("buyProposition.cancel"), choices));
        return result == null ? BuyAction.CANCEL : result;
    }

    public List<Goods> showCaptureGoodsDialog(Unit winner, List<Goods> loot) {
        CaptureGoodsDialog dialog = new CaptureGoodsDialog(this.freeColClient, this.gui, winner, loot);
        return this.showFreeColDialog(dialog, winner.getTile());
    }

    public void showChatPanel() {
        if (this.freeColClient.isSingleplayer()) {
            return;
        }
        this.showSubPanel(this.chatPanel);
    }

    public <T> T showChoiceDialog(Tile tile, String text, String cancelText, List<ChoiceItem<T>> choices) {
        ChoiceItem<T> response;
        FreeColDialog<ChoiceItem<T>> choiceDialog = FreeColDialog.createChoiceDialog(this.freeColClient, this.gui, text, cancelText, choices);
        if (choiceDialog.getHeight() > this.getHeight() / 3) {
            choiceDialog.setSize(choiceDialog.getWidth(), this.getHeight() * 2 / 3);
        }
        return (response = this.showFreeColDialog(choiceDialog, tile)) == null ? null : (T)response.getObject();
    }

    public Monarch.MonarchAction showChoiceMonarchActionDialog(String monarchTitle, List<ChoiceItem<Monarch.MonarchAction>> actions) {
        ChoiceDialog choiceDialog = new ChoiceDialog(this.freeColClient, this.gui, monarchTitle, "Cancel", actions);
        return (Monarch.MonarchAction)((Object)this.showFreeColDialog(choiceDialog));
    }

    public FoundingFather showChooseFoundingFatherDialog(List<ChoiceItem<FoundingFather>> fathers, String fatherTitle) {
        ChoiceDialog choiceDialog = new ChoiceDialog(this.freeColClient, this.gui, fatherTitle, "Cancel", fathers);
        return (FoundingFather)this.showFreeColDialog(choiceDialog);
    }

    public FoundingFather showChooseFoundingFatherDialog(List<FoundingFather> ffs) {
        return this.showFreeColDialog(new ChooseFoundingFatherDialog(this.freeColClient, this.gui, ffs));
    }

    public ClaimAction showClaimDialog(Tile tile, Player player, int price, Player owner, boolean canAccept) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ClaimAction>(Messages.message(StringTemplate.template("indianLand.pay").addAmount("%amount%", price)), ClaimAction.ACCEPT, canAccept));
        choices.add(new ChoiceItem<ClaimAction>(Messages.message("indianLand.take"), ClaimAction.STEAL));
        ClaimAction result = (ClaimAction)((Object)this.showChoiceDialog(tile, Messages.message(StringTemplate.template("indianLand.text").addStringTemplate("%player%", owner.getNationName())), Messages.message("indianLand.cancel"), choices));
        return result == null ? ClaimAction.CANCEL : result;
    }

    public OptionGroup showClientOptionsDialog() {
        this.clientOptionsDialog.initialize();
        this.clientOptionsDialogShowing = true;
        OptionGroup group = this.showFreeColDialog(this.clientOptionsDialog);
        this.clientOptionsDialogShowing = false;
        this.freeColClient.getActionManager().update();
        return group;
    }

    public void showColonyPanel(Colony colony, Runnable callback) {
        ColonyPanel panel = new ColonyPanel(this.freeColClient, this.gui, colony);
        panel.addClosingCallback(callback);
        this.showSubPanel(panel);
    }

    public void showColonyPanel(Tile t) {
        if (this.gui.getCurrentViewMode() == 0 && t != null && t.getColony() != null && this.freeColClient.getMyPlayer().owns(t.getColony())) {
            this.mapViewer.setFocus(t);
            this.mapViewer.stopBlinking();
            this.showColonyPanel(t.getColony());
        }
    }

    public void showColopediaPanel(String nodeId) {
        this.showSubPanel(new ColopediaPanel(this.freeColClient, this.gui, nodeId));
    }

    public void showCompactLabourReport() {
        this.showSubPanel(new CompactLabourReport(this.freeColClient, this.gui));
    }

    public void showCompactLabourReport(LabourData.UnitData unitData) {
        CompactLabourReport details = new CompactLabourReport(this.freeColClient, this.gui, unitData);
        details.initialize();
        this.addAsFrame(details);
        details.requestFocus();
    }

    public List<String> showConfirmDeclarationDialog() {
        return this.showFreeColDialog(new ConfirmDeclarationDialog(this.freeColClient, this.gui));
    }

    public boolean showConfirmDialog(String text, String okText, String cancelText) {
        return this.showFreeColDialog(FreeColDialog.createConfirmDialog(this.freeColClient, this.gui, Messages.message(text), Messages.message(okText), Messages.message(cancelText)), null);
    }

    public boolean showConfirmDialog(Tile tile, ModelMessage[] messages, String okText, String cancelText) {
        String[] texts = new String[messages.length];
        ImageIcon[] images = new ImageIcon[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            texts[i] = Messages.message(messages[i]);
            images[i] = this.gui.getImageIcon(this.freeColClient.getGame().getMessageDisplay(messages[i]), false);
        }
        FreeColDialog<Boolean> confirmDialog = FreeColDialog.createConfirmDialog(this.freeColClient, this.gui, texts, images, Messages.message(okText), Messages.message(cancelText));
        return this.showFreeColDialog(confirmDialog, tile);
    }

    public boolean showConfirmDialog(Tile tile, StringTemplate text, String okText, String cancelText) {
        return this.showFreeColDialog(FreeColDialog.createConfirmDialog(this.freeColClient, this.gui, Messages.message(text), Messages.message(okText), Messages.message(cancelText)), tile);
    }

    public void showDeclarationDialog() {
        this.showFreeColDialog(new DeclarationDialog(this.freeColClient, this.gui));
    }

    public void showDifficultyDialog() {
        this.showSubPanel(new DifficultyDialog(this.freeColClient, this.gui, this.freeColClient.getGame().getDifficultyLevel()));
    }

    public OptionGroup showDifficultyDialog(Specification specification) {
        return this.showFreeColDialog(new DifficultyDialog(this.freeColClient, this.gui, specification));
    }

    public List<Goods> showDumpCargoDialog(Unit unit) {
        DumpCargoDialog dumpDialog = new DumpCargoDialog(this.freeColClient, this.gui, unit);
        return this.showFreeColDialog(dumpDialog, unit.getTile());
    }

    public void showEditSettlementDialog(IndianSettlement settlement) {
        this.showFreeColDialog(new EditSettlementDialog(this.freeColClient, this.gui, settlement));
    }

    public int showEmigrationPanel(boolean fountainOfYouth) {
        EmigrationPanel emigrationPanel = new EmigrationPanel(this.freeColClient, this.gui);
        emigrationPanel.initialize(this.freeColClient.getMyPlayer().getEurope(), fountainOfYouth);
        return this.showFreeColDialog(emigrationPanel);
    }

    public boolean showEndTurnDialog(List<Unit> units) {
        return this.showFreeColDialog(new EndTurnDialog(this.freeColClient, this.gui, units));
    }

    public int showEuropeDialog(EuropePanel.EuropeAction europeAction) {
        try {
            if (this.europeOpenDialog != null) {
                this.europeOpenDialog.setResponse(new Integer(-1));
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Canvas.showEuropeDialog: Invalid europeDialogType");
        }
        FreeColDialog localDialog = null;
        switch (europeAction) {
            case EXIT: 
            case UNLOAD: 
            case SAIL: {
                return -1;
            }
            case RECRUIT: {
                localDialog = new RecruitDialog(this.freeColClient, this.gui);
                break;
            }
            case PURCHASE: 
            case TRAIN: {
                localDialog = new TrainDialog(this.freeColClient, this.gui, europeAction);
            }
        }
        localDialog.initialize();
        this.europeOpenDialog = localDialog;
        int response = (Integer)this.showFreeColDialog(localDialog);
        if (this.europeOpenDialog == localDialog) {
            this.europeOpenDialog = null;
        }
        return response;
    }

    public void showEuropePanel() {
        if (this.freeColClient.getGame() == null) {
            this.errorMessage("europe.noGame");
        } else {
            this.europePanel.initialize(this.freeColClient.getMyPlayer().getEurope(), this.freeColClient.getGame());
            this.showSubPanel(this.europePanel);
        }
    }

    public void showEventPanel(EventType type) {
        this.showSubPanel(new EventPanel(this.freeColClient, this.gui, type), PopupPosition.CENTERED);
    }

    public void showFindSettlementDialog() {
        this.showSubPanel(new FindSettlementDialog(this.freeColClient, this.gui), PopupPosition.ORIGIN);
    }

    public <T> T showFreeColDialog(FreeColDialog<T> freeColDialog) {
        return this.showFreeColDialog(freeColDialog, null);
    }

    public void showGameOptionsDialog(boolean editable, boolean loadCustomOptions) {
        this.showSubPanel(new GameOptionsDialog(this.freeColClient, this.gui, editable, loadCustomOptions));
    }

    public void showHighScoresPanel(String messageId) {
        this.showSubPanel(new ReportHighScoresPanel(this.freeColClient, this.gui, messageId), PopupPosition.ORIGIN);
    }

    public void showIndianSettlementPanel(IndianSettlement indianSettlement) {
        IndianSettlementPanel panel = new IndianSettlementPanel(this.freeColClient, this.gui, indianSettlement);
        this.showFreeColPanel(panel, indianSettlement.getTile());
    }

    public TradeAction showIndianSettlementTradeDialog(Settlement settlement, boolean canBuy, boolean canSell, boolean canGift) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toBuy"), TradeAction.BUY, canBuy));
        choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toSell"), TradeAction.SELL, canSell));
        choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toGift"), TradeAction.GIFT, canGift));
        TradeAction result = (TradeAction)((Object)this.showChoiceDialog(settlement.getTile(), Messages.message(StringTemplate.template("tradeProposition.welcome").addStringTemplate("%nation%", settlement.getOwner().getNationName()).addName("%settlement%", settlement.getName())), Messages.message("tradeProposition.cancel"), choices));
        return result == null ? TradeAction.CANCEL : result;
    }

    public void showInformationMessage(FreeColObject displayObject, String messageId) {
        this.showInformationMessage(displayObject, StringTemplate.key(messageId));
    }

    public void showInformationMessage(FreeColObject displayObject, StringTemplate template) {
        String text = Messages.message(template);
        ImageIcon icon = null;
        if (displayObject != null) {
            icon = this.gui.getImageIcon(displayObject, false);
        }
        Tile tile = null;
        if (displayObject instanceof Tile) {
            tile = (Tile)displayObject;
        } else {
            try {
                tile = (Tile)displayObject.getClass().getMethod("getTile", new Class[0]).invoke((Object)displayObject, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.audioAlerts")) {
            this.gui.playSound("sound.event.alertSound");
        }
        this.showFreeColPanel(new InformationDialog(this.freeColClient, this.gui, text, icon), tile);
    }

    public void showInformationMessage(ModelMessage message) {
        this.showInformationMessage(this.freeColClient.getGame().getMessageDisplay(message), message);
    }

    public void showInformationMessage(String messageId) {
        this.showInformationMessage(null, StringTemplate.key(messageId));
    }

    public void showInformationMessage(StringTemplate template) {
        this.showInformationMessage(null, template);
    }

    public String showInputDialog(Tile tile, StringTemplate text, String defaultValue, String okText, String cancelText, boolean rejectEmptyString) {
        FreeColDialog<String> inputDialog = FreeColDialog.createInputDialog(this.freeColClient, this.gui, Messages.message(text), defaultValue, Messages.message(okText), cancelText == null ? null : Messages.message(cancelText));
        String response = null;
        while (true) {
            response = this.showFreeColDialog(inputDialog, tile);
            if (!rejectEmptyString || response == null || response.length() > 0) break;
            this.showFreeColPanel(new InformationDialog(this.freeColClient, this.gui, Messages.message("enterSomeText"), null), tile);
        }
        return response;
    }

    public File showLoadDialog(File directory) {
        return this.showLoadDialog(directory, new FileFilter[]{FreeColDialog.getFSGFileFilter()});
    }

    public File showLoadDialog(File directory, FileFilter[] fileFilters) {
        FreeColDialog<File> loadDialog = FreeColDialog.createLoadDialog(this.freeColClient, this.gui, directory, fileFilters);
        File response = null;
        this.showSubPanel(loadDialog);
        while ((response = loadDialog.getResponse()) != null && !response.isFile()) {
            this.errorMessage("noSuchFile");
        }
        this.remove(loadDialog);
        return response;
    }

    public boolean showLoadingSavegameDialog(boolean publicServer, boolean singleplayer) {
        this.loadingSavegameDialog.initialize(publicServer, singleplayer);
        return this.showFreeColDialog(this.loadingSavegameDialog);
    }

    public void showLogFilePanel() {
        this.showSubPanel(new ErrorPanel(this.freeColClient, this.gui));
    }

    public void showMainPanel() {
        this.closeMenus();
        this.gui.setupMenuBarToNull();
        this.mainPanel = new MainPanel(this.freeColClient, this.gui);
        this.addCentered(this.mainPanel, MAIN_LAYER);
        this.mainPanel.requestFocus();
    }

    public OptionGroup showMapGeneratorOptionsDialog(OptionGroup mgo, boolean editable, boolean loadCustomOptions) {
        return this.showFreeColDialog(new MapGeneratorOptionsDialog(this.freeColClient, this.gui, mgo, editable, loadCustomOptions));
    }

    public Dimension showMapSizeDialog() {
        return this.showFreeColDialog(FreeColDialog.createMapSizeDialog(this.freeColClient, this.gui));
    }

    public void showModelMessages(ModelMessage ... modelMessages) {
        List<ModelMessage> messages = this.filterEventPanels(modelMessages);
        if (messages.size() <= 0) {
            return;
        }
        Game game = this.freeColClient.getGame();
        String[] messageText = new String[messages.size()];
        ImageIcon[] messageIcon = new ImageIcon[messages.size()];
        for (int i = 0; i < messages.size(); ++i) {
            messageText[i] = Messages.message(messages.get(i));
            messageIcon[i] = this.gui.getImageIcon(game.getMessageDisplay(messages.get(i)), false);
        }
        FreeColGameObject source = game.getMessageSource(messages.get(0));
        if (source instanceof Europe && !this.europePanel.isShowing() || source instanceof Colony || source instanceof WorkLocation) {
            FreeColDialog<Boolean> confirmDialog = FreeColDialog.createConfirmDialog(this.freeColClient, this.gui, messageText, messageIcon, Messages.message("ok"), Messages.message("display"));
            if (this.showFreeColDialog(confirmDialog).booleanValue()) {
                if (!this.isShowingSubPanel()) {
                    this.freeColClient.getInGameController().nextModelMessage();
                }
            } else if (source instanceof Europe) {
                this.showEuropePanel();
            } else if (source instanceof Colony) {
                this.showColonyPanel((Colony)source);
            } else if (source instanceof WorkLocation) {
                this.showColonyPanel(((WorkLocation)source).getColony());
            }
        } else {
            this.showSubPanel(new InformationDialog(this.freeColClient, this.gui, messageText, messageIcon));
            if (!this.isShowingSubPanel()) {
                this.freeColClient.getInGameController().nextModelMessage();
            }
        }
    }

    public boolean showMonarchPanelDialog(Monarch.MonarchAction action, StringTemplate replace) {
        return this.showFreeColDialog(new MonarchPanel(this.freeColClient, this.gui, action, replace));
    }

    public DiplomaticTrade showNegotiationDialog(Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        NegotiationDialog negotiationDialog = new NegotiationDialog(this.freeColClient, this.gui, unit, settlement, agreement);
        negotiationDialog.initialize();
        return this.showFreeColDialog(negotiationDialog, unit.getTile());
    }

    public void showNewPanel() {
        this.showSubPanel(new NewPanel(this.freeColClient, this.gui));
    }

    public void showNewPanel(Specification specification) {
        this.showSubPanel(new NewPanel(this.freeColClient, this.gui, specification));
    }

    public void showOpenGamePanel() {
        this.errorMessage("openGame.unimplemented");
    }

    public void showOpeningVideoPanel() {
        this.closeMenus();
        Video video = ResourceManager.getVideo("Opening.video");
        boolean muteAudio = !this.gui.canPlaySound();
        final VideoComponent vp = new VideoComponent(video, muteAudio);
        this.addCentered(vp, MAIN_LAYER);
        vp.play();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class AbortListener
        implements KeyListener,
        MouseListener,
        VideoListener {
            AbortListener() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.execute();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.execute();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void stopped() {
                this.execute();
            }

            private void execute() {
                Canvas.this.removeKeyListener(this);
                Canvas.this.removeMouseListener(this);
                vp.removeMouseListener(this);
                vp.removeVideoListener(this);
                vp.stop();
                Canvas.this.remove(vp);
                Canvas.this.showMainPanel();
                Canvas.this.gui.playSound("sound.intro.general");
            }
        }
        AbortListener l = new AbortListener();
        this.addMouseListener(l);
        this.addKeyListener(l);
        vp.addMouseListener(l);
        vp.addVideoListener(l);
    }

    public boolean showPreCombatDialog(FreeColGameObject attacker, FreeColGameObject defender, Tile tile) {
        return this.showFreeColDialog(new PreCombatDialog(this.freeColClient, this.gui, attacker, defender), tile);
    }

    public void showReportCargoPanel() {
        this.showSubPanel(new ReportCargoPanel(this.freeColClient, this.gui));
    }

    public void showReportColonyPanel() {
        this.showSubPanel(new ReportColonyPanel(this.freeColClient, this.gui));
    }

    public void showReportContinentalCongressPanel() {
        this.showSubPanel(new ReportContinentalCongressPanel(this.freeColClient, this.gui));
    }

    public void showReportEducationPanel() {
        this.showSubPanel(new ReportEducationPanel(this.freeColClient, this.gui));
    }

    public void showReportExplorationPanel() {
        this.showSubPanel(new ReportExplorationPanel(this.freeColClient, this.gui));
    }

    public void showReportForeignAffairPanel() {
        this.showSubPanel(new ReportForeignAffairPanel(this.freeColClient, this.gui));
    }

    public void showReportHistoryPanel() {
        this.showSubPanel(new ReportHistoryPanel(this.freeColClient, this.gui));
    }

    public void showReportIndianPanel() {
        this.showSubPanel(new ReportIndianPanel(this.freeColClient, this.gui));
    }

    public void showReportLabourPanel() {
        this.showSubPanel(new ReportLabourPanel(this.freeColClient, this.gui));
    }

    public void showReportMilitaryPanel() {
        this.showSubPanel(new ReportMilitaryPanel(this.freeColClient, this.gui));
    }

    public void showReportNavalPanel() {
        this.showSubPanel(new ReportNavalPanel(this.freeColClient, this.gui));
    }

    public void showReportProductionPanel() {
        this.showSubPanel(new ReportProductionPanel(this.freeColClient, this.gui));
    }

    public void showReportReligiousPanel() {
        this.showSubPanel(new ReportReligiousPanel(this.freeColClient, this.gui));
    }

    public void showReportRequirementsPanel() {
        this.showSubPanel(new ReportRequirementsPanel(this.freeColClient, this.gui));
    }

    public void showReportTradePanel() {
        this.showSubPanel(new ReportTradePanel(this.freeColClient, this.gui));
    }

    public void showReportTurnPanel(ModelMessage ... messages) {
        this.showSubPanel(new ReportTurnPanel(this.freeColClient, this.gui, messages));
    }

    public int showRiverStyleDialog() {
        return this.showFreeColDialog(new RiverStylePanel(this.freeColClient, this.gui));
    }

    public File showSaveDialog(File directory, String defaultName) {
        return this.showSaveDialog(directory, ".fsg", new FileFilter[]{FreeColDialog.getFSGFileFilter()}, defaultName);
    }

    public File showSaveDialog(File directory, String standardName, FileFilter[] fileFilters, String defaultName) {
        FreeColDialog<File> saveDialog = FreeColDialog.createSaveDialog(this.freeColClient, this.gui, directory, standardName, fileFilters, defaultName);
        return this.showFreeColDialog(saveDialog);
    }

    public ScoutColonyAction showScoutForeignColonyDialog(Colony colony, Unit unit, boolean canNegotiate) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.negotiate"), ScoutColonyAction.FOREIGN_COLONY_NEGOTIATE, canNegotiate));
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.spy"), ScoutColonyAction.FOREIGN_COLONY_SPY));
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.attack"), ScoutColonyAction.FOREIGN_COLONY_ATTACK));
        StringTemplate template = StringTemplate.template("scoutColony.text").addStringTemplate("%unit%", Messages.getLabel(unit)).addName("%colony%", colony.getName());
        ScoutColonyAction result = (ScoutColonyAction)((Object)this.showChoiceDialog(unit.getTile(), Messages.message(template), Messages.message("cancel"), choices));
        return result == null ? ScoutColonyAction.CANCEL : result;
    }

    public ScoutIndianSettlementAction showScoutIndianSettlementDialog(IndianSettlement settlement, String number) {
        GoodsType[] wantedGoods;
        StringBuilder text = new StringBuilder(400);
        Player owner = settlement.getOwner();
        text.append(Messages.message(StringTemplate.template(settlement.getAlarmLevelMessageId(this.freeColClient.getMyPlayer())).addStringTemplate("%nation%", owner.getNationName())));
        text.append("\n\n");
        text.append(Messages.message(StringTemplate.template("scoutSettlement.greetings").addStringTemplate("%nation%", settlement.getOwner().getNationName()).addName("%settlement%", settlement.getName()).add("%number%", number).add("%settlementType%", ((IndianNationType)owner.getNationType()).getSettlementTypeKey(true))));
        text.append(" ");
        if (settlement.getLearnableSkill() != null) {
            text.append(Messages.message(StringTemplate.template("scoutSettlement.skill").add("%skill%", settlement.getLearnableSkill().getNameKey())));
            text.append(" ");
        }
        if ((wantedGoods = settlement.getWantedGoods()).length > 0) {
            StringTemplate template = StringTemplate.template("scoutSettlement.trade." + Integer.toString(wantedGoods.length));
            for (int i = 0; i < wantedGoods.length; ++i) {
                if (wantedGoods[i] == null) continue;
                template.add("%goods" + Integer.toString(i + 1) + "%", wantedGoods[i].getNameKey());
            }
            text.append(Messages.message(template) + "\n\n");
        }
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.speak"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_SPEAK));
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.tribute"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.attack"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_ATTACK));
        ScoutIndianSettlementAction result = (ScoutIndianSettlementAction)((Object)this.showChoiceDialog(settlement.getTile(), text.toString(), Messages.message("cancel"), choices));
        return result == null ? ScoutIndianSettlementAction.CANCEL : result;
    }

    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return this.showFreeColDialog(new SelectAmountDialog(this.freeColClient, this.gui, goodsType, available, defaultAmount, needToPay));
    }

    public Location showSelectDestinationDialog(Unit unit) {
        return this.showFreeColDialog(new SelectDestinationDialog(this.freeColClient, this.gui, unit), unit.getTile());
    }

    public SellAction showSellDialog(Unit unit, Settlement settlement, Goods goods, int gold) {
        StringTemplate goodsTemplate = StringTemplate.template("model.goods.goodsAmount").add("%goods%", goods.getType().getNameKey()).addAmount("%amount%", goods.getAmount());
        StringTemplate nation = settlement.getOwner().getNationName();
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<SellAction>(Messages.message("sell.takeOffer"), SellAction.SELL));
        choices.add(new ChoiceItem<SellAction>(Messages.message("sell.moreGold"), SellAction.HAGGLE));
        choices.add(new ChoiceItem<SellAction>(Messages.message(StringTemplate.template("sell.gift").addStringTemplate("%goods%", goodsTemplate)), SellAction.GIFT));
        SellAction result = (SellAction)((Object)this.showChoiceDialog(unit.getTile(), Messages.message(StringTemplate.template("sell.text").addStringTemplate("%nation%", nation).addStringTemplate("%goods%", goodsTemplate).addAmount("%gold%", gold)), Messages.message("sellProposition.cancel"), choices));
        return result == null ? SellAction.CANCEL : result;
    }

    public void showServerListPanel(String username, ArrayList<ServerInfo> serverList) {
        this.closeMenus();
        this.serverListPanel.initialize(username, serverList);
        this.showSubPanel(this.serverListPanel);
    }

    public void showSettlement(Settlement s) {
        if (s instanceof Colony) {
            if (s.getOwner().equals(this.freeColClient.getMyPlayer())) {
                this.showColonyPanel((Colony)s);
            } else if (FreeCol.isInDebugMode()) {
                this.debugForeignColony(s);
            }
        } else if (s instanceof IndianSettlement) {
            this.showIndianSettlementPanel((IndianSettlement)s);
        } else {
            throw new IllegalStateException("Bogus settlement");
        }
    }

    public <T> T showSimpleChoiceDialog(Tile tile, String text, String cancelText, List<T> objects) {
        ArrayList<ChoiceItem<T>> choices = new ArrayList<ChoiceItem<T>>();
        for (T object : objects) {
            choices.add(new ChoiceItem<T>(object));
        }
        return this.showChoiceDialog(tile, Messages.message(text), Messages.message(cancelText), choices);
    }

    public void showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        this.closeMenus();
        if (game != null && player != null) {
            this.startGamePanel.initialize(singlePlayerMode);
            this.showSubPanel(this.startGamePanel);
        } else {
            logger.warning("Tried to open 'StartGamePanel' without having 'game' and/or 'player' set.");
        }
    }

    public void showStatisticsPanel() {
        this.showSubPanel(new StatisticsPanel(this.freeColClient, this.gui));
    }

    public void showStatusPanel(String message) {
        this.statusPanel.setStatusMessage(message);
        this.addCentered(this.statusPanel, STATUS_LAYER);
    }

    public void showTilePanel(Tile tile) {
        this.showSubPanel(new TilePanel(this.freeColClient, this.gui, tile));
    }

    public void showTilePopup(Tile tile, int x, int y) {
        if (tile == null) {
            return;
        }
        TilePopup tp = new TilePopup(this.freeColClient, this.gui, tile);
        if (tp.hasItem()) {
            tp.show(this, x, y);
            tp.repaint();
        } else if (tile.isExplored()) {
            this.showTilePanel(tile);
        }
    }

    public TradeRoute showTradeRouteDialog(TradeRoute tradeRoute, Tile tile) {
        return this.showFreeColDialog(new TradeRouteDialog(this.freeColClient, this.gui, tradeRoute), tile);
    }

    public boolean showTradeRouteInputDialog(TradeRoute newRoute) {
        return this.showFreeColDialog(new TradeRouteInputDialog(this.freeColClient, this.gui, newRoute));
    }

    public MissionaryAction showUseMissionaryDialog(Unit unit, IndianSettlement settlement, boolean canEstablish, boolean canDenounce) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.establish"), MissionaryAction.ESTABLISH_MISSION, canEstablish));
        choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.heresy"), MissionaryAction.DENOUNCE_HERESY, canDenounce));
        choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.incite"), MissionaryAction.INCITE_INDIANS));
        String messageId = settlement.getAlarmLevelMessageId(unit.getOwner());
        StringBuilder introText = new StringBuilder(Messages.message(StringTemplate.template(messageId).addStringTemplate("%nation%", settlement.getOwner().getNationName())));
        introText.append("\n\n");
        introText.append(Messages.message(StringTemplate.template("missionarySettlement.question").addName("%settlement%", settlement.getName())));
        MissionaryAction result = (MissionaryAction)((Object)this.showChoiceDialog(unit.getTile(), introText.toString(), Messages.message("cancel"), choices));
        return result == null ? MissionaryAction.CANCEL : result;
    }

    public void showVictoryPanel() {
        this.showSubPanel(new VictoryPanel(this.freeColClient, this.gui));
    }

    public boolean showWarehouseDialog(Colony colony) {
        return this.showFreeColDialog(new WarehouseDialog(this.freeColClient, this.gui, colony));
    }

    public void showWorkProductionPanel(Unit unit) {
        this.showSubPanel(new WorkProductionPanel(this.freeColClient, this.gui, unit));
    }

    public void updateGameOptions() {
        this.startGamePanel.updateGameOptions();
    }

    public void updateMapGeneratorOptions() {
        this.startGamePanel.updateMapGeneratorOptions();
    }

    public void updateSizes() {
        if (this.oldSize == null) {
            this.oldSize = this.getSize();
        }
        if (this.oldSize.width != this.getWidth() || this.oldSize.height != this.getHeight()) {
            MapControlsAction mca = (MapControlsAction)this.freeColClient.getActionManager().getFreeColAction("mapControlsAction");
            MapControls mc = mca.getMapControls();
            if (mc != null && mc.isShowing()) {
                mc.removeFromComponent(this);
                mc.addToComponent(this);
                this.mapControls = mc;
            }
            this.mapViewer.setSize(this.getSize());
            this.mapViewer.forceReposition();
            this.oldSize = this.getSize();
        }
    }

    void closeMenus() {
        for (JInternalFrame frame : this.getAllFrames()) {
            for (Component c : frame.getContentPane().getComponents()) {
                if (!(c instanceof FreeColPanel)) continue;
                ((FreeColPanel)c).notifyClose();
            }
            frame.dispose();
        }
    }

    void displayChat(String senderNme, String message, boolean privateChat) {
        this.startGamePanel.displayChat(senderNme, message, privateChat);
    }

    void errorMessage(String messageID) {
        this.errorMessage(messageID, "Unspecified error: " + messageID);
    }

    void refresh() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    ColonyPanel showColonyPanel(Colony colony) {
        ColonyPanel panel = this.getColonyPanel(colony);
        if (panel != null) {
            return panel;
        }
        panel = new ColonyPanel(this.freeColClient, this.gui, colony);
        this.showFreeColPanel(panel, colony.getTile());
        return panel;
    }

    private JInternalFrame addAsFrame(JComponent comp, boolean toolBox, PopupPosition popupPosition) {
        JInternalFrame f;
        int FRAME_EMPTY_SPACE = 60;
        JInternalFrame jInternalFrame = f = toolBox ? new ToolBoxFrame() : new JInternalFrame();
        if (f.getContentPane() instanceof JComponent) {
            JComponent c = (JComponent)f.getContentPane();
            c.setOpaque(false);
            c.setBorder(null);
        }
        if (comp.getBorder() != null) {
            if (comp.getBorder() instanceof EmptyBorder) {
                f.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            } else {
                f.setBorder(comp.getBorder());
                comp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            }
        } else {
            f.setBorder(null);
        }
        FrameMotionListener fml = new FrameMotionListener(f);
        comp.addMouseMotionListener(fml);
        comp.addMouseListener(fml);
        if (f.getUI() instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI biu = (BasicInternalFrameUI)f.getUI();
            biu.setNorthPane(null);
            biu.setSouthPane(null);
            biu.setWestPane(null);
            biu.setEastPane(null);
        }
        f.getContentPane().add(comp);
        f.setOpaque(false);
        f.pack();
        int width = f.getWidth();
        int height = f.getHeight();
        if (width > this.getWidth() - 60) {
            width = Math.min(width, this.getWidth());
        }
        if (height > this.getHeight() - 60) {
            height = Math.min(height, this.getHeight());
        }
        f.setSize(width, height);
        Point p = null;
        if (comp instanceof FreeColPanel && this.freeColClient.getClientOptions().getBoolean("model.option.rememberPanelPositions") && (p = ((FreeColPanel)comp).getSavedPosition()) != null && (p.getX() < 0.0 || p.getX() >= (double)(this.getWidth() - f.getWidth()) || p.getY() < 0.0 || p.getY() >= (double)(this.getHeight() - f.getHeight()))) {
            p = null;
        }
        if (p == null) {
            switch (popupPosition) {
                case CENTERED: {
                    f.setLocation((this.getWidth() - f.getWidth()) / 2, (this.getHeight() - f.getHeight()) / 2);
                    break;
                }
                case CENTERED_LEFT: {
                    f.setLocation((this.getWidth() - f.getWidth()) / 4, (this.getHeight() - f.getHeight()) / 2);
                    break;
                }
                case CENTERED_RIGHT: {
                    f.setLocation((this.getWidth() - f.getWidth()) * 3 / 4, (this.getHeight() - f.getHeight()) / 2);
                    break;
                }
                default: {
                    f.setLocation(0, 0);
                    break;
                }
            }
        } else {
            f.setLocation(p);
        }
        this.add((Component)f, MODAL_LAYER);
        f.setName(comp.getClass().getSimpleName());
        f.setFrameIcon(null);
        f.setVisible(true);
        f.setResizable(true);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return f;
    }

    private void addCentered(Component comp, Integer i) {
        comp.setLocation((this.getWidth() - comp.getWidth()) / 2, (this.getHeight() - comp.getHeight()) / 2);
        this.add(comp, i);
    }

    private void createKeyBindings() {
        for (Option option : this.freeColClient.getActionManager().getOptions()) {
            FreeColAction action = (FreeColAction)option;
            this.getInputMap().put(action.getAccelerator(), action.getId());
            this.getActionMap().put(action.getId(), action);
        }
    }

    private List<ModelMessage> filterEventPanels(ModelMessage[] messages) {
        String eventMatch = "EventPanel.";
        ArrayList<ModelMessage> normal = new ArrayList<ModelMessage>();
        for (int i = 0; i < messages.length; ++i) {
            String id = messages[i].getId();
            if (id.startsWith("EventPanel.")) {
                id = id.substring("EventPanel.".length());
                final EventType e = EventType.valueOf(id);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Canvas.this.showEventPanel(e);
                    }
                });
                continue;
            }
            normal.add(messages[i]);
        }
        return normal;
    }

    private ColonyPanel getColonyPanel(Colony colony) {
        for (Component c1 : this.getComponents()) {
            if (!(c1 instanceof JInternalFrame)) continue;
            for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                if (!(c2 instanceof ColonyPanel) || ((ColonyPanel)c2).getColony() != colony) continue;
                return (ColonyPanel)c2;
            }
        }
        return null;
    }

    private JInternalFrame getInternalFrame(Component c) {
        Component temp;
        for (temp = c; temp != null && !(temp instanceof JInternalFrame); temp = temp.getParent()) {
        }
        return (JInternalFrame)temp;
    }

    private PopupPosition getPopupPosition(Tile tile) {
        if (tile == null) {
            return PopupPosition.CENTERED;
        }
        int where = this.mapViewer.setOffsetFocus(tile);
        return where > 0 ? PopupPosition.CENTERED_LEFT : (where < 0 ? PopupPosition.CENTERED_RIGHT : PopupPosition.CENTERED);
    }

    private <T> T showFreeColDialog(FreeColDialog<T> freeColDialog, Tile tile) {
        this.showFreeColPanel(freeColDialog, tile);
        T response = freeColDialog.getResponse();
        this.remove(freeColDialog);
        return response;
    }

    private void showFreeColPanel(FreeColPanel panel, Tile tile) {
        this.showSubPanel(panel, this.getPopupPosition(tile));
    }

    private void showSubPanel(FreeColPanel panel) {
        this.showSubPanel(panel, PopupPosition.CENTERED);
    }

    private void showSubPanel(FreeColPanel panel, PopupPosition popupPosition) {
        this.repaint();
        this.addAsFrame(panel, false, popupPosition);
        panel.requestFocus();
    }

    class ToolBoxFrame
    extends JInternalFrame {
        ToolBoxFrame() {
        }
    }

    class FrameMotionListener
    extends MouseAdapter
    implements MouseMotionListener {
        private JInternalFrame f;
        private Point loc = null;

        FrameMotionListener(JInternalFrame f) {
            this.f = f;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            int moveX = this.loc.x - p.x;
            int moveY = this.loc.y - p.y;
            this.f.getDesktopPane().getDesktopManager().dragFrame(this.f, this.f.getX() - moveX, this.f.getY() - moveY);
            this.loc = p;
        }

        public void mouseMoved(MouseEvent arg0) {
        }

        public void mousePressed(MouseEvent e) {
            if (this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            this.loc = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            this.f.getDesktopPane().getDesktopManager().beginDraggingFrame(this.f);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            this.f.getDesktopPane().getDesktopManager().endDraggingFrame(this.f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TradeAction {
        CANCEL,
        BUY,
        SELL,
        GIFT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SellAction {
        CANCEL,
        SELL,
        HAGGLE,
        GIFT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScoutIndianSettlementAction {
        CANCEL,
        INDIAN_SETTLEMENT_SPEAK,
        INDIAN_SETTLEMENT_TRIBUTE,
        INDIAN_SETTLEMENT_ATTACK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScoutColonyAction {
        CANCEL,
        FOREIGN_COLONY_NEGOTIATE,
        FOREIGN_COLONY_SPY,
        FOREIGN_COLONY_ATTACK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PopupPosition {
        ORIGIN,
        CENTERED,
        CENTERED_LEFT,
        CENTERED_RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MissionaryAction {
        CANCEL,
        ESTABLISH_MISSION,
        DENOUNCE_HERESY,
        INCITE_INDIANS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        FIRST_LANDING,
        MEETING_NATIVES,
        MEETING_EUROPEANS,
        MEETING_AZTEC,
        MEETING_INCA,
        DISCOVER_PACIFIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClaimAction {
        CANCEL,
        ACCEPT,
        STEAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuyAction {
        CANCEL,
        BUY,
        HAGGLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoycottAction {
        CANCEL,
        PAY_ARREARS,
        DUMP_CARGO;

    }
}

