/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class WorkInsideColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(WorkInsideColonyMission.class.getName());
    private AIColony aiColony;

    public WorkInsideColonyMission(AIMain aiMain, AIUnit aiUnit, AIColony aiColony) {
        super(aiMain, aiUnit);
        this.aiColony = aiColony;
    }

    public WorkInsideColonyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public WorkInsideColonyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isValid() {
        return super.isValid() && this.aiColony != null && this.aiColony.getColony() != null && !this.aiColony.getColony().isDisposed() && this.getUnit().getOwner() == this.aiColony.getColony().getOwner();
    }

    public Tile getTransportDestination() {
        Tile colonyTile = this.aiColony.getColony().getTile();
        return this.shouldTakeTransportToTile(colonyTile) ? colonyTile : null;
    }

    public void doMission(Connection connection) {
        if (!this.isValid()) {
            return;
        }
        Tile colonyTile = this.aiColony.getColony().getTile();
        Unit unit = this.getUnit();
        if (!unit.isOnCarrier() && unit.getTile() != null && unit.getTile() != colonyTile) {
            this.moveTowards(colonyTile);
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, WorkInsideColonyMission.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("colony", this.aiColony.getId());
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.aiColony = (AIColony)this.getAIMain().getAIObject(in.getAttributeValue(null, "colony"));
        if (this.aiColony == null) {
            this.aiColony = new AIColony(this.getAIMain(), in.getAttributeValue(null, "colony"));
        }
    }

    public static String getXMLElementTagName() {
        return "workInsideColonyMission";
    }
}

