/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class UnitSeekAndDestroyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(UnitSeekAndDestroyMission.class.getName());
    private Location target;

    public UnitSeekAndDestroyMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit);
        this.target = target;
        if (!(target instanceof Ownable)) {
            logger.warning("!(target instanceof Ownable)");
            throw new IllegalArgumentException("!(target instanceof Ownable)");
        }
        if (!(target instanceof Unit) && !(target instanceof Settlement)) {
            logger.warning("!(target instanceof Unit || target instanceof Settlement)");
            throw new IllegalArgumentException("!(target instanceof Unit || target instanceof Settlement)");
        }
    }

    public UnitSeekAndDestroyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public UnitSeekAndDestroyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        Map.Direction direction;
        Unit unit = this.getUnit();
        if (!this.isValid()) {
            return;
        }
        PathNode pathToTarget = null;
        if (unit.isOnCarrier()) {
            if (unit.getTile() != null && (pathToTarget = this.getDisembarkPath(unit, unit.getTile(), this.target.getTile(), (Unit)unit.getLocation())).getTransportDropNode() != pathToTarget) {
                pathToTarget = null;
            }
        } else if (unit.getTile() != null) {
            pathToTarget = this.getUnit().findPath(this.target.getTile());
        }
        if (pathToTarget != null && (direction = this.moveTowards(pathToTarget)) != null && unit.getMoveType(direction).isAttack()) {
            Tile newTile = unit.getTile().getNeighbourOrNull(direction);
            Unit defender = newTile.getDefendingUnit(unit);
            if (defender == null) {
                logger.warning("MoveType is ATTACK, but no defender is present!");
            } else if (unit.getTile().getSettlement() == null || unit.getTile().getSettlement().getUnitCount() >= 2) {
                Player enemy = defender.getOwner();
                if (unit.getOwner().atWarWith(enemy) || enemy.owns((Ownable)((Object)this.target))) {
                    AIMessage.askAttack(this.getAIUnit(), direction);
                }
            }
        }
    }

    private PathNode getDisembarkPath(Unit unit, Tile start, final Tile end, Unit carrier) {
        GoalDecider gd = new GoalDecider(){
            private PathNode goal = null;

            public PathNode getGoal() {
                return this.goal;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode pathNode) {
                this.goal = pathNode;
                if (pathNode.getTile().getSettlement() == null) {
                    for (Map.Direction direction : Map.Direction.values()) {
                        Tile attackTile = pathNode.getTile().getNeighbourOrNull(direction);
                        if (attackTile == null || end != attackTile || attackTile.getSettlement() == null || !pathNode.getTile().isLand()) continue;
                        int cost = pathNode.getCost();
                        int movesLeft = pathNode.getMovesLeft();
                        int turns = pathNode.getTurns();
                        this.goal = new PathNode(attackTile, cost, cost, direction, movesLeft, turns);
                        this.goal.previous = pathNode;
                        return true;
                    }
                }
                return pathNode.getTile() == end;
            }
        };
        return unit.search(start, gd, CostDeciders.avoidSettlementsAndBlockingUnits(), Integer.MAX_VALUE, carrier);
    }

    public boolean isValid() {
        Player targetPlayer;
        Player owner = this.getUnit().getOwner();
        return super.isValid() && this.target != null && !((FreeColGameObject)((Object)this.target)).isDisposed() && this.target.getTile() != null && this.getUnit().isOffensiveUnit() && (!(this.target instanceof Unit) || this.target.getTile().getSettlement() == null) && (targetPlayer = ((Ownable)((Object)this.target)).getOwner()) != null && targetPlayer != owner && (owner.getStance(targetPlayer) == Player.Stance.WAR || owner.isIndian() && owner.getTension(targetPlayer).getLevel().compareTo(Tension.Level.CONTENT) >= 0);
    }

    public Tile getTransportDestination() {
        PathNode p;
        if (this.target == null) {
            return null;
        }
        Tile dropTarget = this.target.getTile();
        if (this.getUnit().getTile() == null) {
            return dropTarget;
        }
        if (this.getUnit().isOnCarrier() && (p = this.getDisembarkPath(this.getUnit(), this.getUnit().getTile(), this.target.getTile(), (Unit)this.getUnit().getLocation())) != null) {
            dropTarget = p.getTransportDropNode().getTile();
        }
        if (this.getUnit().isOnCarrier()) {
            return dropTarget;
        }
        if (this.getUnit().getLocation().getTile() == this.target) {
            return null;
        }
        if (this.getUnit().findPath(this.target.getTile()) == null) {
            return dropTarget;
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        this.target = target;
    }

    public String getDebuggingInfo() {
        if (this.target == null) {
            return "No target";
        }
        String name = this.target instanceof Unit ? ((Unit)this.target).toString() : (this.target instanceof Colony ? ((Colony)this.target).getName() : "");
        return this.target.getTile().getPosition() + " " + name;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, UnitSeekAndDestroyMission.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.getTarget() != null) {
            out.writeAttribute("target", this.getTarget().getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.setTarget((Location)((Object)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "target"))));
    }

    public static String getXMLElementTagName() {
        return "unitSeekAndDestroyMission";
    }
}

