/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class IndianDemandMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianDemandMission.class.getName());
    private Colony target;
    private boolean completed;
    private boolean demanded;

    public IndianDemandMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit);
        this.target = target;
        if (!this.getUnit().getOwner().isIndian() || !this.getUnit().canCarryGoods()) {
            logger.warning("Only an indian which can carry goods can be given the mission: IndianBringGiftMission");
            throw new IllegalArgumentException("Only an indian which can carry goods can be given the mission: IndianBringGiftMission");
        }
    }

    public IndianDemandMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public IndianDemandMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        if (!this.isValid()) {
            return;
        }
        Unit unit = this.getUnit();
        if (this.hasTribute()) {
            if (unit.getTile() != unit.getIndianSettlement().getTile()) {
                Map.Direction r = this.moveTowards(unit.getIndianSettlement().getTile());
                if (r == null || !this.moveButDontAttack(r)) {
                    return;
                }
            } else {
                GoodsContainer container = unit.getGoodsContainer();
                IndianSettlement is = unit.getIndianSettlement();
                for (Goods goods : container.getCompactGoods()) {
                    Goods tribute = container.removeGoods(goods.getType());
                    is.addGoods(tribute);
                }
                logger.info("IndianDemand by " + unit + " complete, tribute unloaded at " + is.getName());
                this.completed = true;
            }
        } else {
            this.moveTowards(this.target.getTile());
            if (unit.getTile().isAdjacent(this.target.getTile()) && unit.getMovesLeft() > 0) {
                if (this.demanded) {
                    return;
                }
                Player enemy = this.target.getOwner();
                Goods goods = this.selectGoods(this.target);
                int gold = 0;
                int oldGoods = goods == null ? 0 : unit.getGoodsContainer().getGoodsCount(goods.getType());
                int oldGold = unit.getOwner().getGold();
                if (goods == null) {
                    if (!enemy.checkGold(1)) {
                        this.completed = true;
                        return;
                    }
                    gold = enemy.getGold() / 20;
                    if (gold == 0) {
                        gold = enemy.getGold();
                    }
                }
                this.demanded = true;
                AIUnit au = this.getAIUnit();
                boolean accepted = AIMessage.askIndianDemand(au, this.target, goods, gold);
                Mission mission = au.getMission();
                if (mission instanceof IndianDemandMission && !((IndianDemandMission)mission).hasTribute()) {
                    au.abortMission("completed demand");
                }
                if (accepted) {
                    logger.info("Indian demand by " + unit + " accepted at " + this.target.getName() + " tribute: " + (goods != null ? goods.toString() : Integer.toString(gold) + " gold"));
                } else {
                    Map.Direction d;
                    int unitTension = unit.getIndianSettlement() == null ? 0 : unit.getIndianSettlement().getAlarm(enemy).getValue();
                    int tension = Math.max(unitTension, unit.getOwner().getTension(enemy).getValue());
                    if (tension >= Tension.Level.CONTENT.getLimit() && (d = unit.getTile().getDirection(this.target.getTile())) != null) {
                        AIMessage.askAttack(au, d);
                    }
                    logger.info("Indian demand by " + unit + " refused at " + this.target.getName());
                }
                return;
            }
        }
        this.moveRandomly();
    }

    public Goods selectGoods(Colony target) {
        int goodsValue;
        List<Goods> warehouseGoods;
        int value;
        Tension.Level tension = this.getUnit().getOwner().getTension(target.getOwner()).getLevel();
        int dx = this.getSpecification().getIntegerOption("model.option.nativeDemands").getValue() + 1;
        GoodsType food = this.getSpecification().getPrimaryFoodType();
        AbstractGoods goods = null;
        GoodsContainer warehouse = target.getGoodsContainer();
        if (tension.compareTo(Tension.Level.CONTENT) <= 0 && warehouse.getGoodsCount(food) >= 100) {
            int amount = warehouse.getGoodsCount(food) * dx / 6;
            if (amount > 0) {
                return new Goods(this.getGame(), target, food, this.capAmount(amount, dx));
            }
        } else if (tension.compareTo(Tension.Level.DISPLEASED) <= 0) {
            Market market = target.getOwner().getMarket();
            value = 0;
            warehouseGoods = warehouse.getCompactGoods();
            for (Goods currentGoods : warehouseGoods) {
                goodsValue = market.getSalePrice(currentGoods);
                if (currentGoods.getType().isFoodType() || currentGoods.getType().isMilitaryGoods() || goodsValue <= value) continue;
                value = goodsValue;
                goods = currentGoods;
            }
            if (goods != null) {
                goods.setAmount(this.capAmount(goods.getAmount(), dx));
                return goods;
            }
        } else {
            int amount;
            for (GoodsType preferred : this.getSpecification().getGoodsTypeList()) {
                if (!preferred.isMilitaryGoods() || (amount = warehouse.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : this.getSpecification().getGoodsTypeList()) {
                if (!preferred.isBuildingMaterial() || !preferred.isStorable() || (amount = warehouse.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : this.getSpecification().getGoodsTypeList()) {
                if (!preferred.isTradeGoods() || (amount = warehouse.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : this.getSpecification().getGoodsTypeList()) {
                if (!preferred.isRefined() || !preferred.isStorable() || (amount = warehouse.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
        }
        Market market = target.getOwner().getMarket();
        value = 0;
        warehouseGoods = warehouse.getCompactGoods();
        for (Goods currentGoods : warehouseGoods) {
            goodsValue = market.getSalePrice(currentGoods);
            if (goodsValue <= value) continue;
            value = goodsValue;
            goods = currentGoods;
        }
        if (goods != null) {
            goods.setAmount(this.capAmount(goods.getAmount(), dx));
        }
        return goods;
    }

    private int capAmount(int amount, int difficulty) {
        int finalAmount = Math.max(amount * difficulty / 6, 1);
        finalAmount = Math.min(finalAmount, 100);
        return finalAmount;
    }

    private boolean hasTribute() {
        return this.getUnit().getSpaceLeft() == 0;
    }

    public boolean isValid() {
        return super.isValid() && !this.completed && this.getUnit().getIndianSettlement() != null && (this.hasTribute() || this.target != null && !this.target.isDisposed() && this.target.getTile().getColony() == this.target && this.getUnit().getOwner().getTension(this.target.getOwner()).getLevel().compareTo(Tension.Level.HAPPY) <= 0);
    }

    public String getDebuggingInfo() {
        String targetName;
        if (this.getUnit().getIndianSettlement() == null) {
            return "invalid";
        }
        String string = targetName = this.target != null ? this.target.getName() : "null";
        if (!this.hasTribute()) {
            return "[" + targetName + "] Getting tribute: " + this.getUnit().getIndianSettlement().getTile().getPosition();
        }
        return "[" + targetName + "] " + this.getUnit().getGoodsIterator().next().getNameKey();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, IndianDemandMission.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
        out.writeAttribute("completed", Boolean.toString(this.completed));
        out.writeAttribute("demanded", Boolean.toString(this.demanded));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String targetString = in.getAttributeValue(null, "target");
        this.target = targetString == null ? null : (Colony)this.getGame().getFreeColGameObject(targetString);
        String completedString = in.getAttributeValue(null, "completed");
        this.completed = Boolean.valueOf(completedString);
        String demandedString = in.getAttributeValue(null, "demanded");
        this.demanded = demandedString == null ? false : Boolean.valueOf(demandedString);
    }

    public static String getXMLElementTagName() {
        return "indianDemandMission";
    }
}

