/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.goal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.goal.CreateMissionAtSettlementGoal;
import net.sf.freecol.server.ai.goal.Goal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageMissionariesGoal
extends Goal {
    private static final Logger logger = Logger.getLogger(ManageMissionariesGoal.class.getName());
    private List<Goal> subGoalList = new ArrayList<Goal>();

    public ManageMissionariesGoal(AIPlayer p, Goal g, float w) {
        super(p, g, w);
    }

    @Override
    protected Iterator<AIUnit> getOwnedAIUnitsIterator() {
        return this.availableUnitsList.iterator();
    }

    @Override
    protected Iterator<Goal> getSubGoalIterator() {
        return this.subGoalList.iterator();
    }

    @Override
    protected void removeUnit(AIUnit u) {
        Iterator uit = this.availableUnitsList.iterator();
        while (uit.hasNext()) {
            AIUnit unit = (AIUnit)uit.next();
            if (!unit.equals(u)) continue;
            uit.remove();
        }
    }

    @Override
    protected void plan() {
        this.isFinished = false;
        Iterator<Goal> git = this.subGoalList.iterator();
        while (git.hasNext()) {
            Goal g = git.next();
            if (!g.isFinished()) continue;
            List<AIUnit> units = g.cancelGoal();
            this.availableUnitsList.addAll(units);
            git.remove();
        }
        this.validateOwnedUnits();
        Iterator uit = this.availableUnitsList.iterator();
        while (uit.hasNext()) {
            AIUnit u = (AIUnit)uit.next();
            uit.remove();
            if (u.getUnit().getRole() == Unit.Role.MISSIONARY) {
                PathNode pathNode;
                IndianSettlement i = this.findSettlement(u.getUnit().getTile());
                if (i == null || (pathNode = u.getUnit().findPath(i.getTile())) == null) continue;
                logger.info("Creating subgoal CreateMissionAtSettlementGoal.");
                CreateMissionAtSettlementGoal g = new CreateMissionAtSettlementGoal(this.player, this, 1.0f, u, i);
                this.subGoalList.add(g);
                continue;
            }
            u.setGoal(null);
        }
        if (this.availableUnitsList.size() == 0 && this.subGoalList.size() == 0) {
            this.isFinished = true;
        } else {
            float newWeight = 1.0f / (float)this.subGoalList.size();
            for (Goal g : this.subGoalList) {
                g.setWeight(newWeight);
            }
        }
    }

    @Override
    public String getGoalDescription() {
        String descr = super.getGoalDescription();
        descr = descr + ":" + this.availableUnitsList.size();
        return descr;
    }

    private IndianSettlement findSettlement(Tile tile) {
        if (tile == null) {
            return null;
        }
        for (Tile t : tile.getSurroundingTiles(8)) {
            IndianSettlement is = t.getIndianSettlement();
            if (is == null || is.getMissionary() != null && is.getMissionary().getOwner() == this.player.getPlayer()) continue;
            return is;
        }
        return null;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
    }
}

