/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.ValuedAIObject;
import org.w3c.dom.Element;

public abstract class Wish
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(Wish.class.getName());
    protected Location destination = null;
    protected Transportable transportable = null;

    public Wish(AIMain aiMain, String id) {
        super(aiMain, id);
    }

    public Wish(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public Wish(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public boolean shouldBeStored() {
        return this.transportable != null;
    }

    public void setTransportable(Transportable transportable) {
        this.transportable = transportable;
    }

    public Transportable getTransportable() {
        return this.transportable;
    }

    public void dispose() {
        AIColony ac = this.getDestinationAIColony();
        if (ac != null) {
            ac.removeWish(this);
        } else {
            logger.warning("Unknown destination: " + this.destination);
        }
        if (this.transportable != null) {
            Transportable temp = this.transportable;
            this.transportable = null;
            temp.abortWish(this);
        }
        super.dispose();
    }

    public Location getDestination() {
        return this.destination;
    }

    public AIColony getDestinationAIColony() {
        return this.destination instanceof Colony ? this.getAIMain().getAIColony((Colony)this.destination) : null;
    }

    public void attachToDestination() {
        AIColony ac = this.getDestinationAIColony();
        if (ac != null) {
            ac.addWish(this);
        }
    }
}

