/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitWas;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ColonyPlan;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkLocationPlan;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtColonyMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIColony
extends AIObject
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AIColony.class.getName());
    private static final String LIST_ELEMENT = "ListElement";
    private static final int FOREST_MINIMUM = 1;
    private static final int EXPORT_MINIMUM = 10;
    private Colony colony;
    private ColonyPlan colonyPlan;
    private final List<AIGoods> aiGoods = new ArrayList<AIGoods>();
    private final List<Wish> wishes = new ArrayList<Wish>();
    private final List<TileImprovementPlan> tileImprovementPlans = new ArrayList<TileImprovementPlan>();
    private Turn rearrangeTurn = new Turn(0);
    private static final Set<GoodsType> fullExport = new HashSet<GoodsType>();
    private static final Set<GoodsType> partExport = new HashSet<GoodsType>();
    private static final Comparator<Unit> scoutComparator = new Comparator<Unit>(){

        @Override
        public int compare(Unit u1, Unit u2) {
            boolean a2;
            boolean a1 = u1.hasAbility("model.ability.expertScout");
            if (a1 != (a2 = u2.hasAbility("model.ability.expertScout"))) {
                return a1 ? -1 : 1;
            }
            a1 = u1.getRole() == Unit.Role.SCOUT;
            boolean bl = a2 = u2.getRole() == Unit.Role.SCOUT;
            if (a1 != a2) {
                return a1 ? -1 : 1;
            }
            return u1.getType().getSkill() - u2.getType().getSkill();
        }
    };

    public AIColony(AIMain aiMain, Colony colony) {
        super(aiMain, colony.getId());
        this.colony = colony;
        this.colonyPlan = new ColonyPlan(aiMain, colony);
        colony.addPropertyChangeListener("rearrangeWorkers", this);
    }

    public AIColony(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public AIColony(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public AIColony(AIMain aiMain, String id) {
        this(aiMain, (Colony)aiMain.getGame().getFreeColGameObject(id));
    }

    public Colony getColony() {
        return this.colony;
    }

    public ColonyPlan getColonyPlan() {
        return this.colonyPlan;
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected AIPlayer getAIOwner() {
        return this.getAIMain().getAIPlayer(this.colony.getOwner());
    }

    protected Connection getConnection() {
        return this.getAIOwner().getConnection();
    }

    @Override
    public void dispose() {
        ArrayList<AIObject> disposeList = new ArrayList<AIObject>();
        for (AIGoods ag : this.aiGoods) {
            if (ag.getGoods().getLocation() != this.colony) continue;
            disposeList.add(ag);
        }
        for (Wish w : this.wishes) {
            disposeList.add(w);
        }
        for (TileImprovementPlan ti : this.tileImprovementPlans) {
            disposeList.add(ti);
        }
        for (AIObject o : disposeList) {
            o.dispose();
        }
        super.dispose();
    }

    public static boolean isBadlyDefended(Colony colony) {
        return colony.getTotalDefencePower() < 1.25f * (float)colony.getUnitCount() - 2.5f;
    }

    public boolean rearrangeWorkers() {
        int turn = this.getGame().getTurn().getNumber();
        if (this.colony.getCurrentlyBuilding() == null && this.colonyPlan.getBestBuildableType() != null && this.rearrangeTurn.getNumber() > turn) {
            logger.warning(this.colony.getName() + " could be building but" + " is asleep until turn: " + this.rearrangeTurn.getNumber() + "( > " + turn + ")");
        }
        if (this.rearrangeTurn.getNumber() > turn) {
            return false;
        }
        AIMain aiMain = this.getAIMain();
        Tile tile = this.colony.getTile();
        Player player = this.colony.getOwner();
        Specification spec = this.getSpecification();
        int nextRearrange = 15;
        this.exploreLCRs();
        this.stealTiles();
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (player.owns(t) || !player.canClaimForSettlement(t)) continue;
            AIMessage.askClaimLand(this.getConnection(), t, this.colony, 0);
        }
        this.colonyPlan.update();
        BuildableType oldBuild = this.colony.getCurrentlyBuilding();
        BuildableType build = this.colonyPlan.getBestBuildableType();
        if (build != oldBuild) {
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            if (build != null) {
                queue.add(build);
            }
            AIMessage.askSetBuildQueue(this, queue);
            build = this.colony.getCurrentlyBuilding();
        }
        this.colonyPlan.refine(build);
        List<Unit> workers = this.colony.getUnitList();
        ArrayList<UnitWas> was = new ArrayList<UnitWas>();
        for (Unit u : workers) {
            was.add(new UnitWas(u));
        }
        for (Unit u : tile.getUnitList()) {
            Mission mission;
            if (!u.isPerson() || (mission = this.getAIUnit(u).getMission()) != null && !(mission instanceof IdleAtColonyMission) && !(mission instanceof WorkInsideColonyMission) && (!(mission instanceof BuildColonyMission) || ((BuildColonyMission)mission).getTarget() != tile) && !(mission instanceof DefendSettlementMission)) continue;
            workers.add(u);
            was.add(new UnitWas(u));
        }
        Colony scratch = this.colonyPlan.assignWorkers(workers);
        for (Unit u : scratch.getUnitList()) {
            AIUnit aiU = this.getAIUnit(u);
            WorkLocation wl = (WorkLocation)u.getLocation();
            wl = this.colony.getCorrespondingWorkLocation(wl);
            u.setLocation(wl);
        }
        for (Unit u : scratch.getTile().getUnitList()) {
            u.setLocation(tile);
        }
        for (GoodsType g : spec.getGoodsTypeList()) {
            if (!g.isStorable()) continue;
            int oldCount = this.colony.getGoodsCount(g);
            int newCount = scratch.getGoodsCount(g);
            if (newCount == oldCount) continue;
            this.colony.getGoodsContainer().addGoods(g, newCount - oldCount);
        }
        scratch.disposeScratchColony();
        if (this.colony.getUnitCount() <= 0) {
            String destruct = "Autodestruct at " + this.colony.getName() + " in " + turn + "\n";
            for (UnitWas uw : was) {
                destruct = destruct + uw.toString() + "\n";
            }
            logger.warning(destruct);
            this.avertAutoDestruction();
        }
        if (build != null && !this.colony.canBuild(build)) {
            logger.warning(this.colony.getName() + " reneged building " + build);
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            build = this.colonyPlan.getBestBuildableType();
            if (build != null) {
                queue.add(build);
            }
            AIMessage.askSetBuildQueue(this, queue);
            nextRearrange = 1;
        }
        if (this.colony.getNetProductionOf(spec.getPrimaryFoodType()) < 0) {
            int net = this.colony.getNetProductionOf(spec.getPrimaryFoodType());
            int when = this.colony.getGoodsCount(spec.getPrimaryFoodType()) / -net;
            nextRearrange = Math.max(0, Math.min(nextRearrange, when - 1));
        }
        int warehouse = this.colony.getWarehouseCapacity();
        for (GoodsType g : spec.getGoodsTypeList()) {
            if (!g.isStorable() || g.isFoodType()) continue;
            int have = this.colony.getGoodsCount(g);
            int net = this.colony.getAdjustedNetProductionOf(g);
            if (net >= 0 && (have >= warehouse || g.limitIgnored())) continue;
            int when = net < 0 ? have / -net - 1 : (net > 0 ? (warehouse - have) / net - 1 : Integer.MAX_VALUE);
            nextRearrange = Math.max(1, Math.min(nextRearrange, when));
        }
        build = this.colony.getCurrentlyBuilding();
        String buildStr = build != null ? build.toString() : ((build = this.colonyPlan.getBestBuildableType()) != null ? "unexpected-null(" + build.toString() + ")" : "expected-null");
        String report = "Rearrange " + this.colony.getName() + " (" + this.colony.getUnitCount() + ")" + " build=" + buildStr + " " + this.getGame().getTurn() + " + " + nextRearrange + "\n";
        for (UnitWas uw : was) {
            report = report + uw.toString() + "\n";
        }
        logger.finest(report);
        for (Unit u : this.colony.getUnitList()) {
            AIUnit aiU = this.getAIUnit(u);
            aiU.setMission(new WorkInsideColonyMission(aiMain, aiU, this));
        }
        for (Unit u : tile.getUnitList()) {
            AIUnit aiU = this.getAIUnit(u);
            if (aiU.getMission() != null) continue;
            switch (u.getRole()) {
                case SOLDIER: 
                case DRAGOON: {
                    aiU.setMission(new DefendSettlementMission(aiMain, aiU, this.colony));
                    break;
                }
                case SCOUT: {
                    if (!ScoutingMission.isValid(aiU)) break;
                    aiU.setMission(new ScoutingMission(aiMain, aiU));
                    break;
                }
                case PIONEER: {
                    if (!PioneeringMission.isValid(aiU)) break;
                    aiU.setMission(new PioneeringMission(aiMain, aiU));
                    break;
                }
            }
        }
        this.resetExports();
        this.createTileImprovementPlans();
        this.createWishes();
        this.rearrangeTurn = new Turn(turn + nextRearrange);
        return true;
    }

    private void resetExports() {
        Specification spec = this.getSpecification();
        List<GoodsType> produce = this.colonyPlan.getPreferredProduction();
        if (fullExport.isEmpty()) {
            for (GoodsType g : spec.getGoodsTypeList()) {
                if (!g.isStorable() || g.isFoodType() || g.isBuildingMaterial() || g.isMilitaryGoods() || g.isTradeGoods()) continue;
                if (g.isRawMaterial() && produce.contains(g)) {
                    partExport.add(g);
                    continue;
                }
                fullExport.add(g);
            }
            for (EquipmentType e : spec.getEquipmentTypeList()) {
                for (AbstractGoods ag : e.getGoodsRequired()) {
                    fullExport.remove(ag.getType());
                    partExport.add(ag.getType());
                }
            }
        }
        if (this.colony.getOwner().getMarket() == null) {
            for (GoodsType g : spec.getGoodsTypeList()) {
                this.colony.getExportData(g).setExported(false);
            }
        } else {
            int exportLevel = 4 * this.colony.getWarehouseCapacity() / 5;
            for (GoodsType g : spec.getGoodsTypeList()) {
                if (fullExport.contains(g)) {
                    this.colony.getExportData(g).setExportLevel(0);
                    this.colony.getExportData(g).setExported(true);
                    continue;
                }
                if (partExport.contains(g)) {
                    this.colony.getExportData(g).setExportLevel(exportLevel);
                    this.colony.getExportData(g).setExported(true);
                    continue;
                }
                this.colony.getExportData(g).setExported(false);
            }
        }
    }

    private void exploreLCRs() {
        Tile tile = this.colony.getTile();
        ArrayList<Unit> explorers = new ArrayList<Unit>();
        for (Unit u : tile.getUnitList()) {
            if (!u.isPerson() || u.getType().getSkill() > 0 && !u.hasAbility("model.ability.expertScout")) continue;
            explorers.add(u);
        }
        Collections.sort(explorers, scoutComparator);
        for (Tile t : tile.getSurroundingTiles(1)) {
            Unit u;
            if (!t.hasLostCityRumour()) continue;
            Map.Direction direction = tile.getDirection(t);
            do {
                if (!explorers.isEmpty()) continue;
                return;
            } while (!(u = (Unit)explorers.remove(0)).getMoveType(t).isProgress() || !AIMessage.askMove(this.getAIUnit(u), direction) || t.hasLostCityRumour());
            u.setDestination(tile);
        }
    }

    private void stealTiles() {
        Specification spec = this.getSpecification();
        Tile tile = this.colony.getTile();
        Player player = this.colony.getOwner();
        boolean hasDefender = false;
        for (Unit u : tile.getUnitList()) {
            if (!u.isDefensiveUnit() || !(this.getAIUnit(u).getMission() instanceof DefendSettlementMission)) continue;
            hasDefender = true;
            break;
        }
        if (!hasDefender) {
            return;
        }
        ArrayList<GoodsType> needed = new ArrayList<GoodsType>();
        for (GoodsType g : spec.getRawBuildingGoodsTypeList()) {
            if (this.colony.getProductionOf(g) > 0) continue;
            needed.add(g);
        }
        UnitType unitType = spec.getDefaultUnitType();
        Tile steal = null;
        float score = 1.0f;
        for (Tile t : tile.getSurroundingTiles(1)) {
            Player owner = t.getOwner();
            if (owner == null || owner == player || owner.isEuropean()) continue;
            if (owner.atWarWith(player)) {
                if (!AIMessage.askClaimLand(this.getConnection(), t, this.colony, -1) || !player.owns(t)) continue;
                logger.info(player.getName() + " stole tile " + t + " from hostile " + owner.getName());
                continue;
            }
            float s = 0.0f;
            for (GoodsType g : needed) {
                s += (float)t.potential(g, unitType);
            }
            for (GoodsType g : spec.getFoodGoodsTypeList()) {
                s = (float)((double)s + 0.1 * (double)t.potential(g, unitType));
            }
            if (!(s > score)) continue;
            score = s;
            steal = t;
        }
        if (steal != null) {
            Player owner = steal.getOwner();
            if (AIMessage.askClaimLand(this.getConnection(), steal, this.colony, -1) && player.owns(steal)) {
                logger.info(player.getName() + " stole tile " + steal + " (score = " + score + ") from " + owner.getName());
            }
        }
    }

    private void avertAutoDestruction() {
        List<GoodsType> libertyGoods = this.getSpecification().getLibertyGoodsTypeList();
        for (Unit u : this.colony.getTile().getUnitList()) {
            if (!u.isPerson()) continue;
            block1: for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
                if (!wl.canAdd(u)) continue;
                for (GoodsType type : libertyGoods) {
                    if (wl.getPotentialProduction(u.getType(), type) <= 0 || !AIMessage.askWork(this.getAIUnit(u), wl) || u.getLocation() != wl) continue;
                    AIMessage.askChangeWorkType(this.getAIUnit(u), type);
                    logger.warning("Colony " + this.colony.getName() + " autodestruct averted.");
                    continue block1;
                }
            }
        }
        if (this.colony.getUnitCount() <= 0) {
            throw new IllegalStateException("Colony " + this.colony.getName() + " rearrangement leaves no units!");
        }
    }

    public List<AIGoods> getAIGoods() {
        return new ArrayList<AIGoods>(this.aiGoods);
    }

    public void removeAIGoods(AIGoods ag) {
        while (this.aiGoods.remove(ag)) {
        }
    }

    private void dropGoods(AIGoods ag) {
        if (ag.getTransport() != null && ag.getTransport().getMission() instanceof TransportMission) {
            ((TransportMission)ag.getTransport().getMission()).removeFromTransportList(ag);
        }
        this.aiGoods.remove(ag);
        ag.dispose();
    }

    public void createAIGoods() {
        if (this.colony.hasAbility("model.ability.export")) {
            while (!this.aiGoods.isEmpty()) {
                AIGoods ag = this.aiGoods.remove(0);
                this.dropGoods(ag);
            }
            return;
        }
        Europe europe = this.colony.getOwner().getEurope();
        int capacity = this.colony.getWarehouseCapacity();
        ArrayList<AIGoods> newAIGoods = new ArrayList<AIGoods>();
        ArrayList<AIGoods> oldAIGoods = new ArrayList<AIGoods>();
        for (GoodsType g : this.getSpecification().getGoodsTypeList()) {
            AIGoods newGoods;
            int exportAmount;
            if (this.colony.getAdjustedNetProductionOf(g) < 0) continue;
            int count = this.colony.getGoodsCount(g);
            int n = fullExport.contains(g) ? count : (exportAmount = partExport.contains(g) ? count - this.colony.getExportData(g).getExportLevel() : -1);
            int priority = exportAmount >= capacity ? 110 : (exportAmount > 100 ? 100 : 0);
            int i = 0;
            while (i < this.aiGoods.size()) {
                AIGoods ag = this.aiGoods.get(i);
                if (ag == null) {
                    this.aiGoods.remove(i);
                    continue;
                }
                if (ag.getGoods() == null || ag.getGoods().getType() == null || ag.getGoods().getAmount() <= 0) {
                    this.dropGoods(ag);
                    continue;
                }
                Goods oldGoods = ag.getGoods();
                if (oldGoods.getLocation() != this.colony) {
                    this.aiGoods.remove(ag);
                    continue;
                }
                if (oldGoods.getType() != g) {
                    ++i;
                    continue;
                }
                int oldAmount = oldGoods.getAmount();
                String msg = null;
                if (oldAmount < exportAmount) {
                    int goodsAmount = oldAmount;
                    if (oldAmount < 100) {
                        goodsAmount = Math.min(exportAmount, 100);
                        oldGoods.setAmount(goodsAmount);
                        ag.setTransportPriority(priority);
                    }
                    exportAmount -= goodsAmount;
                    oldAIGoods.add(ag);
                } else if (oldAmount == exportAmount) {
                    oldAIGoods.add(ag);
                    exportAmount = 0;
                } else {
                    if (exportAmount <= 0) {
                        msg = String.format("%-20s %-8s AIGoods: %s %d %s\n", this.colony.getName(), "drops", ag.getId(), oldGoods.getAmount(), g.toString().substring(12));
                        this.dropGoods(ag);
                        continue;
                    }
                    oldGoods.setAmount(exportAmount);
                    oldAIGoods.add(ag);
                    exportAmount = 0;
                }
                if (msg != null) {
                    logger.finest(msg);
                }
                ++i;
            }
            while (exportAmount >= 100) {
                newGoods = new AIGoods(this.getAIMain(), this.colony, g, 100, europe);
                logger.finest(String.format("%-20s %-8s AIGoods: %s full %s\n", this.colony.getName(), "makes", newGoods.getId(), g.toString().substring(12)));
                newGoods.setTransportPriority(priority);
                newAIGoods.add(newGoods);
                exportAmount -= 100;
            }
            if (exportAmount < 10) continue;
            newGoods = new AIGoods(this.getAIMain(), this.colony, g, exportAmount, europe);
            logger.finest(String.format("%-20s %-8s AIGoods: %s %d %s\n", this.colony.getName(), "makes", newGoods.getId(), exportAmount, g.toString().substring(12)));
            newAIGoods.add(newGoods);
        }
        this.aiGoods.clear();
        this.aiGoods.addAll(oldAIGoods);
        this.aiGoods.addAll(newAIGoods);
        Collections.sort(this.aiGoods, AIGoods.getAIGoodsPriorityComparator());
    }

    public void addWish(Wish wish) {
        this.wishes.add(wish);
    }

    public void removeWish(Wish wish) {
        this.wishes.remove(wish);
    }

    public void completeWish(Goods goods) {
        int i = 0;
        while (i < this.wishes.size()) {
            GoodsWish gw;
            if (this.wishes.get(i) instanceof GoodsWish && (gw = (GoodsWish)this.wishes.get(i)).getGoodsType() == goods.getType() && gw.getGoodsAmount() <= goods.getAmount()) {
                logger.finest(this.colony.getName() + " completes goods wish: " + gw);
                this.wishes.remove(gw);
                gw.dispose();
                continue;
            }
            ++i;
        }
    }

    public void completeWish(Unit unit) {
        int i = 0;
        while (i < this.wishes.size()) {
            WorkerWish ww;
            if (this.wishes.get(i) instanceof WorkerWish && (ww = (WorkerWish)this.wishes.get(i)).getUnitType() == unit.getType()) {
                logger.finest(this.colony.getName() + " completes worker wish: " + ww);
                this.wishes.remove(ww);
                ww.dispose();
                continue;
            }
            ++i;
        }
    }

    public List<Wish> getWishes() {
        return new ArrayList<Wish>(this.wishes);
    }

    public List<WorkerWish> getWorkerWishes() {
        ArrayList<WorkerWish> result = new ArrayList<WorkerWish>();
        for (Wish wish : this.wishes) {
            if (!(wish instanceof WorkerWish)) continue;
            result.add((WorkerWish)wish);
        }
        return result;
    }

    private void createWishes() {
        this.wishes.clear();
        this.createWorkerWishes();
        this.createGoodsWishes();
    }

    private void createWorkerWishes() {
        UnitType bestDefender;
        GoodsType goods;
        Specification spec = this.getSpecification();
        int baseValue = 25;
        int priorityMax = 50;
        int priorityDecay = 5;
        int multipleBonus = 5;
        int multipleMax = 5;
        ArrayList<GoodsType> producing = new ArrayList<GoodsType>();
        for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
            for (Unit u : wl.getUnitList()) {
                GoodsType work = u.getWorkType();
                if (work == null || producing.contains(work = work.getStoredAs())) continue;
                producing.add(work);
            }
        }
        Collections.sort(producing, new Comparator<GoodsType>(){

            @Override
            public int compare(GoodsType g1, GoodsType g2) {
                return AIColony.this.colony.getAdjustedNetProductionOf(g1) - AIColony.this.colony.getAdjustedNetProductionOf(g2);
            }
        });
        TypeCountMap<UnitType> experts = new TypeCountMap<UnitType>();
        for (Unit unit : this.colony.getUnitList()) {
            goods = unit.getWorkType();
            UnitType expert = goods == null || goods == unit.getType().getExpertProduction() ? null : spec.getExpertForProducing(goods);
            if (expert == null) continue;
            experts.incrementCount(expert, 1);
        }
        for (UnitType expert : experts.keySet()) {
            goods = expert.getExpertProduction();
            int value = 25 + Math.max(0, 50 - 5 * producing.indexOf(goods)) + Math.min(5, experts.getCount(expert) - 1) * 5;
            WorkerWish ww = new WorkerWish(this.getAIMain(), this.colony, value, expert, true);
            this.wishes.add(ww);
            logger.finest("New WorkerWish at " + this.colony.getName() + ": " + ww.getId() + " " + ww);
        }
        if (experts.isEmpty() && this.colony.governmentChange(this.colony.getUnitCount() + 1) >= 0) {
            UnitType expert;
            boolean needFood = this.colony.getFoodProduction() <= this.colony.getFoodConsumption() + this.colony.getOwner().getMaximumFoodConsumption();
            expert = spec.getDefaultUnitType();
            for (WorkLocationPlan plan : needFood ? this.colonyPlan.getFoodPlans() : this.colonyPlan.getWorkPlans()) {
                WorkLocation location = plan.getWorkLocation();
                if (!location.canBeWorked()) continue;
                expert = spec.getExpertForProducing(plan.getGoodsType());
                break;
            }
            WorkerWish ww = new WorkerWish(this.getAIMain(), this.colony, 50, expert, false);
            this.wishes.add(ww);
            logger.finest("New WorkerWish at " + this.colony.getName() + ": " + ww.getId() + " " + ww);
        }
        if (AIColony.isBadlyDefended(this.colony) && (bestDefender = this.colony.getBestDefenderType()) != null) {
            WorkerWish ww = new WorkerWish(this.getAIMain(), this.colony, 100, bestDefender, true);
            this.wishes.add(ww);
            logger.finest("New WorkerWish at " + this.colony.getName() + ": " + ww.getId() + " " + ww);
        }
    }

    private void createGoodsWishes() {
        Specification spec = this.getSpecification();
        int goodsWishValue = 50;
        TypeCountMap<GoodsType> required = new TypeCountMap<GoodsType>();
        if (this.colony.getCurrentlyBuilding() != null) {
            for (AbstractGoods abstractGoods : this.colony.getCurrentlyBuilding().getGoodsRequired()) {
                if (this.colony.getAdjustedNetProductionOf(abstractGoods.getType()) > 0) continue;
                required.incrementCount(abstractGoods.getType(), abstractGoods.getAmount());
            }
        }
        for (TileImprovementPlan tileImprovementPlan : this.tileImprovementPlans) {
            for (AbstractGoods ag : tileImprovementPlan.getType().getExpendedEquipmentType().getGoodsRequired()) {
                required.incrementCount(ag.getType(), ag.getAmount());
            }
        }
        for (WorkLocation workLocation : this.colony.getCurrentWorkLocations()) {
            if (!(workLocation instanceof Building)) continue;
            Building building = (Building)workLocation;
            GoodsType inputType = building.getGoodsInputType();
            ProductionInfo info = this.colony.getProductionInfo(building);
            if (inputType == null || info == null || info.hasMaximumProduction()) continue;
            required.incrementCount(inputType, 100);
        }
        for (GoodsType goodsType : spec.getGoodsTypeList()) {
            if (!goodsType.isBreedable() || this.colony.getGoodsCount(goodsType) >= goodsType.getBreedingNumber()) continue;
            required.incrementCount(goodsType, goodsType.getBreedingNumber());
        }
        if (AIColony.isBadlyDefended(this.colony)) {
            block5: for (EquipmentType equipmentType : spec.getEquipmentTypeList()) {
                if (!equipmentType.isMilitaryEquipment()) continue;
                for (Unit unit : this.colony.getTile().getUnitList()) {
                    if (!unit.canBeEquippedWith(equipmentType)) continue;
                    for (AbstractGoods ag : equipmentType.getGoodsRequired()) {
                        required.incrementCount(ag.getType(), ag.getAmount());
                    }
                    continue block5;
                }
            }
        }
        Iterator<FreeColObject> i$ = required.keySet().iterator();
        while (i$.hasNext()) {
            int amount;
            GoodsType goodsType;
            GoodsType requiredType;
            for (requiredType = goodsType = (GoodsType)i$.next(); requiredType != null && !requiredType.isStorable(); requiredType = requiredType.getRawMaterial()) {
            }
            if (requiredType == null || (amount = Math.min(this.colony.getWarehouseCapacity(), required.getCount(requiredType) - this.colony.getGoodsCount(requiredType))) <= 0) continue;
            int value = goodsWishValue;
            if (this.colonyCouldProduce(requiredType)) {
                value /= 10;
            }
            GoodsWish gw = new GoodsWish(this.getAIMain(), this.colony, value, amount, requiredType);
            this.wishes.add(gw);
            logger.finest("New GoodsWish at " + this.colony.getName() + ": " + gw.getId() + " " + gw);
        }
        Collections.sort(this.wishes);
    }

    private boolean colonyCouldProduce(GoodsType goodsType) {
        if (goodsType.isBreedable()) {
            return this.colony.getGoodsCount(goodsType) >= goodsType.getBreedingNumber();
        }
        if (goodsType.isFarmed()) {
            for (ColonyTile colonyTile : this.colony.getColonyTiles()) {
                if (colonyTile.getWorkTile().potential(goodsType, null) <= 0) continue;
                return true;
            }
        } else if (!this.colony.getBuildingsForProducing(goodsType).isEmpty()) {
            return goodsType.getRawMaterial() == null ? true : this.colonyCouldProduce(goodsType.getRawMaterial());
        }
        return false;
    }

    public List<TileImprovementPlan> getTileImprovementPlans() {
        return new ArrayList<TileImprovementPlan>(this.tileImprovementPlans);
    }

    public boolean removeTileImprovementPlan(TileImprovementPlan plan) {
        return this.tileImprovementPlans.remove(plan);
    }

    private TileImprovementPlan getPlanFor(Tile tile, List<TileImprovementPlan> plans) {
        for (TileImprovementPlan tip : plans) {
            if (tip.getTarget() != tile) continue;
            return tip;
        }
        return null;
    }

    public void createTileImprovementPlans() {
        ArrayList<TileImprovementPlan> newPlans = new ArrayList<TileImprovementPlan>();
        for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
            ColonyTile colonyTile;
            Tile workTile;
            if (!(wl instanceof ColonyTile) || (workTile = (colonyTile = (ColonyTile)wl).getWorkTile()).getOwningSettlement() != this.colony || this.getPlanFor(workTile, newPlans) != null) continue;
            GoodsType goodsType = null;
            if (colonyTile.isColonyCenterTile()) {
                for (AbstractGoods ag : colonyTile.getProduction()) {
                    if (!ag.getType().isFoodType()) continue;
                    goodsType = ag.getType();
                    break;
                }
            } else {
                if (colonyTile.isEmpty()) continue;
                goodsType = colonyTile.getUnitList().get(0).getWorkType();
            }
            if (goodsType == null) continue;
            TileImprovementPlan plan = this.getPlanFor(workTile, this.tileImprovementPlans);
            if (plan == null) {
                TileImprovementType type = TileImprovementPlan.getBestTileImprovementType(workTile, goodsType);
                if (type != null) {
                    plan = new TileImprovementPlan(this.getAIMain(), workTile, type, type.getImprovementValue(workTile, goodsType));
                }
            } else if (!plan.update(goodsType)) {
                plan = null;
            }
            if (plan == null) continue;
            TileType change = plan.getType().getChange(workTile.getType());
            if (change != null && !change.isForested()) {
                int forest = 0;
                for (WorkLocation f : this.colony.getAvailableWorkLocations()) {
                    if (!(f instanceof ColonyTile) || !((ColonyTile)f).getWorkTile().isForested()) continue;
                    ++forest;
                }
                if (forest <= 1) continue;
            }
            newPlans.add(plan);
            logger.info(this.colony.getName() + " new tile improvement plan: " + plan);
        }
        this.tileImprovementPlans.clear();
        this.tileImprovementPlans.addAll(newPlans);
        Collections.sort(this.tileImprovementPlans);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("Property change REARRANGE_WORKERS fired.");
        this.rearrangeTurn = new Turn(0);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIColony.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        for (AIGoods ag : this.aiGoods) {
            if (ag.getId() == null) {
                logger.warning("ag.getId() == null");
                continue;
            }
            out.writeStartElement(ag.getXMLElementTagName() + LIST_ELEMENT);
            out.writeAttribute("ID", ag.getId());
            out.writeEndElement();
        }
        for (Wish w : this.wishes) {
            String tag;
            if (!w.shouldBeStored()) continue;
            String string = w instanceof GoodsWish ? GoodsWish.getXMLElementTagName() : (tag = w instanceof WorkerWish ? WorkerWish.getXMLElementTagName() : null);
            if (tag == null) continue;
            out.writeStartElement(tag + LIST_ELEMENT);
            out.writeAttribute("ID", w.getId());
            out.writeEndElement();
        }
        for (TileImprovementPlan tip : this.tileImprovementPlans) {
            out.writeStartElement(tip.getXMLElementTagName() + LIST_ELEMENT);
            out.writeAttribute("ID", tip.getId());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.colony = (Colony)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID"));
        if (this.colony == null) {
            throw new NullPointerException("Could not find Colony with ID: " + in.getAttributeValue(null, "ID"));
        }
        this.aiGoods.clear();
        this.wishes.clear();
        this.colonyPlan = new ColonyPlan(this.getAIMain(), this.colony);
        while (in.nextTag() != 2) {
            Wish w;
            if (in.getLocalName().equals(AIGoods.getXMLElementTagName() + LIST_ELEMENT)) {
                AIGoods ag = (AIGoods)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (ag == null) {
                    ag = new AIGoods(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.aiGoods.add(ag);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(WorkerWish.getXMLElementTagName() + LIST_ELEMENT) || in.getLocalName().equals(WorkerWish.getXMLElementTagName() + "Wish" + LIST_ELEMENT)) {
                w = (Wish)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (w == null) {
                    w = new WorkerWish(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.wishes.add(w);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(GoodsWish.getXMLElementTagName() + LIST_ELEMENT) || in.getLocalName().equals("GoodsWishWishListElement")) {
                w = (Wish)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (w == null) {
                    w = new GoodsWish(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.wishes.add(w);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(TileImprovementPlan.getXMLElementTagName() + LIST_ELEMENT) || in.getLocalName().equals("tileimprovementplanListElement")) {
                TileImprovementPlan ti = (TileImprovementPlan)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (ti == null) {
                    ti = new TileImprovementPlan(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.tileImprovementPlans.add(ti);
                in.nextTag();
                continue;
            }
            logger.warning("Unknown tag name: " + in.getLocalName());
        }
        if (!in.getLocalName().equals(AIColony.getXMLElementTagName())) {
            logger.warning("Expected end tag, received: " + in.getLocalName());
        }
    }

    public static String getXMLElementTagName() {
        return "aiColony";
    }
}

