/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.sf.freecol.common.resources.Resource;

public class AudioResource
extends Resource {
    private static final Logger logger = Logger.getLogger(AudioResource.class.getName());
    private File file;

    public AudioResource(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AudioResource(URI resourceLocator) throws Exception {
        super(resourceLocator);
        File f = new File(resourceLocator);
        BufferedInputStream bis = null;
        AudioInputStream ais = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(f));
            bis.mark(1000);
            bis.skip(1L);
            bis.reset();
            ais = AudioSystem.getAudioInputStream(bis);
            this.file = f;
        }
        catch (Exception e) {
            logger.warning("Not an audio file: " + f.getPath() + "\r\nProblem: " + e);
            e.printStackTrace();
            this.file = null;
        }
        finally {
            try {
                if (ais != null) {
                    ais.close();
                } else if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void preload() {
    }

    public File getAudio() {
        return this.file;
    }
}

