/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.ModListOption;
import net.sf.freecol.common.option.ModOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.option.UnitTypeOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOption<T>
extends FreeColObject
implements Option<T> {
    private static Logger logger = Logger.getLogger(AbstractOption.class.getName());
    private String optionGroup = "";
    protected boolean isDefined = false;

    public AbstractOption(String id) {
        this(id, null);
    }

    public AbstractOption(Specification specification) {
        this(null, specification);
    }

    public AbstractOption(String id, Specification specification) {
        this.setId(id);
        this.setSpecification(specification);
    }

    @Override
    public abstract AbstractOption<T> clone() throws CloneNotSupportedException;

    protected void setValues(AbstractOption<T> source) {
        this.setId(source.getId());
        this.setSpecification(source.getSpecification());
        this.setValue(source.getValue());
        this.setGroup(source.getGroup());
        this.isDefined = source.isDefined;
    }

    public String getGroup() {
        return this.optionGroup;
    }

    public void setGroup(String group) {
        this.optionGroup = group == null ? "" : group;
    }

    @Override
    public abstract T getValue();

    @Override
    public abstract void setValue(T var1);

    protected void setValue(String valueString, String defaultValueString) {
        logger.warning("Unsupported method: setValue.");
    }

    public boolean isNullValueOK() {
        return false;
    }

    public void generateChoices() {
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.readAttributes(in);
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        this.setId(this.getAttribute(in, "id", this.getId()));
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String value = in.getAttributeValue(null, "value");
        if (!this.isNullValueOK() && defaultValue == null && value == null) {
            throw new XMLStreamException("invalid option " + this.getId() + ": no value nor default value found.");
        }
        this.setValue(value, defaultValue);
    }

    protected AbstractOption readOption(XMLStreamReader in) throws XMLStreamException {
        String optionType = in.getLocalName();
        AbstractOption option = null;
        if (OptionGroup.getXMLElementTagName().equals(optionType)) {
            option = new OptionGroup(this.getSpecification());
        } else if (IntegerOption.getXMLElementTagName().equals(optionType)) {
            option = new IntegerOption(this.getSpecification());
        } else if (BooleanOption.getXMLElementTagName().equals(optionType)) {
            option = new BooleanOption(this.getSpecification());
        } else if (RangeOption.getXMLElementTagName().equals(optionType)) {
            option = new RangeOption(this.getSpecification());
        } else if (SelectOption.getXMLElementTagName().equals(optionType)) {
            option = new SelectOption(this.getSpecification());
        } else if (LanguageOption.getXMLElementTagName().equals(optionType)) {
            option = new LanguageOption(this.getSpecification());
        } else if (FileOption.getXMLElementTagName().equals(optionType)) {
            option = new FileOption(this.getSpecification());
        } else if (PercentageOption.getXMLElementTagName().equals(optionType)) {
            option = new PercentageOption(this.getSpecification());
        } else if (AudioMixerOption.getXMLElementTagName().equals(optionType)) {
            option = new AudioMixerOption(this.getSpecification());
        } else if (StringOption.getXMLElementTagName().equals(optionType)) {
            option = new StringOption(this.getSpecification());
        } else if (UnitTypeOption.getXMLElementTagName().equals(optionType)) {
            option = new UnitTypeOption(this.getSpecification());
        } else if (AbstractUnitOption.getXMLElementTagName().equals(optionType)) {
            option = new AbstractUnitOption(this.getSpecification());
        } else if (ModOption.getXMLElementTagName().equals(optionType)) {
            option = new ModOption(this.getSpecification());
        } else if (UnitListOption.getXMLElementTagName().equals(optionType)) {
            option = new UnitListOption(this.getSpecification());
        } else if (ModListOption.getXMLElementTagName().equals(optionType)) {
            option = new ModListOption(this.getSpecification());
        } else {
            if ("action".equals(optionType)) {
                logger.finest("Skipping action " + in.getAttributeValue(null, "id"));
                in.nextTag();
                return null;
            }
            logger.finest("Parsing of option type '" + optionType + "' is not implemented yet");
            in.nextTag();
            return null;
        }
        option.readFromXML(in);
        return option;
    }
}

