/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SellGoodsMessage
extends DOMMessage {
    private String carrierId;
    private String goodsTypeId;
    private String amountString;

    public SellGoodsMessage(Goods goods, Unit carrier) {
        this.carrierId = carrier.getId();
        this.goodsTypeId = goods.getType().getId();
        this.amountString = Integer.toString(goods.getAmount());
    }

    public SellGoodsMessage(Game game, Element element) {
        this.carrierId = element.getAttribute("carrier");
        this.goodsTypeId = element.getAttribute("type");
        this.amountString = element.getAttribute("amount");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int amount;
        Unit carrier;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            carrier = server.getUnitSafely(this.carrierId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!carrier.canCarryGoods()) {
            return DOMMessage.clientError("Not a carrier: " + this.carrierId);
        }
        if (!carrier.isInEurope()) {
            return DOMMessage.clientError("Not in Europe: " + this.carrierId);
        }
        GoodsType type = server.getSpecification().getGoodsType(this.goodsTypeId);
        if (type == null) {
            return DOMMessage.clientError("Not a goods type: " + this.goodsTypeId);
        }
        if (!player.canTrade(type)) {
            return DOMMessage.clientError("Goods are boycotted: " + this.goodsTypeId);
        }
        try {
            amount = Integer.parseInt(this.amountString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad amount: " + this.amountString);
        }
        if (amount <= 0) {
            return DOMMessage.clientError("Amount must be positive: " + this.amountString);
        }
        int present = carrier.getGoodsContainer().getGoodsCount(type);
        if (present < amount) {
            return DOMMessage.clientError("Attempt to sell " + Integer.toString(amount) + " " + type.getId() + " but only " + Integer.toString(present) + " present.");
        }
        return server.getInGameController().sellGoods(serverPlayer, carrier, type, amount);
    }

    public Element toXMLElement() {
        Element result = SellGoodsMessage.createNewRootElement(SellGoodsMessage.getXMLElementTagName());
        result.setAttribute("carrier", this.carrierId);
        result.setAttribute("type", this.goodsTypeId);
        result.setAttribute("amount", this.amountString);
        return result;
    }

    public static String getXMLElementTagName() {
        return "sellGoods";
    }
}

