/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class MissionaryMessage
extends DOMMessage {
    private String unitId;
    private String directionString;
    private boolean denounce;

    public MissionaryMessage(Unit unit, Map.Direction direction, boolean denounce) {
        this.unitId = unit.getId();
        this.directionString = String.valueOf((Object)direction);
        this.denounce = denounce;
    }

    public MissionaryMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unitId");
        this.directionString = element.getAttribute("direction");
        this.denounce = Boolean.valueOf(element.getAttribute("denounce"));
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit.MoveType type;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (unit.getTile() == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, this.directionString);
        Tile tile = unit.getTile().getNeighbourOrNull(direction);
        if (tile == null) {
            return DOMMessage.clientError("Could not find tile in direction: " + (Object)((Object)direction) + " from unit: " + this.unitId);
        }
        IndianSettlement is = tile.getIndianSettlement();
        if (is == null) {
            return DOMMessage.clientError("There is no native settlement at: " + tile.getId());
        }
        Unit missionary = is.getMissionary();
        if (this.denounce) {
            if (missionary == null) {
                return DOMMessage.clientError("Denouncing an empty mission at: " + is.getId());
            }
            if (missionary.getOwner() == player) {
                return DOMMessage.clientError("Denouncing our own missionary at: " + is.getId());
            }
        } else if (missionary != null) {
            return DOMMessage.clientError("Establishing extra mission at: " + is.getId());
        }
        if ((type = unit.getMoveType(is.getTile())) != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY) {
            return DOMMessage.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        return this.denounce ? server.getInGameController().denounceMission(serverPlayer, unit, is) : server.getInGameController().establishMission(serverPlayer, unit, is);
    }

    public Element toXMLElement() {
        Element result = MissionaryMessage.createNewRootElement(MissionaryMessage.getXMLElementTagName());
        result.setAttribute("unitId", this.unitId);
        result.setAttribute("direction", this.directionString);
        result.setAttribute("denounce", Boolean.toString(this.denounce));
        return result;
    }

    public static String getXMLElementTagName() {
        return "missionary";
    }
}

