/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class BuildColonyMessage
extends DOMMessage {
    String colonyName;
    String builderId;

    public BuildColonyMessage(String colonyName, Unit builder) {
        this.colonyName = colonyName;
        this.builderId = builder.getId();
    }

    public BuildColonyMessage(Game game, Element element) {
        this.colonyName = element.getAttribute("name");
        this.builderId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.builderId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.colonyName == null) {
            return DOMMessage.clientError("Null colony name");
        }
        if (!"".equals(this.colonyName) && player.getColony(this.colonyName) != null) {
            return DOMMessage.clientError("Non-unique colony name " + this.colonyName);
        }
        if (!unit.canBuildColony()) {
            return DOMMessage.clientError("Unit " + this.builderId + " can not build colony.");
        }
        Tile tile = unit.getTile();
        if (!player.canClaimToFoundSettlement(tile)) {
            return DOMMessage.clientError("Can not build colony on tile: " + tile);
        }
        return server.getInGameController().buildSettlement(serverPlayer, unit, this.colonyName);
    }

    public Element toXMLElement() {
        Element result = BuildColonyMessage.createNewRootElement(BuildColonyMessage.getXMLElementTagName());
        result.setAttribute("name", this.colonyName);
        result.setAttribute("unit", this.builderId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "buildColony";
    }
}

