/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.pathfinding;

import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.BaseCostDecider;
import net.sf.freecol.common.model.pathfinding.CostDecider;

public final class CostDeciders {
    private static final CostDecider tileCostDecider = new CostDecider(){

        public int getCost(Unit unit, Tile oldTile, Tile newTile, int movesLeft) {
            if (unit.isNaval()) {
                if (!newTile.isLand()) {
                    return 1;
                }
                Settlement settlement = newTile.getSettlement();
                return settlement != null && settlement.getOwner().equals(unit.getOwner()) ? 1 : -1;
            }
            return newTile.isLand() ? 1 : -1;
        }

        public int getMovesLeft() {
            return 0;
        }

        public boolean isNewTurn() {
            return false;
        }
    };
    private static final CostDecider avoidIllegalCostDecider = new BaseCostDecider();
    private static final CostDecider serverAvoidIllegalCostDecider = new ServerBaseCostDecider();
    private static final AvoidSettlementsCostDecider avoidSettlementsCostDecider = new AvoidSettlementsCostDecider();
    private static final AvoidSettlementsAndBlockingUnitsCostDecider avoidSettlementsAndBlockingUnitsCostDecider = new AvoidSettlementsAndBlockingUnitsCostDecider();

    public static CostDecider defaultCostDeciderFor(Unit unit) {
        return unit == null || !unit.getOwner().isAI() || !unit.isOffensiveUnit() ? CostDeciders.avoidSettlementsAndBlockingUnits() : CostDeciders.avoidSettlements();
    }

    public static CostDecider numberOfTiles() {
        return tileCostDecider;
    }

    public static CostDecider avoidIllegal() {
        return avoidIllegalCostDecider;
    }

    public static CostDecider serverAvoidIllegal() {
        return serverAvoidIllegalCostDecider;
    }

    public static CostDecider avoidSettlements() {
        return avoidSettlementsCostDecider;
    }

    public static CostDecider avoidSettlementsAndBlockingUnits() {
        return avoidSettlementsAndBlockingUnitsCostDecider;
    }

    private static class AvoidSettlementsAndBlockingUnitsCostDecider
    extends BaseCostDecider {
        private AvoidSettlementsAndBlockingUnitsCostDecider() {
        }

        public int getCost(Unit unit, Tile oldTile, Tile newTile, int movesLeft) {
            int cost = super.getCost(unit, oldTile, newTile, movesLeft);
            if (cost != -1 && cost != Integer.MIN_VALUE) {
                Settlement settlement = newTile.getSettlement();
                if (settlement != null && settlement.getOwner() != unit.getOwner()) {
                    return -1;
                }
                Unit defender = newTile.getFirstUnit();
                if (defender != null && defender.getOwner() != unit.getOwner()) {
                    return -1;
                }
                if (newTile.isLand() && newTile.getFirstUnit() != null && newTile.getFirstUnit().isNaval() && newTile.getFirstUnit().getOwner() != unit.getOwner()) {
                    return -1;
                }
                if (unit.getTradeRoute() != null && unit.getMoveType(newTile) == Unit.MoveType.EXPLORE_LOST_CITY_RUMOUR) {
                    return -1;
                }
            }
            return cost;
        }
    }

    private static class AvoidSettlementsCostDecider
    extends BaseCostDecider {
        private AvoidSettlementsCostDecider() {
        }

        public int getCost(Unit unit, Tile oldTile, Tile newTile, int movesLeft) {
            Settlement settlement;
            int cost = super.getCost(unit, oldTile, newTile, movesLeft);
            if (cost != -1 && cost != Integer.MIN_VALUE && (settlement = newTile.getSettlement()) != null && settlement.getOwner() != unit.getOwner()) {
                return -1;
            }
            return cost;
        }
    }

    private static class ServerBaseCostDecider
    extends BaseCostDecider {
        private ServerBaseCostDecider() {
        }

        public int getCost(Unit unit, Tile oldTile, Tile newTile, int movesLeft) {
            int cost = super.getCost(unit, oldTile, newTile, movesLeft);
            if (cost != -1 && cost != Integer.MIN_VALUE && !newTile.isExploredBy(unit.getOwner())) {
                return -1;
            }
            return cost;
        }
    }
}

