/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.freecol.client.gui.plaf.FreeColButtonUI;
import net.sf.freecol.client.gui.plaf.FreeColCheckBoxUI;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxUI;
import net.sf.freecol.client.gui.plaf.FreeColLabelUI;
import net.sf.freecol.client.gui.plaf.FreeColListUI;
import net.sf.freecol.client.gui.plaf.FreeColMenuBarUI;
import net.sf.freecol.client.gui.plaf.FreeColMenuItemUI;
import net.sf.freecol.client.gui.plaf.FreeColPanelUI;
import net.sf.freecol.client.gui.plaf.FreeColPopupMenuUI;
import net.sf.freecol.client.gui.plaf.FreeColRadioButtonUI;
import net.sf.freecol.client.gui.plaf.FreeColScrollPaneUI;
import net.sf.freecol.client.gui.plaf.FreeColTableHeaderUI;
import net.sf.freecol.client.gui.plaf.FreeColTableUI;
import net.sf.freecol.client.gui.plaf.FreeColTextAreaUI;
import net.sf.freecol.client.gui.plaf.FreeColTextFieldUI;
import net.sf.freecol.client.gui.plaf.FreeColToolTipUI;
import net.sf.freecol.client.gui.plaf.FreeColTransparentPanelUI;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.resources.ResourceManager;

public class FreeColLookAndFeel
extends MetalLookAndFeel {
    private static final Logger logger = Logger.getLogger(FreeColLookAndFeel.class.getName());

    public FreeColLookAndFeel(File dataDirectory, Dimension windowSize) throws FreeColException {
        FreeColLookAndFeel.setCurrentTheme(new DefaultMetalTheme(){

            protected ColorUIResource getPrimary1() {
                return new ColorUIResource(ResourceManager.getColor("lookAndFeel.primary1.color"));
            }

            protected ColorUIResource getPrimary2() {
                return new ColorUIResource(ResourceManager.getColor("lookAndFeel.backgroundSelect.color"));
            }

            protected ColorUIResource getPrimary3() {
                return new ColorUIResource(ResourceManager.getColor("lookAndFeel.primary3.color"));
            }

            protected ColorUIResource getSecondary1() {
                return new ColorUIResource(ResourceManager.getColor("lookAndFeel.secondary1.color"));
            }

            protected ColorUIResource getSecondary2() {
                return new ColorUIResource(ResourceManager.getColor("lookAndFeel.disabled.color"));
            }

            protected ColorUIResource getSecondary3() {
                return new ColorUIResource(ResourceManager.getColor("lookAndFeel.background.color"));
            }

            public ColorUIResource getMenuDisabledForeground() {
                return new ColorUIResource(ResourceManager.getColor("lookAndFeel.disabledMenu.color"));
            }
        });
        if (!dataDirectory.isDirectory()) {
            throw new FreeColException("Data directory is not a directory.");
        }
    }

    public UIDefaults getDefaults() {
        UIDefaults u = super.getDefaults();
        try {
            int offset = "FreeCol".length();
            for (Class uiClass : new Class[]{FreeColButtonUI.class, FreeColCheckBoxUI.class, FreeColComboBoxUI.class, FreeColLabelUI.class, FreeColListUI.class, FreeColMenuBarUI.class, FreeColMenuItemUI.class, FreeColPanelUI.class, FreeColPopupMenuUI.class, FreeColRadioButtonUI.class, FreeColScrollPaneUI.class, FreeColTableHeaderUI.class, FreeColTableUI.class, FreeColTextAreaUI.class, FreeColTextFieldUI.class, FreeColToolTipUI.class, FreeColTransparentPanelUI.class}) {
                String name = uiClass.getName();
                int index = name.lastIndexOf("FreeCol");
                if (index < 0) continue;
                String shortName = name.substring(index += offset);
                u.put(shortName, name);
                u.put(name, uiClass);
            }
            String brightPanelUI = "net.sf.freecol.client.gui.plaf.FreeColBrightPanelUI";
            u.put(brightPanelUI, Class.forName(brightPanelUI));
            u.put("InPortPanelUI", brightPanelUI);
            u.put("CargoPanelUI", brightPanelUI);
            u.put("BuildingsPanelUI", brightPanelUI);
            u.put("OutsideColonyPanelUI", brightPanelUI);
            u.put("WarehousePanelUI", brightPanelUI);
            u.put("ConstructionPanelUI", brightPanelUI);
            u.put("PopulationPanelUI", brightPanelUI);
            u.put("WarehouseGoodsPanelUI", brightPanelUI);
            u.put("ReportPanelUI", brightPanelUI);
            u.put("ColopediaPanelUI", brightPanelUI);
            u.put("TilePanelUI", brightPanelUI);
            u.put("OptionGroupUI", brightPanelUI);
            String transparentPanelUI = "net.sf.freecol.client.gui.plaf.FreeColTransparentPanelUI";
            u.put(transparentPanelUI, Class.forName(transparentPanelUI));
            u.put("MarketPanelUI", transparentPanelUI);
            u.put("EuropeCargoPanelUI", transparentPanelUI);
            u.put("ToAmericaPanelUI", transparentPanelUI);
            u.put("ToEuropePanelUI", transparentPanelUI);
            u.put("EuropeInPortPanelUI", transparentPanelUI);
            u.put("DocksPanelUI", transparentPanelUI);
            Image im = ResourceManager.getImage("cursor.go.image");
            if (im != null) {
                u.put("cursor.go", Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(im.getWidth(null) / 2, im.getHeight(null) / 2), "go"));
            } else {
                u.put("cursor.go", Cursor.getPredefinedCursor(12));
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to load look and feel!", e);
            System.exit(-1);
        }
        return u;
    }

    public static void install(FreeColLookAndFeel fclaf, Font defaultFont) throws FreeColException {
        try {
            UIManager.setLookAndFeel(fclaf);
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new FreeColException(e.getMessage());
        }
        UIDefaults u = UIManager.getDefaults();
        Enumeration keys = u.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!(u.get(key) instanceof FontUIResource)) continue;
            u.put(key, defaultFont);
        }
    }

    public String getDescription() {
        return "The default Look and Feel for FreeCol";
    }

    public String getName() {
        return "FreeCol Look and Feel";
    }
}

