/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FindSettlementDialog;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndTurnDialog
extends FreeColDialog<Boolean>
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(FindSettlementDialog.class.getName());
    private JList unitList;

    public EndTurnDialog(FreeColClient freeColClient, GUI gui, List<Unit> units) {
        super(freeColClient, gui);
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "[align center]"));
        JLabel header = new JLabel(Messages.message("endTurnDialog.name"));
        header.setFont(smallHeaderFont);
        StringTemplate t = StringTemplate.template("endTurnDialog.areYouSure").addAmount("%number%", units.size());
        DefaultListModel<UnitWrapper> model = new DefaultListModel<UnitWrapper>();
        for (Unit unit : units) {
            model.addElement(new UnitWrapper(unit));
        }
        this.unitList = new JList(model);
        this.unitList.setCellRenderer(new UnitCellRenderer());
        this.unitList.setFixedCellHeight(48);
        JScrollPane listScroller = new JScrollPane(this.unitList);
        listScroller.setPreferredSize(new Dimension(250, 250));
        this.unitList.addListSelectionListener(this);
        AbstractAction selectAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EndTurnDialog.this.selectUnit();
            }
        };
        AbstractAction quitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EndTurnDialog.this.setResponse(Boolean.FALSE);
            }
        };
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.unitList.getActionMap().put("select", selectAction);
        this.unitList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.unitList.getActionMap().put("quit", quitAction);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EndTurnDialog.this.selectUnit();
                }
            }
        };
        this.unitList.addMouseListener(mouseListener);
        this.add(header);
        this.add((Component)EndTurnDialog.getDefaultTextArea(Messages.message(t)), "newline 30");
        this.add((Component)listScroller, "width max(200, 100%), height max(300, 100%), newline 20");
        this.add((Component)this.cancelButton, "newline 20, span, split 2, tag cancel");
        this.add((Component)this.okButton, "tag ok");
        this.restoreSavedSize(this.getPreferredSize());
    }

    private void selectUnit() {
        UnitWrapper wrapper = (UnitWrapper)this.unitList.getSelectedValue();
        if (wrapper != null && wrapper.getUnit() != null) {
            Unit unit = wrapper.getUnit();
            if (unit.getColony() != null) {
                this.getGUI().showColonyPanel(unit.getColony());
            } else if (unit.isInEurope()) {
                this.getGUI().showEuropePanel();
            }
        }
    }

    @Override
    public void requestFocus() {
        this.unitList.requestFocus();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Unit unit = ((UnitWrapper)this.unitList.getSelectedValue()).unit;
        if (unit != null && unit.getTile() != null) {
            this.getGUI().setFocus(unit.getTile());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.setResponse(Boolean.TRUE);
        } else if ("CANCEL".equals(command)) {
            this.setResponse(Boolean.FALSE);
        } else {
            super.actionPerformed(event);
        }
    }

    private class UnitCellRenderer
    implements ListCellRenderer {
        JPanel itemPanel = new JPanel();
        JPanel selectedPanel = new JPanel();
        JLabel imageLabel = new JLabel();
        JLabel nameLabel = new JLabel();
        JLabel locationLabel = new JLabel();

        public UnitCellRenderer() {
            this.itemPanel.setOpaque(false);
            this.itemPanel.setLayout((LayoutManager)new MigLayout("", "[60]"));
            this.selectedPanel.setOpaque(false);
            this.selectedPanel.setLayout((LayoutManager)new MigLayout("", "[60]"));
            this.selectedPanel.setUI((PanelUI)FreeColSelectedPanelUI.createUI(this.selectedPanel));
            this.locationLabel.setFont(this.locationLabel.getFont().deriveFont(2));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            UnitWrapper unit = (UnitWrapper)value;
            JPanel panel = isSelected ? this.selectedPanel : this.itemPanel;
            panel.removeAll();
            this.imageLabel.setIcon(EndTurnDialog.this.getLibrary().getUnitImageIcon(unit.unit, 0.5));
            this.nameLabel.setText(unit.name);
            this.locationLabel.setText(unit.location);
            panel.add((Component)this.imageLabel, "center");
            panel.add((Component)this.nameLabel, "split 2, flowy");
            panel.add(this.locationLabel);
            return panel;
        }
    }

    public class UnitWrapper {
        public Unit unit;
        public String name;
        public String location;

        public UnitWrapper(Unit unit) {
            this.unit = unit;
            this.name = Messages.message(Messages.getLabel(unit));
            this.location = Messages.message(unit.getLocation().getLocationName());
        }

        public Unit getUnit() {
            return this.unit;
        }

        public String toString() {
            return this.name;
        }
    }
}

