/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ImageSelection;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

public final class DefaultTransferHandler
extends TransferHandler {
    private static Logger logger = Logger.getLogger(DefaultTransferHandler.class.getName());
    public static final DataFlavor flavor = new DataFlavor(ImageSelection.class, "ImageSelection");
    private final FreeColPanel parentPanel;
    private FreeColClient freeColClient;
    private GUI gui;
    private static FreeColDragGestureRecognizer recognizer = null;

    public DefaultTransferHandler(FreeColClient freeColClient, GUI gui, FreeColPanel parentPanel) {
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.parentPanel = parentPanel;
    }

    public int getSourceActions(JComponent comp) {
        return 3;
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        if (!(comp instanceof UnitLabel || comp instanceof GoodsLabel || comp instanceof MarketLabel || comp instanceof JPanel || comp instanceof JLabel)) {
            return false;
        }
        for (int i = 0; i < flavor.length; ++i) {
            if (!flavor[i].equals(DefaultTransferHandler.flavor)) continue;
            return true;
        }
        return false;
    }

    public Transferable createTransferable(JComponent comp) {
        if (comp instanceof UnitLabel) {
            return new ImageSelection((UnitLabel)comp);
        }
        if (comp instanceof GoodsLabel) {
            return new ImageSelection((GoodsLabel)comp);
        }
        if (comp instanceof MarketLabel) {
            return new ImageSelection((MarketLabel)comp);
        }
        return null;
    }

    public boolean importData(JComponent comp, Transferable t) {
        try {
            AbstractGoodsLabel label;
            UnitLabel oldSelectedUnit = null;
            if (!t.isDataFlavorSupported(flavor)) {
                logger.warning("Data flavor is not supported!");
                return false;
            }
            JLabel data = (JLabel)t.getTransferData(flavor);
            if (comp == data) {
                return false;
            }
            if (comp instanceof UnitLabel) {
                UnitLabel unitLabel = (UnitLabel)comp;
                if (unitLabel.getUnit().isCarrier() && unitLabel.getParent() instanceof EuropePanel.InPortPanel) {
                    if (data instanceof UnitLabel && ((UnitLabel)data).getUnit().isOnCarrier() || data instanceof GoodsLabel && ((GoodsLabel)data).getGoods().getLocation() instanceof Unit) {
                        oldSelectedUnit = ((EuropePanel)this.parentPanel).getSelectedUnitLabel();
                    }
                    ((EuropePanel)this.parentPanel).setSelectedUnitLabel(unitLabel);
                    comp = ((EuropePanel)this.parentPanel).getCargoPanel();
                } else if (unitLabel.getUnit().isCarrier() && unitLabel.getParent() instanceof ColonyPanel.InPortPanel) {
                    if (data instanceof UnitLabel && ((UnitLabel)data).getUnit().isOnCarrier() || data instanceof GoodsLabel && ((GoodsLabel)data).getGoods().getLocation() instanceof Unit) {
                        oldSelectedUnit = ((ColonyPanel)this.parentPanel).getSelectedUnitLabel();
                    }
                    ((ColonyPanel)this.parentPanel).setSelectedUnitLabel(unitLabel);
                    comp = ((ColonyPanel)this.parentPanel).getCargoPanel();
                } else if (!unitLabel.canUnitBeEquipedWith(data)) {
                    try {
                        comp = (JComponent)comp.getParent();
                    }
                    catch (ClassCastException e) {
                        return false;
                    }
                    try {
                        if ((JComponent)comp.getParent() instanceof ColonyPanel.BuildingsPanel.ASingleBuildingPanel) {
                            comp = (JComponent)comp.getParent();
                        }
                    }
                    catch (ClassCastException e) {}
                }
            } else if (comp instanceof GoodsLabel || comp instanceof MarketLabel) {
                try {
                    comp = (JComponent)comp.getParent();
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
            if (data.getParent() == comp) {
                return false;
            }
            if (data instanceof UnitLabel) {
                Unit unit = ((UnitLabel)data).getUnit();
                if (unit.isUnderRepair()) {
                    return false;
                }
                if (unit.getLocation() instanceof HighSeas && !(comp instanceof EuropePanel.DestinationPanel)) {
                    return false;
                }
                if (!unit.isNaval() && (comp instanceof EuropePanel.InPortPanel || comp instanceof ColonyPanel.InPortPanel || comp instanceof EuropePanel.DestinationPanel)) {
                    return false;
                }
                if (comp instanceof EuropePanel.MarketPanel || comp instanceof ColonyPanel.WarehousePanel) {
                    return false;
                }
                if (unit.isNaval() && (comp instanceof EuropePanel.DocksPanel || comp instanceof ColonyPanel.OutsideColonyPanel || comp instanceof ColonyPanel.BuildingsPanel.ASingleBuildingPanel || comp instanceof ColonyPanel.TilePanel.ASingleTilePanel || comp instanceof CargoPanel)) {
                    return false;
                }
                if (comp instanceof JLabel) {
                    logger.warning("Oops, I thought we didn't have to write this part.");
                    return true;
                }
                if (comp instanceof JPanel) {
                    if (comp instanceof EuropePanel.DestinationPanel) {
                        ((EuropePanel.DestinationPanel)comp).add((Component)data, true);
                    } else if (comp instanceof EuropePanel.DocksPanel) {
                        ((EuropePanel.DocksPanel)comp).add((Component)data, true);
                    } else if (comp instanceof ColonyPanel.BuildingsPanel.ASingleBuildingPanel) {
                        ((ColonyPanel.BuildingsPanel.ASingleBuildingPanel)comp).add((Component)data, true);
                    } else if (comp instanceof ColonyPanel.OutsideColonyPanel) {
                        ColonyPanel.OutsideColonyPanel outside = (ColonyPanel.OutsideColonyPanel)comp;
                        if (outside.getColony().canReducePopulation()) {
                            outside.add((Component)data, true);
                        } else {
                            String message = "";
                            Set<Modifier> modifierSet = outside.getColony().getFeatureContainer().getModifierSet("model.modifier.minimumColonySize");
                            for (Modifier modifier : modifierSet) {
                                message = message + Messages.message(StringTemplate.template("colonyPanel.minimumColonySize").addName("%object%", modifier.getSource())) + "\n";
                            }
                            this.gui.showInformationMessage(message);
                        }
                    } else if (comp instanceof CargoPanel) {
                        ((CargoPanel)comp).add((Component)data, true);
                    } else if (comp instanceof ColonyPanel.TilePanel.ASingleTilePanel) {
                        ((ColonyPanel.TilePanel.ASingleTilePanel)comp).add((Component)data, true);
                    } else {
                        logger.warning("The receiving component is of an invalid type.");
                        return false;
                    }
                    if (oldSelectedUnit != null) {
                        if (oldSelectedUnit.getParent() instanceof EuropePanel.InPortPanel) {
                            ((EuropePanel)this.parentPanel).setSelectedUnit(oldSelectedUnit.getUnit());
                        } else {
                            ((ColonyPanel)this.parentPanel).setSelectedUnit(oldSelectedUnit.getUnit());
                        }
                    }
                    comp.revalidate();
                    return true;
                }
            } else if (data instanceof GoodsLabel) {
                label = (GoodsLabel)data;
                if (label.isPartialChosen()) {
                    int amount;
                    Goods goods = ((GoodsLabel)label).getGoods();
                    int defaultAmount = -1;
                    if (goods.getLocation() instanceof GoodsLocation) {
                        GoodsLocation loc = (GoodsLocation)goods.getLocation();
                        if (goods.getAmount() > loc.getGoodsCapacity()) {
                            defaultAmount = Math.min(goods.getAmount() - loc.getGoodsCapacity(), 100);
                        }
                    }
                    if ((amount = this.getAmount(((GoodsLabel)label).getGoods().getType(), ((GoodsLabel)label).getGoods().getAmount(), defaultAmount, false)) <= 0) {
                        return false;
                    }
                    ((GoodsLabel)label).getGoods().setAmount(amount);
                } else if (((GoodsLabel)label).getGoods().getAmount() > 100) {
                    ((GoodsLabel)label).getGoods().setAmount(100);
                }
                if (comp instanceof UnitLabel) {
                    UnitLabel unitLabel = (UnitLabel)comp;
                    Unit unit = unitLabel.getUnit();
                    if (unit.hasAbility("model.ability.canBeEquipped")) {
                        Goods goods = ((GoodsLabel)label).getGoods();
                        for (EquipmentType equipment : this.freeColClient.getGame().getSpecification().getEquipmentTypeList()) {
                            AbstractGoods requiredGoods;
                            if (!unit.canBeEquippedWith(equipment) || equipment.getGoodsRequired().size() != 1 || !(requiredGoods = equipment.getGoodsRequired().get(0)).getType().equals(goods.getType()) || requiredGoods.getAmount() > goods.getAmount()) continue;
                            int amount = Math.min(goods.getAmount() / requiredGoods.getAmount(), equipment.getMaximumCount());
                            this.freeColClient.getInGameController().equipUnit(unit, equipment, amount);
                            unitLabel.updateIcon();
                            return true;
                        }
                    }
                    return false;
                }
                if (comp instanceof JLabel) {
                    logger.warning("Oops, I thought we didn't have to write this part.");
                    return true;
                }
                if (comp instanceof JPanel) {
                    if (comp instanceof ColonyPanel.WarehousePanel) {
                        ((ColonyPanel.WarehousePanel)comp).add((Component)data, true);
                    } else if (comp instanceof CargoPanel) {
                        ((CargoPanel)comp).add((Component)data, true);
                    } else if (comp instanceof EuropePanel.MarketPanel) {
                        ((EuropePanel.MarketPanel)comp).add((Component)data, true);
                    } else {
                        logger.warning("The receiving component is of an invalid type.");
                        return false;
                    }
                    comp.revalidate();
                    if (oldSelectedUnit != null) {
                        if (oldSelectedUnit.getParent() instanceof EuropePanel.InPortPanel) {
                            ((EuropePanel)this.parentPanel).setSelectedUnit(oldSelectedUnit.getUnit());
                        } else {
                            ((ColonyPanel)this.parentPanel).setSelectedUnit(oldSelectedUnit.getUnit());
                        }
                    }
                    return true;
                }
            } else if (data instanceof MarketLabel) {
                label = (MarketLabel)data;
                if (label.isPartialChosen()) {
                    int amount = this.getAmount(label.getType(), label.getAmount(), -1, true);
                    if (amount <= 0) {
                        return false;
                    }
                    ((MarketLabel)label).setAmount(amount);
                }
                if (comp instanceof UnitLabel) {
                    UnitLabel unitLabel = (UnitLabel)comp;
                    Unit unit = unitLabel.getUnit();
                    if (unit.hasAbility("model.ability.canBeEquipped")) {
                        for (EquipmentType equipment : this.freeColClient.getGame().getSpecification().getEquipmentTypeList()) {
                            AbstractGoods requiredGoods;
                            if (!unit.canBeEquippedWith(equipment) || equipment.getGoodsRequired().size() != 1 || !(requiredGoods = equipment.getGoodsRequired().get(0)).getType().equals(label.getType()) || requiredGoods.getAmount() > label.getAmount()) continue;
                            int amount = Math.min(label.getAmount() / requiredGoods.getAmount(), equipment.getMaximumCount());
                            this.freeColClient.getInGameController().equipUnit(unit, equipment, amount);
                            unitLabel.updateIcon();
                            return true;
                        }
                    }
                    return false;
                }
                if (comp instanceof JLabel) {
                    logger.warning("Oops, I thought we didn't have to write this part.");
                    return true;
                }
                if (comp instanceof JPanel) {
                    if (!(comp instanceof CargoPanel)) {
                        logger.warning("The receiving component is of an invalid type.");
                        return false;
                    }
                    ((CargoPanel)comp).add((Component)data, true);
                    comp.revalidate();
                    return true;
                }
            }
            logger.warning("The dragged component is of an invalid type.");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
        }
        return false;
    }

    private int getAmount(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return this.gui.showSelectAmountDialog(goodsType, available, defaultAmount, needToPay);
    }

    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        int srcActions = this.getSourceActions(comp);
        int dragAction = srcActions & action;
        if (!(e instanceof MouseEvent)) {
            dragAction = 0;
        }
        if (dragAction != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new FreeColDragGestureRecognizer(new FreeColDragHandler());
            }
            recognizer.gestured(comp, (MouseEvent)e, srcActions, dragAction);
        } else {
            this.exportDone(comp, null, 0);
        }
    }

    private static class FreeColDragGestureRecognizer
    extends DragGestureRecognizer {
        FreeColDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private static class FreeColDragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private FreeColDragHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            DefaultTransferHandler th = (DefaultTransferHandler)c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    if (c instanceof JLabel && ((JLabel)c).getIcon() instanceof ImageIcon) {
                        Cursor cursor;
                        Toolkit tk = Toolkit.getDefaultToolkit();
                        ImageIcon imageIcon = (ImageIcon)((JLabel)c).getIcon();
                        Dimension bestSize = tk.getBestCursorSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
                        if (bestSize.width == 0 || bestSize.height == 0) {
                            dge.startDrag(null, t, this);
                            return;
                        }
                        if (bestSize.width > bestSize.height) {
                            bestSize.height = (int)((double)bestSize.width / (double)imageIcon.getIconWidth() * (double)imageIcon.getIconHeight());
                        } else {
                            bestSize.width = (int)((double)bestSize.height / (double)imageIcon.getIconHeight() * (double)imageIcon.getIconWidth());
                        }
                        Image image = imageIcon.getImage().getScaledInstance(bestSize.width, bestSize.height, 1);
                        MediaTracker mt = new MediaTracker(c);
                        mt.addImage(image, 0, bestSize.width, bestSize.height);
                        try {
                            mt.waitForID(0);
                        }
                        catch (InterruptedException e) {
                            dge.startDrag(null, t, this);
                            return;
                        }
                        Point point = new Point(bestSize.width / 2, bestSize.height / 2);
                        try {
                            cursor = tk.createCustomCursor(image, point, "freeColDragIcon");
                        }
                        catch (RuntimeException re) {
                            cursor = null;
                        }
                        dge.startDrag(cursor, t, this);
                    } else {
                        dge.startDrag(null, t, this);
                    }
                    return;
                }
                catch (RuntimeException re) {
                    c.setAutoscrolls(this.scrolls);
                }
            }
            th.exportDone(c, null, 0);
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dsde) {
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            if (dsde.getDropSuccess()) {
                ((DefaultTransferHandler)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), dsde.getDropAction());
            } else {
                ((DefaultTransferHandler)c.getTransferHandler()).exportDone(c, null, 0);
            }
            c.setAutoscrolls(this.scrolls);
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent comp = (JComponent)dsc.getComponent();
            this.updatePartialChosen(comp, dsde.getUserAction() == 2);
        }

        private void updatePartialChosen(JComponent comp, boolean partialChosen) {
            if (comp instanceof GoodsLabel) {
                ((GoodsLabel)comp).setPartialChosen(partialChosen);
            } else if (comp instanceof MarketLabel) {
                ((MarketLabel)comp).setPartialChosen(partialChosen);
            }
        }
    }
}

