/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.InfoPanel;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.resources.ResourceManager;

public final class CornerMapControls
extends MapControls {
    private final JLabel compassRose = new JLabel(ResourceManager.getImageIcon("compass.image"));

    public CornerMapControls(final FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, true);
        this.compassRose.setFocusable(false);
        this.compassRose.setSize(this.compassRose.getPreferredSize());
        this.compassRose.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int x = e.getX() - CornerMapControls.this.compassRose.getWidth() / 2;
                int y = e.getY() - CornerMapControls.this.compassRose.getHeight() / 2;
                double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                Map.Direction direction = Map.Direction.values()[(int)Math.floor(theta / 0.7853981633974483)];
                freeColClient.getInGameController().moveActiveUnit(direction);
            }
        });
    }

    public boolean isShowing() {
        return this.getInfoPanel().getParent() != null;
    }

    public void addToComponent(Canvas component) {
        if (this.getFreeColClient().getGame() == null || this.getFreeColClient().getGame().getMap() == null) {
            return;
        }
        MiniMap miniMap = this.getMiniMap();
        InfoPanel infoPanel = this.getInfoPanel();
        infoPanel.setLocation(component.getWidth() - infoPanel.getWidth(), component.getHeight() - infoPanel.getHeight());
        miniMap.setLocation(0, component.getHeight() - miniMap.getHeight());
        this.compassRose.setLocation(component.getWidth() - this.compassRose.getWidth() - 20, 20);
        List<UnitButton> unitButtons = this.getUnitButtons();
        if (!unitButtons.isEmpty()) {
            int WIDTH = unitButtons.get(0).getWidth();
            int SPACE = 5;
            int length = unitButtons.size();
            int x = miniMap.getWidth() + 1 + (infoPanel.getX() - miniMap.getWidth() - length * WIDTH - (length - 1) * 5 - WIDTH) / 2;
            int y = component.getHeight() - 40;
            int step = WIDTH + 5;
            for (UnitButton button : unitButtons) {
                button.setLocation(x, y);
                x += step;
            }
        }
        component.add((Component)infoPanel, CONTROLS_LAYER, false);
        component.add((Component)miniMap, CONTROLS_LAYER, false);
        if (this.getFreeColClient().getClientOptions().getBoolean("model.option.displayCompassRose")) {
            component.add((Component)this.compassRose, CONTROLS_LAYER, false);
        }
        if (!this.getFreeColClient().isMapEditor()) {
            for (UnitButton button : unitButtons) {
                component.add((Component)button, CONTROLS_LAYER, false);
                button.refreshAction();
            }
        }
    }

    public void removeFromComponent(Canvas canvas) {
        canvas.remove(this.getInfoPanel(), false);
        canvas.remove(this.getMiniMap(), false);
        canvas.remove(this.compassRose, false);
        for (UnitButton button : this.getUnitButtons()) {
            canvas.remove(button, false);
        }
    }
}

