/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaptureGoodsDialog
extends FreeColDialog<List<Goods>>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(CaptureGoodsDialog.class.getName());
    static final String ALL = "All";
    static final String NONE = "None";
    private JButton allButton;
    private JButton noneButton;
    private JList goodsList;
    private int maxCargo;

    public CaptureGoodsDialog(FreeColClient freeColClient, GUI gui, Unit winner, List<Goods> loot) {
        super(freeColClient, gui);
        this.maxCargo = winner.getSpaceLeft();
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "[center]", "[]20[]20[]"));
        JLabel header = new JLabel(Messages.message("lootCargo.header"));
        header.setFont(mediumHeaderFont);
        this.add(header);
        this.goodsList = new JList();
        GoodsItem[] goods = new GoodsItem[loot.size()];
        for (int i = 0; i < loot.size(); ++i) {
            goods[i] = new GoodsItem(loot.get(i));
        }
        this.goodsList.setListData(goods);
        this.goodsList.setCellRenderer(new CheckBoxRenderer());
        this.goodsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                int index = CaptureGoodsDialog.this.goodsList.locationToIndex(me.getPoint());
                if (index < 0) {
                    return;
                }
                GoodsItem item = (GoodsItem)CaptureGoodsDialog.this.goodsList.getModel().getElementAt(index);
                if (item.isEnabled()) {
                    item.setSelected(!item.isSelected());
                }
                CaptureGoodsDialog.this.updateComponents();
            }
        });
        this.add(this.goodsList);
        this.allButton = new JButton(Messages.message(ALL));
        this.allButton.addActionListener(this);
        CaptureGoodsDialog.enterPressesWhenFocused(this.allButton);
        this.allButton.setMnemonic('a');
        this.allButton.setActionCommand(ALL);
        this.noneButton = new JButton(Messages.message(NONE));
        this.noneButton.addActionListener(this);
        CaptureGoodsDialog.enterPressesWhenFocused(this.noneButton);
        this.noneButton.setMnemonic('n');
        this.noneButton.setActionCommand(NONE);
        this.add((Component)this.allButton, "span, split 3");
        this.add((Component)this.noneButton, "tag cancel");
        this.add((Component)this.okButton, "tag ok");
        this.setSize(this.getPreferredSize());
    }

    private void updateComponents() {
        GoodsItem gi;
        int i;
        int selectedCount = 0;
        for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
            gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
            if (!gi.isSelected()) continue;
            ++selectedCount;
        }
        if (selectedCount >= this.maxCargo) {
            this.allButton.setEnabled(false);
            for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
                if (gi.isSelected()) continue;
                gi.setEnabled(false);
            }
        } else {
            this.allButton.setEnabled(true);
            for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
                if (gi.isSelected()) continue;
                gi.setEnabled(true);
            }
        }
        this.goodsList.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (ALL.equals(command)) {
            for (int i = 0; i < this.goodsList.getModel().getSize() && i < this.maxCargo; ++i) {
                GoodsItem gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
                gi.setSelected(true);
                this.updateComponents();
            }
        } else if (NONE.equals(command)) {
            for (int i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                GoodsItem gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
                gi.setSelected(false);
                this.updateComponents();
            }
        } else if ("OK".equals(command)) {
            ArrayList<Goods> list = new ArrayList<Goods>();
            for (int i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                GoodsItem gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
                if (!gi.isSelected()) continue;
                list.add(gi.getGoods());
            }
            this.setResponse(list);
        } else {
            logger.warning("Invalid action command: " + command);
        }
    }

    private class GoodsItem
    extends JCheckBox {
        private Goods good;

        public GoodsItem(Goods good) {
            this.good = good;
        }

        public Goods getGoods() {
            return this.good;
        }

        public String toString() {
            StringTemplate template = StringTemplate.template("model.goods.goodsAmount").add("%goods%", this.good.getNameKey()).addAmount("%amount%", this.good.getAmount());
            return Messages.message(template);
        }
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList listBox, Object obj, int currentindex, boolean isChecked, boolean hasFocus) {
            GoodsItem item = (GoodsItem)obj;
            this.setSelected(item.isSelected());
            this.setText(item.toString());
            this.setEnabled(item.isEnabled());
            return this;
        }
    }
}

