/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.i18n;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Relation {
    int low;
    int high;
    int mod = 1;
    boolean negated = false;
    boolean integer = true;

    public Relation(List<String> tokens) {
        this.parse(tokens);
    }

    public Relation(int low, int high) {
        this.low = low;
        this.high = high;
    }

    public void setMod(int mod) {
        this.mod = mod;
    }

    public void setNegated(boolean value) {
        this.negated = value;
    }

    public void setInteger(boolean value) {
        this.integer = value;
    }

    public boolean matches(double number) {
        double value;
        double d = value = this.mod == 1 ? number : number % (double)this.mod;
        if (this.integer && value != (double)((int)value)) {
            return false;
        }
        return ((double)this.low <= value && value <= (double)this.high) != this.negated;
    }

    public String toString() {
        String result = new String("n ");
        if (this.mod != 1) {
            result = result + "mod " + Integer.toString(this.mod) + " ";
        }
        if (this.low == this.high) {
            result = result + "is ";
            if (this.negated) {
                result = result + "not ";
            }
            result = result + Integer.toString(this.low);
        } else {
            if (this.negated) {
                result = result + "not ";
            }
            if (!this.integer) {
                result = result + "with";
            }
            result = result + "in " + Integer.toString(this.low) + ".." + Integer.toString(this.high);
        }
        return result;
    }

    private void parse(List<String> input) {
        String token = input.remove(0);
        if (!"n".equals(token)) {
            throw new IllegalArgumentException("Relation must start with 'n'.");
        }
        token = input.remove(0);
        if ("mod".equals(token)) {
            this.mod = Integer.parseInt(input.remove(0));
            token = input.remove(0);
        }
        if ("not".equals(token)) {
            this.negated = true;
            token = input.remove(0);
        }
        if ("is".equals(token)) {
            token = input.remove(0);
            if ("not".equals(token)) {
                this.negated = true;
                token = input.remove(0);
            }
            this.low = this.high = Integer.parseInt(token);
        } else {
            if ("within".equals(token)) {
                this.integer = false;
            }
            this.low = Integer.parseInt(input.remove(0));
            this.high = Integer.parseInt(input.remove(0));
        }
    }
}

