/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;

public final class CanvasMouseMotionListener
implements MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseMotionListener.class.getName());
    private Tile lastTile;
    private final MapViewer mapViewer;
    private final Map map;
    private ScrollThread scrollThread;
    private FreeColClient freeColClient;
    private static final int DRAG_SCROLLSPACE = 100;
    private static final int AUTO_SCROLLSPACE = 1;

    public CanvasMouseMotionListener(FreeColClient freeColClient, MapViewer mapViewer, Map m) {
        this.freeColClient = freeColClient;
        this.mapViewer = mapViewer;
        this.map = m;
        this.scrollThread = null;
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.freeColClient.getClientOptions().getBoolean("model.option.autoScroll")) {
            this.auto_scroll(e.getX(), e.getY());
        } else if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
        if (this.mapViewer.isGotoStarted()) {
            Tile tile;
            if (this.mapViewer.getActiveUnit() == null) {
                this.mapViewer.stopGoto();
            }
            if ((tile = this.mapViewer.convertToMapTile(e.getX(), e.getY())) != null && this.lastTile != tile) {
                this.lastTile = tile;
                if (this.mapViewer.getActiveUnit() != null && this.mapViewer.getActiveUnit().getTile() != tile) {
                    PathNode dragPath = this.mapViewer.getActiveUnit().findPath(tile);
                    this.mapViewer.setGotoPath(dragPath);
                } else {
                    this.mapViewer.setGotoPath(null);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.freeColClient.getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            this.drag_scroll(e.getX(), e.getY());
        } else if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
        Tile tile = this.mapViewer.convertToMapTile(e.getX(), e.getY());
        if (tile != null && (e.getModifiers() & 0x10) == 16) {
            if (this.mapViewer.isGotoStarted()) {
                if (this.mapViewer.getActiveUnit() == null) {
                    this.mapViewer.stopGoto();
                } else if (this.lastTile != tile) {
                    this.lastTile = tile;
                    if (this.mapViewer.getActiveUnit().getTile() != tile) {
                        PathNode dragPath = this.mapViewer.getActiveUnit().findPath(tile);
                        this.mapViewer.setGotoPath(dragPath);
                    } else {
                        this.mapViewer.setGotoPath(null);
                    }
                }
            } else {
                this.mapViewer.startGoto();
            }
        }
    }

    private void auto_scroll(int x, int y) {
        this.scroll(x, y, 1);
    }

    private void drag_scroll(int x, int y) {
        this.scroll(x, y, 100);
    }

    private void scroll(int x, int y, int scrollspace) {
        Map.Direction direction;
        if (x < scrollspace && y < scrollspace) {
            direction = Map.Direction.NW;
        } else if (x >= this.mapViewer.getWidth() - scrollspace && y < scrollspace) {
            direction = Map.Direction.NE;
        } else if (x >= this.mapViewer.getWidth() - scrollspace && y >= this.mapViewer.getHeight() - scrollspace) {
            direction = Map.Direction.SE;
        } else if (x < scrollspace && y >= this.mapViewer.getHeight() - scrollspace) {
            direction = Map.Direction.SW;
        } else if (y < scrollspace) {
            direction = Map.Direction.N;
        } else if (x >= this.mapViewer.getWidth() - scrollspace) {
            direction = Map.Direction.E;
        } else if (y >= this.mapViewer.getHeight() - scrollspace) {
            direction = Map.Direction.S;
        } else if (x < scrollspace) {
            direction = Map.Direction.W;
        } else {
            if (this.scrollThread != null) {
                this.scrollThread.stopScrolling();
                this.scrollThread = null;
            }
            return;
        }
        if (this.scrollThread != null) {
            this.scrollThread.setDirection(direction);
        } else {
            this.scrollThread = new ScrollThread(this.map, this.mapViewer);
            this.scrollThread.setDirection(direction);
            this.scrollThread.start();
        }
    }

    private class ScrollThread
    extends Thread {
        private final Map map;
        private final MapViewer mapViewer;
        private Map.Direction direction;
        private boolean cont;

        public ScrollThread(Map m, MapViewer mapViewer) {
            super("FreeColClient:Mouse scroller");
            this.map = m;
            this.mapViewer = mapViewer;
            this.cont = true;
        }

        public void setDirection(Map.Direction d) {
            this.direction = d;
        }

        public void stopScrolling() {
            this.cont = false;
        }

        public void run() {
            do {
                try {
                    ScrollThread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            try {
                                int x;
                                int y;
                                Tile t = ScrollThread.this.mapViewer.getFocus();
                                if (t == null) {
                                    return;
                                }
                                if ((t = t.getNeighbourOrNull(ScrollThread.this.direction)) == null) {
                                    return;
                                }
                                if (ScrollThread.this.mapViewer.isMapNearTop(t.getY()) && ScrollThread.this.mapViewer.isMapNearTop(ScrollThread.this.mapViewer.getFocus().getY())) {
                                    if (t.getY() > ScrollThread.this.mapViewer.getFocus().getY()) {
                                        y = t.getY();
                                        while (ScrollThread.this.mapViewer.isMapNearTop(y += 2)) {
                                        }
                                    } else {
                                        y = ScrollThread.this.mapViewer.getFocus().getY();
                                    }
                                } else if (ScrollThread.this.mapViewer.isMapNearBottom(t.getY()) && ScrollThread.this.mapViewer.isMapNearBottom(ScrollThread.this.mapViewer.getFocus().getY())) {
                                    if (t.getY() < ScrollThread.this.mapViewer.getFocus().getY()) {
                                        y = t.getY();
                                        while (ScrollThread.this.mapViewer.isMapNearBottom(y -= 2)) {
                                        }
                                    } else {
                                        y = ScrollThread.this.mapViewer.getFocus().getY();
                                    }
                                } else {
                                    y = t.getY();
                                }
                                if (ScrollThread.this.mapViewer.isMapNearLeft(t.getX(), t.getY()) && ScrollThread.this.mapViewer.isMapNearLeft(ScrollThread.this.mapViewer.getFocus().getX(), ScrollThread.this.mapViewer.getFocus().getY())) {
                                    if (t.getX() > ScrollThread.this.mapViewer.getFocus().getX()) {
                                        x = t.getX();
                                        while (ScrollThread.this.mapViewer.isMapNearLeft(++x, y)) {
                                        }
                                    } else {
                                        x = ScrollThread.this.mapViewer.getFocus().getX();
                                    }
                                } else if (ScrollThread.this.mapViewer.isMapNearRight(t.getX(), t.getY()) && ScrollThread.this.mapViewer.isMapNearRight(ScrollThread.this.mapViewer.getFocus().getX(), ScrollThread.this.mapViewer.getFocus().getY())) {
                                    if (t.getX() < ScrollThread.this.mapViewer.getFocus().getX()) {
                                        x = t.getX();
                                        while (ScrollThread.this.mapViewer.isMapNearRight(--x, y)) {
                                        }
                                    } else {
                                        x = ScrollThread.this.mapViewer.getFocus().getX();
                                    }
                                } else {
                                    x = t.getX();
                                }
                                ScrollThread.this.mapViewer.setFocus(ScrollThread.this.map.getTile(x, y));
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Exception while scrolling!", e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    logger.log(Level.WARNING, "Scroll thread caught error", e);
                    this.cont = false;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Scroll thread interrupted", e);
                    this.cont = false;
                }
            } while (this.cont);
        }
    }
}

